/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.CreateToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GetToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolVersionsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolVersionsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreToolVersionResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Tool;
import com.google.cloud.dialogflow.cx.v3beta1.ToolVersion;
import com.google.cloud.dialogflow.cx.v3beta1.ToolsClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcToolsCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ToolsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ToolsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcToolsStub
extends ToolsStub {
    private static final MethodDescriptor<CreateToolRequest, Tool> createToolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/CreateTool").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateToolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tool.getDefaultInstance())).build();
    private static final MethodDescriptor<ListToolsRequest, ListToolsResponse> listToolsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/ListTools").setRequestMarshaller(ProtoUtils.marshaller((Message)ListToolsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListToolsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportToolsRequest, Operation> exportToolsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/ExportTools").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportToolsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetToolRequest, Tool> getToolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/GetTool").setRequestMarshaller(ProtoUtils.marshaller((Message)GetToolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tool.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateToolRequest, Tool> updateToolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/UpdateTool").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateToolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tool.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteToolRequest, Empty> deleteToolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/DeleteTool").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteToolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListToolVersionsRequest, ListToolVersionsResponse> listToolVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/ListToolVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListToolVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListToolVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateToolVersionRequest, ToolVersion> createToolVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/CreateToolVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateToolVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ToolVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<GetToolVersionRequest, ToolVersion> getToolVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/GetToolVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetToolVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ToolVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteToolVersionRequest, Empty> deleteToolVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/DeleteToolVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteToolVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Tools/RestoreToolVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)RestoreToolVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RestoreToolVersionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateToolRequest, Tool> createToolCallable;
    private final UnaryCallable<ListToolsRequest, ListToolsResponse> listToolsCallable;
    private final UnaryCallable<ListToolsRequest, ToolsClient.ListToolsPagedResponse> listToolsPagedCallable;
    private final UnaryCallable<ExportToolsRequest, Operation> exportToolsCallable;
    private final OperationCallable<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationCallable;
    private final UnaryCallable<GetToolRequest, Tool> getToolCallable;
    private final UnaryCallable<UpdateToolRequest, Tool> updateToolCallable;
    private final UnaryCallable<DeleteToolRequest, Empty> deleteToolCallable;
    private final UnaryCallable<ListToolVersionsRequest, ListToolVersionsResponse> listToolVersionsCallable;
    private final UnaryCallable<ListToolVersionsRequest, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsPagedCallable;
    private final UnaryCallable<CreateToolVersionRequest, ToolVersion> createToolVersionCallable;
    private final UnaryCallable<GetToolVersionRequest, ToolVersion> getToolVersionCallable;
    private final UnaryCallable<DeleteToolVersionRequest, Empty> deleteToolVersionCallable;
    private final UnaryCallable<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ToolsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcToolsStub create(ToolsStubSettings settings) throws IOException {
        return new GrpcToolsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcToolsStub create(ClientContext clientContext) throws IOException {
        return new GrpcToolsStub(ToolsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcToolsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcToolsStub(ToolsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcToolsStub(ToolsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcToolsCallableFactory());
    }

    protected GrpcToolsStub(ToolsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createToolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createToolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listToolsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listToolsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportToolsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportToolsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getToolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getToolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateToolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateToolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("tool.name", String.valueOf(request.getTool().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteToolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteToolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listToolVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listToolVersionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createToolVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createToolVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getToolVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getToolVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteToolVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteToolVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings restoreToolVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restoreToolVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createToolCallable = callableFactory.createUnaryCallable(createToolTransportSettings, settings.createToolSettings(), clientContext);
        this.listToolsCallable = callableFactory.createUnaryCallable(listToolsTransportSettings, settings.listToolsSettings(), clientContext);
        this.listToolsPagedCallable = callableFactory.createPagedCallable(listToolsTransportSettings, settings.listToolsSettings(), clientContext);
        this.exportToolsCallable = callableFactory.createUnaryCallable(exportToolsTransportSettings, settings.exportToolsSettings(), clientContext);
        this.exportToolsOperationCallable = callableFactory.createOperationCallable(exportToolsTransportSettings, settings.exportToolsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getToolCallable = callableFactory.createUnaryCallable(getToolTransportSettings, settings.getToolSettings(), clientContext);
        this.updateToolCallable = callableFactory.createUnaryCallable(updateToolTransportSettings, settings.updateToolSettings(), clientContext);
        this.deleteToolCallable = callableFactory.createUnaryCallable(deleteToolTransportSettings, settings.deleteToolSettings(), clientContext);
        this.listToolVersionsCallable = callableFactory.createUnaryCallable(listToolVersionsTransportSettings, settings.listToolVersionsSettings(), clientContext);
        this.listToolVersionsPagedCallable = callableFactory.createPagedCallable(listToolVersionsTransportSettings, settings.listToolVersionsSettings(), clientContext);
        this.createToolVersionCallable = callableFactory.createUnaryCallable(createToolVersionTransportSettings, settings.createToolVersionSettings(), clientContext);
        this.getToolVersionCallable = callableFactory.createUnaryCallable(getToolVersionTransportSettings, settings.getToolVersionSettings(), clientContext);
        this.deleteToolVersionCallable = callableFactory.createUnaryCallable(deleteToolVersionTransportSettings, settings.deleteToolVersionSettings(), clientContext);
        this.restoreToolVersionCallable = callableFactory.createUnaryCallable(restoreToolVersionTransportSettings, settings.restoreToolVersionSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateToolRequest, Tool> createToolCallable() {
        return this.createToolCallable;
    }

    @Override
    public UnaryCallable<ListToolsRequest, ListToolsResponse> listToolsCallable() {
        return this.listToolsCallable;
    }

    @Override
    public UnaryCallable<ListToolsRequest, ToolsClient.ListToolsPagedResponse> listToolsPagedCallable() {
        return this.listToolsPagedCallable;
    }

    @Override
    public UnaryCallable<ExportToolsRequest, Operation> exportToolsCallable() {
        return this.exportToolsCallable;
    }

    @Override
    public OperationCallable<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationCallable() {
        return this.exportToolsOperationCallable;
    }

    @Override
    public UnaryCallable<GetToolRequest, Tool> getToolCallable() {
        return this.getToolCallable;
    }

    @Override
    public UnaryCallable<UpdateToolRequest, Tool> updateToolCallable() {
        return this.updateToolCallable;
    }

    @Override
    public UnaryCallable<DeleteToolRequest, Empty> deleteToolCallable() {
        return this.deleteToolCallable;
    }

    @Override
    public UnaryCallable<ListToolVersionsRequest, ListToolVersionsResponse> listToolVersionsCallable() {
        return this.listToolVersionsCallable;
    }

    @Override
    public UnaryCallable<ListToolVersionsRequest, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsPagedCallable() {
        return this.listToolVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateToolVersionRequest, ToolVersion> createToolVersionCallable() {
        return this.createToolVersionCallable;
    }

    @Override
    public UnaryCallable<GetToolVersionRequest, ToolVersion> getToolVersionCallable() {
        return this.getToolVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteToolVersionRequest, Empty> deleteToolVersionCallable() {
        return this.deleteToolVersionCallable;
    }

    @Override
    public UnaryCallable<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionCallable() {
        return this.restoreToolVersionCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ToolsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

