/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.AgentName;
import com.google.cloud.dialogflow.cx.v3.CreateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ExportFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ExportFlowResponse;
import com.google.cloud.dialogflow.cx.v3.Flow;
import com.google.cloud.dialogflow.cx.v3.FlowName;
import com.google.cloud.dialogflow.cx.v3.FlowValidationResult;
import com.google.cloud.dialogflow.cx.v3.FlowValidationResultName;
import com.google.cloud.dialogflow.cx.v3.FlowsSettings;
import com.google.cloud.dialogflow.cx.v3.GetFlowRequest;
import com.google.cloud.dialogflow.cx.v3.GetFlowValidationResultRequest;
import com.google.cloud.dialogflow.cx.v3.ImportFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ImportFlowResponse;
import com.google.cloud.dialogflow.cx.v3.ListFlowsRequest;
import com.google.cloud.dialogflow.cx.v3.ListFlowsResponse;
import com.google.cloud.dialogflow.cx.v3.TrainFlowRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.ValidateFlowRequest;
import com.google.cloud.dialogflow.cx.v3.stub.FlowsStub;
import com.google.cloud.dialogflow.cx.v3.stub.FlowsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FlowsClient
implements BackgroundResource {
    private final FlowsSettings settings;
    private final FlowsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final FlowsClient create() throws IOException {
        return FlowsClient.create(FlowsSettings.newBuilder().build());
    }

    public static final FlowsClient create(FlowsSettings settings) throws IOException {
        return new FlowsClient(settings);
    }

    public static final FlowsClient create(FlowsStub stub) {
        return new FlowsClient(stub);
    }

    protected FlowsClient(FlowsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FlowsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected FlowsClient(FlowsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final FlowsSettings getSettings() {
        return this.settings;
    }

    public FlowsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Flow createFlow(AgentName parent, Flow flow) {
        CreateFlowRequest request = CreateFlowRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFlow(flow).build();
        return this.createFlow(request);
    }

    public final Flow createFlow(String parent, Flow flow) {
        CreateFlowRequest request = CreateFlowRequest.newBuilder().setParent(parent).setFlow(flow).build();
        return this.createFlow(request);
    }

    public final Flow createFlow(CreateFlowRequest request) {
        return (Flow)this.createFlowCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFlowRequest, Flow> createFlowCallable() {
        return this.stub.createFlowCallable();
    }

    public final void deleteFlow(FlowName name) {
        DeleteFlowRequest request = DeleteFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFlow(request);
    }

    public final void deleteFlow(String name) {
        DeleteFlowRequest request = DeleteFlowRequest.newBuilder().setName(name).build();
        this.deleteFlow(request);
    }

    public final void deleteFlow(DeleteFlowRequest request) {
        this.deleteFlowCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFlowRequest, Empty> deleteFlowCallable() {
        return this.stub.deleteFlowCallable();
    }

    public final ListFlowsPagedResponse listFlows(AgentName parent) {
        ListFlowsRequest request = ListFlowsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFlows(request);
    }

    public final ListFlowsPagedResponse listFlows(String parent) {
        ListFlowsRequest request = ListFlowsRequest.newBuilder().setParent(parent).build();
        return this.listFlows(request);
    }

    public final ListFlowsPagedResponse listFlows(ListFlowsRequest request) {
        return (ListFlowsPagedResponse)((Object)this.listFlowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFlowsRequest, ListFlowsPagedResponse> listFlowsPagedCallable() {
        return this.stub.listFlowsPagedCallable();
    }

    public final UnaryCallable<ListFlowsRequest, ListFlowsResponse> listFlowsCallable() {
        return this.stub.listFlowsCallable();
    }

    public final Flow getFlow(FlowName name) {
        GetFlowRequest request = GetFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFlow(request);
    }

    public final Flow getFlow(String name) {
        GetFlowRequest request = GetFlowRequest.newBuilder().setName(name).build();
        return this.getFlow(request);
    }

    public final Flow getFlow(GetFlowRequest request) {
        return (Flow)this.getFlowCallable().call((Object)request);
    }

    public final UnaryCallable<GetFlowRequest, Flow> getFlowCallable() {
        return this.stub.getFlowCallable();
    }

    public final Flow updateFlow(Flow flow, FieldMask updateMask) {
        UpdateFlowRequest request = UpdateFlowRequest.newBuilder().setFlow(flow).setUpdateMask(updateMask).build();
        return this.updateFlow(request);
    }

    public final Flow updateFlow(UpdateFlowRequest request) {
        return (Flow)this.updateFlowCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFlowRequest, Flow> updateFlowCallable() {
        return this.stub.updateFlowCallable();
    }

    public final OperationFuture<Empty, Struct> trainFlowAsync(FlowName name) {
        TrainFlowRequest request = TrainFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.trainFlowAsync(request);
    }

    public final OperationFuture<Empty, Struct> trainFlowAsync(String name) {
        TrainFlowRequest request = TrainFlowRequest.newBuilder().setName(name).build();
        return this.trainFlowAsync(request);
    }

    public final OperationFuture<Empty, Struct> trainFlowAsync(TrainFlowRequest request) {
        return this.trainFlowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TrainFlowRequest, Empty, Struct> trainFlowOperationCallable() {
        return this.stub.trainFlowOperationCallable();
    }

    public final UnaryCallable<TrainFlowRequest, Operation> trainFlowCallable() {
        return this.stub.trainFlowCallable();
    }

    public final FlowValidationResult validateFlow(ValidateFlowRequest request) {
        return (FlowValidationResult)this.validateFlowCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateFlowRequest, FlowValidationResult> validateFlowCallable() {
        return this.stub.validateFlowCallable();
    }

    public final FlowValidationResult getFlowValidationResult(FlowValidationResultName name) {
        GetFlowValidationResultRequest request = GetFlowValidationResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFlowValidationResult(request);
    }

    public final FlowValidationResult getFlowValidationResult(String name) {
        GetFlowValidationResultRequest request = GetFlowValidationResultRequest.newBuilder().setName(name).build();
        return this.getFlowValidationResult(request);
    }

    public final FlowValidationResult getFlowValidationResult(GetFlowValidationResultRequest request) {
        return (FlowValidationResult)this.getFlowValidationResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetFlowValidationResultRequest, FlowValidationResult> getFlowValidationResultCallable() {
        return this.stub.getFlowValidationResultCallable();
    }

    public final OperationFuture<ImportFlowResponse, Struct> importFlowAsync(ImportFlowRequest request) {
        return this.importFlowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportFlowRequest, ImportFlowResponse, Struct> importFlowOperationCallable() {
        return this.stub.importFlowOperationCallable();
    }

    public final UnaryCallable<ImportFlowRequest, Operation> importFlowCallable() {
        return this.stub.importFlowCallable();
    }

    public final OperationFuture<ExportFlowResponse, Struct> exportFlowAsync(ExportFlowRequest request) {
        return this.exportFlowOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportFlowRequest, ExportFlowResponse, Struct> exportFlowOperationCallable() {
        return this.stub.exportFlowOperationCallable();
    }

    public final UnaryCallable<ExportFlowRequest, Operation> exportFlowCallable() {
        return this.stub.exportFlowCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFlowsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage, ListFlowsFixedSizeCollection> {
        private ListFlowsFixedSizeCollection(List<ListFlowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFlowsFixedSizeCollection createEmptyCollection() {
            return new ListFlowsFixedSizeCollection(null, 0);
        }

        protected ListFlowsFixedSizeCollection createCollection(List<ListFlowsPage> pages, int collectionSize) {
            return new ListFlowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFlowsPage
    extends AbstractPage<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage> {
        private ListFlowsPage(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ListFlowsResponse response) {
            super(context, (Object)response);
        }

        private static ListFlowsPage createEmptyPage() {
            return new ListFlowsPage(null, null);
        }

        protected ListFlowsPage createPage(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ListFlowsResponse response) {
            return new ListFlowsPage(context, response);
        }

        public ApiFuture<ListFlowsPage> createPageAsync(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ApiFuture<ListFlowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFlowsPagedResponse
    extends AbstractPagedListResponse<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage, ListFlowsFixedSizeCollection> {
        public static ApiFuture<ListFlowsPagedResponse> createAsync(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ApiFuture<ListFlowsResponse> futureResponse) {
            ApiFuture<ListFlowsPage> futurePage = ListFlowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFlowsPagedResponse((ListFlowsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFlowsPagedResponse(ListFlowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFlowsFixedSizeCollection.createEmptyCollection());
        }
    }
}

