/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.cloud.dialogflow.cx.v3beta1.stub;

import static com.google.cloud.dialogflow.cx.v3beta1.SessionsClient.ListLocationsPagedResponse;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AnswerFeedback;
import com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.SubmitAnswerFeedbackRequest;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
/**
 * REST stub implementation for the Sessions service API.
 *
 * <p>This class is for advanced usage and reflects the underlying API directly.
 */
@BetaApi
@Generated("by gapic-generator-java")
public class HttpJsonSessionsStub extends SessionsStub {
  private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();

  private static final ApiMethodDescriptor<DetectIntentRequest, DetectIntentResponse>
      detectIntentMethodDescriptor =
          ApiMethodDescriptor.<DetectIntentRequest, DetectIntentResponse>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent")
              .setHttpMethod("POST")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<DetectIntentRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/sessions/*}:detectIntent",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<DetectIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "session", request.getSession());
                            return fields;
                          })
                      .setAdditionalPaths(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/environments/*/sessions/*}:detectIntent")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<DetectIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("*", request.toBuilder().clearSession().build(), true))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<DetectIntentResponse>newBuilder()
                      .setDefaultInstance(DetectIntentResponse.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<DetectIntentRequest, DetectIntentResponse>
      serverStreamingDetectIntentMethodDescriptor =
          ApiMethodDescriptor.<DetectIntentRequest, DetectIntentResponse>newBuilder()
              .setFullMethodName(
                  "google.cloud.dialogflow.cx.v3beta1.Sessions/ServerStreamingDetectIntent")
              .setHttpMethod("POST")
              .setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<DetectIntentRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/sessions/*}:serverStreamingDetectIntent",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<DetectIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "session", request.getSession());
                            return fields;
                          })
                      .setAdditionalPaths(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/environments/*/sessions/*}:serverStreamingDetectIntent")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<DetectIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("*", request.toBuilder().clearSession().build(), true))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<DetectIntentResponse>newBuilder()
                      .setDefaultInstance(DetectIntentResponse.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<MatchIntentRequest, MatchIntentResponse>
      matchIntentMethodDescriptor =
          ApiMethodDescriptor.<MatchIntentRequest, MatchIntentResponse>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent")
              .setHttpMethod("POST")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<MatchIntentRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/sessions/*}:matchIntent",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<MatchIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "session", request.getSession());
                            return fields;
                          })
                      .setAdditionalPaths(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/environments/*/sessions/*}:matchIntent")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<MatchIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("*", request.toBuilder().clearSession().build(), true))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<MatchIntentResponse>newBuilder()
                      .setDefaultInstance(MatchIntentResponse.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<FulfillIntentRequest, FulfillIntentResponse>
      fulfillIntentMethodDescriptor =
          ApiMethodDescriptor.<FulfillIntentRequest, FulfillIntentResponse>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent")
              .setHttpMethod("POST")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<FulfillIntentRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{matchIntentRequest.session=projects/*/locations/*/agents/*/sessions/*}:fulfillIntent",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<FulfillIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(
                                fields,
                                "matchIntentRequest.session",
                                request.getMatchIntentRequest().getSession());
                            return fields;
                          })
                      .setAdditionalPaths(
                          "/v3beta1/{matchIntentRequest.session=projects/*/locations/*/agents/*/environments/*/sessions/*}:fulfillIntent")
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<FulfillIntentRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("*", request.toBuilder().build(), true))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<FulfillIntentResponse>newBuilder()
                      .setDefaultInstance(FulfillIntentResponse.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<SubmitAnswerFeedbackRequest, AnswerFeedback>
      submitAnswerFeedbackMethodDescriptor =
          ApiMethodDescriptor.<SubmitAnswerFeedbackRequest, AnswerFeedback>newBuilder()
              .setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/SubmitAnswerFeedback")
              .setHttpMethod("POST")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<SubmitAnswerFeedbackRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{session=projects/*/locations/*/agents/*/sessions/*}:submitAnswerFeedback",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<SubmitAnswerFeedbackRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "session", request.getSession());
                            return fields;
                          })
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<SubmitAnswerFeedbackRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(
                          request ->
                              ProtoRestSerializer.create()
                                  .toBody("*", request.toBuilder().clearSession().build(), true))
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<AnswerFeedback>newBuilder()
                      .setDefaultInstance(AnswerFeedback.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse>
      listLocationsMethodDescriptor =
          ApiMethodDescriptor.<ListLocationsRequest, ListLocationsResponse>newBuilder()
              .setFullMethodName("google.cloud.location.Locations/ListLocations")
              .setHttpMethod("GET")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<ListLocationsRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{name=projects/*}/locations",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<ListLocationsRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "name", request.getName());
                            return fields;
                          })
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<ListLocationsRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(request -> null)
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<ListLocationsResponse>newBuilder()
                      .setDefaultInstance(ListLocationsResponse.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private static final ApiMethodDescriptor<GetLocationRequest, Location>
      getLocationMethodDescriptor =
          ApiMethodDescriptor.<GetLocationRequest, Location>newBuilder()
              .setFullMethodName("google.cloud.location.Locations/GetLocation")
              .setHttpMethod("GET")
              .setType(ApiMethodDescriptor.MethodType.UNARY)
              .setRequestFormatter(
                  ProtoMessageRequestFormatter.<GetLocationRequest>newBuilder()
                      .setPath(
                          "/v3beta1/{name=projects/*/locations/*}",
                          request -> {
                            Map<String, String> fields = new HashMap<>();
                            ProtoRestSerializer<GetLocationRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putPathParam(fields, "name", request.getName());
                            return fields;
                          })
                      .setQueryParamsExtractor(
                          request -> {
                            Map<String, List<String>> fields = new HashMap<>();
                            ProtoRestSerializer<GetLocationRequest> serializer =
                                ProtoRestSerializer.create();
                            serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
                            return fields;
                          })
                      .setRequestBodyExtractor(request -> null)
                      .build())
              .setResponseParser(
                  ProtoMessageResponseParser.<Location>newBuilder()
                      .setDefaultInstance(Location.getDefaultInstance())
                      .setDefaultTypeRegistry(typeRegistry)
                      .build())
              .build();

  private final UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable;
  private final ServerStreamingCallable<DetectIntentRequest, DetectIntentResponse>
      serverStreamingDetectIntentCallable;
  private final UnaryCallable<MatchIntentRequest, MatchIntentResponse> matchIntentCallable;
  private final UnaryCallable<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentCallable;
  private final UnaryCallable<SubmitAnswerFeedbackRequest, AnswerFeedback>
      submitAnswerFeedbackCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
  private final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable;
  private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;

  private final BackgroundResource backgroundResources;
  private final HttpJsonStubCallableFactory callableFactory;

  public static final HttpJsonSessionsStub create(SessionsStubSettings settings)
      throws IOException {
    return new HttpJsonSessionsStub(settings, ClientContext.create(settings));
  }

  public static final HttpJsonSessionsStub create(ClientContext clientContext) throws IOException {
    return new HttpJsonSessionsStub(
        SessionsStubSettings.newHttpJsonBuilder().build(), clientContext);
  }

  public static final HttpJsonSessionsStub create(
      ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
    return new HttpJsonSessionsStub(
        SessionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
  }

  /**
   * Constructs an instance of HttpJsonSessionsStub, using the given settings. This is protected so
   * that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected HttpJsonSessionsStub(SessionsStubSettings settings, ClientContext clientContext)
      throws IOException {
    this(settings, clientContext, new HttpJsonSessionsCallableFactory());
  }

  /**
   * Constructs an instance of HttpJsonSessionsStub, using the given settings. This is protected so
   * that it is easy to make a subclass, but otherwise, the static factory methods should be
   * preferred.
   */
  protected HttpJsonSessionsStub(
      SessionsStubSettings settings,
      ClientContext clientContext,
      HttpJsonStubCallableFactory callableFactory)
      throws IOException {
    this.callableFactory = callableFactory;

    HttpJsonCallSettings<DetectIntentRequest, DetectIntentResponse> detectIntentTransportSettings =
        HttpJsonCallSettings.<DetectIntentRequest, DetectIntentResponse>newBuilder()
            .setMethodDescriptor(detectIntentMethodDescriptor)
            .setTypeRegistry(typeRegistry)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("session", String.valueOf(request.getSession()));
                  return builder.build();
                })
            .build();
    HttpJsonCallSettings<DetectIntentRequest, DetectIntentResponse>
        serverStreamingDetectIntentTransportSettings =
            HttpJsonCallSettings.<DetectIntentRequest, DetectIntentResponse>newBuilder()
                .setMethodDescriptor(serverStreamingDetectIntentMethodDescriptor)
                .setTypeRegistry(typeRegistry)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("session", String.valueOf(request.getSession()));
                      return builder.build();
                    })
                .build();
    HttpJsonCallSettings<MatchIntentRequest, MatchIntentResponse> matchIntentTransportSettings =
        HttpJsonCallSettings.<MatchIntentRequest, MatchIntentResponse>newBuilder()
            .setMethodDescriptor(matchIntentMethodDescriptor)
            .setTypeRegistry(typeRegistry)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("session", String.valueOf(request.getSession()));
                  return builder.build();
                })
            .build();
    HttpJsonCallSettings<FulfillIntentRequest, FulfillIntentResponse>
        fulfillIntentTransportSettings =
            HttpJsonCallSettings.<FulfillIntentRequest, FulfillIntentResponse>newBuilder()
                .setMethodDescriptor(fulfillIntentMethodDescriptor)
                .setTypeRegistry(typeRegistry)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add(
                          "match_intent_request.session",
                          String.valueOf(request.getMatchIntentRequest().getSession()));
                      return builder.build();
                    })
                .build();
    HttpJsonCallSettings<SubmitAnswerFeedbackRequest, AnswerFeedback>
        submitAnswerFeedbackTransportSettings =
            HttpJsonCallSettings.<SubmitAnswerFeedbackRequest, AnswerFeedback>newBuilder()
                .setMethodDescriptor(submitAnswerFeedbackMethodDescriptor)
                .setTypeRegistry(typeRegistry)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("session", String.valueOf(request.getSession()));
                      return builder.build();
                    })
                .build();
    HttpJsonCallSettings<ListLocationsRequest, ListLocationsResponse>
        listLocationsTransportSettings =
            HttpJsonCallSettings.<ListLocationsRequest, ListLocationsResponse>newBuilder()
                .setMethodDescriptor(listLocationsMethodDescriptor)
                .setTypeRegistry(typeRegistry)
                .setParamsExtractor(
                    request -> {
                      RequestParamsBuilder builder = RequestParamsBuilder.create();
                      builder.add("name", String.valueOf(request.getName()));
                      return builder.build();
                    })
                .build();
    HttpJsonCallSettings<GetLocationRequest, Location> getLocationTransportSettings =
        HttpJsonCallSettings.<GetLocationRequest, Location>newBuilder()
            .setMethodDescriptor(getLocationMethodDescriptor)
            .setTypeRegistry(typeRegistry)
            .setParamsExtractor(
                request -> {
                  RequestParamsBuilder builder = RequestParamsBuilder.create();
                  builder.add("name", String.valueOf(request.getName()));
                  return builder.build();
                })
            .build();

    this.detectIntentCallable =
        callableFactory.createUnaryCallable(
            detectIntentTransportSettings, settings.detectIntentSettings(), clientContext);
    this.serverStreamingDetectIntentCallable =
        callableFactory.createServerStreamingCallable(
            serverStreamingDetectIntentTransportSettings,
            settings.serverStreamingDetectIntentSettings(),
            clientContext);
    this.matchIntentCallable =
        callableFactory.createUnaryCallable(
            matchIntentTransportSettings, settings.matchIntentSettings(), clientContext);
    this.fulfillIntentCallable =
        callableFactory.createUnaryCallable(
            fulfillIntentTransportSettings, settings.fulfillIntentSettings(), clientContext);
    this.submitAnswerFeedbackCallable =
        callableFactory.createUnaryCallable(
            submitAnswerFeedbackTransportSettings,
            settings.submitAnswerFeedbackSettings(),
            clientContext);
    this.listLocationsCallable =
        callableFactory.createUnaryCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.listLocationsPagedCallable =
        callableFactory.createPagedCallable(
            listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
    this.getLocationCallable =
        callableFactory.createUnaryCallable(
            getLocationTransportSettings, settings.getLocationSettings(), clientContext);

    this.backgroundResources =
        new BackgroundResourceAggregation(clientContext.getBackgroundResources());
  }

  @InternalApi
  public static List<ApiMethodDescriptor> getMethodDescriptors() {
    List<ApiMethodDescriptor> methodDescriptors = new ArrayList<>();
    methodDescriptors.add(detectIntentMethodDescriptor);
    methodDescriptors.add(serverStreamingDetectIntentMethodDescriptor);
    methodDescriptors.add(matchIntentMethodDescriptor);
    methodDescriptors.add(fulfillIntentMethodDescriptor);
    methodDescriptors.add(submitAnswerFeedbackMethodDescriptor);
    methodDescriptors.add(listLocationsMethodDescriptor);
    methodDescriptors.add(getLocationMethodDescriptor);
    return methodDescriptors;
  }

  @Override
  public UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable() {
    return detectIntentCallable;
  }

  @Override
  public ServerStreamingCallable<DetectIntentRequest, DetectIntentResponse>
      serverStreamingDetectIntentCallable() {
    return serverStreamingDetectIntentCallable;
  }

  @Override
  public UnaryCallable<MatchIntentRequest, MatchIntentResponse> matchIntentCallable() {
    return matchIntentCallable;
  }

  @Override
  public UnaryCallable<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentCallable() {
    return fulfillIntentCallable;
  }

  @Override
  public UnaryCallable<SubmitAnswerFeedbackRequest, AnswerFeedback> submitAnswerFeedbackCallable() {
    return submitAnswerFeedbackCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
    return listLocationsCallable;
  }

  @Override
  public UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse>
      listLocationsPagedCallable() {
    return listLocationsPagedCallable;
  }

  @Override
  public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
    return getLocationCallable;
  }

  @Override
  public BidiStreamingCallable<StreamingDetectIntentRequest, StreamingDetectIntentResponse>
      streamingDetectIntentCallable() {
    throw new UnsupportedOperationException(
        "Not implemented: streamingDetectIntentCallable(). REST transport is not implemented for this method yet.");
  }

  @Override
  public final void close() {
    try {
      backgroundResources.close();
    } catch (RuntimeException e) {
      throw e;
    } catch (Exception e) {
      throw new IllegalStateException("Failed to close resource", e);
    }
  }

  @Override
  public void shutdown() {
    backgroundResources.shutdown();
  }

  @Override
  public boolean isShutdown() {
    return backgroundResources.isShutdown();
  }

  @Override
  public boolean isTerminated() {
    return backgroundResources.isTerminated();
  }

  @Override
  public void shutdownNow() {
    backgroundResources.shutdownNow();
  }

  @Override
  public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
    return backgroundResources.awaitTermination(duration, unit);
  }
}
