/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportIntentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GetIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ImportIntentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Intent;
import com.google.cloud.dialogflow.cx.v3beta1.IntentsClient;
import com.google.cloud.dialogflow.cx.v3beta1.ListIntentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListIntentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonIntentsCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.IntentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.IntentsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonIntentsStub
extends IntentsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ImportIntentsResponse.getDescriptor()).add(ExportIntentsResponse.getDescriptor()).add(ExportIntentsMetadata.getDescriptor()).add(ImportIntentsMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListIntentsRequest, ListIntentsResponse> listIntentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/ListIntents").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{parent=projects/*/locations/*/agents/*}/intents", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "intentView", (Object)request.getIntentViewValue());
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListIntentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIntentRequest, Intent> getIntentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/GetIntent").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{name=projects/*/locations/*/agents/*/intents/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Intent.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateIntentRequest, Intent> createIntentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/CreateIntent").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{parent=projects/*/locations/*/agents/*}/intents", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("intent", (Message)request.getIntent(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Intent.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateIntentRequest, Intent> updateIntentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/UpdateIntent").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{intent.name=projects/*/locations/*/agents/*/intents/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "intent.name", (Object)request.getIntent().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "languageCode", (Object)request.getLanguageCode());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("intent", (Message)request.getIntent(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Intent.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteIntentRequest, Empty> deleteIntentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/DeleteIntent").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{name=projects/*/locations/*/agents/*/intents/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ImportIntentsRequest, Operation> importIntentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/ImportIntents").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{parent=projects/*/locations/*/agents/*}/intents:import", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportIntentsRequest, Operation> exportIntentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Intents/ExportIntents").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{parent=projects/*/locations/*/agents/*}/intents:export", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3beta1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListIntentsRequest, ListIntentsResponse> listIntentsCallable;
    private final UnaryCallable<ListIntentsRequest, IntentsClient.ListIntentsPagedResponse> listIntentsPagedCallable;
    private final UnaryCallable<GetIntentRequest, Intent> getIntentCallable;
    private final UnaryCallable<CreateIntentRequest, Intent> createIntentCallable;
    private final UnaryCallable<UpdateIntentRequest, Intent> updateIntentCallable;
    private final UnaryCallable<DeleteIntentRequest, Empty> deleteIntentCallable;
    private final UnaryCallable<ImportIntentsRequest, Operation> importIntentsCallable;
    private final OperationCallable<ImportIntentsRequest, ImportIntentsResponse, ImportIntentsMetadata> importIntentsOperationCallable;
    private final UnaryCallable<ExportIntentsRequest, Operation> exportIntentsCallable;
    private final OperationCallable<ExportIntentsRequest, ExportIntentsResponse, ExportIntentsMetadata> exportIntentsOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, IntentsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonIntentsStub create(IntentsStubSettings settings) throws IOException {
        return new HttpJsonIntentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonIntentsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonIntentsStub(IntentsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonIntentsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonIntentsStub(IntentsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonIntentsStub(IntentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonIntentsCallableFactory());
    }

    protected HttpJsonIntentsStub(IntentsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v3beta1/{name=projects/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v3beta1/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v3beta1/{name=projects/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v3beta1/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v3beta1/{name=projects/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v3beta1/{name=projects/*/locations/*}/operations").build()).build()).build());
        HttpJsonCallSettings listIntentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listIntentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIntentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIntentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createIntentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createIntentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateIntentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateIntentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("intent.name", String.valueOf(request.getIntent().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteIntentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteIntentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings importIntentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importIntentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportIntentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportIntentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listIntentsCallable = callableFactory.createUnaryCallable(listIntentsTransportSettings, settings.listIntentsSettings(), clientContext);
        this.listIntentsPagedCallable = callableFactory.createPagedCallable(listIntentsTransportSettings, settings.listIntentsSettings(), clientContext);
        this.getIntentCallable = callableFactory.createUnaryCallable(getIntentTransportSettings, settings.getIntentSettings(), clientContext);
        this.createIntentCallable = callableFactory.createUnaryCallable(createIntentTransportSettings, settings.createIntentSettings(), clientContext);
        this.updateIntentCallable = callableFactory.createUnaryCallable(updateIntentTransportSettings, settings.updateIntentSettings(), clientContext);
        this.deleteIntentCallable = callableFactory.createUnaryCallable(deleteIntentTransportSettings, settings.deleteIntentSettings(), clientContext);
        this.importIntentsCallable = callableFactory.createUnaryCallable(importIntentsTransportSettings, settings.importIntentsSettings(), clientContext);
        this.importIntentsOperationCallable = callableFactory.createOperationCallable(importIntentsTransportSettings, settings.importIntentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportIntentsCallable = callableFactory.createUnaryCallable(exportIntentsTransportSettings, settings.exportIntentsSettings(), clientContext);
        this.exportIntentsOperationCallable = callableFactory.createOperationCallable(exportIntentsTransportSettings, settings.exportIntentsOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listIntentsMethodDescriptor);
        methodDescriptors.add(getIntentMethodDescriptor);
        methodDescriptors.add(createIntentMethodDescriptor);
        methodDescriptors.add(updateIntentMethodDescriptor);
        methodDescriptors.add(deleteIntentMethodDescriptor);
        methodDescriptors.add(importIntentsMethodDescriptor);
        methodDescriptors.add(exportIntentsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListIntentsRequest, ListIntentsResponse> listIntentsCallable() {
        return this.listIntentsCallable;
    }

    @Override
    public UnaryCallable<ListIntentsRequest, IntentsClient.ListIntentsPagedResponse> listIntentsPagedCallable() {
        return this.listIntentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetIntentRequest, Intent> getIntentCallable() {
        return this.getIntentCallable;
    }

    @Override
    public UnaryCallable<CreateIntentRequest, Intent> createIntentCallable() {
        return this.createIntentCallable;
    }

    @Override
    public UnaryCallable<UpdateIntentRequest, Intent> updateIntentCallable() {
        return this.updateIntentCallable;
    }

    @Override
    public UnaryCallable<DeleteIntentRequest, Empty> deleteIntentCallable() {
        return this.deleteIntentCallable;
    }

    @Override
    public UnaryCallable<ImportIntentsRequest, Operation> importIntentsCallable() {
        return this.importIntentsCallable;
    }

    @Override
    public OperationCallable<ImportIntentsRequest, ImportIntentsResponse, ImportIntentsMetadata> importIntentsOperationCallable() {
        return this.importIntentsOperationCallable;
    }

    @Override
    public UnaryCallable<ExportIntentsRequest, Operation> exportIntentsCallable() {
        return this.exportIntentsCallable;
    }

    @Override
    public OperationCallable<ExportIntentsRequest, ExportIntentsResponse, ExportIntentsMetadata> exportIntentsOperationCallable() {
        return this.exportIntentsOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, IntentsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

