/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.Agent;
import com.google.cloud.dialogflow.cx.v3beta1.AgentValidationResult;
import com.google.cloud.dialogflow.cx.v3beta1.AgentsClient;
import com.google.cloud.dialogflow.cx.v3beta1.CreateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportAgentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GetAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetAgentValidationResultRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListAgentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListAgentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ValidateAgentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.AgentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcAgentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class AgentsStubSettings
extends StubSettings<AgentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse> listAgentsSettings;
    private final UnaryCallSettings<GetAgentRequest, Agent> getAgentSettings;
    private final UnaryCallSettings<CreateAgentRequest, Agent> createAgentSettings;
    private final UnaryCallSettings<UpdateAgentRequest, Agent> updateAgentSettings;
    private final UnaryCallSettings<DeleteAgentRequest, Empty> deleteAgentSettings;
    private final UnaryCallSettings<ExportAgentRequest, Operation> exportAgentSettings;
    private final OperationCallSettings<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings;
    private final UnaryCallSettings<RestoreAgentRequest, Operation> restoreAgentSettings;
    private final OperationCallSettings<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings;
    private final UnaryCallSettings<ValidateAgentRequest, AgentValidationResult> validateAgentSettings;
    private final UnaryCallSettings<GetAgentValidationResultRequest, AgentValidationResult> getAgentValidationResultSettings;
    private static final PagedListDescriptor<ListAgentsRequest, ListAgentsResponse, Agent> LIST_AGENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAgentsRequest, ListAgentsResponse, Agent>(){

        public String emptyToken() {
            return "";
        }

        public ListAgentsRequest injectToken(ListAgentsRequest payload, String token) {
            return ListAgentsRequest.newBuilder((ListAgentsRequest)payload).setPageToken(token).build();
        }

        public ListAgentsRequest injectPageSize(ListAgentsRequest payload, int pageSize) {
            return ListAgentsRequest.newBuilder((ListAgentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAgentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAgentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Agent> extractResources(ListAgentsResponse payload) {
            return payload.getAgentsList() == null ? ImmutableList.of() : payload.getAgentsList();
        }
    };
    private static final PagedListResponseFactory<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse> LIST_AGENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse>(){

        public ApiFuture<AgentsClient.ListAgentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAgentsRequest, ListAgentsResponse> callable, ListAgentsRequest request, ApiCallContext context, ApiFuture<ListAgentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AGENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AgentsClient.ListAgentsPagedResponse.createAsync((PageContext<ListAgentsRequest, ListAgentsResponse, Agent>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse> listAgentsSettings() {
        return this.listAgentsSettings;
    }

    public UnaryCallSettings<GetAgentRequest, Agent> getAgentSettings() {
        return this.getAgentSettings;
    }

    public UnaryCallSettings<CreateAgentRequest, Agent> createAgentSettings() {
        return this.createAgentSettings;
    }

    public UnaryCallSettings<UpdateAgentRequest, Agent> updateAgentSettings() {
        return this.updateAgentSettings;
    }

    public UnaryCallSettings<DeleteAgentRequest, Empty> deleteAgentSettings() {
        return this.deleteAgentSettings;
    }

    public UnaryCallSettings<ExportAgentRequest, Operation> exportAgentSettings() {
        return this.exportAgentSettings;
    }

    public OperationCallSettings<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings() {
        return this.exportAgentOperationSettings;
    }

    public UnaryCallSettings<RestoreAgentRequest, Operation> restoreAgentSettings() {
        return this.restoreAgentSettings;
    }

    public OperationCallSettings<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings() {
        return this.restoreAgentOperationSettings;
    }

    public UnaryCallSettings<ValidateAgentRequest, AgentValidationResult> validateAgentSettings() {
        return this.validateAgentSettings;
    }

    public UnaryCallSettings<GetAgentValidationResultRequest, AgentValidationResult> getAgentValidationResultSettings() {
        return this.getAgentValidationResultSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AgentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAgentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AgentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AgentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AgentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAgentsSettings = settingsBuilder.listAgentsSettings().build();
        this.getAgentSettings = settingsBuilder.getAgentSettings().build();
        this.createAgentSettings = settingsBuilder.createAgentSettings().build();
        this.updateAgentSettings = settingsBuilder.updateAgentSettings().build();
        this.deleteAgentSettings = settingsBuilder.deleteAgentSettings().build();
        this.exportAgentSettings = settingsBuilder.exportAgentSettings().build();
        this.exportAgentOperationSettings = settingsBuilder.exportAgentOperationSettings().build();
        this.restoreAgentSettings = settingsBuilder.restoreAgentSettings().build();
        this.restoreAgentOperationSettings = settingsBuilder.restoreAgentOperationSettings().build();
        this.validateAgentSettings = settingsBuilder.validateAgentSettings().build();
        this.getAgentValidationResultSettings = settingsBuilder.getAgentValidationResultSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AgentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse> listAgentsSettings;
        private final UnaryCallSettings.Builder<GetAgentRequest, Agent> getAgentSettings;
        private final UnaryCallSettings.Builder<CreateAgentRequest, Agent> createAgentSettings;
        private final UnaryCallSettings.Builder<UpdateAgentRequest, Agent> updateAgentSettings;
        private final UnaryCallSettings.Builder<DeleteAgentRequest, Empty> deleteAgentSettings;
        private final UnaryCallSettings.Builder<ExportAgentRequest, Operation> exportAgentSettings;
        private final OperationCallSettings.Builder<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings;
        private final UnaryCallSettings.Builder<RestoreAgentRequest, Operation> restoreAgentSettings;
        private final OperationCallSettings.Builder<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings;
        private final UnaryCallSettings.Builder<ValidateAgentRequest, AgentValidationResult> validateAgentSettings;
        private final UnaryCallSettings.Builder<GetAgentValidationResultRequest, AgentValidationResult> getAgentValidationResultSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAgentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AGENTS_PAGE_STR_FACT);
            this.getAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportAgentOperationSettings = OperationCallSettings.newBuilder();
            this.restoreAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreAgentOperationSettings = OperationCallSettings.newBuilder();
            this.validateAgentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAgentValidationResultSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAgentsSettings, this.getAgentSettings, this.createAgentSettings, this.updateAgentSettings, this.deleteAgentSettings, this.exportAgentSettings, this.restoreAgentSettings, this.validateAgentSettings, this.getAgentValidationResultSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AgentsStubSettings settings) {
            super((StubSettings)settings);
            this.listAgentsSettings = settings.listAgentsSettings.toBuilder();
            this.getAgentSettings = settings.getAgentSettings.toBuilder();
            this.createAgentSettings = settings.createAgentSettings.toBuilder();
            this.updateAgentSettings = settings.updateAgentSettings.toBuilder();
            this.deleteAgentSettings = settings.deleteAgentSettings.toBuilder();
            this.exportAgentSettings = settings.exportAgentSettings.toBuilder();
            this.exportAgentOperationSettings = settings.exportAgentOperationSettings.toBuilder();
            this.restoreAgentSettings = settings.restoreAgentSettings.toBuilder();
            this.restoreAgentOperationSettings = settings.restoreAgentOperationSettings.toBuilder();
            this.validateAgentSettings = settings.validateAgentSettings.toBuilder();
            this.getAgentValidationResultSettings = settings.getAgentValidationResultSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAgentsSettings, this.getAgentSettings, this.createAgentSettings, this.updateAgentSettings, this.deleteAgentSettings, this.exportAgentSettings, this.restoreAgentSettings, this.validateAgentSettings, this.getAgentValidationResultSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AgentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AgentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AgentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AgentsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAgentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.restoreAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.validateAgentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAgentValidationResultSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportAgentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.restoreAgentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAgentsRequest, ListAgentsResponse, AgentsClient.ListAgentsPagedResponse> listAgentsSettings() {
            return this.listAgentsSettings;
        }

        public UnaryCallSettings.Builder<GetAgentRequest, Agent> getAgentSettings() {
            return this.getAgentSettings;
        }

        public UnaryCallSettings.Builder<CreateAgentRequest, Agent> createAgentSettings() {
            return this.createAgentSettings;
        }

        public UnaryCallSettings.Builder<UpdateAgentRequest, Agent> updateAgentSettings() {
            return this.updateAgentSettings;
        }

        public UnaryCallSettings.Builder<DeleteAgentRequest, Empty> deleteAgentSettings() {
            return this.deleteAgentSettings;
        }

        public UnaryCallSettings.Builder<ExportAgentRequest, Operation> exportAgentSettings() {
            return this.exportAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationSettings() {
            return this.exportAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<RestoreAgentRequest, Operation> restoreAgentSettings() {
            return this.restoreAgentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RestoreAgentRequest, Empty, Struct> restoreAgentOperationSettings() {
            return this.restoreAgentOperationSettings;
        }

        public UnaryCallSettings.Builder<ValidateAgentRequest, AgentValidationResult> validateAgentSettings() {
            return this.validateAgentSettings;
        }

        public UnaryCallSettings.Builder<GetAgentValidationResultRequest, AgentValidationResult> getAgentValidationResultSettings() {
            return this.getAgentValidationResultSettings;
        }

        public AgentsStubSettings build() throws IOException {
            return new AgentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

