/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Example;
import com.google.cloud.dialogflow.cx.v3beta1.ExamplesClient;
import com.google.cloud.dialogflow.cx.v3beta1.GetExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExamplesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExamplesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExamplesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcExamplesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonExamplesStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ExamplesStubSettings
extends StubSettings<ExamplesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateExampleRequest, Example> createExampleSettings;
    private final UnaryCallSettings<DeleteExampleRequest, Empty> deleteExampleSettings;
    private final PagedCallSettings<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse> listExamplesSettings;
    private final UnaryCallSettings<GetExampleRequest, Example> getExampleSettings;
    private final UnaryCallSettings<UpdateExampleRequest, Example> updateExampleSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListExamplesRequest, ListExamplesResponse, Example> LIST_EXAMPLES_PAGE_STR_DESC = new PagedListDescriptor<ListExamplesRequest, ListExamplesResponse, Example>(){

        public String emptyToken() {
            return "";
        }

        public ListExamplesRequest injectToken(ListExamplesRequest payload, String token) {
            return ListExamplesRequest.newBuilder((ListExamplesRequest)payload).setPageToken(token).build();
        }

        public ListExamplesRequest injectPageSize(ListExamplesRequest payload, int pageSize) {
            return ListExamplesRequest.newBuilder((ListExamplesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExamplesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExamplesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Example> extractResources(ListExamplesResponse payload) {
            return payload.getExamplesList() == null ? ImmutableList.of() : payload.getExamplesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse> LIST_EXAMPLES_PAGE_STR_FACT = new PagedListResponseFactory<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse>(){

        public ApiFuture<ExamplesClient.ListExamplesPagedResponse> getFuturePagedResponse(UnaryCallable<ListExamplesRequest, ListExamplesResponse> callable, ListExamplesRequest request, ApiCallContext context, ApiFuture<ListExamplesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXAMPLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExamplesClient.ListExamplesPagedResponse.createAsync((PageContext<ListExamplesRequest, ListExamplesResponse, Example>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse>(){

        public ApiFuture<ExamplesClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExamplesClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateExampleRequest, Example> createExampleSettings() {
        return this.createExampleSettings;
    }

    public UnaryCallSettings<DeleteExampleRequest, Empty> deleteExampleSettings() {
        return this.deleteExampleSettings;
    }

    public PagedCallSettings<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse> listExamplesSettings() {
        return this.listExamplesSettings;
    }

    public UnaryCallSettings<GetExampleRequest, Example> getExampleSettings() {
        return this.getExampleSettings;
    }

    public UnaryCallSettings<UpdateExampleRequest, Example> updateExampleSettings() {
        return this.updateExampleSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ExamplesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExamplesStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonExamplesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExamplesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExamplesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExamplesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ExamplesStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExamplesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createExampleSettings = settingsBuilder.createExampleSettings().build();
        this.deleteExampleSettings = settingsBuilder.deleteExampleSettings().build();
        this.listExamplesSettings = settingsBuilder.listExamplesSettings().build();
        this.getExampleSettings = settingsBuilder.getExampleSettings().build();
        this.updateExampleSettings = settingsBuilder.updateExampleSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExamplesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateExampleRequest, Example> createExampleSettings;
        private final UnaryCallSettings.Builder<DeleteExampleRequest, Empty> deleteExampleSettings;
        private final PagedCallSettings.Builder<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse> listExamplesSettings;
        private final UnaryCallSettings.Builder<GetExampleRequest, Example> getExampleSettings;
        private final UnaryCallSettings.Builder<UpdateExampleRequest, Example> updateExampleSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createExampleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExampleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExamplesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXAMPLES_PAGE_STR_FACT);
            this.getExampleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExampleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createExampleSettings, this.deleteExampleSettings, this.listExamplesSettings, this.getExampleSettings, this.updateExampleSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExamplesStubSettings settings) {
            super((StubSettings)settings);
            this.createExampleSettings = settings.createExampleSettings.toBuilder();
            this.deleteExampleSettings = settings.deleteExampleSettings.toBuilder();
            this.listExamplesSettings = settings.listExamplesSettings.toBuilder();
            this.getExampleSettings = settings.getExampleSettings.toBuilder();
            this.updateExampleSettings = settings.updateExampleSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createExampleSettings, this.deleteExampleSettings, this.listExamplesSettings, this.getExampleSettings, this.updateExampleSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExamplesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExamplesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExamplesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ExamplesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ExamplesStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ExamplesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExamplesStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ExamplesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createExampleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteExampleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listExamplesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getExampleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateExampleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateExampleRequest, Example> createExampleSettings() {
            return this.createExampleSettings;
        }

        public UnaryCallSettings.Builder<DeleteExampleRequest, Empty> deleteExampleSettings() {
            return this.deleteExampleSettings;
        }

        public PagedCallSettings.Builder<ListExamplesRequest, ListExamplesResponse, ExamplesClient.ListExamplesPagedResponse> listExamplesSettings() {
            return this.listExamplesSettings;
        }

        public UnaryCallSettings.Builder<GetExampleRequest, Example> getExampleSettings() {
            return this.getExampleSettings;
        }

        public UnaryCallSettings.Builder<UpdateExampleRequest, Example> updateExampleSettings() {
            return this.updateExampleSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ExamplesClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ExamplesStubSettings build() throws IOException {
            return new ExamplesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

