/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.Changelog;
import com.google.cloud.dialogflow.cx.v3.ChangelogsClient;
import com.google.cloud.dialogflow.cx.v3.GetChangelogRequest;
import com.google.cloud.dialogflow.cx.v3.ListChangelogsRequest;
import com.google.cloud.dialogflow.cx.v3.ListChangelogsResponse;
import com.google.cloud.dialogflow.cx.v3.stub.ChangelogsStub;
import com.google.cloud.dialogflow.cx.v3.stub.ChangelogsStubSettings;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcChangelogsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcChangelogsStub
extends ChangelogsStub {
    private static final MethodDescriptor<ListChangelogsRequest, ListChangelogsResponse> listChangelogsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Changelogs/ListChangelogs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListChangelogsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListChangelogsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetChangelogRequest, Changelog> getChangelogMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Changelogs/GetChangelog").setRequestMarshaller(ProtoUtils.marshaller((Message)GetChangelogRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Changelog.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListChangelogsRequest, ListChangelogsResponse> listChangelogsCallable;
    private final UnaryCallable<ListChangelogsRequest, ChangelogsClient.ListChangelogsPagedResponse> listChangelogsPagedCallable;
    private final UnaryCallable<GetChangelogRequest, Changelog> getChangelogCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ChangelogsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcChangelogsStub create(ChangelogsStubSettings settings) throws IOException {
        return new GrpcChangelogsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcChangelogsStub create(ClientContext clientContext) throws IOException {
        return new GrpcChangelogsStub(ChangelogsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcChangelogsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcChangelogsStub(ChangelogsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcChangelogsStub(ChangelogsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcChangelogsCallableFactory());
    }

    protected GrpcChangelogsStub(ChangelogsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listChangelogsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listChangelogsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getChangelogTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getChangelogMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listChangelogsCallable = callableFactory.createUnaryCallable(listChangelogsTransportSettings, settings.listChangelogsSettings(), clientContext);
        this.listChangelogsPagedCallable = callableFactory.createPagedCallable(listChangelogsTransportSettings, settings.listChangelogsSettings(), clientContext);
        this.getChangelogCallable = callableFactory.createUnaryCallable(getChangelogTransportSettings, settings.getChangelogSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListChangelogsRequest, ListChangelogsResponse> listChangelogsCallable() {
        return this.listChangelogsCallable;
    }

    @Override
    public UnaryCallable<ListChangelogsRequest, ChangelogsClient.ListChangelogsPagedResponse> listChangelogsPagedCallable() {
        return this.listChangelogsPagedCallable;
    }

    @Override
    public UnaryCallable<GetChangelogRequest, Changelog> getChangelogCallable() {
        return this.getChangelogCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ChangelogsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

