/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.FulfillIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.FulfillIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.MatchIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.MatchIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.StreamingDetectIntentResponse;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcSessionsCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SessionsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SessionsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcSessionsStub
extends SessionsStub {
    private static final MethodDescriptor<DetectIntentRequest, DetectIntentResponse> detectIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/DetectIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)DetectIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DetectIntentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StreamingDetectIntentRequest, StreamingDetectIntentResponse> streamingDetectIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/StreamingDetectIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)StreamingDetectIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StreamingDetectIntentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MatchIntentRequest, MatchIntentResponse> matchIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/MatchIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)MatchIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MatchIntentResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Sessions/FulfillIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)FulfillIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FulfillIntentResponse.getDefaultInstance())).build();
    private final UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable;
    private final BidiStreamingCallable<StreamingDetectIntentRequest, StreamingDetectIntentResponse> streamingDetectIntentCallable;
    private final UnaryCallable<MatchIntentRequest, MatchIntentResponse> matchIntentCallable;
    private final UnaryCallable<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSessionsStub create(SessionsStubSettings settings) throws IOException {
        return new GrpcSessionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSessionsStub create(ClientContext clientContext) throws IOException {
        return new GrpcSessionsStub(SessionsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSessionsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSessionsStub(SessionsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSessionsStub(SessionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSessionsCallableFactory());
    }

    protected GrpcSessionsStub(SessionsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings detectIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detectIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DetectIntentRequest>(){

            public Map<String, String> extract(DetectIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings streamingDetectIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(streamingDetectIntentMethodDescriptor).build();
        GrpcCallSettings matchIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(matchIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<MatchIntentRequest>(){

            public Map<String, String> extract(MatchIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"session", (Object)String.valueOf(request.getSession()));
                return params.build();
            }
        }).build();
        GrpcCallSettings fulfillIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fulfillIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<FulfillIntentRequest>(){

            public Map<String, String> extract(FulfillIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"match_intent_request.session", (Object)String.valueOf(request.getMatchIntentRequest().getSession()));
                return params.build();
            }
        }).build();
        this.detectIntentCallable = callableFactory.createUnaryCallable(detectIntentTransportSettings, settings.detectIntentSettings(), clientContext);
        this.streamingDetectIntentCallable = callableFactory.createBidiStreamingCallable(streamingDetectIntentTransportSettings, settings.streamingDetectIntentSettings(), clientContext);
        this.matchIntentCallable = callableFactory.createUnaryCallable(matchIntentTransportSettings, settings.matchIntentSettings(), clientContext);
        this.fulfillIntentCallable = callableFactory.createUnaryCallable(fulfillIntentTransportSettings, settings.fulfillIntentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<DetectIntentRequest, DetectIntentResponse> detectIntentCallable() {
        return this.detectIntentCallable;
    }

    @Override
    public BidiStreamingCallable<StreamingDetectIntentRequest, StreamingDetectIntentResponse> streamingDetectIntentCallable() {
        return this.streamingDetectIntentCallable;
    }

    @Override
    public UnaryCallable<MatchIntentRequest, MatchIntentResponse> matchIntentCallable() {
        return this.matchIntentCallable;
    }

    @Override
    public UnaryCallable<FulfillIntentRequest, FulfillIntentResponse> fulfillIntentCallable() {
        return this.fulfillIntentCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

