/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetPageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPagesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPagesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Page;
import com.google.cloud.dialogflow.cx.v3beta1.PagesClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcPagesCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PagesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PagesStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPagesStub
extends PagesStub {
    private static final MethodDescriptor<ListPagesRequest, ListPagesResponse> listPagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Pages/ListPages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPageRequest, Page> getPageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Pages/GetPage").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Page.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePageRequest, Page> createPageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Pages/CreatePage").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Page.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdatePageRequest, Page> updatePageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Pages/UpdatePage").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Page.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePageRequest, Empty> deletePageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Pages/DeletePage").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListPagesRequest, ListPagesResponse> listPagesCallable;
    private final UnaryCallable<ListPagesRequest, PagesClient.ListPagesPagedResponse> listPagesPagedCallable;
    private final UnaryCallable<GetPageRequest, Page> getPageCallable;
    private final UnaryCallable<CreatePageRequest, Page> createPageCallable;
    private final UnaryCallable<UpdatePageRequest, Page> updatePageCallable;
    private final UnaryCallable<DeletePageRequest, Empty> deletePageCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, PagesClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPagesStub create(PagesStubSettings settings) throws IOException {
        return new GrpcPagesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPagesStub create(ClientContext clientContext) throws IOException {
        return new GrpcPagesStub(PagesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPagesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPagesStub(PagesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPagesStub(PagesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPagesCallableFactory());
    }

    protected GrpcPagesStub(PagesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listPagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPagesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("page.name", String.valueOf(request.getPage().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listPagesCallable = callableFactory.createUnaryCallable(listPagesTransportSettings, settings.listPagesSettings(), clientContext);
        this.listPagesPagedCallable = callableFactory.createPagedCallable(listPagesTransportSettings, settings.listPagesSettings(), clientContext);
        this.getPageCallable = callableFactory.createUnaryCallable(getPageTransportSettings, settings.getPageSettings(), clientContext);
        this.createPageCallable = callableFactory.createUnaryCallable(createPageTransportSettings, settings.createPageSettings(), clientContext);
        this.updatePageCallable = callableFactory.createUnaryCallable(updatePageTransportSettings, settings.updatePageSettings(), clientContext);
        this.deletePageCallable = callableFactory.createUnaryCallable(deletePageTransportSettings, settings.deletePageSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListPagesRequest, ListPagesResponse> listPagesCallable() {
        return this.listPagesCallable;
    }

    @Override
    public UnaryCallable<ListPagesRequest, PagesClient.ListPagesPagedResponse> listPagesPagedCallable() {
        return this.listPagesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPageRequest, Page> getPageCallable() {
        return this.getPageCallable;
    }

    @Override
    public UnaryCallable<CreatePageRequest, Page> createPageCallable() {
        return this.createPageCallable;
    }

    @Override
    public UnaryCallable<UpdatePageRequest, Page> updatePageCallable() {
        return this.updatePageCallable;
    }

    @Override
    public UnaryCallable<DeletePageRequest, Empty> deletePageCallable() {
        return this.deletePageCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, PagesClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

