/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListWebhooksResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateWebhookRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Webhook;
import com.google.cloud.dialogflow.cx.v3beta1.WebhooksClient;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcWebhooksCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.WebhooksStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.WebhooksStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcWebhooksStub
extends WebhooksStub {
    private static final MethodDescriptor<ListWebhooksRequest, ListWebhooksResponse> listWebhooksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Webhooks/ListWebhooks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListWebhooksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListWebhooksResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetWebhookRequest, Webhook> getWebhookMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Webhooks/GetWebhook").setRequestMarshaller(ProtoUtils.marshaller((Message)GetWebhookRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Webhook.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateWebhookRequest, Webhook> createWebhookMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Webhooks/CreateWebhook").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateWebhookRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Webhook.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateWebhookRequest, Webhook> updateWebhookMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Webhooks/UpdateWebhook").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateWebhookRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Webhook.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteWebhookRequest, Empty> deleteWebhookMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Webhooks/DeleteWebhook").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteWebhookRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListWebhooksRequest, ListWebhooksResponse> listWebhooksCallable;
    private final UnaryCallable<ListWebhooksRequest, WebhooksClient.ListWebhooksPagedResponse> listWebhooksPagedCallable;
    private final UnaryCallable<GetWebhookRequest, Webhook> getWebhookCallable;
    private final UnaryCallable<CreateWebhookRequest, Webhook> createWebhookCallable;
    private final UnaryCallable<UpdateWebhookRequest, Webhook> updateWebhookCallable;
    private final UnaryCallable<DeleteWebhookRequest, Empty> deleteWebhookCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, WebhooksClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcWebhooksStub create(WebhooksStubSettings settings) throws IOException {
        return new GrpcWebhooksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcWebhooksStub create(ClientContext clientContext) throws IOException {
        return new GrpcWebhooksStub(WebhooksStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcWebhooksStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcWebhooksStub(WebhooksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcWebhooksStub(WebhooksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcWebhooksCallableFactory());
    }

    protected GrpcWebhooksStub(WebhooksStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listWebhooksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listWebhooksMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getWebhookTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getWebhookMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createWebhookTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createWebhookMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateWebhookTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateWebhookMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"webhook.name", (Object)String.valueOf(request.getWebhook().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteWebhookTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteWebhookMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listWebhooksCallable = callableFactory.createUnaryCallable(listWebhooksTransportSettings, settings.listWebhooksSettings(), clientContext);
        this.listWebhooksPagedCallable = callableFactory.createPagedCallable(listWebhooksTransportSettings, settings.listWebhooksSettings(), clientContext);
        this.getWebhookCallable = callableFactory.createUnaryCallable(getWebhookTransportSettings, settings.getWebhookSettings(), clientContext);
        this.createWebhookCallable = callableFactory.createUnaryCallable(createWebhookTransportSettings, settings.createWebhookSettings(), clientContext);
        this.updateWebhookCallable = callableFactory.createUnaryCallable(updateWebhookTransportSettings, settings.updateWebhookSettings(), clientContext);
        this.deleteWebhookCallable = callableFactory.createUnaryCallable(deleteWebhookTransportSettings, settings.deleteWebhookSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListWebhooksRequest, ListWebhooksResponse> listWebhooksCallable() {
        return this.listWebhooksCallable;
    }

    @Override
    public UnaryCallable<ListWebhooksRequest, WebhooksClient.ListWebhooksPagedResponse> listWebhooksPagedCallable() {
        return this.listWebhooksPagedCallable;
    }

    @Override
    public UnaryCallable<GetWebhookRequest, Webhook> getWebhookCallable() {
        return this.getWebhookCallable;
    }

    @Override
    public UnaryCallable<CreateWebhookRequest, Webhook> createWebhookCallable() {
        return this.createWebhookCallable;
    }

    @Override
    public UnaryCallable<UpdateWebhookRequest, Webhook> updateWebhookCallable() {
        return this.updateWebhookCallable;
    }

    @Override
    public UnaryCallable<DeleteWebhookRequest, Empty> deleteWebhookCallable() {
        return this.deleteWebhookCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, WebhooksClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

