/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CompareVersionsRequest;
import com.google.cloud.dialogflow.cx.v3.CompareVersionsResponse;
import com.google.cloud.dialogflow.cx.v3.CreateVersionOperationMetadata;
import com.google.cloud.dialogflow.cx.v3.CreateVersionRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteVersionRequest;
import com.google.cloud.dialogflow.cx.v3.FlowName;
import com.google.cloud.dialogflow.cx.v3.GetVersionRequest;
import com.google.cloud.dialogflow.cx.v3.ListVersionsRequest;
import com.google.cloud.dialogflow.cx.v3.ListVersionsResponse;
import com.google.cloud.dialogflow.cx.v3.LoadVersionRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateVersionRequest;
import com.google.cloud.dialogflow.cx.v3.Version;
import com.google.cloud.dialogflow.cx.v3.VersionName;
import com.google.cloud.dialogflow.cx.v3.VersionsSettings;
import com.google.cloud.dialogflow.cx.v3.stub.VersionsStub;
import com.google.cloud.dialogflow.cx.v3.stub.VersionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VersionsClient
implements BackgroundResource {
    private final VersionsSettings settings;
    private final VersionsStub stub;
    private final OperationsClient operationsClient;

    public static final VersionsClient create() throws IOException {
        return VersionsClient.create(VersionsSettings.newBuilder().build());
    }

    public static final VersionsClient create(VersionsSettings settings) throws IOException {
        return new VersionsClient(settings);
    }

    public static final VersionsClient create(VersionsStub stub) {
        return new VersionsClient(stub);
    }

    protected VersionsClient(VersionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VersionsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected VersionsClient(VersionsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VersionsSettings getSettings() {
        return this.settings;
    }

    public VersionsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListVersionsPagedResponse listVersions(FlowName parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(String parent) {
        ListVersionsRequest request = ListVersionsRequest.newBuilder().setParent(parent).build();
        return this.listVersions(request);
    }

    public final ListVersionsPagedResponse listVersions(ListVersionsRequest request) {
        return (ListVersionsPagedResponse)((Object)this.listVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.stub.listVersionsPagedCallable();
    }

    public final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.stub.listVersionsCallable();
    }

    public final Version getVersion(VersionName name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVersion(request);
    }

    public final Version getVersion(String name) {
        GetVersionRequest request = GetVersionRequest.newBuilder().setName(name).build();
        return this.getVersion(request);
    }

    public final Version getVersion(GetVersionRequest request) {
        return (Version)this.getVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.stub.getVersionCallable();
    }

    public final OperationFuture<Version, CreateVersionOperationMetadata> createVersionAsync(FlowName parent, Version version) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVersion(version).build();
        return this.createVersionAsync(request);
    }

    public final OperationFuture<Version, CreateVersionOperationMetadata> createVersionAsync(String parent, Version version) {
        CreateVersionRequest request = CreateVersionRequest.newBuilder().setParent(parent).setVersion(version).build();
        return this.createVersionAsync(request);
    }

    public final OperationFuture<Version, CreateVersionOperationMetadata> createVersionAsync(CreateVersionRequest request) {
        return this.createVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVersionRequest, Version, CreateVersionOperationMetadata> createVersionOperationCallable() {
        return this.stub.createVersionOperationCallable();
    }

    public final UnaryCallable<CreateVersionRequest, Operation> createVersionCallable() {
        return this.stub.createVersionCallable();
    }

    public final Version updateVersion(Version version, FieldMask updateMask) {
        UpdateVersionRequest request = UpdateVersionRequest.newBuilder().setVersion(version).setUpdateMask(updateMask).build();
        return this.updateVersion(request);
    }

    public final Version updateVersion(UpdateVersionRequest request) {
        return (Version)this.updateVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.stub.updateVersionCallable();
    }

    public final void deleteVersion(VersionName name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(String name) {
        DeleteVersionRequest request = DeleteVersionRequest.newBuilder().setName(name).build();
        this.deleteVersion(request);
    }

    public final void deleteVersion(DeleteVersionRequest request) {
        this.deleteVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable() {
        return this.stub.deleteVersionCallable();
    }

    public final OperationFuture<Empty, Struct> loadVersionAsync(VersionName name) {
        LoadVersionRequest request = LoadVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.loadVersionAsync(request);
    }

    public final OperationFuture<Empty, Struct> loadVersionAsync(String name) {
        LoadVersionRequest request = LoadVersionRequest.newBuilder().setName(name).build();
        return this.loadVersionAsync(request);
    }

    public final OperationFuture<Empty, Struct> loadVersionAsync(LoadVersionRequest request) {
        return this.loadVersionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LoadVersionRequest, Empty, Struct> loadVersionOperationCallable() {
        return this.stub.loadVersionOperationCallable();
    }

    public final UnaryCallable<LoadVersionRequest, Operation> loadVersionCallable() {
        return this.stub.loadVersionCallable();
    }

    public final CompareVersionsResponse compareVersions(VersionName baseVersion) {
        CompareVersionsRequest request = CompareVersionsRequest.newBuilder().setBaseVersion(baseVersion == null ? null : baseVersion.toString()).build();
        return this.compareVersions(request);
    }

    public final CompareVersionsResponse compareVersions(String baseVersion) {
        CompareVersionsRequest request = CompareVersionsRequest.newBuilder().setBaseVersion(baseVersion).build();
        return this.compareVersions(request);
    }

    public final CompareVersionsResponse compareVersions(CompareVersionsRequest request) {
        return (CompareVersionsResponse)this.compareVersionsCallable().call((Object)request);
    }

    public final UnaryCallable<CompareVersionsRequest, CompareVersionsResponse> compareVersionsCallable() {
        return this.stub.compareVersionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        private ListVersionsFixedSizeCollection(List<ListVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVersionsFixedSizeCollection createEmptyCollection() {
            return new ListVersionsFixedSizeCollection(null, 0);
        }

        protected ListVersionsFixedSizeCollection createCollection(List<ListVersionsPage> pages, int collectionSize) {
            return new ListVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVersionsPage
    extends AbstractPage<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage> {
        private ListVersionsPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListVersionsPage createEmptyPage() {
            return new ListVersionsPage(null, null);
        }

        protected ListVersionsPage createPage(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ListVersionsResponse response) {
            return new ListVersionsPage(context, response);
        }

        public ApiFuture<ListVersionsPage> createPageAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVersionsPagedResponse
    extends AbstractPagedListResponse<ListVersionsRequest, ListVersionsResponse, Version, ListVersionsPage, ListVersionsFixedSizeCollection> {
        public static ApiFuture<ListVersionsPagedResponse> createAsync(PageContext<ListVersionsRequest, ListVersionsResponse, Version> context, ApiFuture<ListVersionsResponse> futureResponse) {
            ApiFuture<ListVersionsPage> futurePage = ListVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVersionsPagedResponse((ListVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVersionsPagedResponse(ListVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

