/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.ContinuousTestResult;
import com.google.cloud.dialogflow.cx.v3beta1.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Environment;
import com.google.cloud.dialogflow.cx.v3beta1.EnvironmentName;
import com.google.cloud.dialogflow.cx.v3beta1.EnvironmentsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListContinuousTestResultsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListContinuousTestResultsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.LookupEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.cx.v3beta1.LookupEnvironmentHistoryResponse;
import com.google.cloud.dialogflow.cx.v3beta1.RunContinuousTestMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.RunContinuousTestRequest;
import com.google.cloud.dialogflow.cx.v3beta1.RunContinuousTestResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.EnvironmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class EnvironmentsClient
implements BackgroundResource {
    private final EnvironmentsSettings settings;
    private final EnvironmentsStub stub;
    private final OperationsClient operationsClient;

    public static final EnvironmentsClient create() throws IOException {
        return EnvironmentsClient.create(EnvironmentsSettings.newBuilder().build());
    }

    public static final EnvironmentsClient create(EnvironmentsSettings settings) throws IOException {
        return new EnvironmentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final EnvironmentsClient create(EnvironmentsStub stub) {
        return new EnvironmentsClient(stub);
    }

    protected EnvironmentsClient(EnvironmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EnvironmentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected EnvironmentsClient(EnvironmentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final EnvironmentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnvironmentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListEnvironmentsPagedResponse listEnvironments(AgentName parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final Environment getEnvironment(EnvironmentName name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final OperationFuture<Environment, Struct> createEnvironmentAsync(AgentName parent, Environment environment) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEnvironment(environment).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, Struct> createEnvironmentAsync(String parent, Environment environment) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent).setEnvironment(environment).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, Struct> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnvironmentRequest, Environment, Struct> createEnvironmentOperationCallable() {
        return this.stub.createEnvironmentOperationCallable();
    }

    public final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final OperationFuture<Environment, Struct> updateEnvironmentAsync(Environment environment, FieldMask updateMask) {
        UpdateEnvironmentRequest request = UpdateEnvironmentRequest.newBuilder().setEnvironment(environment).setUpdateMask(updateMask).build();
        return this.updateEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, Struct> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEnvironmentRequest, Environment, Struct> updateEnvironmentOperationCallable() {
        return this.stub.updateEnvironmentOperationCallable();
    }

    public final UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable() {
        return this.stub.updateEnvironmentCallable();
    }

    public final void deleteEnvironment(EnvironmentName name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEnvironment(request);
    }

    public final void deleteEnvironment(String name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name).build();
        this.deleteEnvironment(request);
    }

    public final void deleteEnvironment(DeleteEnvironmentRequest request) {
        this.deleteEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Empty> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final LookupEnvironmentHistoryPagedResponse lookupEnvironmentHistory(EnvironmentName name) {
        LookupEnvironmentHistoryRequest request = LookupEnvironmentHistoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.lookupEnvironmentHistory(request);
    }

    public final LookupEnvironmentHistoryPagedResponse lookupEnvironmentHistory(String name) {
        LookupEnvironmentHistoryRequest request = LookupEnvironmentHistoryRequest.newBuilder().setName(name).build();
        return this.lookupEnvironmentHistory(request);
    }

    public final LookupEnvironmentHistoryPagedResponse lookupEnvironmentHistory(LookupEnvironmentHistoryRequest request) {
        return (LookupEnvironmentHistoryPagedResponse)((Object)this.lookupEnvironmentHistoryPagedCallable().call((Object)request));
    }

    public final UnaryCallable<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryPagedResponse> lookupEnvironmentHistoryPagedCallable() {
        return this.stub.lookupEnvironmentHistoryPagedCallable();
    }

    public final UnaryCallable<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse> lookupEnvironmentHistoryCallable() {
        return this.stub.lookupEnvironmentHistoryCallable();
    }

    public final OperationFuture<RunContinuousTestResponse, RunContinuousTestMetadata> runContinuousTestAsync(RunContinuousTestRequest request) {
        return this.runContinuousTestOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunContinuousTestRequest, RunContinuousTestResponse, RunContinuousTestMetadata> runContinuousTestOperationCallable() {
        return this.stub.runContinuousTestOperationCallable();
    }

    public final UnaryCallable<RunContinuousTestRequest, Operation> runContinuousTestCallable() {
        return this.stub.runContinuousTestCallable();
    }

    public final ListContinuousTestResultsPagedResponse listContinuousTestResults(EnvironmentName parent) {
        ListContinuousTestResultsRequest request = ListContinuousTestResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listContinuousTestResults(request);
    }

    public final ListContinuousTestResultsPagedResponse listContinuousTestResults(String parent) {
        ListContinuousTestResultsRequest request = ListContinuousTestResultsRequest.newBuilder().setParent(parent).build();
        return this.listContinuousTestResults(request);
    }

    public final ListContinuousTestResultsPagedResponse listContinuousTestResults(ListContinuousTestResultsRequest request) {
        return (ListContinuousTestResultsPagedResponse)((Object)this.listContinuousTestResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListContinuousTestResultsRequest, ListContinuousTestResultsPagedResponse> listContinuousTestResultsPagedCallable() {
        return this.stub.listContinuousTestResultsPagedCallable();
    }

    public final UnaryCallable<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse> listContinuousTestResultsCallable() {
        return this.stub.listContinuousTestResultsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListContinuousTestResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult, ListContinuousTestResultsPage, ListContinuousTestResultsFixedSizeCollection> {
        private ListContinuousTestResultsFixedSizeCollection(List<ListContinuousTestResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListContinuousTestResultsFixedSizeCollection createEmptyCollection() {
            return new ListContinuousTestResultsFixedSizeCollection(null, 0);
        }

        protected ListContinuousTestResultsFixedSizeCollection createCollection(List<ListContinuousTestResultsPage> pages, int collectionSize) {
            return new ListContinuousTestResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListContinuousTestResultsPage
    extends AbstractPage<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult, ListContinuousTestResultsPage> {
        private ListContinuousTestResultsPage(PageContext<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult> context, ListContinuousTestResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListContinuousTestResultsPage createEmptyPage() {
            return new ListContinuousTestResultsPage(null, null);
        }

        protected ListContinuousTestResultsPage createPage(PageContext<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult> context, ListContinuousTestResultsResponse response) {
            return new ListContinuousTestResultsPage(context, response);
        }

        public ApiFuture<ListContinuousTestResultsPage> createPageAsync(PageContext<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult> context, ApiFuture<ListContinuousTestResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListContinuousTestResultsPagedResponse
    extends AbstractPagedListResponse<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult, ListContinuousTestResultsPage, ListContinuousTestResultsFixedSizeCollection> {
        public static ApiFuture<ListContinuousTestResultsPagedResponse> createAsync(PageContext<ListContinuousTestResultsRequest, ListContinuousTestResultsResponse, ContinuousTestResult> context, ApiFuture<ListContinuousTestResultsResponse> futureResponse) {
            ApiFuture<ListContinuousTestResultsPage> futurePage = ListContinuousTestResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListContinuousTestResultsPagedResponse((ListContinuousTestResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListContinuousTestResultsPagedResponse(ListContinuousTestResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListContinuousTestResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class LookupEnvironmentHistoryFixedSizeCollection
    extends AbstractFixedSizeCollection<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment, LookupEnvironmentHistoryPage, LookupEnvironmentHistoryFixedSizeCollection> {
        private LookupEnvironmentHistoryFixedSizeCollection(List<LookupEnvironmentHistoryPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static LookupEnvironmentHistoryFixedSizeCollection createEmptyCollection() {
            return new LookupEnvironmentHistoryFixedSizeCollection(null, 0);
        }

        protected LookupEnvironmentHistoryFixedSizeCollection createCollection(List<LookupEnvironmentHistoryPage> pages, int collectionSize) {
            return new LookupEnvironmentHistoryFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class LookupEnvironmentHistoryPage
    extends AbstractPage<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment, LookupEnvironmentHistoryPage> {
        private LookupEnvironmentHistoryPage(PageContext<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment> context, LookupEnvironmentHistoryResponse response) {
            super(context, (Object)response);
        }

        private static LookupEnvironmentHistoryPage createEmptyPage() {
            return new LookupEnvironmentHistoryPage(null, null);
        }

        protected LookupEnvironmentHistoryPage createPage(PageContext<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment> context, LookupEnvironmentHistoryResponse response) {
            return new LookupEnvironmentHistoryPage(context, response);
        }

        public ApiFuture<LookupEnvironmentHistoryPage> createPageAsync(PageContext<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment> context, ApiFuture<LookupEnvironmentHistoryResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class LookupEnvironmentHistoryPagedResponse
    extends AbstractPagedListResponse<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment, LookupEnvironmentHistoryPage, LookupEnvironmentHistoryFixedSizeCollection> {
        public static ApiFuture<LookupEnvironmentHistoryPagedResponse> createAsync(PageContext<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment> context, ApiFuture<LookupEnvironmentHistoryResponse> futureResponse) {
            ApiFuture<LookupEnvironmentHistoryPage> futurePage = LookupEnvironmentHistoryPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new LookupEnvironmentHistoryPagedResponse((LookupEnvironmentHistoryPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private LookupEnvironmentHistoryPagedResponse(LookupEnvironmentHistoryPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)LookupEnvironmentHistoryFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

