/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.AccountConnector;
import com.google.cloud.developerconnect.v1.Connection;
import com.google.cloud.developerconnect.v1.CreateAccountConnectorRequest;
import com.google.cloud.developerconnect.v1.CreateConnectionRequest;
import com.google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeleteAccountConnectorRequest;
import com.google.cloud.developerconnect.v1.DeleteConnectionRequest;
import com.google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeleteSelfRequest;
import com.google.cloud.developerconnect.v1.DeleteUserRequest;
import com.google.cloud.developerconnect.v1.DeveloperConnectClient;
import com.google.cloud.developerconnect.v1.FetchAccessTokenRequest;
import com.google.cloud.developerconnect.v1.FetchAccessTokenResponse;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse;
import com.google.cloud.developerconnect.v1.FetchGitRefsRequest;
import com.google.cloud.developerconnect.v1.FetchGitRefsResponse;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse;
import com.google.cloud.developerconnect.v1.FetchReadTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadTokenResponse;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenResponse;
import com.google.cloud.developerconnect.v1.FetchSelfRequest;
import com.google.cloud.developerconnect.v1.GetAccountConnectorRequest;
import com.google.cloud.developerconnect.v1.GetConnectionRequest;
import com.google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.GitRepositoryLink;
import com.google.cloud.developerconnect.v1.LinkableGitRepository;
import com.google.cloud.developerconnect.v1.ListAccountConnectorsRequest;
import com.google.cloud.developerconnect.v1.ListAccountConnectorsResponse;
import com.google.cloud.developerconnect.v1.ListConnectionsRequest;
import com.google.cloud.developerconnect.v1.ListConnectionsResponse;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse;
import com.google.cloud.developerconnect.v1.ListUsersRequest;
import com.google.cloud.developerconnect.v1.ListUsersResponse;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateAccountConnectorRequest;
import com.google.cloud.developerconnect.v1.UpdateConnectionRequest;
import com.google.cloud.developerconnect.v1.User;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStub;
import com.google.cloud.developerconnect.v1.stub.GrpcDeveloperConnectStub;
import com.google.cloud.developerconnect.v1.stub.HttpJsonDeveloperConnectStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DeveloperConnectStubSettings
extends StubSettings<DeveloperConnectStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsSettings;
    private final UnaryCallSettings<GetConnectionRequest, Connection> getConnectionSettings;
    private final UnaryCallSettings<CreateConnectionRequest, Operation> createConnectionSettings;
    private final OperationCallSettings<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings;
    private final UnaryCallSettings<UpdateConnectionRequest, Operation> updateConnectionSettings;
    private final OperationCallSettings<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings;
    private final UnaryCallSettings<DeleteConnectionRequest, Operation> deleteConnectionSettings;
    private final OperationCallSettings<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings;
    private final UnaryCallSettings<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkSettings;
    private final OperationCallSettings<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationSettings;
    private final UnaryCallSettings<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkSettings;
    private final OperationCallSettings<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationSettings;
    private final PagedCallSettings<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksSettings;
    private final UnaryCallSettings<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkSettings;
    private final UnaryCallSettings<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings;
    private final UnaryCallSettings<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings;
    private final PagedCallSettings<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesSettings;
    private final UnaryCallSettings<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsSettings;
    private final PagedCallSettings<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsSettings;
    private final PagedCallSettings<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse> listAccountConnectorsSettings;
    private final UnaryCallSettings<GetAccountConnectorRequest, AccountConnector> getAccountConnectorSettings;
    private final UnaryCallSettings<CreateAccountConnectorRequest, Operation> createAccountConnectorSettings;
    private final OperationCallSettings<CreateAccountConnectorRequest, AccountConnector, OperationMetadata> createAccountConnectorOperationSettings;
    private final UnaryCallSettings<UpdateAccountConnectorRequest, Operation> updateAccountConnectorSettings;
    private final OperationCallSettings<UpdateAccountConnectorRequest, AccountConnector, OperationMetadata> updateAccountConnectorOperationSettings;
    private final UnaryCallSettings<DeleteAccountConnectorRequest, Operation> deleteAccountConnectorSettings;
    private final OperationCallSettings<DeleteAccountConnectorRequest, Empty, OperationMetadata> deleteAccountConnectorOperationSettings;
    private final UnaryCallSettings<FetchAccessTokenRequest, FetchAccessTokenResponse> fetchAccessTokenSettings;
    private final PagedCallSettings<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse> listUsersSettings;
    private final UnaryCallSettings<DeleteUserRequest, Operation> deleteUserSettings;
    private final OperationCallSettings<DeleteUserRequest, Empty, OperationMetadata> deleteUserOperationSettings;
    private final UnaryCallSettings<FetchSelfRequest, User> fetchSelfSettings;
    private final UnaryCallSettings<DeleteSelfRequest, Operation> deleteSelfSettings;
    private final OperationCallSettings<DeleteSelfRequest, Empty, OperationMetadata> deleteSelfOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection> LIST_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectionsRequest injectToken(ListConnectionsRequest payload, String token) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListConnectionsRequest injectPageSize(ListConnectionsRequest payload, int pageSize) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Connection> extractResources(ListConnectionsResponse payload) {
            return payload.getConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink> LIST_GIT_REPOSITORY_LINKS_PAGE_STR_DESC = new PagedListDescriptor<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink>(){

        public String emptyToken() {
            return "";
        }

        public ListGitRepositoryLinksRequest injectToken(ListGitRepositoryLinksRequest payload, String token) {
            return ListGitRepositoryLinksRequest.newBuilder((ListGitRepositoryLinksRequest)payload).setPageToken(token).build();
        }

        public ListGitRepositoryLinksRequest injectPageSize(ListGitRepositoryLinksRequest payload, int pageSize) {
            return ListGitRepositoryLinksRequest.newBuilder((ListGitRepositoryLinksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGitRepositoryLinksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGitRepositoryLinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GitRepositoryLink> extractResources(ListGitRepositoryLinksResponse payload) {
            return payload.getGitRepositoryLinksList();
        }
    };
    private static final PagedListDescriptor<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository> FETCH_LINKABLE_GIT_REPOSITORIES_PAGE_STR_DESC = new PagedListDescriptor<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository>(){

        public String emptyToken() {
            return "";
        }

        public FetchLinkableGitRepositoriesRequest injectToken(FetchLinkableGitRepositoriesRequest payload, String token) {
            return FetchLinkableGitRepositoriesRequest.newBuilder((FetchLinkableGitRepositoriesRequest)payload).setPageToken(token).build();
        }

        public FetchLinkableGitRepositoriesRequest injectPageSize(FetchLinkableGitRepositoriesRequest payload, int pageSize) {
            return FetchLinkableGitRepositoriesRequest.newBuilder((FetchLinkableGitRepositoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchLinkableGitRepositoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchLinkableGitRepositoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LinkableGitRepository> extractResources(FetchLinkableGitRepositoriesResponse payload) {
            return payload.getLinkableGitRepositoriesList();
        }
    };
    private static final PagedListDescriptor<FetchGitRefsRequest, FetchGitRefsResponse, String> FETCH_GIT_REFS_PAGE_STR_DESC = new PagedListDescriptor<FetchGitRefsRequest, FetchGitRefsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public FetchGitRefsRequest injectToken(FetchGitRefsRequest payload, String token) {
            return FetchGitRefsRequest.newBuilder((FetchGitRefsRequest)payload).setPageToken(token).build();
        }

        public FetchGitRefsRequest injectPageSize(FetchGitRefsRequest payload, int pageSize) {
            return FetchGitRefsRequest.newBuilder((FetchGitRefsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchGitRefsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchGitRefsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(FetchGitRefsResponse payload) {
            return payload.getRefNamesList();
        }
    };
    private static final PagedListDescriptor<ListAccountConnectorsRequest, ListAccountConnectorsResponse, AccountConnector> LIST_ACCOUNT_CONNECTORS_PAGE_STR_DESC = new PagedListDescriptor<ListAccountConnectorsRequest, ListAccountConnectorsResponse, AccountConnector>(){

        public String emptyToken() {
            return "";
        }

        public ListAccountConnectorsRequest injectToken(ListAccountConnectorsRequest payload, String token) {
            return ListAccountConnectorsRequest.newBuilder((ListAccountConnectorsRequest)payload).setPageToken(token).build();
        }

        public ListAccountConnectorsRequest injectPageSize(ListAccountConnectorsRequest payload, int pageSize) {
            return ListAccountConnectorsRequest.newBuilder((ListAccountConnectorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccountConnectorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccountConnectorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AccountConnector> extractResources(ListAccountConnectorsResponse payload) {
            return payload.getAccountConnectorsList();
        }
    };
    private static final PagedListDescriptor<ListUsersRequest, ListUsersResponse, User> LIST_USERS_PAGE_STR_DESC = new PagedListDescriptor<ListUsersRequest, ListUsersResponse, User>(){

        public String emptyToken() {
            return "";
        }

        public ListUsersRequest injectToken(ListUsersRequest payload, String token) {
            return ListUsersRequest.newBuilder((ListUsersRequest)payload).setPageToken(token).build();
        }

        public ListUsersRequest injectPageSize(ListUsersRequest payload, int pageSize) {
            return ListUsersRequest.newBuilder((ListUsersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUsersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUsersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<User> extractResources(ListUsersResponse payload) {
            return payload.getUsersList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse> LIST_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.ListConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> callable, ListConnectionsRequest request, ApiCallContext context, ApiFuture<ListConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.ListConnectionsPagedResponse.createAsync((PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> LIST_GIT_REPOSITORY_LINKS_PAGE_STR_FACT = new PagedListResponseFactory<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> getFuturePagedResponse(UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> callable, ListGitRepositoryLinksRequest request, ApiCallContext context, ApiFuture<ListGitRepositoryLinksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GIT_REPOSITORY_LINKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.ListGitRepositoryLinksPagedResponse.createAsync((PageContext<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> FETCH_LINKABLE_GIT_REPOSITORIES_PAGE_STR_FACT = new PagedListResponseFactory<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> getFuturePagedResponse(UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> callable, FetchLinkableGitRepositoriesRequest request, ApiCallContext context, ApiFuture<FetchLinkableGitRepositoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_LINKABLE_GIT_REPOSITORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse.createAsync((PageContext<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse> FETCH_GIT_REFS_PAGE_STR_FACT = new PagedListResponseFactory<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.FetchGitRefsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> callable, FetchGitRefsRequest request, ApiCallContext context, ApiFuture<FetchGitRefsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_GIT_REFS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.FetchGitRefsPagedResponse.createAsync((PageContext<FetchGitRefsRequest, FetchGitRefsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse> LIST_ACCOUNT_CONNECTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.ListAccountConnectorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccountConnectorsRequest, ListAccountConnectorsResponse> callable, ListAccountConnectorsRequest request, ApiCallContext context, ApiFuture<ListAccountConnectorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCOUNT_CONNECTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.ListAccountConnectorsPagedResponse.createAsync((PageContext<ListAccountConnectorsRequest, ListAccountConnectorsResponse, AccountConnector>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse> LIST_USERS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.ListUsersPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsersRequest, ListUsersResponse> callable, ListUsersRequest request, ApiCallContext context, ApiFuture<ListUsersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.ListUsersPagedResponse.createAsync((PageContext<ListUsersRequest, ListUsersResponse, User>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse>(){

        public ApiFuture<DeveloperConnectClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DeveloperConnectClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsSettings() {
        return this.listConnectionsSettings;
    }

    public UnaryCallSettings<GetConnectionRequest, Connection> getConnectionSettings() {
        return this.getConnectionSettings;
    }

    public UnaryCallSettings<CreateConnectionRequest, Operation> createConnectionSettings() {
        return this.createConnectionSettings;
    }

    public OperationCallSettings<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings() {
        return this.createConnectionOperationSettings;
    }

    public UnaryCallSettings<UpdateConnectionRequest, Operation> updateConnectionSettings() {
        return this.updateConnectionSettings;
    }

    public OperationCallSettings<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings() {
        return this.updateConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteConnectionRequest, Operation> deleteConnectionSettings() {
        return this.deleteConnectionSettings;
    }

    public OperationCallSettings<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings() {
        return this.deleteConnectionOperationSettings;
    }

    public UnaryCallSettings<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkSettings() {
        return this.createGitRepositoryLinkSettings;
    }

    public OperationCallSettings<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationSettings() {
        return this.createGitRepositoryLinkOperationSettings;
    }

    public UnaryCallSettings<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkSettings() {
        return this.deleteGitRepositoryLinkSettings;
    }

    public OperationCallSettings<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationSettings() {
        return this.deleteGitRepositoryLinkOperationSettings;
    }

    public PagedCallSettings<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksSettings() {
        return this.listGitRepositoryLinksSettings;
    }

    public UnaryCallSettings<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkSettings() {
        return this.getGitRepositoryLinkSettings;
    }

    public UnaryCallSettings<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings() {
        return this.fetchReadWriteTokenSettings;
    }

    public UnaryCallSettings<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings() {
        return this.fetchReadTokenSettings;
    }

    public PagedCallSettings<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesSettings() {
        return this.fetchLinkableGitRepositoriesSettings;
    }

    public UnaryCallSettings<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsSettings() {
        return this.fetchGitHubInstallationsSettings;
    }

    public PagedCallSettings<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsSettings() {
        return this.fetchGitRefsSettings;
    }

    public PagedCallSettings<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse> listAccountConnectorsSettings() {
        return this.listAccountConnectorsSettings;
    }

    public UnaryCallSettings<GetAccountConnectorRequest, AccountConnector> getAccountConnectorSettings() {
        return this.getAccountConnectorSettings;
    }

    public UnaryCallSettings<CreateAccountConnectorRequest, Operation> createAccountConnectorSettings() {
        return this.createAccountConnectorSettings;
    }

    public OperationCallSettings<CreateAccountConnectorRequest, AccountConnector, OperationMetadata> createAccountConnectorOperationSettings() {
        return this.createAccountConnectorOperationSettings;
    }

    public UnaryCallSettings<UpdateAccountConnectorRequest, Operation> updateAccountConnectorSettings() {
        return this.updateAccountConnectorSettings;
    }

    public OperationCallSettings<UpdateAccountConnectorRequest, AccountConnector, OperationMetadata> updateAccountConnectorOperationSettings() {
        return this.updateAccountConnectorOperationSettings;
    }

    public UnaryCallSettings<DeleteAccountConnectorRequest, Operation> deleteAccountConnectorSettings() {
        return this.deleteAccountConnectorSettings;
    }

    public OperationCallSettings<DeleteAccountConnectorRequest, Empty, OperationMetadata> deleteAccountConnectorOperationSettings() {
        return this.deleteAccountConnectorOperationSettings;
    }

    public UnaryCallSettings<FetchAccessTokenRequest, FetchAccessTokenResponse> fetchAccessTokenSettings() {
        return this.fetchAccessTokenSettings;
    }

    public PagedCallSettings<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse> listUsersSettings() {
        return this.listUsersSettings;
    }

    public UnaryCallSettings<DeleteUserRequest, Operation> deleteUserSettings() {
        return this.deleteUserSettings;
    }

    public OperationCallSettings<DeleteUserRequest, Empty, OperationMetadata> deleteUserOperationSettings() {
        return this.deleteUserOperationSettings;
    }

    public UnaryCallSettings<FetchSelfRequest, User> fetchSelfSettings() {
        return this.fetchSelfSettings;
    }

    public UnaryCallSettings<DeleteSelfRequest, Operation> deleteSelfSettings() {
        return this.deleteSelfSettings;
    }

    public OperationCallSettings<DeleteSelfRequest, Empty, OperationMetadata> deleteSelfOperationSettings() {
        return this.deleteSelfOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DeveloperConnectStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDeveloperConnectStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDeveloperConnectStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "developerconnect";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "developerconnect.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "developerconnect.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DeveloperConnectStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeveloperConnectStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DeveloperConnectStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DeveloperConnectStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DeveloperConnectStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConnectionsSettings = settingsBuilder.listConnectionsSettings().build();
        this.getConnectionSettings = settingsBuilder.getConnectionSettings().build();
        this.createConnectionSettings = settingsBuilder.createConnectionSettings().build();
        this.createConnectionOperationSettings = settingsBuilder.createConnectionOperationSettings().build();
        this.updateConnectionSettings = settingsBuilder.updateConnectionSettings().build();
        this.updateConnectionOperationSettings = settingsBuilder.updateConnectionOperationSettings().build();
        this.deleteConnectionSettings = settingsBuilder.deleteConnectionSettings().build();
        this.deleteConnectionOperationSettings = settingsBuilder.deleteConnectionOperationSettings().build();
        this.createGitRepositoryLinkSettings = settingsBuilder.createGitRepositoryLinkSettings().build();
        this.createGitRepositoryLinkOperationSettings = settingsBuilder.createGitRepositoryLinkOperationSettings().build();
        this.deleteGitRepositoryLinkSettings = settingsBuilder.deleteGitRepositoryLinkSettings().build();
        this.deleteGitRepositoryLinkOperationSettings = settingsBuilder.deleteGitRepositoryLinkOperationSettings().build();
        this.listGitRepositoryLinksSettings = settingsBuilder.listGitRepositoryLinksSettings().build();
        this.getGitRepositoryLinkSettings = settingsBuilder.getGitRepositoryLinkSettings().build();
        this.fetchReadWriteTokenSettings = settingsBuilder.fetchReadWriteTokenSettings().build();
        this.fetchReadTokenSettings = settingsBuilder.fetchReadTokenSettings().build();
        this.fetchLinkableGitRepositoriesSettings = settingsBuilder.fetchLinkableGitRepositoriesSettings().build();
        this.fetchGitHubInstallationsSettings = settingsBuilder.fetchGitHubInstallationsSettings().build();
        this.fetchGitRefsSettings = settingsBuilder.fetchGitRefsSettings().build();
        this.listAccountConnectorsSettings = settingsBuilder.listAccountConnectorsSettings().build();
        this.getAccountConnectorSettings = settingsBuilder.getAccountConnectorSettings().build();
        this.createAccountConnectorSettings = settingsBuilder.createAccountConnectorSettings().build();
        this.createAccountConnectorOperationSettings = settingsBuilder.createAccountConnectorOperationSettings().build();
        this.updateAccountConnectorSettings = settingsBuilder.updateAccountConnectorSettings().build();
        this.updateAccountConnectorOperationSettings = settingsBuilder.updateAccountConnectorOperationSettings().build();
        this.deleteAccountConnectorSettings = settingsBuilder.deleteAccountConnectorSettings().build();
        this.deleteAccountConnectorOperationSettings = settingsBuilder.deleteAccountConnectorOperationSettings().build();
        this.fetchAccessTokenSettings = settingsBuilder.fetchAccessTokenSettings().build();
        this.listUsersSettings = settingsBuilder.listUsersSettings().build();
        this.deleteUserSettings = settingsBuilder.deleteUserSettings().build();
        this.deleteUserOperationSettings = settingsBuilder.deleteUserOperationSettings().build();
        this.fetchSelfSettings = settingsBuilder.fetchSelfSettings().build();
        this.deleteSelfSettings = settingsBuilder.deleteSelfSettings().build();
        this.deleteSelfOperationSettings = settingsBuilder.deleteSelfOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DeveloperConnectStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsSettings;
        private final UnaryCallSettings.Builder<GetConnectionRequest, Connection> getConnectionSettings;
        private final UnaryCallSettings.Builder<CreateConnectionRequest, Operation> createConnectionSettings;
        private final OperationCallSettings.Builder<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConnectionRequest, Operation> updateConnectionSettings;
        private final OperationCallSettings.Builder<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConnectionRequest, Operation> deleteConnectionSettings;
        private final OperationCallSettings.Builder<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings;
        private final UnaryCallSettings.Builder<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkSettings;
        private final OperationCallSettings.Builder<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkSettings;
        private final OperationCallSettings.Builder<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationSettings;
        private final PagedCallSettings.Builder<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksSettings;
        private final UnaryCallSettings.Builder<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkSettings;
        private final UnaryCallSettings.Builder<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings;
        private final UnaryCallSettings.Builder<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings;
        private final PagedCallSettings.Builder<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesSettings;
        private final UnaryCallSettings.Builder<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsSettings;
        private final PagedCallSettings.Builder<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsSettings;
        private final PagedCallSettings.Builder<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse> listAccountConnectorsSettings;
        private final UnaryCallSettings.Builder<GetAccountConnectorRequest, AccountConnector> getAccountConnectorSettings;
        private final UnaryCallSettings.Builder<CreateAccountConnectorRequest, Operation> createAccountConnectorSettings;
        private final OperationCallSettings.Builder<CreateAccountConnectorRequest, AccountConnector, OperationMetadata> createAccountConnectorOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAccountConnectorRequest, Operation> updateAccountConnectorSettings;
        private final OperationCallSettings.Builder<UpdateAccountConnectorRequest, AccountConnector, OperationMetadata> updateAccountConnectorOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAccountConnectorRequest, Operation> deleteAccountConnectorSettings;
        private final OperationCallSettings.Builder<DeleteAccountConnectorRequest, Empty, OperationMetadata> deleteAccountConnectorOperationSettings;
        private final UnaryCallSettings.Builder<FetchAccessTokenRequest, FetchAccessTokenResponse> fetchAccessTokenSettings;
        private final PagedCallSettings.Builder<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse> listUsersSettings;
        private final UnaryCallSettings.Builder<DeleteUserRequest, Operation> deleteUserSettings;
        private final OperationCallSettings.Builder<DeleteUserRequest, Empty, OperationMetadata> deleteUserOperationSettings;
        private final UnaryCallSettings.Builder<FetchSelfRequest, User> fetchSelfSettings;
        private final UnaryCallSettings.Builder<DeleteSelfRequest, Operation> deleteSelfSettings;
        private final OperationCallSettings.Builder<DeleteSelfRequest, Empty, OperationMetadata> deleteSelfOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTIONS_PAGE_STR_FACT);
            this.getConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.updateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.createGitRepositoryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGitRepositoryLinkOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGitRepositoryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGitRepositoryLinkOperationSettings = OperationCallSettings.newBuilder();
            this.listGitRepositoryLinksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GIT_REPOSITORY_LINKS_PAGE_STR_FACT);
            this.getGitRepositoryLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchReadWriteTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchReadTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchLinkableGitRepositoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_LINKABLE_GIT_REPOSITORIES_PAGE_STR_FACT);
            this.fetchGitHubInstallationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchGitRefsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_GIT_REFS_PAGE_STR_FACT);
            this.listAccountConnectorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCOUNT_CONNECTORS_PAGE_STR_FACT);
            this.getAccountConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccountConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccountConnectorOperationSettings = OperationCallSettings.newBuilder();
            this.updateAccountConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccountConnectorOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAccountConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccountConnectorOperationSettings = OperationCallSettings.newBuilder();
            this.fetchAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUsersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USERS_PAGE_STR_FACT);
            this.deleteUserSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteUserOperationSettings = OperationCallSettings.newBuilder();
            this.fetchSelfSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSelfSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSelfOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionsSettings, this.getConnectionSettings, this.createConnectionSettings, this.updateConnectionSettings, this.deleteConnectionSettings, this.createGitRepositoryLinkSettings, this.deleteGitRepositoryLinkSettings, this.listGitRepositoryLinksSettings, this.getGitRepositoryLinkSettings, this.fetchReadWriteTokenSettings, this.fetchReadTokenSettings, this.fetchLinkableGitRepositoriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchGitHubInstallationsSettings, this.fetchGitRefsSettings, this.listAccountConnectorsSettings, this.getAccountConnectorSettings, this.createAccountConnectorSettings, this.updateAccountConnectorSettings, this.deleteAccountConnectorSettings, this.fetchAccessTokenSettings, this.listUsersSettings, this.deleteUserSettings, this.fetchSelfSettings, this.deleteSelfSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DeveloperConnectStubSettings settings) {
            super((StubSettings)settings);
            this.listConnectionsSettings = settings.listConnectionsSettings.toBuilder();
            this.getConnectionSettings = settings.getConnectionSettings.toBuilder();
            this.createConnectionSettings = settings.createConnectionSettings.toBuilder();
            this.createConnectionOperationSettings = settings.createConnectionOperationSettings.toBuilder();
            this.updateConnectionSettings = settings.updateConnectionSettings.toBuilder();
            this.updateConnectionOperationSettings = settings.updateConnectionOperationSettings.toBuilder();
            this.deleteConnectionSettings = settings.deleteConnectionSettings.toBuilder();
            this.deleteConnectionOperationSettings = settings.deleteConnectionOperationSettings.toBuilder();
            this.createGitRepositoryLinkSettings = settings.createGitRepositoryLinkSettings.toBuilder();
            this.createGitRepositoryLinkOperationSettings = settings.createGitRepositoryLinkOperationSettings.toBuilder();
            this.deleteGitRepositoryLinkSettings = settings.deleteGitRepositoryLinkSettings.toBuilder();
            this.deleteGitRepositoryLinkOperationSettings = settings.deleteGitRepositoryLinkOperationSettings.toBuilder();
            this.listGitRepositoryLinksSettings = settings.listGitRepositoryLinksSettings.toBuilder();
            this.getGitRepositoryLinkSettings = settings.getGitRepositoryLinkSettings.toBuilder();
            this.fetchReadWriteTokenSettings = settings.fetchReadWriteTokenSettings.toBuilder();
            this.fetchReadTokenSettings = settings.fetchReadTokenSettings.toBuilder();
            this.fetchLinkableGitRepositoriesSettings = settings.fetchLinkableGitRepositoriesSettings.toBuilder();
            this.fetchGitHubInstallationsSettings = settings.fetchGitHubInstallationsSettings.toBuilder();
            this.fetchGitRefsSettings = settings.fetchGitRefsSettings.toBuilder();
            this.listAccountConnectorsSettings = settings.listAccountConnectorsSettings.toBuilder();
            this.getAccountConnectorSettings = settings.getAccountConnectorSettings.toBuilder();
            this.createAccountConnectorSettings = settings.createAccountConnectorSettings.toBuilder();
            this.createAccountConnectorOperationSettings = settings.createAccountConnectorOperationSettings.toBuilder();
            this.updateAccountConnectorSettings = settings.updateAccountConnectorSettings.toBuilder();
            this.updateAccountConnectorOperationSettings = settings.updateAccountConnectorOperationSettings.toBuilder();
            this.deleteAccountConnectorSettings = settings.deleteAccountConnectorSettings.toBuilder();
            this.deleteAccountConnectorOperationSettings = settings.deleteAccountConnectorOperationSettings.toBuilder();
            this.fetchAccessTokenSettings = settings.fetchAccessTokenSettings.toBuilder();
            this.listUsersSettings = settings.listUsersSettings.toBuilder();
            this.deleteUserSettings = settings.deleteUserSettings.toBuilder();
            this.deleteUserOperationSettings = settings.deleteUserOperationSettings.toBuilder();
            this.fetchSelfSettings = settings.fetchSelfSettings.toBuilder();
            this.deleteSelfSettings = settings.deleteSelfSettings.toBuilder();
            this.deleteSelfOperationSettings = settings.deleteSelfOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionsSettings, this.getConnectionSettings, this.createConnectionSettings, this.updateConnectionSettings, this.deleteConnectionSettings, this.createGitRepositoryLinkSettings, this.deleteGitRepositoryLinkSettings, this.listGitRepositoryLinksSettings, this.getGitRepositoryLinkSettings, this.fetchReadWriteTokenSettings, this.fetchReadTokenSettings, this.fetchLinkableGitRepositoriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchGitHubInstallationsSettings, this.fetchGitRefsSettings, this.listAccountConnectorsSettings, this.getAccountConnectorSettings, this.createAccountConnectorSettings, this.updateAccountConnectorSettings, this.deleteAccountConnectorSettings, this.fetchAccessTokenSettings, this.listUsersSettings, this.deleteUserSettings, this.fetchSelfSettings, this.deleteSelfSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DeveloperConnectStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DeveloperConnectStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeveloperConnectStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeveloperConnectStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DeveloperConnectStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DeveloperConnectStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DeveloperConnectStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DeveloperConnectStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createGitRepositoryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteGitRepositoryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listGitRepositoryLinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGitRepositoryLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchReadWriteTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchReadTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchLinkableGitRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchGitHubInstallationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchGitRefsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listAccountConnectorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getAccountConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createAccountConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateAccountConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteAccountConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listUsersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteUserSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.fetchSelfSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSelfSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Connection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Connection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createGitRepositoryLinkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GitRepositoryLink.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteGitRepositoryLinkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createAccountConnectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccountConnector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateAccountConnectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccountConnector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteAccountConnectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteUserOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteSelfOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsSettings() {
            return this.listConnectionsSettings;
        }

        public UnaryCallSettings.Builder<GetConnectionRequest, Connection> getConnectionSettings() {
            return this.getConnectionSettings;
        }

        public UnaryCallSettings.Builder<CreateConnectionRequest, Operation> createConnectionSettings() {
            return this.createConnectionSettings;
        }

        public OperationCallSettings.Builder<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings() {
            return this.createConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConnectionRequest, Operation> updateConnectionSettings() {
            return this.updateConnectionSettings;
        }

        public OperationCallSettings.Builder<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings() {
            return this.updateConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectionRequest, Operation> deleteConnectionSettings() {
            return this.deleteConnectionSettings;
        }

        public OperationCallSettings.Builder<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings() {
            return this.deleteConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkSettings() {
            return this.createGitRepositoryLinkSettings;
        }

        public OperationCallSettings.Builder<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationSettings() {
            return this.createGitRepositoryLinkOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkSettings() {
            return this.deleteGitRepositoryLinkSettings;
        }

        public OperationCallSettings.Builder<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationSettings() {
            return this.deleteGitRepositoryLinkOperationSettings;
        }

        public PagedCallSettings.Builder<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksSettings() {
            return this.listGitRepositoryLinksSettings;
        }

        public UnaryCallSettings.Builder<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkSettings() {
            return this.getGitRepositoryLinkSettings;
        }

        public UnaryCallSettings.Builder<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings() {
            return this.fetchReadWriteTokenSettings;
        }

        public UnaryCallSettings.Builder<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings() {
            return this.fetchReadTokenSettings;
        }

        public PagedCallSettings.Builder<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesSettings() {
            return this.fetchLinkableGitRepositoriesSettings;
        }

        public UnaryCallSettings.Builder<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsSettings() {
            return this.fetchGitHubInstallationsSettings;
        }

        public PagedCallSettings.Builder<FetchGitRefsRequest, FetchGitRefsResponse, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsSettings() {
            return this.fetchGitRefsSettings;
        }

        public PagedCallSettings.Builder<ListAccountConnectorsRequest, ListAccountConnectorsResponse, DeveloperConnectClient.ListAccountConnectorsPagedResponse> listAccountConnectorsSettings() {
            return this.listAccountConnectorsSettings;
        }

        public UnaryCallSettings.Builder<GetAccountConnectorRequest, AccountConnector> getAccountConnectorSettings() {
            return this.getAccountConnectorSettings;
        }

        public UnaryCallSettings.Builder<CreateAccountConnectorRequest, Operation> createAccountConnectorSettings() {
            return this.createAccountConnectorSettings;
        }

        public OperationCallSettings.Builder<CreateAccountConnectorRequest, AccountConnector, OperationMetadata> createAccountConnectorOperationSettings() {
            return this.createAccountConnectorOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccountConnectorRequest, Operation> updateAccountConnectorSettings() {
            return this.updateAccountConnectorSettings;
        }

        public OperationCallSettings.Builder<UpdateAccountConnectorRequest, AccountConnector, OperationMetadata> updateAccountConnectorOperationSettings() {
            return this.updateAccountConnectorOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccountConnectorRequest, Operation> deleteAccountConnectorSettings() {
            return this.deleteAccountConnectorSettings;
        }

        public OperationCallSettings.Builder<DeleteAccountConnectorRequest, Empty, OperationMetadata> deleteAccountConnectorOperationSettings() {
            return this.deleteAccountConnectorOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchAccessTokenRequest, FetchAccessTokenResponse> fetchAccessTokenSettings() {
            return this.fetchAccessTokenSettings;
        }

        public PagedCallSettings.Builder<ListUsersRequest, ListUsersResponse, DeveloperConnectClient.ListUsersPagedResponse> listUsersSettings() {
            return this.listUsersSettings;
        }

        public UnaryCallSettings.Builder<DeleteUserRequest, Operation> deleteUserSettings() {
            return this.deleteUserSettings;
        }

        public OperationCallSettings.Builder<DeleteUserRequest, Empty, OperationMetadata> deleteUserOperationSettings() {
            return this.deleteUserOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchSelfRequest, User> fetchSelfSettings() {
            return this.fetchSelfSettings;
        }

        public UnaryCallSettings.Builder<DeleteSelfRequest, Operation> deleteSelfSettings() {
            return this.deleteSelfSettings;
        }

        public OperationCallSettings.Builder<DeleteSelfRequest, Empty, OperationMetadata> deleteSelfOperationSettings() {
            return this.deleteSelfOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DeveloperConnectStubSettings build() throws IOException {
            return new DeveloperConnectStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

