/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.Connection;
import com.google.cloud.developerconnect.v1.ConnectionName;
import com.google.cloud.developerconnect.v1.CreateConnectionRequest;
import com.google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeleteConnectionRequest;
import com.google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeveloperConnectSettings;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse;
import com.google.cloud.developerconnect.v1.FetchGitRefsRequest;
import com.google.cloud.developerconnect.v1.FetchGitRefsResponse;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse;
import com.google.cloud.developerconnect.v1.FetchReadTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadTokenResponse;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenResponse;
import com.google.cloud.developerconnect.v1.GetConnectionRequest;
import com.google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.GitRepositoryLink;
import com.google.cloud.developerconnect.v1.GitRepositoryLinkName;
import com.google.cloud.developerconnect.v1.LinkableGitRepository;
import com.google.cloud.developerconnect.v1.ListConnectionsRequest;
import com.google.cloud.developerconnect.v1.ListConnectionsResponse;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse;
import com.google.cloud.developerconnect.v1.LocationName;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateConnectionRequest;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStub;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DeveloperConnectClient
implements BackgroundResource {
    private final DeveloperConnectSettings settings;
    private final DeveloperConnectStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DeveloperConnectClient create() throws IOException {
        return DeveloperConnectClient.create(DeveloperConnectSettings.newBuilder().build());
    }

    public static final DeveloperConnectClient create(DeveloperConnectSettings settings) throws IOException {
        return new DeveloperConnectClient(settings);
    }

    public static final DeveloperConnectClient create(DeveloperConnectStub stub) {
        return new DeveloperConnectClient(stub);
    }

    protected DeveloperConnectClient(DeveloperConnectSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeveloperConnectStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DeveloperConnectClient(DeveloperConnectStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DeveloperConnectSettings getSettings() {
        return this.settings;
    }

    public DeveloperConnectStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListConnectionsPagedResponse listConnections(LocationName parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(String parent) {
        ListConnectionsRequest request = ListConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listConnections(request);
    }

    public final ListConnectionsPagedResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsPagedResponse)((Object)this.listConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.stub.listConnectionsPagedCallable();
    }

    public final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.stub.listConnectionsCallable();
    }

    public final Connection getConnection(ConnectionName name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(String name) {
        GetConnectionRequest request = GetConnectionRequest.newBuilder().setName(name).build();
        return this.getConnection(request);
    }

    public final Connection getConnection(GetConnectionRequest request) {
        return (Connection)this.getConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.stub.getConnectionCallable();
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(LocationName parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(String parent, Connection connection, String connectionId) {
        CreateConnectionRequest request = CreateConnectionRequest.newBuilder().setParent(parent).setConnection(connection).setConnectionId(connectionId).build();
        return this.createConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.stub.createConnectionOperationCallable();
    }

    public final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.stub.createConnectionCallable();
    }

    public final OperationFuture<Connection, OperationMetadata> updateConnectionAsync(Connection connection, FieldMask updateMask) {
        UpdateConnectionRequest request = UpdateConnectionRequest.newBuilder().setConnection(connection).setUpdateMask(updateMask).build();
        return this.updateConnectionAsync(request);
    }

    public final OperationFuture<Connection, OperationMetadata> updateConnectionAsync(UpdateConnectionRequest request) {
        return this.updateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.stub.updateConnectionOperationCallable();
    }

    public final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.stub.updateConnectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(ConnectionName name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(String name) {
        DeleteConnectionRequest request = DeleteConnectionRequest.newBuilder().setName(name).build();
        return this.deleteConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.stub.deleteConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.stub.deleteConnectionCallable();
    }

    public final OperationFuture<GitRepositoryLink, OperationMetadata> createGitRepositoryLinkAsync(ConnectionName parent, GitRepositoryLink gitRepositoryLink, String gitRepositoryLinkId) {
        CreateGitRepositoryLinkRequest request = CreateGitRepositoryLinkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGitRepositoryLink(gitRepositoryLink).setGitRepositoryLinkId(gitRepositoryLinkId).build();
        return this.createGitRepositoryLinkAsync(request);
    }

    public final OperationFuture<GitRepositoryLink, OperationMetadata> createGitRepositoryLinkAsync(String parent, GitRepositoryLink gitRepositoryLink, String gitRepositoryLinkId) {
        CreateGitRepositoryLinkRequest request = CreateGitRepositoryLinkRequest.newBuilder().setParent(parent).setGitRepositoryLink(gitRepositoryLink).setGitRepositoryLinkId(gitRepositoryLinkId).build();
        return this.createGitRepositoryLinkAsync(request);
    }

    public final OperationFuture<GitRepositoryLink, OperationMetadata> createGitRepositoryLinkAsync(CreateGitRepositoryLinkRequest request) {
        return this.createGitRepositoryLinkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationCallable() {
        return this.stub.createGitRepositoryLinkOperationCallable();
    }

    public final UnaryCallable<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkCallable() {
        return this.stub.createGitRepositoryLinkCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGitRepositoryLinkAsync(GitRepositoryLinkName name) {
        DeleteGitRepositoryLinkRequest request = DeleteGitRepositoryLinkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGitRepositoryLinkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGitRepositoryLinkAsync(String name) {
        DeleteGitRepositoryLinkRequest request = DeleteGitRepositoryLinkRequest.newBuilder().setName(name).build();
        return this.deleteGitRepositoryLinkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGitRepositoryLinkAsync(DeleteGitRepositoryLinkRequest request) {
        return this.deleteGitRepositoryLinkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationCallable() {
        return this.stub.deleteGitRepositoryLinkOperationCallable();
    }

    public final UnaryCallable<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkCallable() {
        return this.stub.deleteGitRepositoryLinkCallable();
    }

    public final ListGitRepositoryLinksPagedResponse listGitRepositoryLinks(ConnectionName parent) {
        ListGitRepositoryLinksRequest request = ListGitRepositoryLinksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGitRepositoryLinks(request);
    }

    public final ListGitRepositoryLinksPagedResponse listGitRepositoryLinks(String parent) {
        ListGitRepositoryLinksRequest request = ListGitRepositoryLinksRequest.newBuilder().setParent(parent).build();
        return this.listGitRepositoryLinks(request);
    }

    public final ListGitRepositoryLinksPagedResponse listGitRepositoryLinks(ListGitRepositoryLinksRequest request) {
        return (ListGitRepositoryLinksPagedResponse)((Object)this.listGitRepositoryLinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksPagedCallable() {
        return this.stub.listGitRepositoryLinksPagedCallable();
    }

    public final UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksCallable() {
        return this.stub.listGitRepositoryLinksCallable();
    }

    public final GitRepositoryLink getGitRepositoryLink(GitRepositoryLinkName name) {
        GetGitRepositoryLinkRequest request = GetGitRepositoryLinkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGitRepositoryLink(request);
    }

    public final GitRepositoryLink getGitRepositoryLink(String name) {
        GetGitRepositoryLinkRequest request = GetGitRepositoryLinkRequest.newBuilder().setName(name).build();
        return this.getGitRepositoryLink(request);
    }

    public final GitRepositoryLink getGitRepositoryLink(GetGitRepositoryLinkRequest request) {
        return (GitRepositoryLink)this.getGitRepositoryLinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkCallable() {
        return this.stub.getGitRepositoryLinkCallable();
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(GitRepositoryLinkName gitRepositoryLink) {
        FetchReadWriteTokenRequest request = FetchReadWriteTokenRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink == null ? null : gitRepositoryLink.toString()).build();
        return this.fetchReadWriteToken(request);
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(String gitRepositoryLink) {
        FetchReadWriteTokenRequest request = FetchReadWriteTokenRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink).build();
        return this.fetchReadWriteToken(request);
    }

    public final FetchReadWriteTokenResponse fetchReadWriteToken(FetchReadWriteTokenRequest request) {
        return (FetchReadWriteTokenResponse)this.fetchReadWriteTokenCallable().call((Object)request);
    }

    public final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.stub.fetchReadWriteTokenCallable();
    }

    public final FetchReadTokenResponse fetchReadToken(GitRepositoryLinkName gitRepositoryLink) {
        FetchReadTokenRequest request = FetchReadTokenRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink == null ? null : gitRepositoryLink.toString()).build();
        return this.fetchReadToken(request);
    }

    public final FetchReadTokenResponse fetchReadToken(String gitRepositoryLink) {
        FetchReadTokenRequest request = FetchReadTokenRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink).build();
        return this.fetchReadToken(request);
    }

    public final FetchReadTokenResponse fetchReadToken(FetchReadTokenRequest request) {
        return (FetchReadTokenResponse)this.fetchReadTokenCallable().call((Object)request);
    }

    public final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.stub.fetchReadTokenCallable();
    }

    public final FetchLinkableGitRepositoriesPagedResponse fetchLinkableGitRepositories(ConnectionName connection) {
        FetchLinkableGitRepositoriesRequest request = FetchLinkableGitRepositoriesRequest.newBuilder().setConnection(connection == null ? null : connection.toString()).build();
        return this.fetchLinkableGitRepositories(request);
    }

    public final FetchLinkableGitRepositoriesPagedResponse fetchLinkableGitRepositories(String connection) {
        FetchLinkableGitRepositoriesRequest request = FetchLinkableGitRepositoriesRequest.newBuilder().setConnection(connection).build();
        return this.fetchLinkableGitRepositories(request);
    }

    public final FetchLinkableGitRepositoriesPagedResponse fetchLinkableGitRepositories(FetchLinkableGitRepositoriesRequest request) {
        return (FetchLinkableGitRepositoriesPagedResponse)((Object)this.fetchLinkableGitRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesPagedCallable() {
        return this.stub.fetchLinkableGitRepositoriesPagedCallable();
    }

    public final UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesCallable() {
        return this.stub.fetchLinkableGitRepositoriesCallable();
    }

    public final FetchGitHubInstallationsResponse fetchGitHubInstallations(ConnectionName connection) {
        FetchGitHubInstallationsRequest request = FetchGitHubInstallationsRequest.newBuilder().setConnection(connection == null ? null : connection.toString()).build();
        return this.fetchGitHubInstallations(request);
    }

    public final FetchGitHubInstallationsResponse fetchGitHubInstallations(String connection) {
        FetchGitHubInstallationsRequest request = FetchGitHubInstallationsRequest.newBuilder().setConnection(connection).build();
        return this.fetchGitHubInstallations(request);
    }

    public final FetchGitHubInstallationsResponse fetchGitHubInstallations(FetchGitHubInstallationsRequest request) {
        return (FetchGitHubInstallationsResponse)this.fetchGitHubInstallationsCallable().call((Object)request);
    }

    public final UnaryCallable<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsCallable() {
        return this.stub.fetchGitHubInstallationsCallable();
    }

    public final FetchGitRefsPagedResponse fetchGitRefs(GitRepositoryLinkName gitRepositoryLink, FetchGitRefsRequest.RefType refType) {
        FetchGitRefsRequest request = FetchGitRefsRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink == null ? null : gitRepositoryLink.toString()).setRefType(refType).build();
        return this.fetchGitRefs(request);
    }

    public final FetchGitRefsPagedResponse fetchGitRefs(String gitRepositoryLink, FetchGitRefsRequest.RefType refType) {
        FetchGitRefsRequest request = FetchGitRefsRequest.newBuilder().setGitRepositoryLink(gitRepositoryLink).setRefType(refType).build();
        return this.fetchGitRefs(request);
    }

    public final FetchGitRefsPagedResponse fetchGitRefs(FetchGitRefsRequest request) {
        return (FetchGitRefsPagedResponse)((Object)this.fetchGitRefsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchGitRefsRequest, FetchGitRefsPagedResponse> fetchGitRefsPagedCallable() {
        return this.stub.fetchGitRefsPagedCallable();
    }

    public final UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable() {
        return this.stub.fetchGitRefsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchGitRefsFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchGitRefsRequest, FetchGitRefsResponse, String, FetchGitRefsPage, FetchGitRefsFixedSizeCollection> {
        private FetchGitRefsFixedSizeCollection(List<FetchGitRefsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchGitRefsFixedSizeCollection createEmptyCollection() {
            return new FetchGitRefsFixedSizeCollection(null, 0);
        }

        protected FetchGitRefsFixedSizeCollection createCollection(List<FetchGitRefsPage> pages, int collectionSize) {
            return new FetchGitRefsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchGitRefsPage
    extends AbstractPage<FetchGitRefsRequest, FetchGitRefsResponse, String, FetchGitRefsPage> {
        private FetchGitRefsPage(PageContext<FetchGitRefsRequest, FetchGitRefsResponse, String> context, FetchGitRefsResponse response) {
            super(context, (Object)response);
        }

        private static FetchGitRefsPage createEmptyPage() {
            return new FetchGitRefsPage(null, null);
        }

        protected FetchGitRefsPage createPage(PageContext<FetchGitRefsRequest, FetchGitRefsResponse, String> context, FetchGitRefsResponse response) {
            return new FetchGitRefsPage(context, response);
        }

        public ApiFuture<FetchGitRefsPage> createPageAsync(PageContext<FetchGitRefsRequest, FetchGitRefsResponse, String> context, ApiFuture<FetchGitRefsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchGitRefsPagedResponse
    extends AbstractPagedListResponse<FetchGitRefsRequest, FetchGitRefsResponse, String, FetchGitRefsPage, FetchGitRefsFixedSizeCollection> {
        public static ApiFuture<FetchGitRefsPagedResponse> createAsync(PageContext<FetchGitRefsRequest, FetchGitRefsResponse, String> context, ApiFuture<FetchGitRefsResponse> futureResponse) {
            ApiFuture<FetchGitRefsPage> futurePage = FetchGitRefsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchGitRefsPagedResponse((FetchGitRefsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchGitRefsPagedResponse(FetchGitRefsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchGitRefsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchLinkableGitRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository, FetchLinkableGitRepositoriesPage, FetchLinkableGitRepositoriesFixedSizeCollection> {
        private FetchLinkableGitRepositoriesFixedSizeCollection(List<FetchLinkableGitRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchLinkableGitRepositoriesFixedSizeCollection createEmptyCollection() {
            return new FetchLinkableGitRepositoriesFixedSizeCollection(null, 0);
        }

        protected FetchLinkableGitRepositoriesFixedSizeCollection createCollection(List<FetchLinkableGitRepositoriesPage> pages, int collectionSize) {
            return new FetchLinkableGitRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchLinkableGitRepositoriesPage
    extends AbstractPage<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository, FetchLinkableGitRepositoriesPage> {
        private FetchLinkableGitRepositoriesPage(PageContext<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository> context, FetchLinkableGitRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static FetchLinkableGitRepositoriesPage createEmptyPage() {
            return new FetchLinkableGitRepositoriesPage(null, null);
        }

        protected FetchLinkableGitRepositoriesPage createPage(PageContext<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository> context, FetchLinkableGitRepositoriesResponse response) {
            return new FetchLinkableGitRepositoriesPage(context, response);
        }

        public ApiFuture<FetchLinkableGitRepositoriesPage> createPageAsync(PageContext<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository> context, ApiFuture<FetchLinkableGitRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchLinkableGitRepositoriesPagedResponse
    extends AbstractPagedListResponse<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository, FetchLinkableGitRepositoriesPage, FetchLinkableGitRepositoriesFixedSizeCollection> {
        public static ApiFuture<FetchLinkableGitRepositoriesPagedResponse> createAsync(PageContext<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse, LinkableGitRepository> context, ApiFuture<FetchLinkableGitRepositoriesResponse> futureResponse) {
            ApiFuture<FetchLinkableGitRepositoriesPage> futurePage = FetchLinkableGitRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchLinkableGitRepositoriesPagedResponse((FetchLinkableGitRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchLinkableGitRepositoriesPagedResponse(FetchLinkableGitRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchLinkableGitRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGitRepositoryLinksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink, ListGitRepositoryLinksPage, ListGitRepositoryLinksFixedSizeCollection> {
        private ListGitRepositoryLinksFixedSizeCollection(List<ListGitRepositoryLinksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGitRepositoryLinksFixedSizeCollection createEmptyCollection() {
            return new ListGitRepositoryLinksFixedSizeCollection(null, 0);
        }

        protected ListGitRepositoryLinksFixedSizeCollection createCollection(List<ListGitRepositoryLinksPage> pages, int collectionSize) {
            return new ListGitRepositoryLinksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGitRepositoryLinksPage
    extends AbstractPage<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink, ListGitRepositoryLinksPage> {
        private ListGitRepositoryLinksPage(PageContext<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink> context, ListGitRepositoryLinksResponse response) {
            super(context, (Object)response);
        }

        private static ListGitRepositoryLinksPage createEmptyPage() {
            return new ListGitRepositoryLinksPage(null, null);
        }

        protected ListGitRepositoryLinksPage createPage(PageContext<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink> context, ListGitRepositoryLinksResponse response) {
            return new ListGitRepositoryLinksPage(context, response);
        }

        public ApiFuture<ListGitRepositoryLinksPage> createPageAsync(PageContext<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink> context, ApiFuture<ListGitRepositoryLinksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGitRepositoryLinksPagedResponse
    extends AbstractPagedListResponse<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink, ListGitRepositoryLinksPage, ListGitRepositoryLinksFixedSizeCollection> {
        public static ApiFuture<ListGitRepositoryLinksPagedResponse> createAsync(PageContext<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse, GitRepositoryLink> context, ApiFuture<ListGitRepositoryLinksResponse> futureResponse) {
            ApiFuture<ListGitRepositoryLinksPage> futurePage = ListGitRepositoryLinksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGitRepositoryLinksPagedResponse((ListGitRepositoryLinksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGitRepositoryLinksPagedResponse(ListGitRepositoryLinksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGitRepositoryLinksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        private ListConnectionsFixedSizeCollection(List<ListConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListConnectionsFixedSizeCollection(null, 0);
        }

        protected ListConnectionsFixedSizeCollection createCollection(List<ListConnectionsPage> pages, int collectionSize) {
            return new ListConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConnectionsPage
    extends AbstractPage<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage> {
        private ListConnectionsPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListConnectionsPage createEmptyPage() {
            return new ListConnectionsPage(null, null);
        }

        protected ListConnectionsPage createPage(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ListConnectionsResponse response) {
            return new ListConnectionsPage(context, response);
        }

        public ApiFuture<ListConnectionsPage> createPageAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConnectionsPagedResponse
    extends AbstractPagedListResponse<ListConnectionsRequest, ListConnectionsResponse, Connection, ListConnectionsPage, ListConnectionsFixedSizeCollection> {
        public static ApiFuture<ListConnectionsPagedResponse> createAsync(PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection> context, ApiFuture<ListConnectionsResponse> futureResponse) {
            ApiFuture<ListConnectionsPage> futurePage = ListConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConnectionsPagedResponse((ListConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConnectionsPagedResponse(ListConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

