/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.deploy.v1.AbandonReleaseRequest;
import com.google.cloud.deploy.v1.AbandonReleaseResponse;
import com.google.cloud.deploy.v1.ApproveRolloutRequest;
import com.google.cloud.deploy.v1.ApproveRolloutResponse;
import com.google.cloud.deploy.v1.CloudDeployClient;
import com.google.cloud.deploy.v1.Config;
import com.google.cloud.deploy.v1.CreateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.CreateReleaseRequest;
import com.google.cloud.deploy.v1.CreateRolloutRequest;
import com.google.cloud.deploy.v1.CreateTargetRequest;
import com.google.cloud.deploy.v1.DeleteDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.DeleteTargetRequest;
import com.google.cloud.deploy.v1.DeliveryPipeline;
import com.google.cloud.deploy.v1.GetConfigRequest;
import com.google.cloud.deploy.v1.GetDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.GetJobRunRequest;
import com.google.cloud.deploy.v1.GetReleaseRequest;
import com.google.cloud.deploy.v1.GetRolloutRequest;
import com.google.cloud.deploy.v1.GetTargetRequest;
import com.google.cloud.deploy.v1.JobRun;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesRequest;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesResponse;
import com.google.cloud.deploy.v1.ListJobRunsRequest;
import com.google.cloud.deploy.v1.ListJobRunsResponse;
import com.google.cloud.deploy.v1.ListReleasesRequest;
import com.google.cloud.deploy.v1.ListReleasesResponse;
import com.google.cloud.deploy.v1.ListRolloutsRequest;
import com.google.cloud.deploy.v1.ListRolloutsResponse;
import com.google.cloud.deploy.v1.ListTargetsRequest;
import com.google.cloud.deploy.v1.ListTargetsResponse;
import com.google.cloud.deploy.v1.OperationMetadata;
import com.google.cloud.deploy.v1.Release;
import com.google.cloud.deploy.v1.RetryJobRequest;
import com.google.cloud.deploy.v1.RetryJobResponse;
import com.google.cloud.deploy.v1.Rollout;
import com.google.cloud.deploy.v1.Target;
import com.google.cloud.deploy.v1.UpdateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.UpdateTargetRequest;
import com.google.cloud.deploy.v1.stub.CloudDeployStub;
import com.google.cloud.deploy.v1.stub.GrpcCloudDeployStub;
import com.google.cloud.deploy.v1.stub.HttpJsonCloudDeployStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudDeployStubSettings
extends StubSettings<CloudDeployStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesSettings;
    private final UnaryCallSettings<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineSettings;
    private final UnaryCallSettings<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineSettings;
    private final OperationCallSettings<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationSettings;
    private final UnaryCallSettings<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineSettings;
    private final OperationCallSettings<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationSettings;
    private final UnaryCallSettings<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineSettings;
    private final OperationCallSettings<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationSettings;
    private final PagedCallSettings<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse> listTargetsSettings;
    private final UnaryCallSettings<GetTargetRequest, Target> getTargetSettings;
    private final UnaryCallSettings<CreateTargetRequest, Operation> createTargetSettings;
    private final OperationCallSettings<CreateTargetRequest, Target, OperationMetadata> createTargetOperationSettings;
    private final UnaryCallSettings<UpdateTargetRequest, Operation> updateTargetSettings;
    private final OperationCallSettings<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationSettings;
    private final UnaryCallSettings<DeleteTargetRequest, Operation> deleteTargetSettings;
    private final OperationCallSettings<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationSettings;
    private final PagedCallSettings<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse> listReleasesSettings;
    private final UnaryCallSettings<GetReleaseRequest, Release> getReleaseSettings;
    private final UnaryCallSettings<CreateReleaseRequest, Operation> createReleaseSettings;
    private final OperationCallSettings<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings;
    private final UnaryCallSettings<AbandonReleaseRequest, AbandonReleaseResponse> abandonReleaseSettings;
    private final UnaryCallSettings<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutSettings;
    private final PagedCallSettings<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse> listRolloutsSettings;
    private final UnaryCallSettings<GetRolloutRequest, Rollout> getRolloutSettings;
    private final UnaryCallSettings<CreateRolloutRequest, Operation> createRolloutSettings;
    private final OperationCallSettings<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationSettings;
    private final UnaryCallSettings<RetryJobRequest, RetryJobResponse> retryJobSettings;
    private final PagedCallSettings<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse> listJobRunsSettings;
    private final UnaryCallSettings<GetJobRunRequest, JobRun> getJobRunSettings;
    private final UnaryCallSettings<GetConfigRequest, Config> getConfigSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> LIST_DELIVERY_PIPELINES_PAGE_STR_DESC = new PagedListDescriptor<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline>(){

        public String emptyToken() {
            return "";
        }

        public ListDeliveryPipelinesRequest injectToken(ListDeliveryPipelinesRequest payload, String token) {
            return ListDeliveryPipelinesRequest.newBuilder((ListDeliveryPipelinesRequest)payload).setPageToken(token).build();
        }

        public ListDeliveryPipelinesRequest injectPageSize(ListDeliveryPipelinesRequest payload, int pageSize) {
            return ListDeliveryPipelinesRequest.newBuilder((ListDeliveryPipelinesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeliveryPipelinesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeliveryPipelinesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeliveryPipeline> extractResources(ListDeliveryPipelinesResponse payload) {
            return payload.getDeliveryPipelinesList() == null ? ImmutableList.of() : payload.getDeliveryPipelinesList();
        }
    };
    private static final PagedListDescriptor<ListTargetsRequest, ListTargetsResponse, Target> LIST_TARGETS_PAGE_STR_DESC = new PagedListDescriptor<ListTargetsRequest, ListTargetsResponse, Target>(){

        public String emptyToken() {
            return "";
        }

        public ListTargetsRequest injectToken(ListTargetsRequest payload, String token) {
            return ListTargetsRequest.newBuilder((ListTargetsRequest)payload).setPageToken(token).build();
        }

        public ListTargetsRequest injectPageSize(ListTargetsRequest payload, int pageSize) {
            return ListTargetsRequest.newBuilder((ListTargetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTargetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTargetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Target> extractResources(ListTargetsResponse payload) {
            return payload.getTargetsList() == null ? ImmutableList.of() : payload.getTargetsList();
        }
    };
    private static final PagedListDescriptor<ListReleasesRequest, ListReleasesResponse, Release> LIST_RELEASES_PAGE_STR_DESC = new PagedListDescriptor<ListReleasesRequest, ListReleasesResponse, Release>(){

        public String emptyToken() {
            return "";
        }

        public ListReleasesRequest injectToken(ListReleasesRequest payload, String token) {
            return ListReleasesRequest.newBuilder((ListReleasesRequest)payload).setPageToken(token).build();
        }

        public ListReleasesRequest injectPageSize(ListReleasesRequest payload, int pageSize) {
            return ListReleasesRequest.newBuilder((ListReleasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReleasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReleasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Release> extractResources(ListReleasesResponse payload) {
            return payload.getReleasesList() == null ? ImmutableList.of() : payload.getReleasesList();
        }
    };
    private static final PagedListDescriptor<ListRolloutsRequest, ListRolloutsResponse, Rollout> LIST_ROLLOUTS_PAGE_STR_DESC = new PagedListDescriptor<ListRolloutsRequest, ListRolloutsResponse, Rollout>(){

        public String emptyToken() {
            return "";
        }

        public ListRolloutsRequest injectToken(ListRolloutsRequest payload, String token) {
            return ListRolloutsRequest.newBuilder((ListRolloutsRequest)payload).setPageToken(token).build();
        }

        public ListRolloutsRequest injectPageSize(ListRolloutsRequest payload, int pageSize) {
            return ListRolloutsRequest.newBuilder((ListRolloutsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRolloutsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRolloutsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Rollout> extractResources(ListRolloutsResponse payload) {
            return payload.getRolloutsList() == null ? ImmutableList.of() : payload.getRolloutsList();
        }
    };
    private static final PagedListDescriptor<ListJobRunsRequest, ListJobRunsResponse, JobRun> LIST_JOB_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListJobRunsRequest, ListJobRunsResponse, JobRun>(){

        public String emptyToken() {
            return "";
        }

        public ListJobRunsRequest injectToken(ListJobRunsRequest payload, String token) {
            return ListJobRunsRequest.newBuilder((ListJobRunsRequest)payload).setPageToken(token).build();
        }

        public ListJobRunsRequest injectPageSize(ListJobRunsRequest payload, int pageSize) {
            return ListJobRunsRequest.newBuilder((ListJobRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<JobRun> extractResources(ListJobRunsResponse payload) {
            return payload.getJobRunsList() == null ? ImmutableList.of() : payload.getJobRunsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse> LIST_DELIVERY_PIPELINES_PAGE_STR_FACT = new PagedListResponseFactory<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListDeliveryPipelinesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse> callable, ListDeliveryPipelinesRequest request, ApiCallContext context, ApiFuture<ListDeliveryPipelinesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DELIVERY_PIPELINES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListDeliveryPipelinesPagedResponse.createAsync((PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse> LIST_TARGETS_PAGE_STR_FACT = new PagedListResponseFactory<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListTargetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTargetsRequest, ListTargetsResponse> callable, ListTargetsRequest request, ApiCallContext context, ApiFuture<ListTargetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TARGETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListTargetsPagedResponse.createAsync((PageContext<ListTargetsRequest, ListTargetsResponse, Target>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse> LIST_RELEASES_PAGE_STR_FACT = new PagedListResponseFactory<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListReleasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListReleasesRequest, ListReleasesResponse> callable, ListReleasesRequest request, ApiCallContext context, ApiFuture<ListReleasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RELEASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListReleasesPagedResponse.createAsync((PageContext<ListReleasesRequest, ListReleasesResponse, Release>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse> LIST_ROLLOUTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListRolloutsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRolloutsRequest, ListRolloutsResponse> callable, ListRolloutsRequest request, ApiCallContext context, ApiFuture<ListRolloutsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROLLOUTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListRolloutsPagedResponse.createAsync((PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse> LIST_JOB_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListJobRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobRunsRequest, ListJobRunsResponse> callable, ListJobRunsRequest request, ApiCallContext context, ApiFuture<ListJobRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOB_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListJobRunsPagedResponse.createAsync((PageContext<ListJobRunsRequest, ListJobRunsResponse, JobRun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse>(){

        public ApiFuture<CloudDeployClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudDeployClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesSettings() {
        return this.listDeliveryPipelinesSettings;
    }

    public UnaryCallSettings<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineSettings() {
        return this.getDeliveryPipelineSettings;
    }

    public UnaryCallSettings<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineSettings() {
        return this.createDeliveryPipelineSettings;
    }

    public OperationCallSettings<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationSettings() {
        return this.createDeliveryPipelineOperationSettings;
    }

    public UnaryCallSettings<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineSettings() {
        return this.updateDeliveryPipelineSettings;
    }

    public OperationCallSettings<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationSettings() {
        return this.updateDeliveryPipelineOperationSettings;
    }

    public UnaryCallSettings<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineSettings() {
        return this.deleteDeliveryPipelineSettings;
    }

    public OperationCallSettings<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationSettings() {
        return this.deleteDeliveryPipelineOperationSettings;
    }

    public PagedCallSettings<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse> listTargetsSettings() {
        return this.listTargetsSettings;
    }

    public UnaryCallSettings<GetTargetRequest, Target> getTargetSettings() {
        return this.getTargetSettings;
    }

    public UnaryCallSettings<CreateTargetRequest, Operation> createTargetSettings() {
        return this.createTargetSettings;
    }

    public OperationCallSettings<CreateTargetRequest, Target, OperationMetadata> createTargetOperationSettings() {
        return this.createTargetOperationSettings;
    }

    public UnaryCallSettings<UpdateTargetRequest, Operation> updateTargetSettings() {
        return this.updateTargetSettings;
    }

    public OperationCallSettings<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationSettings() {
        return this.updateTargetOperationSettings;
    }

    public UnaryCallSettings<DeleteTargetRequest, Operation> deleteTargetSettings() {
        return this.deleteTargetSettings;
    }

    public OperationCallSettings<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationSettings() {
        return this.deleteTargetOperationSettings;
    }

    public PagedCallSettings<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse> listReleasesSettings() {
        return this.listReleasesSettings;
    }

    public UnaryCallSettings<GetReleaseRequest, Release> getReleaseSettings() {
        return this.getReleaseSettings;
    }

    public UnaryCallSettings<CreateReleaseRequest, Operation> createReleaseSettings() {
        return this.createReleaseSettings;
    }

    public OperationCallSettings<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings() {
        return this.createReleaseOperationSettings;
    }

    public UnaryCallSettings<AbandonReleaseRequest, AbandonReleaseResponse> abandonReleaseSettings() {
        return this.abandonReleaseSettings;
    }

    public UnaryCallSettings<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutSettings() {
        return this.approveRolloutSettings;
    }

    public PagedCallSettings<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse> listRolloutsSettings() {
        return this.listRolloutsSettings;
    }

    public UnaryCallSettings<GetRolloutRequest, Rollout> getRolloutSettings() {
        return this.getRolloutSettings;
    }

    public UnaryCallSettings<CreateRolloutRequest, Operation> createRolloutSettings() {
        return this.createRolloutSettings;
    }

    public OperationCallSettings<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationSettings() {
        return this.createRolloutOperationSettings;
    }

    public UnaryCallSettings<RetryJobRequest, RetryJobResponse> retryJobSettings() {
        return this.retryJobSettings;
    }

    public PagedCallSettings<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse> listJobRunsSettings() {
        return this.listJobRunsSettings;
    }

    public UnaryCallSettings<GetJobRunRequest, JobRun> getJobRunSettings() {
        return this.getJobRunSettings;
    }

    public UnaryCallSettings<GetConfigRequest, Config> getConfigSettings() {
        return this.getConfigSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public CloudDeployStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudDeployStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudDeployStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "clouddeploy.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "clouddeploy.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudDeployStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudDeployStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudDeployStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudDeployStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudDeployStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDeliveryPipelinesSettings = settingsBuilder.listDeliveryPipelinesSettings().build();
        this.getDeliveryPipelineSettings = settingsBuilder.getDeliveryPipelineSettings().build();
        this.createDeliveryPipelineSettings = settingsBuilder.createDeliveryPipelineSettings().build();
        this.createDeliveryPipelineOperationSettings = settingsBuilder.createDeliveryPipelineOperationSettings().build();
        this.updateDeliveryPipelineSettings = settingsBuilder.updateDeliveryPipelineSettings().build();
        this.updateDeliveryPipelineOperationSettings = settingsBuilder.updateDeliveryPipelineOperationSettings().build();
        this.deleteDeliveryPipelineSettings = settingsBuilder.deleteDeliveryPipelineSettings().build();
        this.deleteDeliveryPipelineOperationSettings = settingsBuilder.deleteDeliveryPipelineOperationSettings().build();
        this.listTargetsSettings = settingsBuilder.listTargetsSettings().build();
        this.getTargetSettings = settingsBuilder.getTargetSettings().build();
        this.createTargetSettings = settingsBuilder.createTargetSettings().build();
        this.createTargetOperationSettings = settingsBuilder.createTargetOperationSettings().build();
        this.updateTargetSettings = settingsBuilder.updateTargetSettings().build();
        this.updateTargetOperationSettings = settingsBuilder.updateTargetOperationSettings().build();
        this.deleteTargetSettings = settingsBuilder.deleteTargetSettings().build();
        this.deleteTargetOperationSettings = settingsBuilder.deleteTargetOperationSettings().build();
        this.listReleasesSettings = settingsBuilder.listReleasesSettings().build();
        this.getReleaseSettings = settingsBuilder.getReleaseSettings().build();
        this.createReleaseSettings = settingsBuilder.createReleaseSettings().build();
        this.createReleaseOperationSettings = settingsBuilder.createReleaseOperationSettings().build();
        this.abandonReleaseSettings = settingsBuilder.abandonReleaseSettings().build();
        this.approveRolloutSettings = settingsBuilder.approveRolloutSettings().build();
        this.listRolloutsSettings = settingsBuilder.listRolloutsSettings().build();
        this.getRolloutSettings = settingsBuilder.getRolloutSettings().build();
        this.createRolloutSettings = settingsBuilder.createRolloutSettings().build();
        this.createRolloutOperationSettings = settingsBuilder.createRolloutOperationSettings().build();
        this.retryJobSettings = settingsBuilder.retryJobSettings().build();
        this.listJobRunsSettings = settingsBuilder.listJobRunsSettings().build();
        this.getJobRunSettings = settingsBuilder.getJobRunSettings().build();
        this.getConfigSettings = settingsBuilder.getConfigSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudDeployStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesSettings;
        private final UnaryCallSettings.Builder<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineSettings;
        private final UnaryCallSettings.Builder<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineSettings;
        private final OperationCallSettings.Builder<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineSettings;
        private final OperationCallSettings.Builder<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineSettings;
        private final OperationCallSettings.Builder<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationSettings;
        private final PagedCallSettings.Builder<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse> listTargetsSettings;
        private final UnaryCallSettings.Builder<GetTargetRequest, Target> getTargetSettings;
        private final UnaryCallSettings.Builder<CreateTargetRequest, Operation> createTargetSettings;
        private final OperationCallSettings.Builder<CreateTargetRequest, Target, OperationMetadata> createTargetOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTargetRequest, Operation> updateTargetSettings;
        private final OperationCallSettings.Builder<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTargetRequest, Operation> deleteTargetSettings;
        private final OperationCallSettings.Builder<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationSettings;
        private final PagedCallSettings.Builder<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse> listReleasesSettings;
        private final UnaryCallSettings.Builder<GetReleaseRequest, Release> getReleaseSettings;
        private final UnaryCallSettings.Builder<CreateReleaseRequest, Operation> createReleaseSettings;
        private final OperationCallSettings.Builder<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings;
        private final UnaryCallSettings.Builder<AbandonReleaseRequest, AbandonReleaseResponse> abandonReleaseSettings;
        private final UnaryCallSettings.Builder<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutSettings;
        private final PagedCallSettings.Builder<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse> listRolloutsSettings;
        private final UnaryCallSettings.Builder<GetRolloutRequest, Rollout> getRolloutSettings;
        private final UnaryCallSettings.Builder<CreateRolloutRequest, Operation> createRolloutSettings;
        private final OperationCallSettings.Builder<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationSettings;
        private final UnaryCallSettings.Builder<RetryJobRequest, RetryJobResponse> retryJobSettings;
        private final PagedCallSettings.Builder<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse> listJobRunsSettings;
        private final UnaryCallSettings.Builder<GetJobRunRequest, JobRun> getJobRunSettings;
        private final UnaryCallSettings.Builder<GetConfigRequest, Config> getConfigSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDeliveryPipelinesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DELIVERY_PIPELINES_PAGE_STR_FACT);
            this.getDeliveryPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeliveryPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeliveryPipelineOperationSettings = OperationCallSettings.newBuilder();
            this.updateDeliveryPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeliveryPipelineOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDeliveryPipelineSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDeliveryPipelineOperationSettings = OperationCallSettings.newBuilder();
            this.listTargetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TARGETS_PAGE_STR_FACT);
            this.getTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTargetOperationSettings = OperationCallSettings.newBuilder();
            this.updateTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTargetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTargetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTargetOperationSettings = OperationCallSettings.newBuilder();
            this.listReleasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RELEASES_PAGE_STR_FACT);
            this.getReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReleaseOperationSettings = OperationCallSettings.newBuilder();
            this.abandonReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.approveRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRolloutsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROLLOUTS_PAGE_STR_FACT);
            this.getRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.retryJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listJobRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOB_RUNS_PAGE_STR_FACT);
            this.getJobRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDeliveryPipelinesSettings, this.getDeliveryPipelineSettings, this.createDeliveryPipelineSettings, this.updateDeliveryPipelineSettings, this.deleteDeliveryPipelineSettings, this.listTargetsSettings, this.getTargetSettings, this.createTargetSettings, this.updateTargetSettings, this.deleteTargetSettings, this.listReleasesSettings, this.getReleaseSettings, (Object[])new UnaryCallSettings.Builder[]{this.createReleaseSettings, this.abandonReleaseSettings, this.approveRolloutSettings, this.listRolloutsSettings, this.getRolloutSettings, this.createRolloutSettings, this.retryJobSettings, this.listJobRunsSettings, this.getJobRunSettings, this.getConfigSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudDeployStubSettings settings) {
            super((StubSettings)settings);
            this.listDeliveryPipelinesSettings = settings.listDeliveryPipelinesSettings.toBuilder();
            this.getDeliveryPipelineSettings = settings.getDeliveryPipelineSettings.toBuilder();
            this.createDeliveryPipelineSettings = settings.createDeliveryPipelineSettings.toBuilder();
            this.createDeliveryPipelineOperationSettings = settings.createDeliveryPipelineOperationSettings.toBuilder();
            this.updateDeliveryPipelineSettings = settings.updateDeliveryPipelineSettings.toBuilder();
            this.updateDeliveryPipelineOperationSettings = settings.updateDeliveryPipelineOperationSettings.toBuilder();
            this.deleteDeliveryPipelineSettings = settings.deleteDeliveryPipelineSettings.toBuilder();
            this.deleteDeliveryPipelineOperationSettings = settings.deleteDeliveryPipelineOperationSettings.toBuilder();
            this.listTargetsSettings = settings.listTargetsSettings.toBuilder();
            this.getTargetSettings = settings.getTargetSettings.toBuilder();
            this.createTargetSettings = settings.createTargetSettings.toBuilder();
            this.createTargetOperationSettings = settings.createTargetOperationSettings.toBuilder();
            this.updateTargetSettings = settings.updateTargetSettings.toBuilder();
            this.updateTargetOperationSettings = settings.updateTargetOperationSettings.toBuilder();
            this.deleteTargetSettings = settings.deleteTargetSettings.toBuilder();
            this.deleteTargetOperationSettings = settings.deleteTargetOperationSettings.toBuilder();
            this.listReleasesSettings = settings.listReleasesSettings.toBuilder();
            this.getReleaseSettings = settings.getReleaseSettings.toBuilder();
            this.createReleaseSettings = settings.createReleaseSettings.toBuilder();
            this.createReleaseOperationSettings = settings.createReleaseOperationSettings.toBuilder();
            this.abandonReleaseSettings = settings.abandonReleaseSettings.toBuilder();
            this.approveRolloutSettings = settings.approveRolloutSettings.toBuilder();
            this.listRolloutsSettings = settings.listRolloutsSettings.toBuilder();
            this.getRolloutSettings = settings.getRolloutSettings.toBuilder();
            this.createRolloutSettings = settings.createRolloutSettings.toBuilder();
            this.createRolloutOperationSettings = settings.createRolloutOperationSettings.toBuilder();
            this.retryJobSettings = settings.retryJobSettings.toBuilder();
            this.listJobRunsSettings = settings.listJobRunsSettings.toBuilder();
            this.getJobRunSettings = settings.getJobRunSettings.toBuilder();
            this.getConfigSettings = settings.getConfigSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDeliveryPipelinesSettings, this.getDeliveryPipelineSettings, this.createDeliveryPipelineSettings, this.updateDeliveryPipelineSettings, this.deleteDeliveryPipelineSettings, this.listTargetsSettings, this.getTargetSettings, this.createTargetSettings, this.updateTargetSettings, this.deleteTargetSettings, this.listReleasesSettings, this.getReleaseSettings, (Object[])new UnaryCallSettings.Builder[]{this.createReleaseSettings, this.abandonReleaseSettings, this.approveRolloutSettings, this.listRolloutsSettings, this.getRolloutSettings, this.createRolloutSettings, this.retryJobSettings, this.listJobRunsSettings, this.getJobRunSettings, this.getConfigSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudDeployStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudDeployStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudDeployStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudDeployStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudDeployStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudDeployStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudDeployStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudDeployStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudDeployStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudDeployStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDeliveryPipelinesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDeliveryPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDeliveryPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDeliveryPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteDeliveryPipelineSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listTargetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTargetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listReleasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.abandonReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.approveRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRolloutsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.retryJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listJobRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getJobRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDeliveryPipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeliveryPipeline.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDeliveryPipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DeliveryPipeline.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDeliveryPipelineOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createTargetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Target.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTargetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Target.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTargetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createReleaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Release.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Rollout.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, CloudDeployClient.ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesSettings() {
            return this.listDeliveryPipelinesSettings;
        }

        public UnaryCallSettings.Builder<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineSettings() {
            return this.getDeliveryPipelineSettings;
        }

        public UnaryCallSettings.Builder<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineSettings() {
            return this.createDeliveryPipelineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationSettings() {
            return this.createDeliveryPipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineSettings() {
            return this.updateDeliveryPipelineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationSettings() {
            return this.updateDeliveryPipelineOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineSettings() {
            return this.deleteDeliveryPipelineSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationSettings() {
            return this.deleteDeliveryPipelineOperationSettings;
        }

        public PagedCallSettings.Builder<ListTargetsRequest, ListTargetsResponse, CloudDeployClient.ListTargetsPagedResponse> listTargetsSettings() {
            return this.listTargetsSettings;
        }

        public UnaryCallSettings.Builder<GetTargetRequest, Target> getTargetSettings() {
            return this.getTargetSettings;
        }

        public UnaryCallSettings.Builder<CreateTargetRequest, Operation> createTargetSettings() {
            return this.createTargetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTargetRequest, Target, OperationMetadata> createTargetOperationSettings() {
            return this.createTargetOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTargetRequest, Operation> updateTargetSettings() {
            return this.updateTargetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationSettings() {
            return this.updateTargetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTargetRequest, Operation> deleteTargetSettings() {
            return this.deleteTargetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationSettings() {
            return this.deleteTargetOperationSettings;
        }

        public PagedCallSettings.Builder<ListReleasesRequest, ListReleasesResponse, CloudDeployClient.ListReleasesPagedResponse> listReleasesSettings() {
            return this.listReleasesSettings;
        }

        public UnaryCallSettings.Builder<GetReleaseRequest, Release> getReleaseSettings() {
            return this.getReleaseSettings;
        }

        public UnaryCallSettings.Builder<CreateReleaseRequest, Operation> createReleaseSettings() {
            return this.createReleaseSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings() {
            return this.createReleaseOperationSettings;
        }

        public UnaryCallSettings.Builder<AbandonReleaseRequest, AbandonReleaseResponse> abandonReleaseSettings() {
            return this.abandonReleaseSettings;
        }

        public UnaryCallSettings.Builder<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutSettings() {
            return this.approveRolloutSettings;
        }

        public PagedCallSettings.Builder<ListRolloutsRequest, ListRolloutsResponse, CloudDeployClient.ListRolloutsPagedResponse> listRolloutsSettings() {
            return this.listRolloutsSettings;
        }

        public UnaryCallSettings.Builder<GetRolloutRequest, Rollout> getRolloutSettings() {
            return this.getRolloutSettings;
        }

        public UnaryCallSettings.Builder<CreateRolloutRequest, Operation> createRolloutSettings() {
            return this.createRolloutSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationSettings() {
            return this.createRolloutOperationSettings;
        }

        public UnaryCallSettings.Builder<RetryJobRequest, RetryJobResponse> retryJobSettings() {
            return this.retryJobSettings;
        }

        public PagedCallSettings.Builder<ListJobRunsRequest, ListJobRunsResponse, CloudDeployClient.ListJobRunsPagedResponse> listJobRunsSettings() {
            return this.listJobRunsSettings;
        }

        public UnaryCallSettings.Builder<GetJobRunRequest, JobRun> getJobRunSettings() {
            return this.getJobRunSettings;
        }

        public UnaryCallSettings.Builder<GetConfigRequest, Config> getConfigSettings() {
            return this.getConfigSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudDeployClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public CloudDeployStubSettings build() throws IOException {
            return new CloudDeployStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

