/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.deploy.v1.ApproveRolloutRequest;
import com.google.cloud.deploy.v1.ApproveRolloutResponse;
import com.google.cloud.deploy.v1.CloudDeploySettings;
import com.google.cloud.deploy.v1.Config;
import com.google.cloud.deploy.v1.ConfigName;
import com.google.cloud.deploy.v1.CreateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.CreateReleaseRequest;
import com.google.cloud.deploy.v1.CreateRolloutRequest;
import com.google.cloud.deploy.v1.CreateTargetRequest;
import com.google.cloud.deploy.v1.DeleteDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.DeleteTargetRequest;
import com.google.cloud.deploy.v1.DeliveryPipeline;
import com.google.cloud.deploy.v1.DeliveryPipelineName;
import com.google.cloud.deploy.v1.GetConfigRequest;
import com.google.cloud.deploy.v1.GetDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.GetReleaseRequest;
import com.google.cloud.deploy.v1.GetRolloutRequest;
import com.google.cloud.deploy.v1.GetTargetRequest;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesRequest;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesResponse;
import com.google.cloud.deploy.v1.ListReleasesRequest;
import com.google.cloud.deploy.v1.ListReleasesResponse;
import com.google.cloud.deploy.v1.ListRolloutsRequest;
import com.google.cloud.deploy.v1.ListRolloutsResponse;
import com.google.cloud.deploy.v1.ListTargetsRequest;
import com.google.cloud.deploy.v1.ListTargetsResponse;
import com.google.cloud.deploy.v1.LocationName;
import com.google.cloud.deploy.v1.OperationMetadata;
import com.google.cloud.deploy.v1.Release;
import com.google.cloud.deploy.v1.ReleaseName;
import com.google.cloud.deploy.v1.Rollout;
import com.google.cloud.deploy.v1.RolloutName;
import com.google.cloud.deploy.v1.Target;
import com.google.cloud.deploy.v1.TargetName;
import com.google.cloud.deploy.v1.UpdateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.UpdateTargetRequest;
import com.google.cloud.deploy.v1.stub.CloudDeployStub;
import com.google.cloud.deploy.v1.stub.CloudDeployStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudDeployClient
implements BackgroundResource {
    private final CloudDeploySettings settings;
    private final CloudDeployStub stub;
    private final OperationsClient operationsClient;

    public static final CloudDeployClient create() throws IOException {
        return CloudDeployClient.create(CloudDeploySettings.newBuilder().build());
    }

    public static final CloudDeployClient create(CloudDeploySettings settings) throws IOException {
        return new CloudDeployClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudDeployClient create(CloudDeployStub stub) {
        return new CloudDeployClient(stub);
    }

    protected CloudDeployClient(CloudDeploySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudDeployStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudDeployClient(CloudDeployStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CloudDeploySettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudDeployStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(LocationName parent) {
        ListDeliveryPipelinesRequest request = ListDeliveryPipelinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeliveryPipelines(request);
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(String parent) {
        ListDeliveryPipelinesRequest request = ListDeliveryPipelinesRequest.newBuilder().setParent(parent).build();
        return this.listDeliveryPipelines(request);
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(ListDeliveryPipelinesRequest request) {
        return (ListDeliveryPipelinesPagedResponse)((Object)this.listDeliveryPipelinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeliveryPipelinesRequest, ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesPagedCallable() {
        return this.stub.listDeliveryPipelinesPagedCallable();
    }

    public final UnaryCallable<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse> listDeliveryPipelinesCallable() {
        return this.stub.listDeliveryPipelinesCallable();
    }

    public final DeliveryPipeline getDeliveryPipeline(DeliveryPipelineName name) {
        GetDeliveryPipelineRequest request = GetDeliveryPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeliveryPipeline(request);
    }

    public final DeliveryPipeline getDeliveryPipeline(String name) {
        GetDeliveryPipelineRequest request = GetDeliveryPipelineRequest.newBuilder().setName(name).build();
        return this.getDeliveryPipeline(request);
    }

    public final DeliveryPipeline getDeliveryPipeline(GetDeliveryPipelineRequest request) {
        return (DeliveryPipeline)this.getDeliveryPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineCallable() {
        return this.stub.getDeliveryPipelineCallable();
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(LocationName parent, DeliveryPipeline deliveryPipeline, String deliveryPipelineId) {
        CreateDeliveryPipelineRequest request = CreateDeliveryPipelineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeliveryPipeline(deliveryPipeline).setDeliveryPipelineId(deliveryPipelineId).build();
        return this.createDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(String parent, DeliveryPipeline deliveryPipeline, String deliveryPipelineId) {
        CreateDeliveryPipelineRequest request = CreateDeliveryPipelineRequest.newBuilder().setParent(parent).setDeliveryPipeline(deliveryPipeline).setDeliveryPipelineId(deliveryPipelineId).build();
        return this.createDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(CreateDeliveryPipelineRequest request) {
        return this.createDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationCallable() {
        return this.stub.createDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineCallable() {
        return this.stub.createDeliveryPipelineCallable();
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> updateDeliveryPipelineAsync(DeliveryPipeline deliveryPipeline, FieldMask updateMask) {
        UpdateDeliveryPipelineRequest request = UpdateDeliveryPipelineRequest.newBuilder().setDeliveryPipeline(deliveryPipeline).setUpdateMask(updateMask).build();
        return this.updateDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> updateDeliveryPipelineAsync(UpdateDeliveryPipelineRequest request) {
        return this.updateDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationCallable() {
        return this.stub.updateDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineCallable() {
        return this.stub.updateDeliveryPipelineCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(DeliveryPipelineName name) {
        DeleteDeliveryPipelineRequest request = DeleteDeliveryPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDeliveryPipelineAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(String name) {
        DeleteDeliveryPipelineRequest request = DeleteDeliveryPipelineRequest.newBuilder().setName(name).build();
        return this.deleteDeliveryPipelineAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(DeleteDeliveryPipelineRequest request) {
        return this.deleteDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationCallable() {
        return this.stub.deleteDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineCallable() {
        return this.stub.deleteDeliveryPipelineCallable();
    }

    public final ListTargetsPagedResponse listTargets(LocationName parent) {
        ListTargetsRequest request = ListTargetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTargets(request);
    }

    public final ListTargetsPagedResponse listTargets(String parent) {
        ListTargetsRequest request = ListTargetsRequest.newBuilder().setParent(parent).build();
        return this.listTargets(request);
    }

    public final ListTargetsPagedResponse listTargets(ListTargetsRequest request) {
        return (ListTargetsPagedResponse)((Object)this.listTargetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetsRequest, ListTargetsPagedResponse> listTargetsPagedCallable() {
        return this.stub.listTargetsPagedCallable();
    }

    public final UnaryCallable<ListTargetsRequest, ListTargetsResponse> listTargetsCallable() {
        return this.stub.listTargetsCallable();
    }

    public final Target getTarget(TargetName name) {
        GetTargetRequest request = GetTargetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTarget(request);
    }

    public final Target getTarget(String name) {
        GetTargetRequest request = GetTargetRequest.newBuilder().setName(name).build();
        return this.getTarget(request);
    }

    public final Target getTarget(GetTargetRequest request) {
        return (Target)this.getTargetCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetRequest, Target> getTargetCallable() {
        return this.stub.getTargetCallable();
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(LocationName parent, Target target, String targetId) {
        CreateTargetRequest request = CreateTargetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTarget(target).setTargetId(targetId).build();
        return this.createTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(String parent, Target target, String targetId) {
        CreateTargetRequest request = CreateTargetRequest.newBuilder().setParent(parent).setTarget(target).setTargetId(targetId).build();
        return this.createTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(CreateTargetRequest request) {
        return this.createTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTargetRequest, Target, OperationMetadata> createTargetOperationCallable() {
        return this.stub.createTargetOperationCallable();
    }

    public final UnaryCallable<CreateTargetRequest, Operation> createTargetCallable() {
        return this.stub.createTargetCallable();
    }

    public final OperationFuture<Target, OperationMetadata> updateTargetAsync(Target target, FieldMask updateMask) {
        UpdateTargetRequest request = UpdateTargetRequest.newBuilder().setTarget(target).setUpdateMask(updateMask).build();
        return this.updateTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> updateTargetAsync(UpdateTargetRequest request) {
        return this.updateTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationCallable() {
        return this.stub.updateTargetOperationCallable();
    }

    public final UnaryCallable<UpdateTargetRequest, Operation> updateTargetCallable() {
        return this.stub.updateTargetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(TargetName name) {
        DeleteTargetRequest request = DeleteTargetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTargetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(String name) {
        DeleteTargetRequest request = DeleteTargetRequest.newBuilder().setName(name).build();
        return this.deleteTargetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(DeleteTargetRequest request) {
        return this.deleteTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationCallable() {
        return this.stub.deleteTargetOperationCallable();
    }

    public final UnaryCallable<DeleteTargetRequest, Operation> deleteTargetCallable() {
        return this.stub.deleteTargetCallable();
    }

    public final ListReleasesPagedResponse listReleases(DeliveryPipelineName parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(String parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(ListReleasesRequest request) {
        return (ListReleasesPagedResponse)((Object)this.listReleasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesPagedResponse> listReleasesPagedCallable() {
        return this.stub.listReleasesPagedCallable();
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesResponse> listReleasesCallable() {
        return this.stub.listReleasesCallable();
    }

    public final Release getRelease(ReleaseName name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRelease(request);
    }

    public final Release getRelease(String name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name).build();
        return this.getRelease(request);
    }

    public final Release getRelease(GetReleaseRequest request) {
        return (Release)this.getReleaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetReleaseRequest, Release> getReleaseCallable() {
        return this.stub.getReleaseCallable();
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(DeliveryPipelineName parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(String parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(CreateReleaseRequest request) {
        return this.createReleaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationCallable() {
        return this.stub.createReleaseOperationCallable();
    }

    public final UnaryCallable<CreateReleaseRequest, Operation> createReleaseCallable() {
        return this.stub.createReleaseCallable();
    }

    public final ApproveRolloutResponse approveRollout(RolloutName name) {
        ApproveRolloutRequest request = ApproveRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.approveRollout(request);
    }

    public final ApproveRolloutResponse approveRollout(String name) {
        ApproveRolloutRequest request = ApproveRolloutRequest.newBuilder().setName(name).build();
        return this.approveRollout(request);
    }

    public final ApproveRolloutResponse approveRollout(ApproveRolloutRequest request) {
        return (ApproveRolloutResponse)this.approveRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutCallable() {
        return this.stub.approveRolloutCallable();
    }

    public final ListRolloutsPagedResponse listRollouts(ReleaseName parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(String parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(ListRolloutsRequest request) {
        return (ListRolloutsPagedResponse)((Object)this.listRolloutsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsPagedResponse> listRolloutsPagedCallable() {
        return this.stub.listRolloutsPagedCallable();
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsResponse> listRolloutsCallable() {
        return this.stub.listRolloutsCallable();
    }

    public final Rollout getRollout(RolloutName name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(String name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(GetRolloutRequest request) {
        return (Rollout)this.getRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<GetRolloutRequest, Rollout> getRolloutCallable() {
        return this.stub.getRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(ReleaseName parent, Rollout rollout, String rolloutId) {
        CreateRolloutRequest request = CreateRolloutRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRollout(rollout).setRolloutId(rolloutId).build();
        return this.createRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(String parent, Rollout rollout, String rolloutId) {
        CreateRolloutRequest request = CreateRolloutRequest.newBuilder().setParent(parent).setRollout(rollout).setRolloutId(rolloutId).build();
        return this.createRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(CreateRolloutRequest request) {
        return this.createRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationCallable() {
        return this.stub.createRolloutOperationCallable();
    }

    public final UnaryCallable<CreateRolloutRequest, Operation> createRolloutCallable() {
        return this.stub.createRolloutCallable();
    }

    public final Config getConfig(ConfigName name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConfig(request);
    }

    public final Config getConfig(String name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name).build();
        return this.getConfig(request);
    }

    public final Config getConfig(GetConfigRequest request) {
        return (Config)this.getConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetConfigRequest, Config> getConfigCallable() {
        return this.stub.getConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRolloutsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        private ListRolloutsFixedSizeCollection(List<ListRolloutsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRolloutsFixedSizeCollection createEmptyCollection() {
            return new ListRolloutsFixedSizeCollection(null, 0);
        }

        protected ListRolloutsFixedSizeCollection createCollection(List<ListRolloutsPage> pages, int collectionSize) {
            return new ListRolloutsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRolloutsPage
    extends AbstractPage<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage> {
        private ListRolloutsPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            super(context, (Object)response);
        }

        private static ListRolloutsPage createEmptyPage() {
            return new ListRolloutsPage(null, null);
        }

        protected ListRolloutsPage createPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            return new ListRolloutsPage(context, response);
        }

        public ApiFuture<ListRolloutsPage> createPageAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRolloutsPagedResponse
    extends AbstractPagedListResponse<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        public static ApiFuture<ListRolloutsPagedResponse> createAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            ApiFuture<ListRolloutsPage> futurePage = ListRolloutsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRolloutsPagedResponse((ListRolloutsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRolloutsPagedResponse(ListRolloutsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRolloutsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReleasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        private ListReleasesFixedSizeCollection(List<ListReleasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReleasesFixedSizeCollection createEmptyCollection() {
            return new ListReleasesFixedSizeCollection(null, 0);
        }

        protected ListReleasesFixedSizeCollection createCollection(List<ListReleasesPage> pages, int collectionSize) {
            return new ListReleasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReleasesPage
    extends AbstractPage<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage> {
        private ListReleasesPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            super(context, (Object)response);
        }

        private static ListReleasesPage createEmptyPage() {
            return new ListReleasesPage(null, null);
        }

        protected ListReleasesPage createPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            return new ListReleasesPage(context, response);
        }

        public ApiFuture<ListReleasesPage> createPageAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReleasesPagedResponse
    extends AbstractPagedListResponse<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        public static ApiFuture<ListReleasesPagedResponse> createAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            ApiFuture<ListReleasesPage> futurePage = ListReleasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReleasesPagedResponse((ListReleasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReleasesPagedResponse(ListReleasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReleasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTargetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage, ListTargetsFixedSizeCollection> {
        private ListTargetsFixedSizeCollection(List<ListTargetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetsFixedSizeCollection createEmptyCollection() {
            return new ListTargetsFixedSizeCollection(null, 0);
        }

        protected ListTargetsFixedSizeCollection createCollection(List<ListTargetsPage> pages, int collectionSize) {
            return new ListTargetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetsPage
    extends AbstractPage<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage> {
        private ListTargetsPage(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ListTargetsResponse response) {
            super(context, (Object)response);
        }

        private static ListTargetsPage createEmptyPage() {
            return new ListTargetsPage(null, null);
        }

        protected ListTargetsPage createPage(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ListTargetsResponse response) {
            return new ListTargetsPage(context, response);
        }

        public ApiFuture<ListTargetsPage> createPageAsync(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ApiFuture<ListTargetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetsPagedResponse
    extends AbstractPagedListResponse<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage, ListTargetsFixedSizeCollection> {
        public static ApiFuture<ListTargetsPagedResponse> createAsync(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ApiFuture<ListTargetsResponse> futureResponse) {
            ApiFuture<ListTargetsPage> futurePage = ListTargetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTargetsPagedResponse((ListTargetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetsPagedResponse(ListTargetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeliveryPipelinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage, ListDeliveryPipelinesFixedSizeCollection> {
        private ListDeliveryPipelinesFixedSizeCollection(List<ListDeliveryPipelinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeliveryPipelinesFixedSizeCollection createEmptyCollection() {
            return new ListDeliveryPipelinesFixedSizeCollection(null, 0);
        }

        protected ListDeliveryPipelinesFixedSizeCollection createCollection(List<ListDeliveryPipelinesPage> pages, int collectionSize) {
            return new ListDeliveryPipelinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeliveryPipelinesPage
    extends AbstractPage<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage> {
        private ListDeliveryPipelinesPage(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ListDeliveryPipelinesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeliveryPipelinesPage createEmptyPage() {
            return new ListDeliveryPipelinesPage(null, null);
        }

        protected ListDeliveryPipelinesPage createPage(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ListDeliveryPipelinesResponse response) {
            return new ListDeliveryPipelinesPage(context, response);
        }

        public ApiFuture<ListDeliveryPipelinesPage> createPageAsync(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ApiFuture<ListDeliveryPipelinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeliveryPipelinesPagedResponse
    extends AbstractPagedListResponse<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage, ListDeliveryPipelinesFixedSizeCollection> {
        public static ApiFuture<ListDeliveryPipelinesPagedResponse> createAsync(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ApiFuture<ListDeliveryPipelinesResponse> futureResponse) {
            ApiFuture<ListDeliveryPipelinesPage> futurePage = ListDeliveryPipelinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeliveryPipelinesPagedResponse((ListDeliveryPipelinesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeliveryPipelinesPagedResponse(ListDeliveryPipelinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeliveryPipelinesFixedSizeCollection.createEmptyCollection());
        }
    }
}

