/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1alpha1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datastream.v1alpha1.ConnectionProfile;
import com.google.cloud.datastream.v1alpha1.CreateConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.CreatePrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.CreateRouteRequest;
import com.google.cloud.datastream.v1alpha1.CreateStreamRequest;
import com.google.cloud.datastream.v1alpha1.DatastreamClient;
import com.google.cloud.datastream.v1alpha1.DeleteConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.DeletePrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.DeleteRouteRequest;
import com.google.cloud.datastream.v1alpha1.DeleteStreamRequest;
import com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileResponse;
import com.google.cloud.datastream.v1alpha1.FetchErrorsRequest;
import com.google.cloud.datastream.v1alpha1.FetchErrorsResponse;
import com.google.cloud.datastream.v1alpha1.FetchStaticIpsRequest;
import com.google.cloud.datastream.v1alpha1.FetchStaticIpsResponse;
import com.google.cloud.datastream.v1alpha1.GetConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.GetPrivateConnectionRequest;
import com.google.cloud.datastream.v1alpha1.GetRouteRequest;
import com.google.cloud.datastream.v1alpha1.GetStreamRequest;
import com.google.cloud.datastream.v1alpha1.ListConnectionProfilesRequest;
import com.google.cloud.datastream.v1alpha1.ListConnectionProfilesResponse;
import com.google.cloud.datastream.v1alpha1.ListPrivateConnectionsRequest;
import com.google.cloud.datastream.v1alpha1.ListPrivateConnectionsResponse;
import com.google.cloud.datastream.v1alpha1.ListRoutesRequest;
import com.google.cloud.datastream.v1alpha1.ListRoutesResponse;
import com.google.cloud.datastream.v1alpha1.ListStreamsRequest;
import com.google.cloud.datastream.v1alpha1.ListStreamsResponse;
import com.google.cloud.datastream.v1alpha1.OperationMetadata;
import com.google.cloud.datastream.v1alpha1.PrivateConnection;
import com.google.cloud.datastream.v1alpha1.Route;
import com.google.cloud.datastream.v1alpha1.Stream;
import com.google.cloud.datastream.v1alpha1.UpdateConnectionProfileRequest;
import com.google.cloud.datastream.v1alpha1.UpdateStreamRequest;
import com.google.cloud.datastream.v1alpha1.stub.DatastreamStub;
import com.google.cloud.datastream.v1alpha1.stub.GrpcDatastreamStub;
import com.google.cloud.datastream.v1alpha1.stub.HttpJsonDatastreamStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DatastreamStubSettings
extends StubSettings<DatastreamStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings;
    private final UnaryCallSettings<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings;
    private final UnaryCallSettings<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings;
    private final OperationCallSettings<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings;
    private final UnaryCallSettings<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings;
    private final OperationCallSettings<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings;
    private final UnaryCallSettings<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings;
    private final OperationCallSettings<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings;
    private final UnaryCallSettings<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileSettings;
    private final PagedCallSettings<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse> listStreamsSettings;
    private final UnaryCallSettings<GetStreamRequest, Stream> getStreamSettings;
    private final UnaryCallSettings<CreateStreamRequest, Operation> createStreamSettings;
    private final OperationCallSettings<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings;
    private final UnaryCallSettings<UpdateStreamRequest, Operation> updateStreamSettings;
    private final OperationCallSettings<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings;
    private final UnaryCallSettings<DeleteStreamRequest, Operation> deleteStreamSettings;
    private final OperationCallSettings<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings;
    private final UnaryCallSettings<FetchErrorsRequest, Operation> fetchErrorsSettings;
    private final OperationCallSettings<FetchErrorsRequest, FetchErrorsResponse, OperationMetadata> fetchErrorsOperationSettings;
    private final PagedCallSettings<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsSettings;
    private final UnaryCallSettings<CreatePrivateConnectionRequest, Operation> createPrivateConnectionSettings;
    private final OperationCallSettings<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationSettings;
    private final UnaryCallSettings<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionSettings;
    private final PagedCallSettings<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsSettings;
    private final UnaryCallSettings<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionSettings;
    private final OperationCallSettings<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationSettings;
    private final UnaryCallSettings<CreateRouteRequest, Operation> createRouteSettings;
    private final OperationCallSettings<CreateRouteRequest, Route, OperationMetadata> createRouteOperationSettings;
    private final UnaryCallSettings<GetRouteRequest, Route> getRouteSettings;
    private final PagedCallSettings<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse> listRoutesSettings;
    private final UnaryCallSettings<DeleteRouteRequest, Operation> deleteRouteSettings;
    private final OperationCallSettings<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationSettings;
    private static final PagedListDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile> LIST_CONNECTION_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectionProfilesRequest injectToken(ListConnectionProfilesRequest payload, String token) {
            return ListConnectionProfilesRequest.newBuilder((ListConnectionProfilesRequest)payload).setPageToken(token).build();
        }

        public ListConnectionProfilesRequest injectPageSize(ListConnectionProfilesRequest payload, int pageSize) {
            return ListConnectionProfilesRequest.newBuilder((ListConnectionProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectionProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectionProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ConnectionProfile> extractResources(ListConnectionProfilesResponse payload) {
            return payload.getConnectionProfilesList() == null ? ImmutableList.of() : payload.getConnectionProfilesList();
        }
    };
    private static final PagedListDescriptor<ListStreamsRequest, ListStreamsResponse, Stream> LIST_STREAMS_PAGE_STR_DESC = new PagedListDescriptor<ListStreamsRequest, ListStreamsResponse, Stream>(){

        public String emptyToken() {
            return "";
        }

        public ListStreamsRequest injectToken(ListStreamsRequest payload, String token) {
            return ListStreamsRequest.newBuilder((ListStreamsRequest)payload).setPageToken(token).build();
        }

        public ListStreamsRequest injectPageSize(ListStreamsRequest payload, int pageSize) {
            return ListStreamsRequest.newBuilder((ListStreamsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListStreamsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListStreamsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Stream> extractResources(ListStreamsResponse payload) {
            return payload.getStreamsList() == null ? ImmutableList.of() : payload.getStreamsList();
        }
    };
    private static final PagedListDescriptor<FetchStaticIpsRequest, FetchStaticIpsResponse, String> FETCH_STATIC_IPS_PAGE_STR_DESC = new PagedListDescriptor<FetchStaticIpsRequest, FetchStaticIpsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public FetchStaticIpsRequest injectToken(FetchStaticIpsRequest payload, String token) {
            return FetchStaticIpsRequest.newBuilder((FetchStaticIpsRequest)payload).setPageToken(token).build();
        }

        public FetchStaticIpsRequest injectPageSize(FetchStaticIpsRequest payload, int pageSize) {
            return FetchStaticIpsRequest.newBuilder((FetchStaticIpsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchStaticIpsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchStaticIpsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(FetchStaticIpsResponse payload) {
            return payload.getStaticIpsList() == null ? ImmutableList.of() : payload.getStaticIpsList();
        }
    };
    private static final PagedListDescriptor<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> LIST_PRIVATE_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection>(){

        public String emptyToken() {
            return "";
        }

        public ListPrivateConnectionsRequest injectToken(ListPrivateConnectionsRequest payload, String token) {
            return ListPrivateConnectionsRequest.newBuilder((ListPrivateConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListPrivateConnectionsRequest injectPageSize(ListPrivateConnectionsRequest payload, int pageSize) {
            return ListPrivateConnectionsRequest.newBuilder((ListPrivateConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPrivateConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPrivateConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PrivateConnection> extractResources(ListPrivateConnectionsResponse payload) {
            return payload.getPrivateConnectionsList() == null ? ImmutableList.of() : payload.getPrivateConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListRoutesRequest, ListRoutesResponse, Route> LIST_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListRoutesRequest, ListRoutesResponse, Route>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutesRequest injectToken(ListRoutesRequest payload, String token) {
            return ListRoutesRequest.newBuilder((ListRoutesRequest)payload).setPageToken(token).build();
        }

        public ListRoutesRequest injectPageSize(ListRoutesRequest payload, int pageSize) {
            return ListRoutesRequest.newBuilder((ListRoutesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRoutesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRoutesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Route> extractResources(ListRoutesResponse payload) {
            return payload.getRoutesList() == null ? ImmutableList.of() : payload.getRoutesList();
        }
    };
    private static final PagedListResponseFactory<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse> LIST_CONNECTION_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse>(){

        public ApiFuture<DatastreamClient.ListConnectionProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectionProfilesRequest, ListConnectionProfilesResponse> callable, ListConnectionProfilesRequest request, ApiCallContext context, ApiFuture<ListConnectionProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTION_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastreamClient.ListConnectionProfilesPagedResponse.createAsync((PageContext<ListConnectionProfilesRequest, ListConnectionProfilesResponse, ConnectionProfile>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse> LIST_STREAMS_PAGE_STR_FACT = new PagedListResponseFactory<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse>(){

        public ApiFuture<DatastreamClient.ListStreamsPagedResponse> getFuturePagedResponse(UnaryCallable<ListStreamsRequest, ListStreamsResponse> callable, ListStreamsRequest request, ApiCallContext context, ApiFuture<ListStreamsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_STREAMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastreamClient.ListStreamsPagedResponse.createAsync((PageContext<ListStreamsRequest, ListStreamsResponse, Stream>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse> FETCH_STATIC_IPS_PAGE_STR_FACT = new PagedListResponseFactory<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse>(){

        public ApiFuture<DatastreamClient.FetchStaticIpsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchStaticIpsRequest, FetchStaticIpsResponse> callable, FetchStaticIpsRequest request, ApiCallContext context, ApiFuture<FetchStaticIpsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_STATIC_IPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastreamClient.FetchStaticIpsPagedResponse.createAsync((PageContext<FetchStaticIpsRequest, FetchStaticIpsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse> LIST_PRIVATE_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse>(){

        public ApiFuture<DatastreamClient.ListPrivateConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> callable, ListPrivateConnectionsRequest request, ApiCallContext context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRIVATE_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastreamClient.ListPrivateConnectionsPagedResponse.createAsync((PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse> LIST_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse>(){

        public ApiFuture<DatastreamClient.ListRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutesRequest, ListRoutesResponse> callable, ListRoutesRequest request, ApiCallContext context, ApiFuture<ListRoutesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DatastreamClient.ListRoutesPagedResponse.createAsync((PageContext<ListRoutesRequest, ListRoutesResponse, Route>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings() {
        return this.listConnectionProfilesSettings;
    }

    public UnaryCallSettings<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings() {
        return this.getConnectionProfileSettings;
    }

    public UnaryCallSettings<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings() {
        return this.createConnectionProfileSettings;
    }

    public OperationCallSettings<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings() {
        return this.createConnectionProfileOperationSettings;
    }

    public UnaryCallSettings<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings() {
        return this.updateConnectionProfileSettings;
    }

    public OperationCallSettings<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings() {
        return this.updateConnectionProfileOperationSettings;
    }

    public UnaryCallSettings<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings() {
        return this.deleteConnectionProfileSettings;
    }

    public OperationCallSettings<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings() {
        return this.deleteConnectionProfileOperationSettings;
    }

    public UnaryCallSettings<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileSettings() {
        return this.discoverConnectionProfileSettings;
    }

    public PagedCallSettings<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse> listStreamsSettings() {
        return this.listStreamsSettings;
    }

    public UnaryCallSettings<GetStreamRequest, Stream> getStreamSettings() {
        return this.getStreamSettings;
    }

    public UnaryCallSettings<CreateStreamRequest, Operation> createStreamSettings() {
        return this.createStreamSettings;
    }

    public OperationCallSettings<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings() {
        return this.createStreamOperationSettings;
    }

    public UnaryCallSettings<UpdateStreamRequest, Operation> updateStreamSettings() {
        return this.updateStreamSettings;
    }

    public OperationCallSettings<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings() {
        return this.updateStreamOperationSettings;
    }

    public UnaryCallSettings<DeleteStreamRequest, Operation> deleteStreamSettings() {
        return this.deleteStreamSettings;
    }

    public OperationCallSettings<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings() {
        return this.deleteStreamOperationSettings;
    }

    public UnaryCallSettings<FetchErrorsRequest, Operation> fetchErrorsSettings() {
        return this.fetchErrorsSettings;
    }

    public OperationCallSettings<FetchErrorsRequest, FetchErrorsResponse, OperationMetadata> fetchErrorsOperationSettings() {
        return this.fetchErrorsOperationSettings;
    }

    public PagedCallSettings<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsSettings() {
        return this.fetchStaticIpsSettings;
    }

    public UnaryCallSettings<CreatePrivateConnectionRequest, Operation> createPrivateConnectionSettings() {
        return this.createPrivateConnectionSettings;
    }

    public OperationCallSettings<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationSettings() {
        return this.createPrivateConnectionOperationSettings;
    }

    public UnaryCallSettings<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionSettings() {
        return this.getPrivateConnectionSettings;
    }

    public PagedCallSettings<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsSettings() {
        return this.listPrivateConnectionsSettings;
    }

    public UnaryCallSettings<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionSettings() {
        return this.deletePrivateConnectionSettings;
    }

    public OperationCallSettings<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationSettings() {
        return this.deletePrivateConnectionOperationSettings;
    }

    public UnaryCallSettings<CreateRouteRequest, Operation> createRouteSettings() {
        return this.createRouteSettings;
    }

    public OperationCallSettings<CreateRouteRequest, Route, OperationMetadata> createRouteOperationSettings() {
        return this.createRouteOperationSettings;
    }

    public UnaryCallSettings<GetRouteRequest, Route> getRouteSettings() {
        return this.getRouteSettings;
    }

    public PagedCallSettings<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse> listRoutesSettings() {
        return this.listRoutesSettings;
    }

    public UnaryCallSettings<DeleteRouteRequest, Operation> deleteRouteSettings() {
        return this.deleteRouteSettings;
    }

    public OperationCallSettings<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationSettings() {
        return this.deleteRouteOperationSettings;
    }

    public DatastreamStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDatastreamStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDatastreamStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datastream";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "datastream.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datastream.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DatastreamStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastreamStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DatastreamStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DatastreamStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DatastreamStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listConnectionProfilesSettings = settingsBuilder.listConnectionProfilesSettings().build();
        this.getConnectionProfileSettings = settingsBuilder.getConnectionProfileSettings().build();
        this.createConnectionProfileSettings = settingsBuilder.createConnectionProfileSettings().build();
        this.createConnectionProfileOperationSettings = settingsBuilder.createConnectionProfileOperationSettings().build();
        this.updateConnectionProfileSettings = settingsBuilder.updateConnectionProfileSettings().build();
        this.updateConnectionProfileOperationSettings = settingsBuilder.updateConnectionProfileOperationSettings().build();
        this.deleteConnectionProfileSettings = settingsBuilder.deleteConnectionProfileSettings().build();
        this.deleteConnectionProfileOperationSettings = settingsBuilder.deleteConnectionProfileOperationSettings().build();
        this.discoverConnectionProfileSettings = settingsBuilder.discoverConnectionProfileSettings().build();
        this.listStreamsSettings = settingsBuilder.listStreamsSettings().build();
        this.getStreamSettings = settingsBuilder.getStreamSettings().build();
        this.createStreamSettings = settingsBuilder.createStreamSettings().build();
        this.createStreamOperationSettings = settingsBuilder.createStreamOperationSettings().build();
        this.updateStreamSettings = settingsBuilder.updateStreamSettings().build();
        this.updateStreamOperationSettings = settingsBuilder.updateStreamOperationSettings().build();
        this.deleteStreamSettings = settingsBuilder.deleteStreamSettings().build();
        this.deleteStreamOperationSettings = settingsBuilder.deleteStreamOperationSettings().build();
        this.fetchErrorsSettings = settingsBuilder.fetchErrorsSettings().build();
        this.fetchErrorsOperationSettings = settingsBuilder.fetchErrorsOperationSettings().build();
        this.fetchStaticIpsSettings = settingsBuilder.fetchStaticIpsSettings().build();
        this.createPrivateConnectionSettings = settingsBuilder.createPrivateConnectionSettings().build();
        this.createPrivateConnectionOperationSettings = settingsBuilder.createPrivateConnectionOperationSettings().build();
        this.getPrivateConnectionSettings = settingsBuilder.getPrivateConnectionSettings().build();
        this.listPrivateConnectionsSettings = settingsBuilder.listPrivateConnectionsSettings().build();
        this.deletePrivateConnectionSettings = settingsBuilder.deletePrivateConnectionSettings().build();
        this.deletePrivateConnectionOperationSettings = settingsBuilder.deletePrivateConnectionOperationSettings().build();
        this.createRouteSettings = settingsBuilder.createRouteSettings().build();
        this.createRouteOperationSettings = settingsBuilder.createRouteOperationSettings().build();
        this.getRouteSettings = settingsBuilder.getRouteSettings().build();
        this.listRoutesSettings = settingsBuilder.listRoutesSettings().build();
        this.deleteRouteSettings = settingsBuilder.deleteRouteSettings().build();
        this.deleteRouteOperationSettings = settingsBuilder.deleteRouteOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DatastreamStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings;
        private final UnaryCallSettings.Builder<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings;
        private final UnaryCallSettings.Builder<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings;
        private final OperationCallSettings.Builder<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings;
        private final UnaryCallSettings.Builder<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings;
        private final OperationCallSettings.Builder<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings;
        private final OperationCallSettings.Builder<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings;
        private final UnaryCallSettings.Builder<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileSettings;
        private final PagedCallSettings.Builder<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse> listStreamsSettings;
        private final UnaryCallSettings.Builder<GetStreamRequest, Stream> getStreamSettings;
        private final UnaryCallSettings.Builder<CreateStreamRequest, Operation> createStreamSettings;
        private final OperationCallSettings.Builder<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings;
        private final UnaryCallSettings.Builder<UpdateStreamRequest, Operation> updateStreamSettings;
        private final OperationCallSettings.Builder<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings;
        private final UnaryCallSettings.Builder<DeleteStreamRequest, Operation> deleteStreamSettings;
        private final OperationCallSettings.Builder<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings;
        private final UnaryCallSettings.Builder<FetchErrorsRequest, Operation> fetchErrorsSettings;
        private final OperationCallSettings.Builder<FetchErrorsRequest, FetchErrorsResponse, OperationMetadata> fetchErrorsOperationSettings;
        private final PagedCallSettings.Builder<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsSettings;
        private final UnaryCallSettings.Builder<CreatePrivateConnectionRequest, Operation> createPrivateConnectionSettings;
        private final OperationCallSettings.Builder<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationSettings;
        private final UnaryCallSettings.Builder<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionSettings;
        private final PagedCallSettings.Builder<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsSettings;
        private final UnaryCallSettings.Builder<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionSettings;
        private final OperationCallSettings.Builder<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationSettings;
        private final UnaryCallSettings.Builder<CreateRouteRequest, Operation> createRouteSettings;
        private final OperationCallSettings.Builder<CreateRouteRequest, Route, OperationMetadata> createRouteOperationSettings;
        private final UnaryCallSettings.Builder<GetRouteRequest, Route> getRouteSettings;
        private final PagedCallSettings.Builder<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse> listRoutesSettings;
        private final UnaryCallSettings.Builder<DeleteRouteRequest, Operation> deleteRouteSettings;
        private final OperationCallSettings.Builder<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listConnectionProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTION_PROFILES_PAGE_STR_FACT);
            this.getConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.updateConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectionProfileOperationSettings = OperationCallSettings.newBuilder();
            this.discoverConnectionProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listStreamsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_STREAMS_PAGE_STR_FACT);
            this.getStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createStreamOperationSettings = OperationCallSettings.newBuilder();
            this.updateStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateStreamOperationSettings = OperationCallSettings.newBuilder();
            this.deleteStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteStreamOperationSettings = OperationCallSettings.newBuilder();
            this.fetchErrorsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchErrorsOperationSettings = OperationCallSettings.newBuilder();
            this.fetchStaticIpsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_STATIC_IPS_PAGE_STR_FACT);
            this.createPrivateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPrivateConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.getPrivateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPrivateConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRIVATE_CONNECTIONS_PAGE_STR_FACT);
            this.deletePrivateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePrivateConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.createRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRouteOperationSettings = OperationCallSettings.newBuilder();
            this.getRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTES_PAGE_STR_FACT);
            this.deleteRouteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRouteOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionProfilesSettings, this.getConnectionProfileSettings, this.createConnectionProfileSettings, this.updateConnectionProfileSettings, this.deleteConnectionProfileSettings, this.discoverConnectionProfileSettings, this.listStreamsSettings, this.getStreamSettings, this.createStreamSettings, this.updateStreamSettings, this.deleteStreamSettings, this.fetchErrorsSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchStaticIpsSettings, this.createPrivateConnectionSettings, this.getPrivateConnectionSettings, this.listPrivateConnectionsSettings, this.deletePrivateConnectionSettings, this.createRouteSettings, this.getRouteSettings, this.listRoutesSettings, this.deleteRouteSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DatastreamStubSettings settings) {
            super((StubSettings)settings);
            this.listConnectionProfilesSettings = settings.listConnectionProfilesSettings.toBuilder();
            this.getConnectionProfileSettings = settings.getConnectionProfileSettings.toBuilder();
            this.createConnectionProfileSettings = settings.createConnectionProfileSettings.toBuilder();
            this.createConnectionProfileOperationSettings = settings.createConnectionProfileOperationSettings.toBuilder();
            this.updateConnectionProfileSettings = settings.updateConnectionProfileSettings.toBuilder();
            this.updateConnectionProfileOperationSettings = settings.updateConnectionProfileOperationSettings.toBuilder();
            this.deleteConnectionProfileSettings = settings.deleteConnectionProfileSettings.toBuilder();
            this.deleteConnectionProfileOperationSettings = settings.deleteConnectionProfileOperationSettings.toBuilder();
            this.discoverConnectionProfileSettings = settings.discoverConnectionProfileSettings.toBuilder();
            this.listStreamsSettings = settings.listStreamsSettings.toBuilder();
            this.getStreamSettings = settings.getStreamSettings.toBuilder();
            this.createStreamSettings = settings.createStreamSettings.toBuilder();
            this.createStreamOperationSettings = settings.createStreamOperationSettings.toBuilder();
            this.updateStreamSettings = settings.updateStreamSettings.toBuilder();
            this.updateStreamOperationSettings = settings.updateStreamOperationSettings.toBuilder();
            this.deleteStreamSettings = settings.deleteStreamSettings.toBuilder();
            this.deleteStreamOperationSettings = settings.deleteStreamOperationSettings.toBuilder();
            this.fetchErrorsSettings = settings.fetchErrorsSettings.toBuilder();
            this.fetchErrorsOperationSettings = settings.fetchErrorsOperationSettings.toBuilder();
            this.fetchStaticIpsSettings = settings.fetchStaticIpsSettings.toBuilder();
            this.createPrivateConnectionSettings = settings.createPrivateConnectionSettings.toBuilder();
            this.createPrivateConnectionOperationSettings = settings.createPrivateConnectionOperationSettings.toBuilder();
            this.getPrivateConnectionSettings = settings.getPrivateConnectionSettings.toBuilder();
            this.listPrivateConnectionsSettings = settings.listPrivateConnectionsSettings.toBuilder();
            this.deletePrivateConnectionSettings = settings.deletePrivateConnectionSettings.toBuilder();
            this.deletePrivateConnectionOperationSettings = settings.deletePrivateConnectionOperationSettings.toBuilder();
            this.createRouteSettings = settings.createRouteSettings.toBuilder();
            this.createRouteOperationSettings = settings.createRouteOperationSettings.toBuilder();
            this.getRouteSettings = settings.getRouteSettings.toBuilder();
            this.listRoutesSettings = settings.listRoutesSettings.toBuilder();
            this.deleteRouteSettings = settings.deleteRouteSettings.toBuilder();
            this.deleteRouteOperationSettings = settings.deleteRouteOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listConnectionProfilesSettings, this.getConnectionProfileSettings, this.createConnectionProfileSettings, this.updateConnectionProfileSettings, this.deleteConnectionProfileSettings, this.discoverConnectionProfileSettings, this.listStreamsSettings, this.getStreamSettings, this.createStreamSettings, this.updateStreamSettings, this.deleteStreamSettings, this.fetchErrorsSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchStaticIpsSettings, this.createPrivateConnectionSettings, this.getPrivateConnectionSettings, this.listPrivateConnectionsSettings, this.deletePrivateConnectionSettings, this.createRouteSettings, this.getRouteSettings, this.listRoutesSettings, this.deleteRouteSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DatastreamStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DatastreamStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastreamStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastreamStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DatastreamStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DatastreamStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DatastreamStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DatastreamStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listConnectionProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.discoverConnectionProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listStreamsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.fetchErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchStaticIpsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPrivateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getPrivateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPrivateConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deletePrivateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteRouteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectionProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ConnectionProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConnectionProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Stream.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Stream.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteStreamOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.fetchErrorsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FetchErrorsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createPrivateConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PrivateConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deletePrivateConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Route.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRouteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListConnectionProfilesRequest, ListConnectionProfilesResponse, DatastreamClient.ListConnectionProfilesPagedResponse> listConnectionProfilesSettings() {
            return this.listConnectionProfilesSettings;
        }

        public UnaryCallSettings.Builder<GetConnectionProfileRequest, ConnectionProfile> getConnectionProfileSettings() {
            return this.getConnectionProfileSettings;
        }

        public UnaryCallSettings.Builder<CreateConnectionProfileRequest, Operation> createConnectionProfileSettings() {
            return this.createConnectionProfileSettings;
        }

        public OperationCallSettings.Builder<CreateConnectionProfileRequest, ConnectionProfile, OperationMetadata> createConnectionProfileOperationSettings() {
            return this.createConnectionProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateConnectionProfileRequest, Operation> updateConnectionProfileSettings() {
            return this.updateConnectionProfileSettings;
        }

        public OperationCallSettings.Builder<UpdateConnectionProfileRequest, ConnectionProfile, OperationMetadata> updateConnectionProfileOperationSettings() {
            return this.updateConnectionProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectionProfileRequest, Operation> deleteConnectionProfileSettings() {
            return this.deleteConnectionProfileSettings;
        }

        public OperationCallSettings.Builder<DeleteConnectionProfileRequest, Empty, OperationMetadata> deleteConnectionProfileOperationSettings() {
            return this.deleteConnectionProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<DiscoverConnectionProfileRequest, DiscoverConnectionProfileResponse> discoverConnectionProfileSettings() {
            return this.discoverConnectionProfileSettings;
        }

        public PagedCallSettings.Builder<ListStreamsRequest, ListStreamsResponse, DatastreamClient.ListStreamsPagedResponse> listStreamsSettings() {
            return this.listStreamsSettings;
        }

        public UnaryCallSettings.Builder<GetStreamRequest, Stream> getStreamSettings() {
            return this.getStreamSettings;
        }

        public UnaryCallSettings.Builder<CreateStreamRequest, Operation> createStreamSettings() {
            return this.createStreamSettings;
        }

        public OperationCallSettings.Builder<CreateStreamRequest, Stream, OperationMetadata> createStreamOperationSettings() {
            return this.createStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateStreamRequest, Operation> updateStreamSettings() {
            return this.updateStreamSettings;
        }

        public OperationCallSettings.Builder<UpdateStreamRequest, Stream, OperationMetadata> updateStreamOperationSettings() {
            return this.updateStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteStreamRequest, Operation> deleteStreamSettings() {
            return this.deleteStreamSettings;
        }

        public OperationCallSettings.Builder<DeleteStreamRequest, Empty, OperationMetadata> deleteStreamOperationSettings() {
            return this.deleteStreamOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchErrorsRequest, Operation> fetchErrorsSettings() {
            return this.fetchErrorsSettings;
        }

        public OperationCallSettings.Builder<FetchErrorsRequest, FetchErrorsResponse, OperationMetadata> fetchErrorsOperationSettings() {
            return this.fetchErrorsOperationSettings;
        }

        public PagedCallSettings.Builder<FetchStaticIpsRequest, FetchStaticIpsResponse, DatastreamClient.FetchStaticIpsPagedResponse> fetchStaticIpsSettings() {
            return this.fetchStaticIpsSettings;
        }

        public UnaryCallSettings.Builder<CreatePrivateConnectionRequest, Operation> createPrivateConnectionSettings() {
            return this.createPrivateConnectionSettings;
        }

        public OperationCallSettings.Builder<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationSettings() {
            return this.createPrivateConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionSettings() {
            return this.getPrivateConnectionSettings;
        }

        public PagedCallSettings.Builder<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, DatastreamClient.ListPrivateConnectionsPagedResponse> listPrivateConnectionsSettings() {
            return this.listPrivateConnectionsSettings;
        }

        public UnaryCallSettings.Builder<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionSettings() {
            return this.deletePrivateConnectionSettings;
        }

        public OperationCallSettings.Builder<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationSettings() {
            return this.deletePrivateConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateRouteRequest, Operation> createRouteSettings() {
            return this.createRouteSettings;
        }

        public OperationCallSettings.Builder<CreateRouteRequest, Route, OperationMetadata> createRouteOperationSettings() {
            return this.createRouteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRouteRequest, Route> getRouteSettings() {
            return this.getRouteSettings;
        }

        public PagedCallSettings.Builder<ListRoutesRequest, ListRoutesResponse, DatastreamClient.ListRoutesPagedResponse> listRoutesSettings() {
            return this.listRoutesSettings;
        }

        public UnaryCallSettings.Builder<DeleteRouteRequest, Operation> deleteRouteSettings() {
            return this.deleteRouteSettings;
        }

        public OperationCallSettings.Builder<DeleteRouteRequest, Empty, OperationMetadata> deleteRouteOperationSettings() {
            return this.deleteRouteOperationSettings;
        }

        public DatastreamStubSettings build() throws IOException {
            return new DatastreamStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

