/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteSessionTemplateRequest;
import com.google.cloud.dataproc.v1.GetSessionTemplateRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesResponse;
import com.google.cloud.dataproc.v1.SessionTemplate;
import com.google.cloud.dataproc.v1.SessionTemplateControllerClient;
import com.google.cloud.dataproc.v1.UpdateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.stub.GrpcSessionTemplateControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSessionTemplateControllerStub
extends SessionTemplateControllerStub {
    private static final MethodDescriptor<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/CreateSessionTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSessionTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SessionTemplate.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/UpdateSessionTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSessionTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SessionTemplate.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/GetSessionTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSessionTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SessionTemplate.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/ListSessionTemplates").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSessionTemplatesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSessionTemplatesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionTemplateController/DeleteSessionTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSessionTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateCallable;
    private final UnaryCallable<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateCallable;
    private final UnaryCallable<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateCallable;
    private final UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesCallable;
    private final UnaryCallable<ListSessionTemplatesRequest, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesPagedCallable;
    private final UnaryCallable<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSessionTemplateControllerStub create(SessionTemplateControllerStubSettings settings) throws IOException {
        return new GrpcSessionTemplateControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSessionTemplateControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcSessionTemplateControllerStub(SessionTemplateControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSessionTemplateControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSessionTemplateControllerStub(SessionTemplateControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSessionTemplateControllerStub(SessionTemplateControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSessionTemplateControllerCallableFactory());
    }

    protected GrpcSessionTemplateControllerStub(SessionTemplateControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSessionTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSessionTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSessionTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSessionTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("session_template.name", String.valueOf(request.getSessionTemplate().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getSessionTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSessionTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSessionTemplatesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSessionTemplatesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSessionTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSessionTemplateMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSessionTemplateCallable = callableFactory.createUnaryCallable(createSessionTemplateTransportSettings, settings.createSessionTemplateSettings(), clientContext);
        this.updateSessionTemplateCallable = callableFactory.createUnaryCallable(updateSessionTemplateTransportSettings, settings.updateSessionTemplateSettings(), clientContext);
        this.getSessionTemplateCallable = callableFactory.createUnaryCallable(getSessionTemplateTransportSettings, settings.getSessionTemplateSettings(), clientContext);
        this.listSessionTemplatesCallable = callableFactory.createUnaryCallable(listSessionTemplatesTransportSettings, settings.listSessionTemplatesSettings(), clientContext);
        this.listSessionTemplatesPagedCallable = callableFactory.createPagedCallable(listSessionTemplatesTransportSettings, settings.listSessionTemplatesSettings(), clientContext);
        this.deleteSessionTemplateCallable = callableFactory.createUnaryCallable(deleteSessionTemplateTransportSettings, settings.deleteSessionTemplateSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateCallable() {
        return this.createSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateCallable() {
        return this.updateSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateCallable() {
        return this.getSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> listSessionTemplatesCallable() {
        return this.listSessionTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListSessionTemplatesRequest, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesPagedCallable() {
        return this.listSessionTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateCallable() {
        return this.deleteSessionTemplateCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

