/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.ClusterRegionName;
import com.google.cloud.dataproc.v1.CreateNodeGroupRequest;
import com.google.cloud.dataproc.v1.GetNodeGroupRequest;
import com.google.cloud.dataproc.v1.NodeGroup;
import com.google.cloud.dataproc.v1.NodeGroupControllerSettings;
import com.google.cloud.dataproc.v1.NodeGroupName;
import com.google.cloud.dataproc.v1.NodeGroupOperationMetadata;
import com.google.cloud.dataproc.v1.ResizeNodeGroupRequest;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStub;
import com.google.cloud.dataproc.v1.stub.NodeGroupControllerStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class NodeGroupControllerClient
implements BackgroundResource {
    private final NodeGroupControllerSettings settings;
    private final NodeGroupControllerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final NodeGroupControllerClient create() throws IOException {
        return NodeGroupControllerClient.create(NodeGroupControllerSettings.newBuilder().build());
    }

    public static final NodeGroupControllerClient create(NodeGroupControllerSettings settings) throws IOException {
        return new NodeGroupControllerClient(settings);
    }

    public static final NodeGroupControllerClient create(NodeGroupControllerStub stub) {
        return new NodeGroupControllerClient(stub);
    }

    protected NodeGroupControllerClient(NodeGroupControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeGroupControllerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected NodeGroupControllerClient(NodeGroupControllerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final NodeGroupControllerSettings getSettings() {
        return this.settings;
    }

    public NodeGroupControllerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<NodeGroup, NodeGroupOperationMetadata> createNodeGroupAsync(ClusterRegionName parent, NodeGroup nodeGroup, String nodeGroupId) {
        CreateNodeGroupRequest request = CreateNodeGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNodeGroup(nodeGroup).setNodeGroupId(nodeGroupId).build();
        return this.createNodeGroupAsync(request);
    }

    public final OperationFuture<NodeGroup, NodeGroupOperationMetadata> createNodeGroupAsync(String parent, NodeGroup nodeGroup, String nodeGroupId) {
        CreateNodeGroupRequest request = CreateNodeGroupRequest.newBuilder().setParent(parent).setNodeGroup(nodeGroup).setNodeGroupId(nodeGroupId).build();
        return this.createNodeGroupAsync(request);
    }

    public final OperationFuture<NodeGroup, NodeGroupOperationMetadata> createNodeGroupAsync(CreateNodeGroupRequest request) {
        return this.createNodeGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> createNodeGroupOperationCallable() {
        return this.stub.createNodeGroupOperationCallable();
    }

    public final UnaryCallable<CreateNodeGroupRequest, Operation> createNodeGroupCallable() {
        return this.stub.createNodeGroupCallable();
    }

    public final OperationFuture<NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupAsync(String name, int size) {
        ResizeNodeGroupRequest request = ResizeNodeGroupRequest.newBuilder().setName(name).setSize(size).build();
        return this.resizeNodeGroupAsync(request);
    }

    public final OperationFuture<NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupAsync(ResizeNodeGroupRequest request) {
        return this.resizeNodeGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResizeNodeGroupRequest, NodeGroup, NodeGroupOperationMetadata> resizeNodeGroupOperationCallable() {
        return this.stub.resizeNodeGroupOperationCallable();
    }

    public final UnaryCallable<ResizeNodeGroupRequest, Operation> resizeNodeGroupCallable() {
        return this.stub.resizeNodeGroupCallable();
    }

    public final NodeGroup getNodeGroup(NodeGroupName name) {
        GetNodeGroupRequest request = GetNodeGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNodeGroup(request);
    }

    public final NodeGroup getNodeGroup(String name) {
        GetNodeGroupRequest request = GetNodeGroupRequest.newBuilder().setName(name).build();
        return this.getNodeGroup(request);
    }

    public final NodeGroup getNodeGroup(GetNodeGroupRequest request) {
        return (NodeGroup)this.getNodeGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeGroupRequest, NodeGroup> getNodeGroupCallable() {
        return this.stub.getNodeGroupCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

