/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionRequest;
import com.google.cloud.dataproc.v1.DeleteSessionRequest;
import com.google.cloud.dataproc.v1.GetSessionRequest;
import com.google.cloud.dataproc.v1.ListSessionsRequest;
import com.google.cloud.dataproc.v1.ListSessionsResponse;
import com.google.cloud.dataproc.v1.Session;
import com.google.cloud.dataproc.v1.SessionControllerClient;
import com.google.cloud.dataproc.v1.SessionOperationMetadata;
import com.google.cloud.dataproc.v1.TerminateSessionRequest;
import com.google.cloud.dataproc.v1.stub.HttpJsonSessionControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.SessionControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionControllerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSessionControllerStub
extends SessionControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(SessionOperationMetadata.getDescriptor()).add(Session.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateSessionRequest, Operation> createSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionController/CreateSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "sessionId", (Object)request.getSessionId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("session", (Message)request.getSession(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionController/GetSession").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Session.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionController/ListSessions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/sessions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSessionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TerminateSessionRequest, Operation> terminateSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionController/TerminateSession").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/sessions/*}:terminate", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteSessionRequest, Operation> deleteSessionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.SessionController/DeleteSession").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/sessions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/operations/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:setIamPolicy", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/operations/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:getIamPolicy", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/regions/*/clusters/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/regions/*/jobs/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/operations/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/workflowTemplates/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/workflowTemplates/*}:testIamPermissions", "/v1/{resource=projects/*/regions/*/autoscalingPolicies/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/autoscalingPolicies/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSessionRequest, Operation> createSessionCallable;
    private final OperationCallable<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SessionControllerClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final UnaryCallable<TerminateSessionRequest, Operation> terminateSessionCallable;
    private final OperationCallable<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationCallable;
    private final UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable;
    private final OperationCallable<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSessionControllerStub create(SessionControllerStubSettings settings) throws IOException {
        return new HttpJsonSessionControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSessionControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSessionControllerStub(SessionControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSessionControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSessionControllerStub(SessionControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSessionControllerStub(SessionControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSessionControllerCallableFactory());
    }

    protected HttpJsonSessionControllerStub(SessionControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/regions/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/regions/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/regions/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/regions/*/operations}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations}").build()).build()).build());
        HttpJsonCallSettings createSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSessionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings terminateSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(terminateSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSessionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.createSessionOperationCallable = callableFactory.createOperationCallable(createSessionTransportSettings, settings.createSessionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.terminateSessionCallable = callableFactory.createUnaryCallable(terminateSessionTransportSettings, settings.terminateSessionSettings(), clientContext);
        this.terminateSessionOperationCallable = callableFactory.createOperationCallable(terminateSessionTransportSettings, settings.terminateSessionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.deleteSessionOperationCallable = callableFactory.createOperationCallable(deleteSessionTransportSettings, settings.deleteSessionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSessionMethodDescriptor);
        methodDescriptors.add(getSessionMethodDescriptor);
        methodDescriptors.add(listSessionsMethodDescriptor);
        methodDescriptors.add(terminateSessionMethodDescriptor);
        methodDescriptors.add(deleteSessionMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Operation> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public OperationCallable<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationCallable() {
        return this.createSessionOperationCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SessionControllerClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<TerminateSessionRequest, Operation> terminateSessionCallable() {
        return this.terminateSessionCallable;
    }

    @Override
    public OperationCallable<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationCallable() {
        return this.terminateSessionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public OperationCallable<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationCallable() {
        return this.deleteSessionOperationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

