/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1beta2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1beta2.CancelJobRequest;
import com.google.cloud.dataproc.v1beta2.DeleteJobRequest;
import com.google.cloud.dataproc.v1beta2.GetJobRequest;
import com.google.cloud.dataproc.v1beta2.Job;
import com.google.cloud.dataproc.v1beta2.JobControllerSettings;
import com.google.cloud.dataproc.v1beta2.JobMetadata;
import com.google.cloud.dataproc.v1beta2.ListJobsRequest;
import com.google.cloud.dataproc.v1beta2.ListJobsResponse;
import com.google.cloud.dataproc.v1beta2.SubmitJobRequest;
import com.google.cloud.dataproc.v1beta2.UpdateJobRequest;
import com.google.cloud.dataproc.v1beta2.stub.JobControllerStub;
import com.google.cloud.dataproc.v1beta2.stub.JobControllerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class JobControllerClient
implements BackgroundResource {
    private final JobControllerSettings settings;
    private final JobControllerStub stub;
    private final OperationsClient operationsClient;

    public static final JobControllerClient create() throws IOException {
        return JobControllerClient.create(JobControllerSettings.newBuilder().build());
    }

    public static final JobControllerClient create(JobControllerSettings settings) throws IOException {
        return new JobControllerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final JobControllerClient create(JobControllerStub stub) {
        return new JobControllerClient(stub);
    }

    protected JobControllerClient(JobControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((JobControllerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected JobControllerClient(JobControllerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final JobControllerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobControllerStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Job submitJob(String projectId, String region, Job job) {
        SubmitJobRequest request = SubmitJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJob(job).build();
        return this.submitJob(request);
    }

    public final Job submitJob(SubmitJobRequest request) {
        return (Job)this.submitJobCallable().call((Object)request);
    }

    public final UnaryCallable<SubmitJobRequest, Job> submitJobCallable() {
        return this.stub.submitJobCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Job, JobMetadata> submitJobAsOperationAsync(String projectId, String region, Job job) {
        SubmitJobRequest request = SubmitJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJob(job).build();
        return this.submitJobAsOperationAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Job, JobMetadata> submitJobAsOperationAsync(SubmitJobRequest request) {
        return this.submitJobAsOperationOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<SubmitJobRequest, Job, JobMetadata> submitJobAsOperationOperationCallable() {
        return this.stub.submitJobAsOperationOperationCallable();
    }

    public final UnaryCallable<SubmitJobRequest, Operation> submitJobAsOperationCallable() {
        return this.stub.submitJobAsOperationCallable();
    }

    public final Job getJob(String projectId, String region, String jobId) {
        GetJobRequest request = GetJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final ListJobsPagedResponse listJobs(String projectId, String region) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setProjectId(projectId).setRegion(region).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(String projectId, String region, String filter) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setProjectId(projectId).setRegion(region).setFilter(filter).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Job updateJob(UpdateJobRequest request) {
        return (Job)this.updateJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final Job cancelJob(String projectId, String region, String jobId) {
        CancelJobRequest request = CancelJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        return this.cancelJob(request);
    }

    public final Job cancelJob(CancelJobRequest request) {
        return (Job)this.cancelJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelJobRequest, Job> cancelJobCallable() {
        return this.stub.cancelJobCallable();
    }

    public final void deleteJob(String projectId, String region, String jobId) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        this.deleteJob(request);
    }

    public final void deleteJob(DeleteJobRequest request) {
        this.deleteJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListJobsPage, ListJobsPagedResponse>(){

                public ListJobsPagedResponse apply(ListJobsPage input) {
                    return new ListJobsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

