/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.BusinessGlossaryServiceSettings;
import com.google.cloud.dataplex.v1.CreateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryTermRequest;
import com.google.cloud.dataplex.v1.GetGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryTermRequest;
import com.google.cloud.dataplex.v1.Glossary;
import com.google.cloud.dataplex.v1.GlossaryCategory;
import com.google.cloud.dataplex.v1.GlossaryCategoryName;
import com.google.cloud.dataplex.v1.GlossaryName;
import com.google.cloud.dataplex.v1.GlossaryTerm;
import com.google.cloud.dataplex.v1.GlossaryTermName;
import com.google.cloud.dataplex.v1.ListGlossariesRequest;
import com.google.cloud.dataplex.v1.ListGlossariesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesRequest;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryTermsRequest;
import com.google.cloud.dataplex.v1.ListGlossaryTermsResponse;
import com.google.cloud.dataplex.v1.LocationName;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.stub.BusinessGlossaryServiceStub;
import com.google.cloud.dataplex.v1.stub.BusinessGlossaryServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BusinessGlossaryServiceClient
implements BackgroundResource {
    private final BusinessGlossaryServiceSettings settings;
    private final BusinessGlossaryServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final BusinessGlossaryServiceClient create() throws IOException {
        return BusinessGlossaryServiceClient.create(BusinessGlossaryServiceSettings.newBuilder().build());
    }

    public static final BusinessGlossaryServiceClient create(BusinessGlossaryServiceSettings settings) throws IOException {
        return new BusinessGlossaryServiceClient(settings);
    }

    public static final BusinessGlossaryServiceClient create(BusinessGlossaryServiceStub stub) {
        return new BusinessGlossaryServiceClient(stub);
    }

    protected BusinessGlossaryServiceClient(BusinessGlossaryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BusinessGlossaryServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected BusinessGlossaryServiceClient(BusinessGlossaryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final BusinessGlossaryServiceSettings getSettings() {
        return this.settings;
    }

    public BusinessGlossaryServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Glossary, OperationMetadata> createGlossaryAsync(LocationName parent, Glossary glossary, String glossaryId) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGlossary(glossary).setGlossaryId(glossaryId).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, OperationMetadata> createGlossaryAsync(String parent, Glossary glossary, String glossaryId) {
        CreateGlossaryRequest request = CreateGlossaryRequest.newBuilder().setParent(parent).setGlossary(glossary).setGlossaryId(glossaryId).build();
        return this.createGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, OperationMetadata> createGlossaryAsync(CreateGlossaryRequest request) {
        return this.createGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationCallable() {
        return this.stub.createGlossaryOperationCallable();
    }

    public final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.stub.createGlossaryCallable();
    }

    public final OperationFuture<Glossary, OperationMetadata> updateGlossaryAsync(Glossary glossary, FieldMask updateMask) {
        UpdateGlossaryRequest request = UpdateGlossaryRequest.newBuilder().setGlossary(glossary).setUpdateMask(updateMask).build();
        return this.updateGlossaryAsync(request);
    }

    public final OperationFuture<Glossary, OperationMetadata> updateGlossaryAsync(UpdateGlossaryRequest request) {
        return this.updateGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationCallable() {
        return this.stub.updateGlossaryOperationCallable();
    }

    public final UnaryCallable<UpdateGlossaryRequest, Operation> updateGlossaryCallable() {
        return this.stub.updateGlossaryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGlossaryAsync(GlossaryName name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGlossaryAsync(String name) {
        DeleteGlossaryRequest request = DeleteGlossaryRequest.newBuilder().setName(name).build();
        return this.deleteGlossaryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteGlossaryAsync(DeleteGlossaryRequest request) {
        return this.deleteGlossaryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationCallable() {
        return this.stub.deleteGlossaryOperationCallable();
    }

    public final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.stub.deleteGlossaryCallable();
    }

    public final Glossary getGlossary(GlossaryName name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(String name) {
        GetGlossaryRequest request = GetGlossaryRequest.newBuilder().setName(name).build();
        return this.getGlossary(request);
    }

    public final Glossary getGlossary(GetGlossaryRequest request) {
        return (Glossary)this.getGlossaryCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.stub.getGlossaryCallable();
    }

    public final ListGlossariesPagedResponse listGlossaries(LocationName parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(String parent) {
        ListGlossariesRequest request = ListGlossariesRequest.newBuilder().setParent(parent).build();
        return this.listGlossaries(request);
    }

    public final ListGlossariesPagedResponse listGlossaries(ListGlossariesRequest request) {
        return (ListGlossariesPagedResponse)((Object)this.listGlossariesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.stub.listGlossariesPagedCallable();
    }

    public final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.stub.listGlossariesCallable();
    }

    public final GlossaryCategory createGlossaryCategory(GlossaryName parent, GlossaryCategory category, String categoryId) {
        CreateGlossaryCategoryRequest request = CreateGlossaryCategoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCategory(category).setCategoryId(categoryId).build();
        return this.createGlossaryCategory(request);
    }

    public final GlossaryCategory createGlossaryCategory(String parent, GlossaryCategory category, String categoryId) {
        CreateGlossaryCategoryRequest request = CreateGlossaryCategoryRequest.newBuilder().setParent(parent).setCategory(category).setCategoryId(categoryId).build();
        return this.createGlossaryCategory(request);
    }

    public final GlossaryCategory createGlossaryCategory(CreateGlossaryCategoryRequest request) {
        return (GlossaryCategory)this.createGlossaryCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategoryCallable() {
        return this.stub.createGlossaryCategoryCallable();
    }

    public final GlossaryCategory updateGlossaryCategory(GlossaryCategory category, FieldMask updateMask) {
        UpdateGlossaryCategoryRequest request = UpdateGlossaryCategoryRequest.newBuilder().setCategory(category).setUpdateMask(updateMask).build();
        return this.updateGlossaryCategory(request);
    }

    public final GlossaryCategory updateGlossaryCategory(UpdateGlossaryCategoryRequest request) {
        return (GlossaryCategory)this.updateGlossaryCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategoryCallable() {
        return this.stub.updateGlossaryCategoryCallable();
    }

    public final void deleteGlossaryCategory(GlossaryCategoryName name) {
        DeleteGlossaryCategoryRequest request = DeleteGlossaryCategoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGlossaryCategory(request);
    }

    public final void deleteGlossaryCategory(String name) {
        DeleteGlossaryCategoryRequest request = DeleteGlossaryCategoryRequest.newBuilder().setName(name).build();
        this.deleteGlossaryCategory(request);
    }

    public final void deleteGlossaryCategory(DeleteGlossaryCategoryRequest request) {
        this.deleteGlossaryCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategoryCallable() {
        return this.stub.deleteGlossaryCategoryCallable();
    }

    public final GlossaryCategory getGlossaryCategory(GlossaryCategoryName name) {
        GetGlossaryCategoryRequest request = GetGlossaryCategoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossaryCategory(request);
    }

    public final GlossaryCategory getGlossaryCategory(String name) {
        GetGlossaryCategoryRequest request = GetGlossaryCategoryRequest.newBuilder().setName(name).build();
        return this.getGlossaryCategory(request);
    }

    public final GlossaryCategory getGlossaryCategory(GetGlossaryCategoryRequest request) {
        return (GlossaryCategory)this.getGlossaryCategoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategoryCallable() {
        return this.stub.getGlossaryCategoryCallable();
    }

    public final ListGlossaryCategoriesPagedResponse listGlossaryCategories(GlossaryName parent) {
        ListGlossaryCategoriesRequest request = ListGlossaryCategoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaryCategories(request);
    }

    public final ListGlossaryCategoriesPagedResponse listGlossaryCategories(String parent) {
        ListGlossaryCategoriesRequest request = ListGlossaryCategoriesRequest.newBuilder().setParent(parent).build();
        return this.listGlossaryCategories(request);
    }

    public final ListGlossaryCategoriesPagedResponse listGlossaryCategories(ListGlossaryCategoriesRequest request) {
        return (ListGlossaryCategoriesPagedResponse)((Object)this.listGlossaryCategoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossaryCategoriesRequest, ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesPagedCallable() {
        return this.stub.listGlossaryCategoriesPagedCallable();
    }

    public final UnaryCallable<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse> listGlossaryCategoriesCallable() {
        return this.stub.listGlossaryCategoriesCallable();
    }

    public final GlossaryTerm createGlossaryTerm(GlossaryName parent, GlossaryTerm term, String termId) {
        CreateGlossaryTermRequest request = CreateGlossaryTermRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTerm(term).setTermId(termId).build();
        return this.createGlossaryTerm(request);
    }

    public final GlossaryTerm createGlossaryTerm(String parent, GlossaryTerm term, String termId) {
        CreateGlossaryTermRequest request = CreateGlossaryTermRequest.newBuilder().setParent(parent).setTerm(term).setTermId(termId).build();
        return this.createGlossaryTerm(request);
    }

    public final GlossaryTerm createGlossaryTerm(CreateGlossaryTermRequest request) {
        return (GlossaryTerm)this.createGlossaryTermCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermCallable() {
        return this.stub.createGlossaryTermCallable();
    }

    public final GlossaryTerm updateGlossaryTerm(GlossaryTerm term, FieldMask updateMask) {
        UpdateGlossaryTermRequest request = UpdateGlossaryTermRequest.newBuilder().setTerm(term).setUpdateMask(updateMask).build();
        return this.updateGlossaryTerm(request);
    }

    public final GlossaryTerm updateGlossaryTerm(UpdateGlossaryTermRequest request) {
        return (GlossaryTerm)this.updateGlossaryTermCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermCallable() {
        return this.stub.updateGlossaryTermCallable();
    }

    public final void deleteGlossaryTerm(GlossaryTermName name) {
        DeleteGlossaryTermRequest request = DeleteGlossaryTermRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteGlossaryTerm(request);
    }

    public final void deleteGlossaryTerm(String name) {
        DeleteGlossaryTermRequest request = DeleteGlossaryTermRequest.newBuilder().setName(name).build();
        this.deleteGlossaryTerm(request);
    }

    public final void deleteGlossaryTerm(DeleteGlossaryTermRequest request) {
        this.deleteGlossaryTermCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermCallable() {
        return this.stub.deleteGlossaryTermCallable();
    }

    public final GlossaryTerm getGlossaryTerm(GlossaryTermName name) {
        GetGlossaryTermRequest request = GetGlossaryTermRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGlossaryTerm(request);
    }

    public final GlossaryTerm getGlossaryTerm(String name) {
        GetGlossaryTermRequest request = GetGlossaryTermRequest.newBuilder().setName(name).build();
        return this.getGlossaryTerm(request);
    }

    public final GlossaryTerm getGlossaryTerm(GetGlossaryTermRequest request) {
        return (GlossaryTerm)this.getGlossaryTermCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermCallable() {
        return this.stub.getGlossaryTermCallable();
    }

    public final ListGlossaryTermsPagedResponse listGlossaryTerms(GlossaryName parent) {
        ListGlossaryTermsRequest request = ListGlossaryTermsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGlossaryTerms(request);
    }

    public final ListGlossaryTermsPagedResponse listGlossaryTerms(String parent) {
        ListGlossaryTermsRequest request = ListGlossaryTermsRequest.newBuilder().setParent(parent).build();
        return this.listGlossaryTerms(request);
    }

    public final ListGlossaryTermsPagedResponse listGlossaryTerms(ListGlossaryTermsRequest request) {
        return (ListGlossaryTermsPagedResponse)((Object)this.listGlossaryTermsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlossaryTermsRequest, ListGlossaryTermsPagedResponse> listGlossaryTermsPagedCallable() {
        return this.stub.listGlossaryTermsPagedCallable();
    }

    public final UnaryCallable<ListGlossaryTermsRequest, ListGlossaryTermsResponse> listGlossaryTermsCallable() {
        return this.stub.listGlossaryTermsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGlossaryTermsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm, ListGlossaryTermsPage, ListGlossaryTermsFixedSizeCollection> {
        private ListGlossaryTermsFixedSizeCollection(List<ListGlossaryTermsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossaryTermsFixedSizeCollection createEmptyCollection() {
            return new ListGlossaryTermsFixedSizeCollection(null, 0);
        }

        protected ListGlossaryTermsFixedSizeCollection createCollection(List<ListGlossaryTermsPage> pages, int collectionSize) {
            return new ListGlossaryTermsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossaryTermsPage
    extends AbstractPage<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm, ListGlossaryTermsPage> {
        private ListGlossaryTermsPage(PageContext<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm> context, ListGlossaryTermsResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossaryTermsPage createEmptyPage() {
            return new ListGlossaryTermsPage(null, null);
        }

        protected ListGlossaryTermsPage createPage(PageContext<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm> context, ListGlossaryTermsResponse response) {
            return new ListGlossaryTermsPage(context, response);
        }

        public ApiFuture<ListGlossaryTermsPage> createPageAsync(PageContext<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm> context, ApiFuture<ListGlossaryTermsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossaryTermsPagedResponse
    extends AbstractPagedListResponse<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm, ListGlossaryTermsPage, ListGlossaryTermsFixedSizeCollection> {
        public static ApiFuture<ListGlossaryTermsPagedResponse> createAsync(PageContext<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm> context, ApiFuture<ListGlossaryTermsResponse> futureResponse) {
            ApiFuture<ListGlossaryTermsPage> futurePage = ListGlossaryTermsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossaryTermsPagedResponse((ListGlossaryTermsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossaryTermsPagedResponse(ListGlossaryTermsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossaryTermsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGlossaryCategoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory, ListGlossaryCategoriesPage, ListGlossaryCategoriesFixedSizeCollection> {
        private ListGlossaryCategoriesFixedSizeCollection(List<ListGlossaryCategoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossaryCategoriesFixedSizeCollection createEmptyCollection() {
            return new ListGlossaryCategoriesFixedSizeCollection(null, 0);
        }

        protected ListGlossaryCategoriesFixedSizeCollection createCollection(List<ListGlossaryCategoriesPage> pages, int collectionSize) {
            return new ListGlossaryCategoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossaryCategoriesPage
    extends AbstractPage<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory, ListGlossaryCategoriesPage> {
        private ListGlossaryCategoriesPage(PageContext<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory> context, ListGlossaryCategoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossaryCategoriesPage createEmptyPage() {
            return new ListGlossaryCategoriesPage(null, null);
        }

        protected ListGlossaryCategoriesPage createPage(PageContext<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory> context, ListGlossaryCategoriesResponse response) {
            return new ListGlossaryCategoriesPage(context, response);
        }

        public ApiFuture<ListGlossaryCategoriesPage> createPageAsync(PageContext<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory> context, ApiFuture<ListGlossaryCategoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossaryCategoriesPagedResponse
    extends AbstractPagedListResponse<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory, ListGlossaryCategoriesPage, ListGlossaryCategoriesFixedSizeCollection> {
        public static ApiFuture<ListGlossaryCategoriesPagedResponse> createAsync(PageContext<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory> context, ApiFuture<ListGlossaryCategoriesResponse> futureResponse) {
            ApiFuture<ListGlossaryCategoriesPage> futurePage = ListGlossaryCategoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossaryCategoriesPagedResponse((ListGlossaryCategoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossaryCategoriesPagedResponse(ListGlossaryCategoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossaryCategoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGlossariesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        private ListGlossariesFixedSizeCollection(List<ListGlossariesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGlossariesFixedSizeCollection createEmptyCollection() {
            return new ListGlossariesFixedSizeCollection(null, 0);
        }

        protected ListGlossariesFixedSizeCollection createCollection(List<ListGlossariesPage> pages, int collectionSize) {
            return new ListGlossariesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGlossariesPage
    extends AbstractPage<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage> {
        private ListGlossariesPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            super(context, (Object)response);
        }

        private static ListGlossariesPage createEmptyPage() {
            return new ListGlossariesPage(null, null);
        }

        protected ListGlossariesPage createPage(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ListGlossariesResponse response) {
            return new ListGlossariesPage(context, response);
        }

        public ApiFuture<ListGlossariesPage> createPageAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGlossariesPagedResponse
    extends AbstractPagedListResponse<ListGlossariesRequest, ListGlossariesResponse, Glossary, ListGlossariesPage, ListGlossariesFixedSizeCollection> {
        public static ApiFuture<ListGlossariesPagedResponse> createAsync(PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary> context, ApiFuture<ListGlossariesResponse> futureResponse) {
            ApiFuture<ListGlossariesPage> futurePage = ListGlossariesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGlossariesPagedResponse((ListGlossariesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGlossariesPagedResponse(ListGlossariesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGlossariesFixedSizeCollection.createEmptyCollection());
        }
    }
}

