/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.BusinessGlossaryServiceClient;
import com.google.cloud.dataplex.v1.CreateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryRequest;
import com.google.cloud.dataplex.v1.CreateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryRequest;
import com.google.cloud.dataplex.v1.DeleteGlossaryTermRequest;
import com.google.cloud.dataplex.v1.GetGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryRequest;
import com.google.cloud.dataplex.v1.GetGlossaryTermRequest;
import com.google.cloud.dataplex.v1.Glossary;
import com.google.cloud.dataplex.v1.GlossaryCategory;
import com.google.cloud.dataplex.v1.GlossaryTerm;
import com.google.cloud.dataplex.v1.ListGlossariesRequest;
import com.google.cloud.dataplex.v1.ListGlossariesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesRequest;
import com.google.cloud.dataplex.v1.ListGlossaryCategoriesResponse;
import com.google.cloud.dataplex.v1.ListGlossaryTermsRequest;
import com.google.cloud.dataplex.v1.ListGlossaryTermsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateGlossaryCategoryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryRequest;
import com.google.cloud.dataplex.v1.UpdateGlossaryTermRequest;
import com.google.cloud.dataplex.v1.stub.BusinessGlossaryServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcBusinessGlossaryServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonBusinessGlossaryServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BusinessGlossaryServiceStubSettings
extends StubSettings<BusinessGlossaryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings;
    private final OperationCallSettings<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationSettings;
    private final UnaryCallSettings<UpdateGlossaryRequest, Operation> updateGlossarySettings;
    private final OperationCallSettings<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationSettings;
    private final UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
    private final OperationCallSettings<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationSettings;
    private final UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings;
    private final PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
    private final UnaryCallSettings<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategorySettings;
    private final UnaryCallSettings<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategorySettings;
    private final UnaryCallSettings<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategorySettings;
    private final UnaryCallSettings<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategorySettings;
    private final PagedCallSettings<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesSettings;
    private final UnaryCallSettings<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermSettings;
    private final UnaryCallSettings<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermSettings;
    private final UnaryCallSettings<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermSettings;
    private final UnaryCallSettings<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermSettings;
    private final PagedCallSettings<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary> LIST_GLOSSARIES_PAGE_STR_DESC = new PagedListDescriptor<ListGlossariesRequest, ListGlossariesResponse, Glossary>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossariesRequest injectToken(ListGlossariesRequest payload, String token) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageToken(token).build();
        }

        public ListGlossariesRequest injectPageSize(ListGlossariesRequest payload, int pageSize) {
            return ListGlossariesRequest.newBuilder((ListGlossariesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossariesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossariesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Glossary> extractResources(ListGlossariesResponse payload) {
            return payload.getGlossariesList();
        }
    };
    private static final PagedListDescriptor<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory> LIST_GLOSSARY_CATEGORIES_PAGE_STR_DESC = new PagedListDescriptor<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossaryCategoriesRequest injectToken(ListGlossaryCategoriesRequest payload, String token) {
            return ListGlossaryCategoriesRequest.newBuilder((ListGlossaryCategoriesRequest)payload).setPageToken(token).build();
        }

        public ListGlossaryCategoriesRequest injectPageSize(ListGlossaryCategoriesRequest payload, int pageSize) {
            return ListGlossaryCategoriesRequest.newBuilder((ListGlossaryCategoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossaryCategoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossaryCategoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GlossaryCategory> extractResources(ListGlossaryCategoriesResponse payload) {
            return payload.getCategoriesList();
        }
    };
    private static final PagedListDescriptor<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm> LIST_GLOSSARY_TERMS_PAGE_STR_DESC = new PagedListDescriptor<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm>(){

        public String emptyToken() {
            return "";
        }

        public ListGlossaryTermsRequest injectToken(ListGlossaryTermsRequest payload, String token) {
            return ListGlossaryTermsRequest.newBuilder((ListGlossaryTermsRequest)payload).setPageToken(token).build();
        }

        public ListGlossaryTermsRequest injectPageSize(ListGlossaryTermsRequest payload, int pageSize) {
            return ListGlossaryTermsRequest.newBuilder((ListGlossaryTermsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGlossaryTermsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGlossaryTermsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GlossaryTerm> extractResources(ListGlossaryTermsResponse payload) {
            return payload.getTermsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> LIST_GLOSSARIES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse>(){

        public ApiFuture<BusinessGlossaryServiceClient.ListGlossariesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> callable, ListGlossariesRequest request, ApiCallContext context, ApiFuture<ListGlossariesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BusinessGlossaryServiceClient.ListGlossariesPagedResponse.createAsync((PageContext<ListGlossariesRequest, ListGlossariesResponse, Glossary>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> LIST_GLOSSARY_CATEGORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse>(){

        public ApiFuture<BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse> callable, ListGlossaryCategoriesRequest request, ApiCallContext context, ApiFuture<ListGlossaryCategoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARY_CATEGORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse.createAsync((PageContext<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, GlossaryCategory>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> LIST_GLOSSARY_TERMS_PAGE_STR_FACT = new PagedListResponseFactory<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse>(){

        public ApiFuture<BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlossaryTermsRequest, ListGlossaryTermsResponse> callable, ListGlossaryTermsRequest request, ApiCallContext context, ApiFuture<ListGlossaryTermsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOSSARY_TERMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse.createAsync((PageContext<ListGlossaryTermsRequest, ListGlossaryTermsResponse, GlossaryTerm>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<BusinessGlossaryServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BusinessGlossaryServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateGlossaryRequest, Operation> createGlossarySettings() {
        return this.createGlossarySettings;
    }

    public OperationCallSettings<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationSettings() {
        return this.createGlossaryOperationSettings;
    }

    public UnaryCallSettings<UpdateGlossaryRequest, Operation> updateGlossarySettings() {
        return this.updateGlossarySettings;
    }

    public OperationCallSettings<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationSettings() {
        return this.updateGlossaryOperationSettings;
    }

    public UnaryCallSettings<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
        return this.deleteGlossarySettings;
    }

    public OperationCallSettings<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationSettings() {
        return this.deleteGlossaryOperationSettings;
    }

    public UnaryCallSettings<GetGlossaryRequest, Glossary> getGlossarySettings() {
        return this.getGlossarySettings;
    }

    public PagedCallSettings<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
        return this.listGlossariesSettings;
    }

    public UnaryCallSettings<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategorySettings() {
        return this.createGlossaryCategorySettings;
    }

    public UnaryCallSettings<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategorySettings() {
        return this.updateGlossaryCategorySettings;
    }

    public UnaryCallSettings<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategorySettings() {
        return this.deleteGlossaryCategorySettings;
    }

    public UnaryCallSettings<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategorySettings() {
        return this.getGlossaryCategorySettings;
    }

    public PagedCallSettings<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesSettings() {
        return this.listGlossaryCategoriesSettings;
    }

    public UnaryCallSettings<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermSettings() {
        return this.createGlossaryTermSettings;
    }

    public UnaryCallSettings<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermSettings() {
        return this.updateGlossaryTermSettings;
    }

    public UnaryCallSettings<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermSettings() {
        return this.deleteGlossaryTermSettings;
    }

    public UnaryCallSettings<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermSettings() {
        return this.getGlossaryTermSettings;
    }

    public PagedCallSettings<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsSettings() {
        return this.listGlossaryTermsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public BusinessGlossaryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBusinessGlossaryServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBusinessGlossaryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataplex";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BusinessGlossaryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BusinessGlossaryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BusinessGlossaryServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BusinessGlossaryServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BusinessGlossaryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createGlossarySettings = settingsBuilder.createGlossarySettings().build();
        this.createGlossaryOperationSettings = settingsBuilder.createGlossaryOperationSettings().build();
        this.updateGlossarySettings = settingsBuilder.updateGlossarySettings().build();
        this.updateGlossaryOperationSettings = settingsBuilder.updateGlossaryOperationSettings().build();
        this.deleteGlossarySettings = settingsBuilder.deleteGlossarySettings().build();
        this.deleteGlossaryOperationSettings = settingsBuilder.deleteGlossaryOperationSettings().build();
        this.getGlossarySettings = settingsBuilder.getGlossarySettings().build();
        this.listGlossariesSettings = settingsBuilder.listGlossariesSettings().build();
        this.createGlossaryCategorySettings = settingsBuilder.createGlossaryCategorySettings().build();
        this.updateGlossaryCategorySettings = settingsBuilder.updateGlossaryCategorySettings().build();
        this.deleteGlossaryCategorySettings = settingsBuilder.deleteGlossaryCategorySettings().build();
        this.getGlossaryCategorySettings = settingsBuilder.getGlossaryCategorySettings().build();
        this.listGlossaryCategoriesSettings = settingsBuilder.listGlossaryCategoriesSettings().build();
        this.createGlossaryTermSettings = settingsBuilder.createGlossaryTermSettings().build();
        this.updateGlossaryTermSettings = settingsBuilder.updateGlossaryTermSettings().build();
        this.deleteGlossaryTermSettings = settingsBuilder.deleteGlossaryTermSettings().build();
        this.getGlossaryTermSettings = settingsBuilder.getGlossaryTermSettings().build();
        this.listGlossaryTermsSettings = settingsBuilder.listGlossaryTermsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BusinessGlossaryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings;
        private final OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGlossaryRequest, Operation> updateGlossarySettings;
        private final OperationCallSettings.Builder<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings;
        private final OperationCallSettings.Builder<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationSettings;
        private final UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings;
        private final PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesSettings;
        private final UnaryCallSettings.Builder<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategorySettings;
        private final UnaryCallSettings.Builder<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategorySettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategorySettings;
        private final UnaryCallSettings.Builder<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategorySettings;
        private final PagedCallSettings.Builder<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesSettings;
        private final UnaryCallSettings.Builder<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermSettings;
        private final UnaryCallSettings.Builder<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermSettings;
        private final UnaryCallSettings.Builder<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermSettings;
        private final UnaryCallSettings.Builder<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermSettings;
        private final PagedCallSettings.Builder<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.updateGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryOperationSettings = OperationCallSettings.newBuilder();
            this.getGlossarySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlossariesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARIES_PAGE_STR_FACT);
            this.createGlossaryCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGlossaryCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlossaryCategorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlossaryCategoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARY_CATEGORIES_PAGE_STR_FACT);
            this.createGlossaryTermSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGlossaryTermSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGlossaryTermSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlossaryTermSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlossaryTermsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOSSARY_TERMS_PAGE_STR_FACT);
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createGlossarySettings, this.updateGlossarySettings, this.deleteGlossarySettings, this.getGlossarySettings, this.listGlossariesSettings, this.createGlossaryCategorySettings, this.updateGlossaryCategorySettings, this.deleteGlossaryCategorySettings, this.getGlossaryCategorySettings, this.listGlossaryCategoriesSettings, this.createGlossaryTermSettings, this.updateGlossaryTermSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteGlossaryTermSettings, this.getGlossaryTermSettings, this.listGlossaryTermsSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(BusinessGlossaryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createGlossarySettings = settings.createGlossarySettings.toBuilder();
            this.createGlossaryOperationSettings = settings.createGlossaryOperationSettings.toBuilder();
            this.updateGlossarySettings = settings.updateGlossarySettings.toBuilder();
            this.updateGlossaryOperationSettings = settings.updateGlossaryOperationSettings.toBuilder();
            this.deleteGlossarySettings = settings.deleteGlossarySettings.toBuilder();
            this.deleteGlossaryOperationSettings = settings.deleteGlossaryOperationSettings.toBuilder();
            this.getGlossarySettings = settings.getGlossarySettings.toBuilder();
            this.listGlossariesSettings = settings.listGlossariesSettings.toBuilder();
            this.createGlossaryCategorySettings = settings.createGlossaryCategorySettings.toBuilder();
            this.updateGlossaryCategorySettings = settings.updateGlossaryCategorySettings.toBuilder();
            this.deleteGlossaryCategorySettings = settings.deleteGlossaryCategorySettings.toBuilder();
            this.getGlossaryCategorySettings = settings.getGlossaryCategorySettings.toBuilder();
            this.listGlossaryCategoriesSettings = settings.listGlossaryCategoriesSettings.toBuilder();
            this.createGlossaryTermSettings = settings.createGlossaryTermSettings.toBuilder();
            this.updateGlossaryTermSettings = settings.updateGlossaryTermSettings.toBuilder();
            this.deleteGlossaryTermSettings = settings.deleteGlossaryTermSettings.toBuilder();
            this.getGlossaryTermSettings = settings.getGlossaryTermSettings.toBuilder();
            this.listGlossaryTermsSettings = settings.listGlossaryTermsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createGlossarySettings, this.updateGlossarySettings, this.deleteGlossarySettings, this.getGlossarySettings, this.listGlossariesSettings, this.createGlossaryCategorySettings, this.updateGlossaryCategorySettings, this.deleteGlossaryCategorySettings, this.getGlossaryCategorySettings, this.listGlossaryCategoriesSettings, this.createGlossaryTermSettings, this.updateGlossaryTermSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteGlossaryTermSettings, this.getGlossaryTermSettings, this.listGlossaryTermsSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BusinessGlossaryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BusinessGlossaryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BusinessGlossaryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BusinessGlossaryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BusinessGlossaryServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BusinessGlossaryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BusinessGlossaryServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BusinessGlossaryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGlossarySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGlossariesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGlossaryCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGlossaryCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteGlossaryCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGlossaryCategorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGlossaryCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGlossaryTermSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGlossaryTermSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteGlossaryTermSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGlossaryTermSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listGlossaryTermsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Glossary.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Glossary.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteGlossaryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateGlossaryRequest, Operation> createGlossarySettings() {
            return this.createGlossarySettings;
        }

        public OperationCallSettings.Builder<CreateGlossaryRequest, Glossary, OperationMetadata> createGlossaryOperationSettings() {
            return this.createGlossaryOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGlossaryRequest, Operation> updateGlossarySettings() {
            return this.updateGlossarySettings;
        }

        public OperationCallSettings.Builder<UpdateGlossaryRequest, Glossary, OperationMetadata> updateGlossaryOperationSettings() {
            return this.updateGlossaryOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryRequest, Operation> deleteGlossarySettings() {
            return this.deleteGlossarySettings;
        }

        public OperationCallSettings.Builder<DeleteGlossaryRequest, Empty, OperationMetadata> deleteGlossaryOperationSettings() {
            return this.deleteGlossaryOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryRequest, Glossary> getGlossarySettings() {
            return this.getGlossarySettings;
        }

        public PagedCallSettings.Builder<ListGlossariesRequest, ListGlossariesResponse, BusinessGlossaryServiceClient.ListGlossariesPagedResponse> listGlossariesSettings() {
            return this.listGlossariesSettings;
        }

        public UnaryCallSettings.Builder<CreateGlossaryCategoryRequest, GlossaryCategory> createGlossaryCategorySettings() {
            return this.createGlossaryCategorySettings;
        }

        public UnaryCallSettings.Builder<UpdateGlossaryCategoryRequest, GlossaryCategory> updateGlossaryCategorySettings() {
            return this.updateGlossaryCategorySettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryCategoryRequest, Empty> deleteGlossaryCategorySettings() {
            return this.deleteGlossaryCategorySettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryCategoryRequest, GlossaryCategory> getGlossaryCategorySettings() {
            return this.getGlossaryCategorySettings;
        }

        public PagedCallSettings.Builder<ListGlossaryCategoriesRequest, ListGlossaryCategoriesResponse, BusinessGlossaryServiceClient.ListGlossaryCategoriesPagedResponse> listGlossaryCategoriesSettings() {
            return this.listGlossaryCategoriesSettings;
        }

        public UnaryCallSettings.Builder<CreateGlossaryTermRequest, GlossaryTerm> createGlossaryTermSettings() {
            return this.createGlossaryTermSettings;
        }

        public UnaryCallSettings.Builder<UpdateGlossaryTermRequest, GlossaryTerm> updateGlossaryTermSettings() {
            return this.updateGlossaryTermSettings;
        }

        public UnaryCallSettings.Builder<DeleteGlossaryTermRequest, Empty> deleteGlossaryTermSettings() {
            return this.deleteGlossaryTermSettings;
        }

        public UnaryCallSettings.Builder<GetGlossaryTermRequest, GlossaryTerm> getGlossaryTermSettings() {
            return this.getGlossaryTermSettings;
        }

        public PagedCallSettings.Builder<ListGlossaryTermsRequest, ListGlossaryTermsResponse, BusinessGlossaryServiceClient.ListGlossaryTermsPagedResponse> listGlossaryTermsSettings() {
            return this.listGlossaryTermsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, BusinessGlossaryServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public BusinessGlossaryServiceStubSettings build() throws IOException {
            return new BusinessGlossaryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

