/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataform.v1beta1.CancelWorkflowInvocationRequest;
import com.google.cloud.dataform.v1beta1.CommitLogEntry;
import com.google.cloud.dataform.v1beta1.CommitRepositoryChangesRequest;
import com.google.cloud.dataform.v1beta1.CommitWorkspaceChangesRequest;
import com.google.cloud.dataform.v1beta1.CompilationResult;
import com.google.cloud.dataform.v1beta1.CompilationResultAction;
import com.google.cloud.dataform.v1beta1.CompilationResultName;
import com.google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusRequest;
import com.google.cloud.dataform.v1beta1.ComputeRepositoryAccessTokenStatusResponse;
import com.google.cloud.dataform.v1beta1.CreateCompilationResultRequest;
import com.google.cloud.dataform.v1beta1.CreateReleaseConfigRequest;
import com.google.cloud.dataform.v1beta1.CreateRepositoryRequest;
import com.google.cloud.dataform.v1beta1.CreateWorkflowConfigRequest;
import com.google.cloud.dataform.v1beta1.CreateWorkflowInvocationRequest;
import com.google.cloud.dataform.v1beta1.CreateWorkspaceRequest;
import com.google.cloud.dataform.v1beta1.DataformSettings;
import com.google.cloud.dataform.v1beta1.DeleteReleaseConfigRequest;
import com.google.cloud.dataform.v1beta1.DeleteRepositoryRequest;
import com.google.cloud.dataform.v1beta1.DeleteWorkflowConfigRequest;
import com.google.cloud.dataform.v1beta1.DeleteWorkflowInvocationRequest;
import com.google.cloud.dataform.v1beta1.DeleteWorkspaceRequest;
import com.google.cloud.dataform.v1beta1.DirectoryEntry;
import com.google.cloud.dataform.v1beta1.FetchFileDiffRequest;
import com.google.cloud.dataform.v1beta1.FetchFileDiffResponse;
import com.google.cloud.dataform.v1beta1.FetchFileGitStatusesRequest;
import com.google.cloud.dataform.v1beta1.FetchFileGitStatusesResponse;
import com.google.cloud.dataform.v1beta1.FetchGitAheadBehindRequest;
import com.google.cloud.dataform.v1beta1.FetchGitAheadBehindResponse;
import com.google.cloud.dataform.v1beta1.FetchRemoteBranchesRequest;
import com.google.cloud.dataform.v1beta1.FetchRemoteBranchesResponse;
import com.google.cloud.dataform.v1beta1.FetchRepositoryHistoryRequest;
import com.google.cloud.dataform.v1beta1.FetchRepositoryHistoryResponse;
import com.google.cloud.dataform.v1beta1.GetCompilationResultRequest;
import com.google.cloud.dataform.v1beta1.GetReleaseConfigRequest;
import com.google.cloud.dataform.v1beta1.GetRepositoryRequest;
import com.google.cloud.dataform.v1beta1.GetWorkflowConfigRequest;
import com.google.cloud.dataform.v1beta1.GetWorkflowInvocationRequest;
import com.google.cloud.dataform.v1beta1.GetWorkspaceRequest;
import com.google.cloud.dataform.v1beta1.InstallNpmPackagesRequest;
import com.google.cloud.dataform.v1beta1.InstallNpmPackagesResponse;
import com.google.cloud.dataform.v1beta1.ListCompilationResultsRequest;
import com.google.cloud.dataform.v1beta1.ListCompilationResultsResponse;
import com.google.cloud.dataform.v1beta1.ListReleaseConfigsRequest;
import com.google.cloud.dataform.v1beta1.ListReleaseConfigsResponse;
import com.google.cloud.dataform.v1beta1.ListRepositoriesRequest;
import com.google.cloud.dataform.v1beta1.ListRepositoriesResponse;
import com.google.cloud.dataform.v1beta1.ListWorkflowConfigsRequest;
import com.google.cloud.dataform.v1beta1.ListWorkflowConfigsResponse;
import com.google.cloud.dataform.v1beta1.ListWorkflowInvocationsRequest;
import com.google.cloud.dataform.v1beta1.ListWorkflowInvocationsResponse;
import com.google.cloud.dataform.v1beta1.ListWorkspacesRequest;
import com.google.cloud.dataform.v1beta1.ListWorkspacesResponse;
import com.google.cloud.dataform.v1beta1.LocationName;
import com.google.cloud.dataform.v1beta1.MakeDirectoryRequest;
import com.google.cloud.dataform.v1beta1.MakeDirectoryResponse;
import com.google.cloud.dataform.v1beta1.MoveDirectoryRequest;
import com.google.cloud.dataform.v1beta1.MoveDirectoryResponse;
import com.google.cloud.dataform.v1beta1.MoveFileRequest;
import com.google.cloud.dataform.v1beta1.MoveFileResponse;
import com.google.cloud.dataform.v1beta1.PullGitCommitsRequest;
import com.google.cloud.dataform.v1beta1.PushGitCommitsRequest;
import com.google.cloud.dataform.v1beta1.QueryCompilationResultActionsRequest;
import com.google.cloud.dataform.v1beta1.QueryCompilationResultActionsResponse;
import com.google.cloud.dataform.v1beta1.QueryDirectoryContentsRequest;
import com.google.cloud.dataform.v1beta1.QueryDirectoryContentsResponse;
import com.google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsRequest;
import com.google.cloud.dataform.v1beta1.QueryRepositoryDirectoryContentsResponse;
import com.google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsRequest;
import com.google.cloud.dataform.v1beta1.QueryWorkflowInvocationActionsResponse;
import com.google.cloud.dataform.v1beta1.ReadFileRequest;
import com.google.cloud.dataform.v1beta1.ReadFileResponse;
import com.google.cloud.dataform.v1beta1.ReadRepositoryFileRequest;
import com.google.cloud.dataform.v1beta1.ReadRepositoryFileResponse;
import com.google.cloud.dataform.v1beta1.ReleaseConfig;
import com.google.cloud.dataform.v1beta1.ReleaseConfigName;
import com.google.cloud.dataform.v1beta1.RemoveDirectoryRequest;
import com.google.cloud.dataform.v1beta1.RemoveFileRequest;
import com.google.cloud.dataform.v1beta1.Repository;
import com.google.cloud.dataform.v1beta1.RepositoryName;
import com.google.cloud.dataform.v1beta1.ResetWorkspaceChangesRequest;
import com.google.cloud.dataform.v1beta1.UpdateReleaseConfigRequest;
import com.google.cloud.dataform.v1beta1.UpdateRepositoryRequest;
import com.google.cloud.dataform.v1beta1.UpdateWorkflowConfigRequest;
import com.google.cloud.dataform.v1beta1.WorkflowConfig;
import com.google.cloud.dataform.v1beta1.WorkflowConfigName;
import com.google.cloud.dataform.v1beta1.WorkflowInvocation;
import com.google.cloud.dataform.v1beta1.WorkflowInvocationAction;
import com.google.cloud.dataform.v1beta1.WorkflowInvocationName;
import com.google.cloud.dataform.v1beta1.Workspace;
import com.google.cloud.dataform.v1beta1.WorkspaceName;
import com.google.cloud.dataform.v1beta1.WriteFileRequest;
import com.google.cloud.dataform.v1beta1.WriteFileResponse;
import com.google.cloud.dataform.v1beta1.stub.DataformStub;
import com.google.cloud.dataform.v1beta1.stub.DataformStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataformClient
implements BackgroundResource {
    private final DataformSettings settings;
    private final DataformStub stub;

    public static final DataformClient create() throws IOException {
        return DataformClient.create(DataformSettings.newBuilder().build());
    }

    public static final DataformClient create(DataformSettings settings) throws IOException {
        return new DataformClient(settings);
    }

    public static final DataformClient create(DataformStub stub) {
        return new DataformClient(stub);
    }

    protected DataformClient(DataformSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataformStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataformClient(DataformStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataformSettings getSettings() {
        return this.settings;
    }

    public DataformStub getStub() {
        return this.stub;
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final Repository createRepository(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepository(request);
    }

    public final Repository createRepository(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepository(request);
    }

    public final Repository createRepository(CreateRepositoryRequest request) {
        return (Repository)this.createRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRepositoryRequest, Repository> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final Repository updateRepository(Repository repository, FieldMask updateMask) {
        UpdateRepositoryRequest request = UpdateRepositoryRequest.newBuilder().setRepository(repository).setUpdateMask(updateMask).build();
        return this.updateRepository(request);
    }

    public final Repository updateRepository(UpdateRepositoryRequest request) {
        return (Repository)this.updateRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRepositoryRequest, Repository> updateRepositoryCallable() {
        return this.stub.updateRepositoryCallable();
    }

    public final void deleteRepository(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRepository(request);
    }

    public final void deleteRepository(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        this.deleteRepository(request);
    }

    public final void deleteRepository(DeleteRepositoryRequest request) {
        this.deleteRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRepositoryRequest, Empty> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final void commitRepositoryChanges(CommitRepositoryChangesRequest request) {
        this.commitRepositoryChangesCallable().call((Object)request);
    }

    public final UnaryCallable<CommitRepositoryChangesRequest, Empty> commitRepositoryChangesCallable() {
        return this.stub.commitRepositoryChangesCallable();
    }

    public final ReadRepositoryFileResponse readRepositoryFile(ReadRepositoryFileRequest request) {
        return (ReadRepositoryFileResponse)this.readRepositoryFileCallable().call((Object)request);
    }

    public final UnaryCallable<ReadRepositoryFileRequest, ReadRepositoryFileResponse> readRepositoryFileCallable() {
        return this.stub.readRepositoryFileCallable();
    }

    public final QueryRepositoryDirectoryContentsPagedResponse queryRepositoryDirectoryContents(QueryRepositoryDirectoryContentsRequest request) {
        return (QueryRepositoryDirectoryContentsPagedResponse)((Object)this.queryRepositoryDirectoryContentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsPagedResponse> queryRepositoryDirectoryContentsPagedCallable() {
        return this.stub.queryRepositoryDirectoryContentsPagedCallable();
    }

    public final UnaryCallable<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse> queryRepositoryDirectoryContentsCallable() {
        return this.stub.queryRepositoryDirectoryContentsCallable();
    }

    public final FetchRepositoryHistoryPagedResponse fetchRepositoryHistory(FetchRepositoryHistoryRequest request) {
        return (FetchRepositoryHistoryPagedResponse)((Object)this.fetchRepositoryHistoryPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchRepositoryHistoryRequest, FetchRepositoryHistoryPagedResponse> fetchRepositoryHistoryPagedCallable() {
        return this.stub.fetchRepositoryHistoryPagedCallable();
    }

    public final UnaryCallable<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse> fetchRepositoryHistoryCallable() {
        return this.stub.fetchRepositoryHistoryCallable();
    }

    public final ComputeRepositoryAccessTokenStatusResponse computeRepositoryAccessTokenStatus(ComputeRepositoryAccessTokenStatusRequest request) {
        return (ComputeRepositoryAccessTokenStatusResponse)this.computeRepositoryAccessTokenStatusCallable().call((Object)request);
    }

    public final UnaryCallable<ComputeRepositoryAccessTokenStatusRequest, ComputeRepositoryAccessTokenStatusResponse> computeRepositoryAccessTokenStatusCallable() {
        return this.stub.computeRepositoryAccessTokenStatusCallable();
    }

    public final FetchRemoteBranchesResponse fetchRemoteBranches(FetchRemoteBranchesRequest request) {
        return (FetchRemoteBranchesResponse)this.fetchRemoteBranchesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchRemoteBranchesRequest, FetchRemoteBranchesResponse> fetchRemoteBranchesCallable() {
        return this.stub.fetchRemoteBranchesCallable();
    }

    public final ListWorkspacesPagedResponse listWorkspaces(RepositoryName parent) {
        ListWorkspacesRequest request = ListWorkspacesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkspaces(request);
    }

    public final ListWorkspacesPagedResponse listWorkspaces(String parent) {
        ListWorkspacesRequest request = ListWorkspacesRequest.newBuilder().setParent(parent).build();
        return this.listWorkspaces(request);
    }

    public final ListWorkspacesPagedResponse listWorkspaces(ListWorkspacesRequest request) {
        return (ListWorkspacesPagedResponse)((Object)this.listWorkspacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesPagedResponse> listWorkspacesPagedCallable() {
        return this.stub.listWorkspacesPagedCallable();
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesResponse> listWorkspacesCallable() {
        return this.stub.listWorkspacesCallable();
    }

    public final Workspace getWorkspace(WorkspaceName name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(String name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(GetWorkspaceRequest request) {
        return (Workspace)this.getWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkspaceRequest, Workspace> getWorkspaceCallable() {
        return this.stub.getWorkspaceCallable();
    }

    public final Workspace createWorkspace(RepositoryName parent, Workspace workspace, String workspaceId) {
        CreateWorkspaceRequest request = CreateWorkspaceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkspace(workspace).setWorkspaceId(workspaceId).build();
        return this.createWorkspace(request);
    }

    public final Workspace createWorkspace(String parent, Workspace workspace, String workspaceId) {
        CreateWorkspaceRequest request = CreateWorkspaceRequest.newBuilder().setParent(parent).setWorkspace(workspace).setWorkspaceId(workspaceId).build();
        return this.createWorkspace(request);
    }

    public final Workspace createWorkspace(CreateWorkspaceRequest request) {
        return (Workspace)this.createWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkspaceRequest, Workspace> createWorkspaceCallable() {
        return this.stub.createWorkspaceCallable();
    }

    public final void deleteWorkspace(WorkspaceName name) {
        DeleteWorkspaceRequest request = DeleteWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkspace(request);
    }

    public final void deleteWorkspace(String name) {
        DeleteWorkspaceRequest request = DeleteWorkspaceRequest.newBuilder().setName(name).build();
        this.deleteWorkspace(request);
    }

    public final void deleteWorkspace(DeleteWorkspaceRequest request) {
        this.deleteWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkspaceRequest, Empty> deleteWorkspaceCallable() {
        return this.stub.deleteWorkspaceCallable();
    }

    public final InstallNpmPackagesResponse installNpmPackages(InstallNpmPackagesRequest request) {
        return (InstallNpmPackagesResponse)this.installNpmPackagesCallable().call((Object)request);
    }

    public final UnaryCallable<InstallNpmPackagesRequest, InstallNpmPackagesResponse> installNpmPackagesCallable() {
        return this.stub.installNpmPackagesCallable();
    }

    public final void pullGitCommits(PullGitCommitsRequest request) {
        this.pullGitCommitsCallable().call((Object)request);
    }

    public final UnaryCallable<PullGitCommitsRequest, Empty> pullGitCommitsCallable() {
        return this.stub.pullGitCommitsCallable();
    }

    public final void pushGitCommits(PushGitCommitsRequest request) {
        this.pushGitCommitsCallable().call((Object)request);
    }

    public final UnaryCallable<PushGitCommitsRequest, Empty> pushGitCommitsCallable() {
        return this.stub.pushGitCommitsCallable();
    }

    public final FetchFileGitStatusesResponse fetchFileGitStatuses(FetchFileGitStatusesRequest request) {
        return (FetchFileGitStatusesResponse)this.fetchFileGitStatusesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchFileGitStatusesRequest, FetchFileGitStatusesResponse> fetchFileGitStatusesCallable() {
        return this.stub.fetchFileGitStatusesCallable();
    }

    public final FetchGitAheadBehindResponse fetchGitAheadBehind(FetchGitAheadBehindRequest request) {
        return (FetchGitAheadBehindResponse)this.fetchGitAheadBehindCallable().call((Object)request);
    }

    public final UnaryCallable<FetchGitAheadBehindRequest, FetchGitAheadBehindResponse> fetchGitAheadBehindCallable() {
        return this.stub.fetchGitAheadBehindCallable();
    }

    public final void commitWorkspaceChanges(CommitWorkspaceChangesRequest request) {
        this.commitWorkspaceChangesCallable().call((Object)request);
    }

    public final UnaryCallable<CommitWorkspaceChangesRequest, Empty> commitWorkspaceChangesCallable() {
        return this.stub.commitWorkspaceChangesCallable();
    }

    public final void resetWorkspaceChanges(ResetWorkspaceChangesRequest request) {
        this.resetWorkspaceChangesCallable().call((Object)request);
    }

    public final UnaryCallable<ResetWorkspaceChangesRequest, Empty> resetWorkspaceChangesCallable() {
        return this.stub.resetWorkspaceChangesCallable();
    }

    public final FetchFileDiffResponse fetchFileDiff(FetchFileDiffRequest request) {
        return (FetchFileDiffResponse)this.fetchFileDiffCallable().call((Object)request);
    }

    public final UnaryCallable<FetchFileDiffRequest, FetchFileDiffResponse> fetchFileDiffCallable() {
        return this.stub.fetchFileDiffCallable();
    }

    public final QueryDirectoryContentsPagedResponse queryDirectoryContents(QueryDirectoryContentsRequest request) {
        return (QueryDirectoryContentsPagedResponse)((Object)this.queryDirectoryContentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryDirectoryContentsRequest, QueryDirectoryContentsPagedResponse> queryDirectoryContentsPagedCallable() {
        return this.stub.queryDirectoryContentsPagedCallable();
    }

    public final UnaryCallable<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse> queryDirectoryContentsCallable() {
        return this.stub.queryDirectoryContentsCallable();
    }

    public final MakeDirectoryResponse makeDirectory(MakeDirectoryRequest request) {
        return (MakeDirectoryResponse)this.makeDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<MakeDirectoryRequest, MakeDirectoryResponse> makeDirectoryCallable() {
        return this.stub.makeDirectoryCallable();
    }

    public final void removeDirectory(RemoveDirectoryRequest request) {
        this.removeDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveDirectoryRequest, Empty> removeDirectoryCallable() {
        return this.stub.removeDirectoryCallable();
    }

    public final MoveDirectoryResponse moveDirectory(MoveDirectoryRequest request) {
        return (MoveDirectoryResponse)this.moveDirectoryCallable().call((Object)request);
    }

    public final UnaryCallable<MoveDirectoryRequest, MoveDirectoryResponse> moveDirectoryCallable() {
        return this.stub.moveDirectoryCallable();
    }

    public final ReadFileResponse readFile(ReadFileRequest request) {
        return (ReadFileResponse)this.readFileCallable().call((Object)request);
    }

    public final UnaryCallable<ReadFileRequest, ReadFileResponse> readFileCallable() {
        return this.stub.readFileCallable();
    }

    public final void removeFile(RemoveFileRequest request) {
        this.removeFileCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveFileRequest, Empty> removeFileCallable() {
        return this.stub.removeFileCallable();
    }

    public final MoveFileResponse moveFile(MoveFileRequest request) {
        return (MoveFileResponse)this.moveFileCallable().call((Object)request);
    }

    public final UnaryCallable<MoveFileRequest, MoveFileResponse> moveFileCallable() {
        return this.stub.moveFileCallable();
    }

    public final WriteFileResponse writeFile(WriteFileRequest request) {
        return (WriteFileResponse)this.writeFileCallable().call((Object)request);
    }

    public final UnaryCallable<WriteFileRequest, WriteFileResponse> writeFileCallable() {
        return this.stub.writeFileCallable();
    }

    public final ListReleaseConfigsPagedResponse listReleaseConfigs(RepositoryName parent) {
        ListReleaseConfigsRequest request = ListReleaseConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReleaseConfigs(request);
    }

    public final ListReleaseConfigsPagedResponse listReleaseConfigs(String parent) {
        ListReleaseConfigsRequest request = ListReleaseConfigsRequest.newBuilder().setParent(parent).build();
        return this.listReleaseConfigs(request);
    }

    public final ListReleaseConfigsPagedResponse listReleaseConfigs(ListReleaseConfigsRequest request) {
        return (ListReleaseConfigsPagedResponse)((Object)this.listReleaseConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReleaseConfigsRequest, ListReleaseConfigsPagedResponse> listReleaseConfigsPagedCallable() {
        return this.stub.listReleaseConfigsPagedCallable();
    }

    public final UnaryCallable<ListReleaseConfigsRequest, ListReleaseConfigsResponse> listReleaseConfigsCallable() {
        return this.stub.listReleaseConfigsCallable();
    }

    public final ReleaseConfig getReleaseConfig(ReleaseConfigName name) {
        GetReleaseConfigRequest request = GetReleaseConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReleaseConfig(request);
    }

    public final ReleaseConfig getReleaseConfig(String name) {
        GetReleaseConfigRequest request = GetReleaseConfigRequest.newBuilder().setName(name).build();
        return this.getReleaseConfig(request);
    }

    public final ReleaseConfig getReleaseConfig(GetReleaseConfigRequest request) {
        return (ReleaseConfig)this.getReleaseConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetReleaseConfigRequest, ReleaseConfig> getReleaseConfigCallable() {
        return this.stub.getReleaseConfigCallable();
    }

    public final ReleaseConfig createReleaseConfig(RepositoryName parent, ReleaseConfig releaseConfig, String releaseConfigId) {
        CreateReleaseConfigRequest request = CreateReleaseConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReleaseConfig(releaseConfig).setReleaseConfigId(releaseConfigId).build();
        return this.createReleaseConfig(request);
    }

    public final ReleaseConfig createReleaseConfig(String parent, ReleaseConfig releaseConfig, String releaseConfigId) {
        CreateReleaseConfigRequest request = CreateReleaseConfigRequest.newBuilder().setParent(parent).setReleaseConfig(releaseConfig).setReleaseConfigId(releaseConfigId).build();
        return this.createReleaseConfig(request);
    }

    public final ReleaseConfig createReleaseConfig(CreateReleaseConfigRequest request) {
        return (ReleaseConfig)this.createReleaseConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReleaseConfigRequest, ReleaseConfig> createReleaseConfigCallable() {
        return this.stub.createReleaseConfigCallable();
    }

    public final ReleaseConfig updateReleaseConfig(ReleaseConfig releaseConfig, FieldMask updateMask) {
        UpdateReleaseConfigRequest request = UpdateReleaseConfigRequest.newBuilder().setReleaseConfig(releaseConfig).setUpdateMask(updateMask).build();
        return this.updateReleaseConfig(request);
    }

    public final ReleaseConfig updateReleaseConfig(UpdateReleaseConfigRequest request) {
        return (ReleaseConfig)this.updateReleaseConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateReleaseConfigRequest, ReleaseConfig> updateReleaseConfigCallable() {
        return this.stub.updateReleaseConfigCallable();
    }

    public final void deleteReleaseConfig(ReleaseConfigName name) {
        DeleteReleaseConfigRequest request = DeleteReleaseConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteReleaseConfig(request);
    }

    public final void deleteReleaseConfig(String name) {
        DeleteReleaseConfigRequest request = DeleteReleaseConfigRequest.newBuilder().setName(name).build();
        this.deleteReleaseConfig(request);
    }

    public final void deleteReleaseConfig(DeleteReleaseConfigRequest request) {
        this.deleteReleaseConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReleaseConfigRequest, Empty> deleteReleaseConfigCallable() {
        return this.stub.deleteReleaseConfigCallable();
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(RepositoryName parent) {
        ListCompilationResultsRequest request = ListCompilationResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCompilationResults(request);
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(String parent) {
        ListCompilationResultsRequest request = ListCompilationResultsRequest.newBuilder().setParent(parent).build();
        return this.listCompilationResults(request);
    }

    public final ListCompilationResultsPagedResponse listCompilationResults(ListCompilationResultsRequest request) {
        return (ListCompilationResultsPagedResponse)((Object)this.listCompilationResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCompilationResultsRequest, ListCompilationResultsPagedResponse> listCompilationResultsPagedCallable() {
        return this.stub.listCompilationResultsPagedCallable();
    }

    public final UnaryCallable<ListCompilationResultsRequest, ListCompilationResultsResponse> listCompilationResultsCallable() {
        return this.stub.listCompilationResultsCallable();
    }

    public final CompilationResult getCompilationResult(CompilationResultName name) {
        GetCompilationResultRequest request = GetCompilationResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCompilationResult(request);
    }

    public final CompilationResult getCompilationResult(String name) {
        GetCompilationResultRequest request = GetCompilationResultRequest.newBuilder().setName(name).build();
        return this.getCompilationResult(request);
    }

    public final CompilationResult getCompilationResult(GetCompilationResultRequest request) {
        return (CompilationResult)this.getCompilationResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetCompilationResultRequest, CompilationResult> getCompilationResultCallable() {
        return this.stub.getCompilationResultCallable();
    }

    public final CompilationResult createCompilationResult(RepositoryName parent, CompilationResult compilationResult) {
        CreateCompilationResultRequest request = CreateCompilationResultRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCompilationResult(compilationResult).build();
        return this.createCompilationResult(request);
    }

    public final CompilationResult createCompilationResult(String parent, CompilationResult compilationResult) {
        CreateCompilationResultRequest request = CreateCompilationResultRequest.newBuilder().setParent(parent).setCompilationResult(compilationResult).build();
        return this.createCompilationResult(request);
    }

    public final CompilationResult createCompilationResult(CreateCompilationResultRequest request) {
        return (CompilationResult)this.createCompilationResultCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCompilationResultRequest, CompilationResult> createCompilationResultCallable() {
        return this.stub.createCompilationResultCallable();
    }

    public final QueryCompilationResultActionsPagedResponse queryCompilationResultActions(QueryCompilationResultActionsRequest request) {
        return (QueryCompilationResultActionsPagedResponse)((Object)this.queryCompilationResultActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryCompilationResultActionsRequest, QueryCompilationResultActionsPagedResponse> queryCompilationResultActionsPagedCallable() {
        return this.stub.queryCompilationResultActionsPagedCallable();
    }

    public final UnaryCallable<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse> queryCompilationResultActionsCallable() {
        return this.stub.queryCompilationResultActionsCallable();
    }

    public final ListWorkflowConfigsPagedResponse listWorkflowConfigs(RepositoryName parent) {
        ListWorkflowConfigsRequest request = ListWorkflowConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkflowConfigs(request);
    }

    public final ListWorkflowConfigsPagedResponse listWorkflowConfigs(String parent) {
        ListWorkflowConfigsRequest request = ListWorkflowConfigsRequest.newBuilder().setParent(parent).build();
        return this.listWorkflowConfigs(request);
    }

    public final ListWorkflowConfigsPagedResponse listWorkflowConfigs(ListWorkflowConfigsRequest request) {
        return (ListWorkflowConfigsPagedResponse)((Object)this.listWorkflowConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkflowConfigsRequest, ListWorkflowConfigsPagedResponse> listWorkflowConfigsPagedCallable() {
        return this.stub.listWorkflowConfigsPagedCallable();
    }

    public final UnaryCallable<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse> listWorkflowConfigsCallable() {
        return this.stub.listWorkflowConfigsCallable();
    }

    public final WorkflowConfig getWorkflowConfig(WorkflowConfigName name) {
        GetWorkflowConfigRequest request = GetWorkflowConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkflowConfig(request);
    }

    public final WorkflowConfig getWorkflowConfig(String name) {
        GetWorkflowConfigRequest request = GetWorkflowConfigRequest.newBuilder().setName(name).build();
        return this.getWorkflowConfig(request);
    }

    public final WorkflowConfig getWorkflowConfig(GetWorkflowConfigRequest request) {
        return (WorkflowConfig)this.getWorkflowConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkflowConfigRequest, WorkflowConfig> getWorkflowConfigCallable() {
        return this.stub.getWorkflowConfigCallable();
    }

    public final WorkflowConfig createWorkflowConfig(RepositoryName parent, WorkflowConfig workflowConfig, String workflowConfigId) {
        CreateWorkflowConfigRequest request = CreateWorkflowConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkflowConfig(workflowConfig).setWorkflowConfigId(workflowConfigId).build();
        return this.createWorkflowConfig(request);
    }

    public final WorkflowConfig createWorkflowConfig(String parent, WorkflowConfig workflowConfig, String workflowConfigId) {
        CreateWorkflowConfigRequest request = CreateWorkflowConfigRequest.newBuilder().setParent(parent).setWorkflowConfig(workflowConfig).setWorkflowConfigId(workflowConfigId).build();
        return this.createWorkflowConfig(request);
    }

    public final WorkflowConfig createWorkflowConfig(CreateWorkflowConfigRequest request) {
        return (WorkflowConfig)this.createWorkflowConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkflowConfigRequest, WorkflowConfig> createWorkflowConfigCallable() {
        return this.stub.createWorkflowConfigCallable();
    }

    public final WorkflowConfig updateWorkflowConfig(WorkflowConfig workflowConfig, FieldMask updateMask) {
        UpdateWorkflowConfigRequest request = UpdateWorkflowConfigRequest.newBuilder().setWorkflowConfig(workflowConfig).setUpdateMask(updateMask).build();
        return this.updateWorkflowConfig(request);
    }

    public final WorkflowConfig updateWorkflowConfig(UpdateWorkflowConfigRequest request) {
        return (WorkflowConfig)this.updateWorkflowConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateWorkflowConfigRequest, WorkflowConfig> updateWorkflowConfigCallable() {
        return this.stub.updateWorkflowConfigCallable();
    }

    public final void deleteWorkflowConfig(WorkflowConfigName name) {
        DeleteWorkflowConfigRequest request = DeleteWorkflowConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkflowConfig(request);
    }

    public final void deleteWorkflowConfig(String name) {
        DeleteWorkflowConfigRequest request = DeleteWorkflowConfigRequest.newBuilder().setName(name).build();
        this.deleteWorkflowConfig(request);
    }

    public final void deleteWorkflowConfig(DeleteWorkflowConfigRequest request) {
        this.deleteWorkflowConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkflowConfigRequest, Empty> deleteWorkflowConfigCallable() {
        return this.stub.deleteWorkflowConfigCallable();
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(RepositoryName parent) {
        ListWorkflowInvocationsRequest request = ListWorkflowInvocationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkflowInvocations(request);
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(String parent) {
        ListWorkflowInvocationsRequest request = ListWorkflowInvocationsRequest.newBuilder().setParent(parent).build();
        return this.listWorkflowInvocations(request);
    }

    public final ListWorkflowInvocationsPagedResponse listWorkflowInvocations(ListWorkflowInvocationsRequest request) {
        return (ListWorkflowInvocationsPagedResponse)((Object)this.listWorkflowInvocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkflowInvocationsRequest, ListWorkflowInvocationsPagedResponse> listWorkflowInvocationsPagedCallable() {
        return this.stub.listWorkflowInvocationsPagedCallable();
    }

    public final UnaryCallable<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse> listWorkflowInvocationsCallable() {
        return this.stub.listWorkflowInvocationsCallable();
    }

    public final WorkflowInvocation getWorkflowInvocation(WorkflowInvocationName name) {
        GetWorkflowInvocationRequest request = GetWorkflowInvocationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkflowInvocation(request);
    }

    public final WorkflowInvocation getWorkflowInvocation(String name) {
        GetWorkflowInvocationRequest request = GetWorkflowInvocationRequest.newBuilder().setName(name).build();
        return this.getWorkflowInvocation(request);
    }

    public final WorkflowInvocation getWorkflowInvocation(GetWorkflowInvocationRequest request) {
        return (WorkflowInvocation)this.getWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkflowInvocationRequest, WorkflowInvocation> getWorkflowInvocationCallable() {
        return this.stub.getWorkflowInvocationCallable();
    }

    public final WorkflowInvocation createWorkflowInvocation(RepositoryName parent, WorkflowInvocation workflowInvocation) {
        CreateWorkflowInvocationRequest request = CreateWorkflowInvocationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkflowInvocation(workflowInvocation).build();
        return this.createWorkflowInvocation(request);
    }

    public final WorkflowInvocation createWorkflowInvocation(String parent, WorkflowInvocation workflowInvocation) {
        CreateWorkflowInvocationRequest request = CreateWorkflowInvocationRequest.newBuilder().setParent(parent).setWorkflowInvocation(workflowInvocation).build();
        return this.createWorkflowInvocation(request);
    }

    public final WorkflowInvocation createWorkflowInvocation(CreateWorkflowInvocationRequest request) {
        return (WorkflowInvocation)this.createWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateWorkflowInvocationRequest, WorkflowInvocation> createWorkflowInvocationCallable() {
        return this.stub.createWorkflowInvocationCallable();
    }

    public final void deleteWorkflowInvocation(WorkflowInvocationName name) {
        DeleteWorkflowInvocationRequest request = DeleteWorkflowInvocationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteWorkflowInvocation(request);
    }

    public final void deleteWorkflowInvocation(String name) {
        DeleteWorkflowInvocationRequest request = DeleteWorkflowInvocationRequest.newBuilder().setName(name).build();
        this.deleteWorkflowInvocation(request);
    }

    public final void deleteWorkflowInvocation(DeleteWorkflowInvocationRequest request) {
        this.deleteWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteWorkflowInvocationRequest, Empty> deleteWorkflowInvocationCallable() {
        return this.stub.deleteWorkflowInvocationCallable();
    }

    public final void cancelWorkflowInvocation(CancelWorkflowInvocationRequest request) {
        this.cancelWorkflowInvocationCallable().call((Object)request);
    }

    public final UnaryCallable<CancelWorkflowInvocationRequest, Empty> cancelWorkflowInvocationCallable() {
        return this.stub.cancelWorkflowInvocationCallable();
    }

    public final QueryWorkflowInvocationActionsPagedResponse queryWorkflowInvocationActions(QueryWorkflowInvocationActionsRequest request) {
        return (QueryWorkflowInvocationActionsPagedResponse)((Object)this.queryWorkflowInvocationActionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsPagedResponse> queryWorkflowInvocationActionsPagedCallable() {
        return this.stub.queryWorkflowInvocationActionsPagedCallable();
    }

    public final UnaryCallable<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse> queryWorkflowInvocationActionsCallable() {
        return this.stub.queryWorkflowInvocationActionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryWorkflowInvocationActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage, QueryWorkflowInvocationActionsFixedSizeCollection> {
        private QueryWorkflowInvocationActionsFixedSizeCollection(List<QueryWorkflowInvocationActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryWorkflowInvocationActionsFixedSizeCollection createEmptyCollection() {
            return new QueryWorkflowInvocationActionsFixedSizeCollection(null, 0);
        }

        protected QueryWorkflowInvocationActionsFixedSizeCollection createCollection(List<QueryWorkflowInvocationActionsPage> pages, int collectionSize) {
            return new QueryWorkflowInvocationActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryWorkflowInvocationActionsPage
    extends AbstractPage<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage> {
        private QueryWorkflowInvocationActionsPage(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, QueryWorkflowInvocationActionsResponse response) {
            super(context, (Object)response);
        }

        private static QueryWorkflowInvocationActionsPage createEmptyPage() {
            return new QueryWorkflowInvocationActionsPage(null, null);
        }

        protected QueryWorkflowInvocationActionsPage createPage(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, QueryWorkflowInvocationActionsResponse response) {
            return new QueryWorkflowInvocationActionsPage(context, response);
        }

        public ApiFuture<QueryWorkflowInvocationActionsPage> createPageAsync(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, ApiFuture<QueryWorkflowInvocationActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryWorkflowInvocationActionsPagedResponse
    extends AbstractPagedListResponse<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction, QueryWorkflowInvocationActionsPage, QueryWorkflowInvocationActionsFixedSizeCollection> {
        public static ApiFuture<QueryWorkflowInvocationActionsPagedResponse> createAsync(PageContext<QueryWorkflowInvocationActionsRequest, QueryWorkflowInvocationActionsResponse, WorkflowInvocationAction> context, ApiFuture<QueryWorkflowInvocationActionsResponse> futureResponse) {
            ApiFuture<QueryWorkflowInvocationActionsPage> futurePage = QueryWorkflowInvocationActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryWorkflowInvocationActionsPagedResponse((QueryWorkflowInvocationActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryWorkflowInvocationActionsPagedResponse(QueryWorkflowInvocationActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryWorkflowInvocationActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkflowInvocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage, ListWorkflowInvocationsFixedSizeCollection> {
        private ListWorkflowInvocationsFixedSizeCollection(List<ListWorkflowInvocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkflowInvocationsFixedSizeCollection createEmptyCollection() {
            return new ListWorkflowInvocationsFixedSizeCollection(null, 0);
        }

        protected ListWorkflowInvocationsFixedSizeCollection createCollection(List<ListWorkflowInvocationsPage> pages, int collectionSize) {
            return new ListWorkflowInvocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkflowInvocationsPage
    extends AbstractPage<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage> {
        private ListWorkflowInvocationsPage(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ListWorkflowInvocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkflowInvocationsPage createEmptyPage() {
            return new ListWorkflowInvocationsPage(null, null);
        }

        protected ListWorkflowInvocationsPage createPage(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ListWorkflowInvocationsResponse response) {
            return new ListWorkflowInvocationsPage(context, response);
        }

        public ApiFuture<ListWorkflowInvocationsPage> createPageAsync(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ApiFuture<ListWorkflowInvocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkflowInvocationsPagedResponse
    extends AbstractPagedListResponse<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation, ListWorkflowInvocationsPage, ListWorkflowInvocationsFixedSizeCollection> {
        public static ApiFuture<ListWorkflowInvocationsPagedResponse> createAsync(PageContext<ListWorkflowInvocationsRequest, ListWorkflowInvocationsResponse, WorkflowInvocation> context, ApiFuture<ListWorkflowInvocationsResponse> futureResponse) {
            ApiFuture<ListWorkflowInvocationsPage> futurePage = ListWorkflowInvocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkflowInvocationsPagedResponse((ListWorkflowInvocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkflowInvocationsPagedResponse(ListWorkflowInvocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkflowInvocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkflowConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig, ListWorkflowConfigsPage, ListWorkflowConfigsFixedSizeCollection> {
        private ListWorkflowConfigsFixedSizeCollection(List<ListWorkflowConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkflowConfigsFixedSizeCollection createEmptyCollection() {
            return new ListWorkflowConfigsFixedSizeCollection(null, 0);
        }

        protected ListWorkflowConfigsFixedSizeCollection createCollection(List<ListWorkflowConfigsPage> pages, int collectionSize) {
            return new ListWorkflowConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkflowConfigsPage
    extends AbstractPage<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig, ListWorkflowConfigsPage> {
        private ListWorkflowConfigsPage(PageContext<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig> context, ListWorkflowConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkflowConfigsPage createEmptyPage() {
            return new ListWorkflowConfigsPage(null, null);
        }

        protected ListWorkflowConfigsPage createPage(PageContext<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig> context, ListWorkflowConfigsResponse response) {
            return new ListWorkflowConfigsPage(context, response);
        }

        public ApiFuture<ListWorkflowConfigsPage> createPageAsync(PageContext<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig> context, ApiFuture<ListWorkflowConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkflowConfigsPagedResponse
    extends AbstractPagedListResponse<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig, ListWorkflowConfigsPage, ListWorkflowConfigsFixedSizeCollection> {
        public static ApiFuture<ListWorkflowConfigsPagedResponse> createAsync(PageContext<ListWorkflowConfigsRequest, ListWorkflowConfigsResponse, WorkflowConfig> context, ApiFuture<ListWorkflowConfigsResponse> futureResponse) {
            ApiFuture<ListWorkflowConfigsPage> futurePage = ListWorkflowConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkflowConfigsPagedResponse((ListWorkflowConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkflowConfigsPagedResponse(ListWorkflowConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkflowConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryCompilationResultActionsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage, QueryCompilationResultActionsFixedSizeCollection> {
        private QueryCompilationResultActionsFixedSizeCollection(List<QueryCompilationResultActionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryCompilationResultActionsFixedSizeCollection createEmptyCollection() {
            return new QueryCompilationResultActionsFixedSizeCollection(null, 0);
        }

        protected QueryCompilationResultActionsFixedSizeCollection createCollection(List<QueryCompilationResultActionsPage> pages, int collectionSize) {
            return new QueryCompilationResultActionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryCompilationResultActionsPage
    extends AbstractPage<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage> {
        private QueryCompilationResultActionsPage(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, QueryCompilationResultActionsResponse response) {
            super(context, (Object)response);
        }

        private static QueryCompilationResultActionsPage createEmptyPage() {
            return new QueryCompilationResultActionsPage(null, null);
        }

        protected QueryCompilationResultActionsPage createPage(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, QueryCompilationResultActionsResponse response) {
            return new QueryCompilationResultActionsPage(context, response);
        }

        public ApiFuture<QueryCompilationResultActionsPage> createPageAsync(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, ApiFuture<QueryCompilationResultActionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryCompilationResultActionsPagedResponse
    extends AbstractPagedListResponse<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction, QueryCompilationResultActionsPage, QueryCompilationResultActionsFixedSizeCollection> {
        public static ApiFuture<QueryCompilationResultActionsPagedResponse> createAsync(PageContext<QueryCompilationResultActionsRequest, QueryCompilationResultActionsResponse, CompilationResultAction> context, ApiFuture<QueryCompilationResultActionsResponse> futureResponse) {
            ApiFuture<QueryCompilationResultActionsPage> futurePage = QueryCompilationResultActionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryCompilationResultActionsPagedResponse((QueryCompilationResultActionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryCompilationResultActionsPagedResponse(QueryCompilationResultActionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryCompilationResultActionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCompilationResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage, ListCompilationResultsFixedSizeCollection> {
        private ListCompilationResultsFixedSizeCollection(List<ListCompilationResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCompilationResultsFixedSizeCollection createEmptyCollection() {
            return new ListCompilationResultsFixedSizeCollection(null, 0);
        }

        protected ListCompilationResultsFixedSizeCollection createCollection(List<ListCompilationResultsPage> pages, int collectionSize) {
            return new ListCompilationResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCompilationResultsPage
    extends AbstractPage<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage> {
        private ListCompilationResultsPage(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ListCompilationResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListCompilationResultsPage createEmptyPage() {
            return new ListCompilationResultsPage(null, null);
        }

        protected ListCompilationResultsPage createPage(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ListCompilationResultsResponse response) {
            return new ListCompilationResultsPage(context, response);
        }

        public ApiFuture<ListCompilationResultsPage> createPageAsync(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ApiFuture<ListCompilationResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCompilationResultsPagedResponse
    extends AbstractPagedListResponse<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult, ListCompilationResultsPage, ListCompilationResultsFixedSizeCollection> {
        public static ApiFuture<ListCompilationResultsPagedResponse> createAsync(PageContext<ListCompilationResultsRequest, ListCompilationResultsResponse, CompilationResult> context, ApiFuture<ListCompilationResultsResponse> futureResponse) {
            ApiFuture<ListCompilationResultsPage> futurePage = ListCompilationResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCompilationResultsPagedResponse((ListCompilationResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCompilationResultsPagedResponse(ListCompilationResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCompilationResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReleaseConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig, ListReleaseConfigsPage, ListReleaseConfigsFixedSizeCollection> {
        private ListReleaseConfigsFixedSizeCollection(List<ListReleaseConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReleaseConfigsFixedSizeCollection createEmptyCollection() {
            return new ListReleaseConfigsFixedSizeCollection(null, 0);
        }

        protected ListReleaseConfigsFixedSizeCollection createCollection(List<ListReleaseConfigsPage> pages, int collectionSize) {
            return new ListReleaseConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReleaseConfigsPage
    extends AbstractPage<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig, ListReleaseConfigsPage> {
        private ListReleaseConfigsPage(PageContext<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig> context, ListReleaseConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListReleaseConfigsPage createEmptyPage() {
            return new ListReleaseConfigsPage(null, null);
        }

        protected ListReleaseConfigsPage createPage(PageContext<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig> context, ListReleaseConfigsResponse response) {
            return new ListReleaseConfigsPage(context, response);
        }

        public ApiFuture<ListReleaseConfigsPage> createPageAsync(PageContext<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig> context, ApiFuture<ListReleaseConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReleaseConfigsPagedResponse
    extends AbstractPagedListResponse<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig, ListReleaseConfigsPage, ListReleaseConfigsFixedSizeCollection> {
        public static ApiFuture<ListReleaseConfigsPagedResponse> createAsync(PageContext<ListReleaseConfigsRequest, ListReleaseConfigsResponse, ReleaseConfig> context, ApiFuture<ListReleaseConfigsResponse> futureResponse) {
            ApiFuture<ListReleaseConfigsPage> futurePage = ListReleaseConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReleaseConfigsPagedResponse((ListReleaseConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReleaseConfigsPagedResponse(ListReleaseConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReleaseConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryDirectoryContentsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry, QueryDirectoryContentsPage, QueryDirectoryContentsFixedSizeCollection> {
        private QueryDirectoryContentsFixedSizeCollection(List<QueryDirectoryContentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryDirectoryContentsFixedSizeCollection createEmptyCollection() {
            return new QueryDirectoryContentsFixedSizeCollection(null, 0);
        }

        protected QueryDirectoryContentsFixedSizeCollection createCollection(List<QueryDirectoryContentsPage> pages, int collectionSize) {
            return new QueryDirectoryContentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryDirectoryContentsPage
    extends AbstractPage<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry, QueryDirectoryContentsPage> {
        private QueryDirectoryContentsPage(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry> context, QueryDirectoryContentsResponse response) {
            super(context, (Object)response);
        }

        private static QueryDirectoryContentsPage createEmptyPage() {
            return new QueryDirectoryContentsPage(null, null);
        }

        protected QueryDirectoryContentsPage createPage(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry> context, QueryDirectoryContentsResponse response) {
            return new QueryDirectoryContentsPage(context, response);
        }

        public ApiFuture<QueryDirectoryContentsPage> createPageAsync(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry> context, ApiFuture<QueryDirectoryContentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryDirectoryContentsPagedResponse
    extends AbstractPagedListResponse<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry, QueryDirectoryContentsPage, QueryDirectoryContentsFixedSizeCollection> {
        public static ApiFuture<QueryDirectoryContentsPagedResponse> createAsync(PageContext<QueryDirectoryContentsRequest, QueryDirectoryContentsResponse, DirectoryEntry> context, ApiFuture<QueryDirectoryContentsResponse> futureResponse) {
            ApiFuture<QueryDirectoryContentsPage> futurePage = QueryDirectoryContentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryDirectoryContentsPagedResponse((QueryDirectoryContentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryDirectoryContentsPagedResponse(QueryDirectoryContentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryDirectoryContentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkspacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        private ListWorkspacesFixedSizeCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkspacesFixedSizeCollection createEmptyCollection() {
            return new ListWorkspacesFixedSizeCollection(null, 0);
        }

        protected ListWorkspacesFixedSizeCollection createCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            return new ListWorkspacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkspacesPage
    extends AbstractPage<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage> {
        private ListWorkspacesPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkspacesPage createEmptyPage() {
            return new ListWorkspacesPage(null, null);
        }

        protected ListWorkspacesPage createPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            return new ListWorkspacesPage(context, response);
        }

        public ApiFuture<ListWorkspacesPage> createPageAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkspacesPagedResponse
    extends AbstractPagedListResponse<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        public static ApiFuture<ListWorkspacesPagedResponse> createAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            ApiFuture<ListWorkspacesPage> futurePage = ListWorkspacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkspacesPagedResponse((ListWorkspacesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkspacesPagedResponse(ListWorkspacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkspacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchRepositoryHistoryFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry, FetchRepositoryHistoryPage, FetchRepositoryHistoryFixedSizeCollection> {
        private FetchRepositoryHistoryFixedSizeCollection(List<FetchRepositoryHistoryPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchRepositoryHistoryFixedSizeCollection createEmptyCollection() {
            return new FetchRepositoryHistoryFixedSizeCollection(null, 0);
        }

        protected FetchRepositoryHistoryFixedSizeCollection createCollection(List<FetchRepositoryHistoryPage> pages, int collectionSize) {
            return new FetchRepositoryHistoryFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchRepositoryHistoryPage
    extends AbstractPage<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry, FetchRepositoryHistoryPage> {
        private FetchRepositoryHistoryPage(PageContext<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry> context, FetchRepositoryHistoryResponse response) {
            super(context, (Object)response);
        }

        private static FetchRepositoryHistoryPage createEmptyPage() {
            return new FetchRepositoryHistoryPage(null, null);
        }

        protected FetchRepositoryHistoryPage createPage(PageContext<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry> context, FetchRepositoryHistoryResponse response) {
            return new FetchRepositoryHistoryPage(context, response);
        }

        public ApiFuture<FetchRepositoryHistoryPage> createPageAsync(PageContext<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry> context, ApiFuture<FetchRepositoryHistoryResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchRepositoryHistoryPagedResponse
    extends AbstractPagedListResponse<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry, FetchRepositoryHistoryPage, FetchRepositoryHistoryFixedSizeCollection> {
        public static ApiFuture<FetchRepositoryHistoryPagedResponse> createAsync(PageContext<FetchRepositoryHistoryRequest, FetchRepositoryHistoryResponse, CommitLogEntry> context, ApiFuture<FetchRepositoryHistoryResponse> futureResponse) {
            ApiFuture<FetchRepositoryHistoryPage> futurePage = FetchRepositoryHistoryPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchRepositoryHistoryPagedResponse((FetchRepositoryHistoryPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchRepositoryHistoryPagedResponse(FetchRepositoryHistoryPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchRepositoryHistoryFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class QueryRepositoryDirectoryContentsFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry, QueryRepositoryDirectoryContentsPage, QueryRepositoryDirectoryContentsFixedSizeCollection> {
        private QueryRepositoryDirectoryContentsFixedSizeCollection(List<QueryRepositoryDirectoryContentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryRepositoryDirectoryContentsFixedSizeCollection createEmptyCollection() {
            return new QueryRepositoryDirectoryContentsFixedSizeCollection(null, 0);
        }

        protected QueryRepositoryDirectoryContentsFixedSizeCollection createCollection(List<QueryRepositoryDirectoryContentsPage> pages, int collectionSize) {
            return new QueryRepositoryDirectoryContentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryRepositoryDirectoryContentsPage
    extends AbstractPage<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry, QueryRepositoryDirectoryContentsPage> {
        private QueryRepositoryDirectoryContentsPage(PageContext<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry> context, QueryRepositoryDirectoryContentsResponse response) {
            super(context, (Object)response);
        }

        private static QueryRepositoryDirectoryContentsPage createEmptyPage() {
            return new QueryRepositoryDirectoryContentsPage(null, null);
        }

        protected QueryRepositoryDirectoryContentsPage createPage(PageContext<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry> context, QueryRepositoryDirectoryContentsResponse response) {
            return new QueryRepositoryDirectoryContentsPage(context, response);
        }

        public ApiFuture<QueryRepositoryDirectoryContentsPage> createPageAsync(PageContext<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry> context, ApiFuture<QueryRepositoryDirectoryContentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryRepositoryDirectoryContentsPagedResponse
    extends AbstractPagedListResponse<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry, QueryRepositoryDirectoryContentsPage, QueryRepositoryDirectoryContentsFixedSizeCollection> {
        public static ApiFuture<QueryRepositoryDirectoryContentsPagedResponse> createAsync(PageContext<QueryRepositoryDirectoryContentsRequest, QueryRepositoryDirectoryContentsResponse, DirectoryEntry> context, ApiFuture<QueryRepositoryDirectoryContentsResponse> futureResponse) {
            ApiFuture<QueryRepositoryDirectoryContentsPage> futurePage = QueryRepositoryDirectoryContentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryRepositoryDirectoryContentsPagedResponse((QueryRepositoryDirectoryContentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private QueryRepositoryDirectoryContentsPagedResponse(QueryRepositoryDirectoryContentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)QueryRepositoryDirectoryContentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

