/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.dataflow.v1beta3.CreateJobFromTemplateRequest;
import com.google.dataflow.v1beta3.GetTemplateRequest;
import com.google.dataflow.v1beta3.GetTemplateResponse;
import com.google.dataflow.v1beta3.Job;
import com.google.dataflow.v1beta3.LaunchTemplateRequest;
import com.google.dataflow.v1beta3.LaunchTemplateResponse;
import com.google.dataflow.v1beta3.stub.HttpJsonTemplatesServiceCallableFactory;
import com.google.dataflow.v1beta3.stub.TemplatesServiceStub;
import com.google.dataflow.v1beta3.stub.TemplatesServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonTemplatesServiceStub
extends TemplatesServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateJobFromTemplateRequest, Job> createJobFromTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.TemplatesService/CreateJobFromTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/templates", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/templates"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearLocation().clearProjectId().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.TemplatesService/LaunchTemplate").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/templates:launch", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/templates:launch"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dynamicTemplate", (Object)request.getDynamicTemplate());
        serializer.putQueryParam(fields, "gcsPath", (Object)request.getGcsPath());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("launchParameters", (Message)request.getLaunchParameters())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LaunchTemplateResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTemplateRequest, GetTemplateResponse> getTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.dataflow.v1beta3.TemplatesService/GetTemplate").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1b3/projects/{projectId}/locations/{location}/templates:get", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "location", (Object)request.getLocation());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1b3/projects/{projectId}/templates:get"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "gcsPath", (Object)request.getGcsPath());
        serializer.putQueryParam(fields, "view", (Object)request.getView());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GetTemplateResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobFromTemplateRequest, Job> createJobFromTemplateCallable;
    private final UnaryCallable<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateCallable;
    private final UnaryCallable<GetTemplateRequest, GetTemplateResponse> getTemplateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTemplatesServiceStub create(TemplatesServiceStubSettings settings) throws IOException {
        return new HttpJsonTemplatesServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTemplatesServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTemplatesServiceStub(TemplatesServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTemplatesServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTemplatesServiceStub(TemplatesServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTemplatesServiceStub(TemplatesServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTemplatesServiceCallableFactory());
    }

    protected HttpJsonTemplatesServiceStub(TemplatesServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createJobFromTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobFromTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings launchTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(launchTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTemplateMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createJobFromTemplateCallable = callableFactory.createUnaryCallable(createJobFromTemplateTransportSettings, settings.createJobFromTemplateSettings(), clientContext);
        this.launchTemplateCallable = callableFactory.createUnaryCallable(launchTemplateTransportSettings, settings.launchTemplateSettings(), clientContext);
        this.getTemplateCallable = callableFactory.createUnaryCallable(getTemplateTransportSettings, settings.getTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobFromTemplateMethodDescriptor);
        methodDescriptors.add(launchTemplateMethodDescriptor);
        methodDescriptors.add(getTemplateMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateJobFromTemplateRequest, Job> createJobFromTemplateCallable() {
        return this.createJobFromTemplateCallable;
    }

    @Override
    public UnaryCallable<LaunchTemplateRequest, LaunchTemplateResponse> launchTemplateCallable() {
        return this.launchTemplateCallable;
    }

    @Override
    public UnaryCallable<GetTemplateRequest, GetTemplateResponse> getTemplateCallable() {
        return this.getTemplateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

