/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataflow.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.dataflow.v1beta3.DeleteSnapshotRequest;
import com.google.dataflow.v1beta3.DeleteSnapshotResponse;
import com.google.dataflow.v1beta3.GetSnapshotRequest;
import com.google.dataflow.v1beta3.ListSnapshotsRequest;
import com.google.dataflow.v1beta3.ListSnapshotsResponse;
import com.google.dataflow.v1beta3.Snapshot;
import com.google.dataflow.v1beta3.stub.GrpcSnapshotsV1Beta3Stub;
import com.google.dataflow.v1beta3.stub.SnapshotsV1Beta3Stub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SnapshotsV1Beta3StubSettings
extends StubSettings<SnapshotsV1Beta3StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/userinfo.email").build();
    private final UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings;
    private final UnaryCallSettings<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotSettings;
    private final UnaryCallSettings<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsSettings;

    public UnaryCallSettings<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
        return this.getSnapshotSettings;
    }

    public UnaryCallSettings<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotSettings() {
        return this.deleteSnapshotSettings;
    }

    public UnaryCallSettings<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsSettings() {
        return this.listSnapshotsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SnapshotsV1Beta3Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSnapshotsV1Beta3Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SnapshotsV1Beta3StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SnapshotsV1Beta3StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SnapshotsV1Beta3StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSnapshotSettings = settingsBuilder.getSnapshotSettings().build();
        this.deleteSnapshotSettings = settingsBuilder.deleteSnapshotSettings().build();
        this.listSnapshotsSettings = settingsBuilder.listSnapshotsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SnapshotsV1Beta3StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings;
        private final UnaryCallSettings.Builder<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotSettings;
        private final UnaryCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSnapshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSnapshotsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSnapshotSettings, this.deleteSnapshotSettings, this.listSnapshotsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SnapshotsV1Beta3StubSettings settings) {
            super((StubSettings)settings);
            this.getSnapshotSettings = settings.getSnapshotSettings.toBuilder();
            this.deleteSnapshotSettings = settings.deleteSnapshotSettings.toBuilder();
            this.listSnapshotsSettings = settings.listSnapshotsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSnapshotSettings, this.deleteSnapshotSettings, this.listSnapshotsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SnapshotsV1Beta3StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SnapshotsV1Beta3StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SnapshotsV1Beta3StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SnapshotsV1Beta3StubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(SnapshotsV1Beta3StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteSnapshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listSnapshotsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSnapshotRequest, Snapshot> getSnapshotSettings() {
            return this.getSnapshotSettings;
        }

        public UnaryCallSettings.Builder<DeleteSnapshotRequest, DeleteSnapshotResponse> deleteSnapshotSettings() {
            return this.deleteSnapshotSettings;
        }

        public UnaryCallSettings.Builder<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsSettings() {
            return this.listSnapshotsSettings;
        }

        public SnapshotsV1Beta3StubSettings build() throws IOException {
            return new SnapshotsV1Beta3StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

