/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datafusion.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datafusion.v1.CreateInstanceRequest;
import com.google.cloud.datafusion.v1.DataFusionSettings;
import com.google.cloud.datafusion.v1.DeleteInstanceRequest;
import com.google.cloud.datafusion.v1.GetInstanceRequest;
import com.google.cloud.datafusion.v1.Instance;
import com.google.cloud.datafusion.v1.ListAvailableVersionsRequest;
import com.google.cloud.datafusion.v1.ListAvailableVersionsResponse;
import com.google.cloud.datafusion.v1.ListInstancesRequest;
import com.google.cloud.datafusion.v1.ListInstancesResponse;
import com.google.cloud.datafusion.v1.OperationMetadata;
import com.google.cloud.datafusion.v1.RestartInstanceRequest;
import com.google.cloud.datafusion.v1.UpdateInstanceRequest;
import com.google.cloud.datafusion.v1.Version;
import com.google.cloud.datafusion.v1.stub.DataFusionStub;
import com.google.cloud.datafusion.v1.stub.DataFusionStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataFusionClient
implements BackgroundResource {
    private final DataFusionSettings settings;
    private final DataFusionStub stub;
    private final OperationsClient operationsClient;

    public static final DataFusionClient create() throws IOException {
        return DataFusionClient.create(DataFusionSettings.newBuilder().build());
    }

    public static final DataFusionClient create(DataFusionSettings settings) throws IOException {
        return new DataFusionClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataFusionClient create(DataFusionStub stub) {
        return new DataFusionClient(stub);
    }

    protected DataFusionClient(DataFusionSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataFusionStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataFusionClient(DataFusionStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataFusionSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataFusionStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAvailableVersionsPagedResponse listAvailableVersions(String parent) {
        ListAvailableVersionsRequest request = ListAvailableVersionsRequest.newBuilder().setParent(parent).build();
        return this.listAvailableVersions(request);
    }

    public final ListAvailableVersionsPagedResponse listAvailableVersions(ListAvailableVersionsRequest request) {
        return (ListAvailableVersionsPagedResponse)((Object)this.listAvailableVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsPagedResponse> listAvailableVersionsPagedCallable() {
        return this.stub.listAvailableVersionsPagedCallable();
    }

    public final UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsCallable() {
        return this.stub.listAvailableVersionsCallable();
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> restartInstanceAsync(RestartInstanceRequest request) {
        return this.restartInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable() {
        return this.stub.restartInstanceOperationCallable();
    }

    public final UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable() {
        return this.stub.restartInstanceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstancesPage, ListInstancesPagedResponse>(){

                public ListInstancesPagedResponse apply(ListInstancesPage input) {
                    return new ListInstancesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAvailableVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version, ListAvailableVersionsPage, ListAvailableVersionsFixedSizeCollection> {
        private ListAvailableVersionsFixedSizeCollection(List<ListAvailableVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAvailableVersionsFixedSizeCollection createEmptyCollection() {
            return new ListAvailableVersionsFixedSizeCollection(null, 0);
        }

        protected ListAvailableVersionsFixedSizeCollection createCollection(List<ListAvailableVersionsPage> pages, int collectionSize) {
            return new ListAvailableVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAvailableVersionsPage
    extends AbstractPage<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version, ListAvailableVersionsPage> {
        private ListAvailableVersionsPage(PageContext<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version> context, ListAvailableVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListAvailableVersionsPage createEmptyPage() {
            return new ListAvailableVersionsPage(null, null);
        }

        protected ListAvailableVersionsPage createPage(PageContext<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version> context, ListAvailableVersionsResponse response) {
            return new ListAvailableVersionsPage(context, response);
        }

        public ApiFuture<ListAvailableVersionsPage> createPageAsync(PageContext<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version> context, ApiFuture<ListAvailableVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAvailableVersionsPagedResponse
    extends AbstractPagedListResponse<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version, ListAvailableVersionsPage, ListAvailableVersionsFixedSizeCollection> {
        public static ApiFuture<ListAvailableVersionsPagedResponse> createAsync(PageContext<ListAvailableVersionsRequest, ListAvailableVersionsResponse, Version> context, ApiFuture<ListAvailableVersionsResponse> futureResponse) {
            ApiFuture<ListAvailableVersionsPage> futurePage = ListAvailableVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAvailableVersionsPage, ListAvailableVersionsPagedResponse>(){

                public ListAvailableVersionsPagedResponse apply(ListAvailableVersionsPage input) {
                    return new ListAvailableVersionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAvailableVersionsPagedResponse(ListAvailableVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAvailableVersionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

