/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.DocumentSchema;
import com.google.cloud.contentwarehouse.v1.DocumentSchemaServiceClient;
import com.google.cloud.contentwarehouse.v1.GetDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.ListDocumentSchemasRequest;
import com.google.cloud.contentwarehouse.v1.ListDocumentSchemasResponse;
import com.google.cloud.contentwarehouse.v1.UpdateDocumentSchemaRequest;
import com.google.cloud.contentwarehouse.v1.stub.DocumentSchemaServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentSchemaServiceStubSettings;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonDocumentSchemaServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonDocumentSchemaServiceStub
extends DocumentSchemaServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateDocumentSchemaRequest, DocumentSchema> createDocumentSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentSchemaService/CreateDocumentSchema").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/documentSchemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("documentSchema", (Message)request.getDocumentSchema(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DocumentSchema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDocumentSchemaRequest, DocumentSchema> updateDocumentSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentSchemaService/UpdateDocumentSchema").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/documentSchemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DocumentSchema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDocumentSchemaRequest, DocumentSchema> getDocumentSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentSchemaService/GetDocumentSchema").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/documentSchemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DocumentSchema.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDocumentSchemaRequest, Empty> deleteDocumentSchemaMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentSchemaService/DeleteDocumentSchema").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/documentSchemas/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDocumentSchemasRequest, ListDocumentSchemasResponse> listDocumentSchemasMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentSchemaService/ListDocumentSchemas").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/documentSchemas", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDocumentSchemasResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDocumentSchemaRequest, DocumentSchema> createDocumentSchemaCallable;
    private final UnaryCallable<UpdateDocumentSchemaRequest, DocumentSchema> updateDocumentSchemaCallable;
    private final UnaryCallable<GetDocumentSchemaRequest, DocumentSchema> getDocumentSchemaCallable;
    private final UnaryCallable<DeleteDocumentSchemaRequest, Empty> deleteDocumentSchemaCallable;
    private final UnaryCallable<ListDocumentSchemasRequest, ListDocumentSchemasResponse> listDocumentSchemasCallable;
    private final UnaryCallable<ListDocumentSchemasRequest, DocumentSchemaServiceClient.ListDocumentSchemasPagedResponse> listDocumentSchemasPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDocumentSchemaServiceStub create(DocumentSchemaServiceStubSettings settings) throws IOException {
        return new HttpJsonDocumentSchemaServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDocumentSchemaServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDocumentSchemaServiceStub(DocumentSchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDocumentSchemaServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDocumentSchemaServiceStub(DocumentSchemaServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDocumentSchemaServiceStub(DocumentSchemaServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDocumentSchemaServiceCallableFactory());
    }

    protected HttpJsonDocumentSchemaServiceStub(DocumentSchemaServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createDocumentSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDocumentSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDocumentSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDocumentSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDocumentSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDocumentSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDocumentSchemaTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDocumentSchemaMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDocumentSchemasTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDocumentSchemasMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createDocumentSchemaCallable = callableFactory.createUnaryCallable(createDocumentSchemaTransportSettings, settings.createDocumentSchemaSettings(), clientContext);
        this.updateDocumentSchemaCallable = callableFactory.createUnaryCallable(updateDocumentSchemaTransportSettings, settings.updateDocumentSchemaSettings(), clientContext);
        this.getDocumentSchemaCallable = callableFactory.createUnaryCallable(getDocumentSchemaTransportSettings, settings.getDocumentSchemaSettings(), clientContext);
        this.deleteDocumentSchemaCallable = callableFactory.createUnaryCallable(deleteDocumentSchemaTransportSettings, settings.deleteDocumentSchemaSettings(), clientContext);
        this.listDocumentSchemasCallable = callableFactory.createUnaryCallable(listDocumentSchemasTransportSettings, settings.listDocumentSchemasSettings(), clientContext);
        this.listDocumentSchemasPagedCallable = callableFactory.createPagedCallable(listDocumentSchemasTransportSettings, settings.listDocumentSchemasSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDocumentSchemaMethodDescriptor);
        methodDescriptors.add(updateDocumentSchemaMethodDescriptor);
        methodDescriptors.add(getDocumentSchemaMethodDescriptor);
        methodDescriptors.add(deleteDocumentSchemaMethodDescriptor);
        methodDescriptors.add(listDocumentSchemasMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateDocumentSchemaRequest, DocumentSchema> createDocumentSchemaCallable() {
        return this.createDocumentSchemaCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentSchemaRequest, DocumentSchema> updateDocumentSchemaCallable() {
        return this.updateDocumentSchemaCallable;
    }

    @Override
    public UnaryCallable<GetDocumentSchemaRequest, DocumentSchema> getDocumentSchemaCallable() {
        return this.getDocumentSchemaCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentSchemaRequest, Empty> deleteDocumentSchemaCallable() {
        return this.deleteDocumentSchemaCallable;
    }

    @Override
    public UnaryCallable<ListDocumentSchemasRequest, ListDocumentSchemasResponse> listDocumentSchemasCallable() {
        return this.listDocumentSchemasCallable;
    }

    @Override
    public UnaryCallable<ListDocumentSchemasRequest, DocumentSchemaServiceClient.ListDocumentSchemasPagedResponse> listDocumentSchemasPagedCallable() {
        return this.listDocumentSchemasPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

