/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.GetRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsResponse;
import com.google.cloud.contentwarehouse.v1.LocationName;
import com.google.cloud.contentwarehouse.v1.RuleSet;
import com.google.cloud.contentwarehouse.v1.RuleSetName;
import com.google.cloud.contentwarehouse.v1.RuleSetServiceSettings;
import com.google.cloud.contentwarehouse.v1.UpdateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RuleSetServiceClient
implements BackgroundResource {
    private final RuleSetServiceSettings settings;
    private final RuleSetServiceStub stub;

    public static final RuleSetServiceClient create() throws IOException {
        return RuleSetServiceClient.create(RuleSetServiceSettings.newBuilder().build());
    }

    public static final RuleSetServiceClient create(RuleSetServiceSettings settings) throws IOException {
        return new RuleSetServiceClient(settings);
    }

    public static final RuleSetServiceClient create(RuleSetServiceStub stub) {
        return new RuleSetServiceClient(stub);
    }

    protected RuleSetServiceClient(RuleSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RuleSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected RuleSetServiceClient(RuleSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RuleSetServiceSettings getSettings() {
        return this.settings;
    }

    public RuleSetServiceStub getStub() {
        return this.stub;
    }

    public final RuleSet createRuleSet(LocationName parent, RuleSet ruleSet) {
        CreateRuleSetRequest request = CreateRuleSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRuleSet(ruleSet).build();
        return this.createRuleSet(request);
    }

    public final RuleSet createRuleSet(String parent, RuleSet ruleSet) {
        CreateRuleSetRequest request = CreateRuleSetRequest.newBuilder().setParent(parent).setRuleSet(ruleSet).build();
        return this.createRuleSet(request);
    }

    public final RuleSet createRuleSet(CreateRuleSetRequest request) {
        return (RuleSet)this.createRuleSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRuleSetRequest, RuleSet> createRuleSetCallable() {
        return this.stub.createRuleSetCallable();
    }

    public final RuleSet getRuleSet(RuleSetName name) {
        GetRuleSetRequest request = GetRuleSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRuleSet(request);
    }

    public final RuleSet getRuleSet(String name) {
        GetRuleSetRequest request = GetRuleSetRequest.newBuilder().setName(name).build();
        return this.getRuleSet(request);
    }

    public final RuleSet getRuleSet(GetRuleSetRequest request) {
        return (RuleSet)this.getRuleSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleSetRequest, RuleSet> getRuleSetCallable() {
        return this.stub.getRuleSetCallable();
    }

    public final RuleSet updateRuleSet(RuleSetName name, RuleSet ruleSet) {
        UpdateRuleSetRequest request = UpdateRuleSetRequest.newBuilder().setName(name == null ? null : name.toString()).setRuleSet(ruleSet).build();
        return this.updateRuleSet(request);
    }

    public final RuleSet updateRuleSet(String name, RuleSet ruleSet) {
        UpdateRuleSetRequest request = UpdateRuleSetRequest.newBuilder().setName(name).setRuleSet(ruleSet).build();
        return this.updateRuleSet(request);
    }

    public final RuleSet updateRuleSet(UpdateRuleSetRequest request) {
        return (RuleSet)this.updateRuleSetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRuleSetRequest, RuleSet> updateRuleSetCallable() {
        return this.stub.updateRuleSetCallable();
    }

    public final void deleteRuleSet(RuleSetName name) {
        DeleteRuleSetRequest request = DeleteRuleSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRuleSet(request);
    }

    public final void deleteRuleSet(String name) {
        DeleteRuleSetRequest request = DeleteRuleSetRequest.newBuilder().setName(name).build();
        this.deleteRuleSet(request);
    }

    public final void deleteRuleSet(DeleteRuleSetRequest request) {
        this.deleteRuleSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRuleSetRequest, Empty> deleteRuleSetCallable() {
        return this.stub.deleteRuleSetCallable();
    }

    public final ListRuleSetsPagedResponse listRuleSets(LocationName parent) {
        ListRuleSetsRequest request = ListRuleSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuleSets(request);
    }

    public final ListRuleSetsPagedResponse listRuleSets(String parent) {
        ListRuleSetsRequest request = ListRuleSetsRequest.newBuilder().setParent(parent).build();
        return this.listRuleSets(request);
    }

    public final ListRuleSetsPagedResponse listRuleSets(ListRuleSetsRequest request) {
        return (ListRuleSetsPagedResponse)((Object)this.listRuleSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRuleSetsRequest, ListRuleSetsPagedResponse> listRuleSetsPagedCallable() {
        return this.stub.listRuleSetsPagedCallable();
    }

    public final UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsCallable() {
        return this.stub.listRuleSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRuleSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet, ListRuleSetsPage, ListRuleSetsFixedSizeCollection> {
        private ListRuleSetsFixedSizeCollection(List<ListRuleSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRuleSetsFixedSizeCollection createEmptyCollection() {
            return new ListRuleSetsFixedSizeCollection(null, 0);
        }

        protected ListRuleSetsFixedSizeCollection createCollection(List<ListRuleSetsPage> pages, int collectionSize) {
            return new ListRuleSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRuleSetsPage
    extends AbstractPage<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet, ListRuleSetsPage> {
        private ListRuleSetsPage(PageContext<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet> context, ListRuleSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListRuleSetsPage createEmptyPage() {
            return new ListRuleSetsPage(null, null);
        }

        protected ListRuleSetsPage createPage(PageContext<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet> context, ListRuleSetsResponse response) {
            return new ListRuleSetsPage(context, response);
        }

        public ApiFuture<ListRuleSetsPage> createPageAsync(PageContext<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet> context, ApiFuture<ListRuleSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRuleSetsPagedResponse
    extends AbstractPagedListResponse<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet, ListRuleSetsPage, ListRuleSetsFixedSizeCollection> {
        public static ApiFuture<ListRuleSetsPagedResponse> createAsync(PageContext<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet> context, ApiFuture<ListRuleSetsResponse> futureResponse) {
            ApiFuture<ListRuleSetsPage> futurePage = ListRuleSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRuleSetsPagedResponse((ListRuleSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRuleSetsPagedResponse(ListRuleSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRuleSetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

