/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DeleteDocumentLinkRequest;
import com.google.cloud.contentwarehouse.v1.DocumentLink;
import com.google.cloud.contentwarehouse.v1.DocumentLinkServiceClient;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedSourcesResponse;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsRequest;
import com.google.cloud.contentwarehouse.v1.ListLinkedTargetsResponse;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.DocumentLinkServiceStubSettings;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonDocumentLinkServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDocumentLinkServiceStub
extends DocumentLinkServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedTargets").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/documents/*}/linkedTargets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLinkedTargetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/ListLinkedSources").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/documents/*}/linkedSources", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLinkedSourcesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/CreateDocumentLink").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/documents/*}/documentLinks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DocumentLink.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.DocumentLinkService/DeleteDocumentLink").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/documents/*/documentLinks/*}:delete", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsCallable;
    private final UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesCallable;
    private final UnaryCallable<ListLinkedSourcesRequest, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesPagedCallable;
    private final UnaryCallable<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkCallable;
    private final UnaryCallable<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDocumentLinkServiceStub create(DocumentLinkServiceStubSettings settings) throws IOException {
        return new HttpJsonDocumentLinkServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDocumentLinkServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDocumentLinkServiceStub(DocumentLinkServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDocumentLinkServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDocumentLinkServiceStub(DocumentLinkServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDocumentLinkServiceStub(DocumentLinkServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDocumentLinkServiceCallableFactory());
    }

    protected HttpJsonDocumentLinkServiceStub(DocumentLinkServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listLinkedTargetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLinkedTargetsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLinkedSourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLinkedSourcesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createDocumentLinkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDocumentLinkMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteDocumentLinkTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDocumentLinkMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listLinkedTargetsCallable = callableFactory.createUnaryCallable(listLinkedTargetsTransportSettings, settings.listLinkedTargetsSettings(), clientContext);
        this.listLinkedSourcesCallable = callableFactory.createUnaryCallable(listLinkedSourcesTransportSettings, settings.listLinkedSourcesSettings(), clientContext);
        this.listLinkedSourcesPagedCallable = callableFactory.createPagedCallable(listLinkedSourcesTransportSettings, settings.listLinkedSourcesSettings(), clientContext);
        this.createDocumentLinkCallable = callableFactory.createUnaryCallable(createDocumentLinkTransportSettings, settings.createDocumentLinkSettings(), clientContext);
        this.deleteDocumentLinkCallable = callableFactory.createUnaryCallable(deleteDocumentLinkTransportSettings, settings.deleteDocumentLinkSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listLinkedTargetsMethodDescriptor);
        methodDescriptors.add(listLinkedSourcesMethodDescriptor);
        methodDescriptors.add(createDocumentLinkMethodDescriptor);
        methodDescriptors.add(deleteDocumentLinkMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListLinkedTargetsRequest, ListLinkedTargetsResponse> listLinkedTargetsCallable() {
        return this.listLinkedTargetsCallable;
    }

    @Override
    public UnaryCallable<ListLinkedSourcesRequest, ListLinkedSourcesResponse> listLinkedSourcesCallable() {
        return this.listLinkedSourcesCallable;
    }

    @Override
    public UnaryCallable<ListLinkedSourcesRequest, DocumentLinkServiceClient.ListLinkedSourcesPagedResponse> listLinkedSourcesPagedCallable() {
        return this.listLinkedSourcesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentLinkRequest, DocumentLink> createDocumentLinkCallable() {
        return this.createDocumentLinkCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentLinkRequest, Empty> deleteDocumentLinkCallable() {
        return this.deleteDocumentLinkCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

