/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.containeranalysis.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.devtools.containeranalysis.v1.ContainerAnalysisSettings;
import com.google.cloud.devtools.containeranalysis.v1.GrafeasUtils;
import com.google.cloud.devtools.containeranalysis.v1.stub.ContainerAnalysisStub;
import com.google.cloud.devtools.containeranalysis.v1.stub.ContainerAnalysisStubSettings;
import com.google.containeranalysis.v1.GetVulnerabilityOccurrencesSummaryRequest;
import com.google.containeranalysis.v1.ProjectName;
import com.google.containeranalysis.v1.VulnerabilityOccurrencesSummary;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import io.grafeas.v1.GrafeasClient;
import io.grafeas.v1.GrafeasSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ContainerAnalysisClient
implements BackgroundResource {
    private final ContainerAnalysisSettings settings;
    private final ContainerAnalysisStub stub;

    public GrafeasClient getGrafeasClient() throws IOException {
        return GrafeasClient.create((GrafeasSettings)GrafeasUtils.transformSettings(this.settings));
    }

    public static final ContainerAnalysisClient create() throws IOException {
        return ContainerAnalysisClient.create(ContainerAnalysisSettings.newBuilder().build());
    }

    public static final ContainerAnalysisClient create(ContainerAnalysisSettings settings) throws IOException {
        return new ContainerAnalysisClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ContainerAnalysisClient create(ContainerAnalysisStub stub) {
        return new ContainerAnalysisClient(stub);
    }

    protected ContainerAnalysisClient(ContainerAnalysisSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContainerAnalysisStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ContainerAnalysisClient(ContainerAnalysisStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContainerAnalysisSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContainerAnalysisStub getStub() {
        return this.stub;
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final VulnerabilityOccurrencesSummary getVulnerabilityOccurrencesSummary(ProjectName parent, String filter) {
        GetVulnerabilityOccurrencesSummaryRequest request = GetVulnerabilityOccurrencesSummaryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFilter(filter).build();
        return this.getVulnerabilityOccurrencesSummary(request);
    }

    public final VulnerabilityOccurrencesSummary getVulnerabilityOccurrencesSummary(String parent, String filter) {
        GetVulnerabilityOccurrencesSummaryRequest request = GetVulnerabilityOccurrencesSummaryRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.getVulnerabilityOccurrencesSummary(request);
    }

    public final VulnerabilityOccurrencesSummary getVulnerabilityOccurrencesSummary(GetVulnerabilityOccurrencesSummaryRequest request) {
        return (VulnerabilityOccurrencesSummary)this.getVulnerabilityOccurrencesSummaryCallable().call((Object)request);
    }

    public final UnaryCallable<GetVulnerabilityOccurrencesSummaryRequest, VulnerabilityOccurrencesSummary> getVulnerabilityOccurrencesSummaryCallable() {
        return this.stub.getVulnerabilityOccurrencesSummaryCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

