/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.confidentialcomputing.v1alpha1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.confidentialcomputing.v1alpha1.Challenge;
import com.google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputingClient;
import com.google.cloud.confidentialcomputing.v1alpha1.CreateChallengeRequest;
import com.google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationRequest;
import com.google.cloud.confidentialcomputing.v1alpha1.VerifyAttestationResponse;
import com.google.cloud.confidentialcomputing.v1alpha1.stub.ConfidentialComputingStub;
import com.google.cloud.confidentialcomputing.v1alpha1.stub.ConfidentialComputingStubSettings;
import com.google.cloud.confidentialcomputing.v1alpha1.stub.GrpcConfidentialComputingCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConfidentialComputingStub
extends ConfidentialComputingStub {
    private static final MethodDescriptor<CreateChallengeRequest, Challenge> createChallengeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/CreateChallenge").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateChallengeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Challenge.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<VerifyAttestationRequest, VerifyAttestationResponse> verifyAttestationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.confidentialcomputing.v1alpha1.ConfidentialComputing/VerifyAttestation").setRequestMarshaller(ProtoUtils.marshaller((Message)VerifyAttestationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)VerifyAttestationResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateChallengeRequest, Challenge> createChallengeCallable;
    private final UnaryCallable<VerifyAttestationRequest, VerifyAttestationResponse> verifyAttestationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConfidentialComputingClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConfidentialComputingStub create(ConfidentialComputingStubSettings settings) throws IOException {
        return new GrpcConfidentialComputingStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConfidentialComputingStub create(ClientContext clientContext) throws IOException {
        return new GrpcConfidentialComputingStub(ConfidentialComputingStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConfidentialComputingStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConfidentialComputingStub(ConfidentialComputingStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConfidentialComputingStub(ConfidentialComputingStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConfidentialComputingCallableFactory());
    }

    protected GrpcConfidentialComputingStub(ConfidentialComputingStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createChallengeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createChallengeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings verifyAttestationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(verifyAttestationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("challenge", String.valueOf(request.getChallenge()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createChallengeCallable = callableFactory.createUnaryCallable(createChallengeTransportSettings, settings.createChallengeSettings(), clientContext);
        this.verifyAttestationCallable = callableFactory.createUnaryCallable(verifyAttestationTransportSettings, settings.verifyAttestationSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateChallengeRequest, Challenge> createChallengeCallable() {
        return this.createChallengeCallable;
    }

    @Override
    public UnaryCallable<VerifyAttestationRequest, VerifyAttestationResponse> verifyAttestationCallable() {
        return this.verifyAttestationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConfidentialComputingClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

