/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.AggregatedListSecurityPoliciesRequest;
import com.google.cloud.compute.v1.DeleteSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetSecurityPolicyRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.InsertSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesAggregatedList;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPoliciesScopedList;
import com.google.cloud.compute.v1.SecurityPoliciesSettings;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.SetLabelsSecurityPolicyRequest;
import com.google.cloud.compute.v1.stub.SecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.SecurityPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecurityPoliciesClient
implements BackgroundResource {
    private final SecurityPoliciesSettings settings;
    private final SecurityPoliciesStub stub;

    public static final SecurityPoliciesClient create() throws IOException {
        return SecurityPoliciesClient.create(SecurityPoliciesSettings.newBuilder().build());
    }

    public static final SecurityPoliciesClient create(SecurityPoliciesSettings settings) throws IOException {
        return new SecurityPoliciesClient(settings);
    }

    public static final SecurityPoliciesClient create(SecurityPoliciesStub stub) {
        return new SecurityPoliciesClient(stub);
    }

    protected SecurityPoliciesClient(SecurityPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected SecurityPoliciesClient(SecurityPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecurityPoliciesSettings getSettings() {
        return this.settings;
    }

    public SecurityPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(String project, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleSecurityPolicyRequest request = AddRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(AddRuleSecurityPolicyRequest request) {
        return this.addRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddRuleSecurityPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.stub.addRuleOperationCallable();
    }

    public final UnaryCallable<AddRuleSecurityPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListSecurityPoliciesRequest request = AggregatedListSecurityPoliciesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListSecurityPoliciesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListSecurityPoliciesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String securityPolicy) {
        DeleteSecurityPolicyRequest request = DeleteSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteSecurityPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSecurityPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteSecurityPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SecurityPolicy get(String project, String securityPolicy) {
        GetSecurityPolicyRequest request = GetSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.get(request);
    }

    public final SecurityPolicy get(GetSecurityPolicyRequest request) {
        return (SecurityPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final SecurityPolicyRule getRule(String project, String securityPolicy) {
        GetRuleSecurityPolicyRequest request = GetRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.getRule(request);
    }

    public final SecurityPolicyRule getRule(GetRuleSecurityPolicyRequest request) {
        return (SecurityPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, SecurityPolicy securityPolicyResource) {
        InsertSecurityPolicyRequest request = InsertSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertSecurityPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertSecurityPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertSecurityPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListSecurityPoliciesRequest request = ListSecurityPoliciesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSecurityPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSecurityPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets(String project) {
        ListPreconfiguredExpressionSetsSecurityPoliciesRequest request = ListPreconfiguredExpressionSetsSecurityPoliciesRequest.newBuilder().setProject(project).build();
        return this.listPreconfiguredExpressionSets(request);
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets(ListPreconfiguredExpressionSetsSecurityPoliciesRequest request) {
        return (SecurityPoliciesListPreconfiguredExpressionSetsResponse)this.listPreconfiguredExpressionSetsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsCallable() {
        return this.stub.listPreconfiguredExpressionSetsCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String securityPolicy, SecurityPolicy securityPolicyResource) {
        PatchSecurityPolicyRequest request = PatchSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchSecurityPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchSecurityPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchSecurityPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(String project, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleSecurityPolicyRequest request = PatchRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(PatchRuleSecurityPolicyRequest request) {
        return this.patchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRuleSecurityPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.stub.patchRuleOperationCallable();
    }

    public final UnaryCallable<PatchRuleSecurityPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(String project, String securityPolicy) {
        RemoveRuleSecurityPolicyRequest request = RemoveRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.removeRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(RemoveRuleSecurityPolicyRequest request) {
        return this.removeRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveRuleSecurityPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.stub.removeRuleOperationCallable();
    }

    public final UnaryCallable<RemoveRuleSecurityPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsSecurityPolicyRequest request = SetLabelsSecurityPolicyRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsSecurityPolicyRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsSecurityPolicyRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsSecurityPolicyRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage> {
        private ListPage(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>> context, SecurityPoliciesAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>> context, SecurityPoliciesAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>> context, ApiFuture<SecurityPoliciesAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>> context, ApiFuture<SecurityPoliciesAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

