/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListResourcePoliciesRequest;
import com.google.cloud.compute.v1.DeleteResourcePolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.GetResourcePolicyRequest;
import com.google.cloud.compute.v1.InsertResourcePolicyRequest;
import com.google.cloud.compute.v1.ListResourcePoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.ResourcePoliciesScopedList;
import com.google.cloud.compute.v1.ResourcePoliciesSettings;
import com.google.cloud.compute.v1.ResourcePolicy;
import com.google.cloud.compute.v1.ResourcePolicyAggregatedList;
import com.google.cloud.compute.v1.ResourcePolicyList;
import com.google.cloud.compute.v1.SetIamPolicyResourcePolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsResourcePolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ResourcePoliciesStub;
import com.google.cloud.compute.v1.stub.ResourcePoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ResourcePoliciesClient
implements BackgroundResource {
    private final ResourcePoliciesSettings settings;
    private final ResourcePoliciesStub stub;

    public static final ResourcePoliciesClient create() throws IOException {
        return ResourcePoliciesClient.create(ResourcePoliciesSettings.newBuilder().build());
    }

    public static final ResourcePoliciesClient create(ResourcePoliciesSettings settings) throws IOException {
        return new ResourcePoliciesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ResourcePoliciesClient create(ResourcePoliciesStub stub) {
        return new ResourcePoliciesClient(stub);
    }

    protected ResourcePoliciesClient(ResourcePoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ResourcePoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ResourcePoliciesClient(ResourcePoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ResourcePoliciesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ResourcePoliciesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListResourcePoliciesRequest request = AggregatedListResourcePoliciesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListResourcePoliciesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListResourcePoliciesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String resourcePolicy) {
        DeleteResourcePolicyRequest request = DeleteResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResourcePolicy(resourcePolicy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteResourcePolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteResourcePolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteResourcePolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ResourcePolicy get(String project, String region, String resourcePolicy) {
        GetResourcePolicyRequest request = GetResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResourcePolicy(resourcePolicy).build();
        return this.get(request);
    }

    public final ResourcePolicy get(GetResourcePolicyRequest request) {
        return (ResourcePolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourcePolicyRequest, ResourcePolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyResourcePolicyRequest request = GetIamPolicyResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyResourcePolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyResourcePolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, ResourcePolicy resourcePolicyResource) {
        InsertResourcePolicyRequest request = InsertResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResourcePolicyResource(resourcePolicyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertResourcePolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertResourcePolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertResourcePolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListResourcePoliciesRequest request = ListResourcePoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListResourcePoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourcePoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListResourcePoliciesRequest, ResourcePolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyResourcePolicyRequest request = SetIamPolicyResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyResourcePolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyResourcePolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsResourcePolicyRequest request = TestIamPermissionsResourcePolicyRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsResourcePolicyRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsResourcePolicyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy, ListPage> {
        private ListPage(PageContext<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy> context, ResourcePolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy> context, ResourcePolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy> context, ApiFuture<ResourcePolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListResourcePoliciesRequest, ResourcePolicyList, ResourcePolicy> context, ApiFuture<ResourcePolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>> context, ResourcePolicyAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>> context, ResourcePolicyAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>> context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListResourcePoliciesRequest, ResourcePolicyAggregatedList, Map.Entry<String, ResourcePoliciesScopedList>> context, ApiFuture<ResourcePolicyAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

