/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.GetGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.GlobalForwardingRulesSettings;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.InsertGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.ListGlobalForwardingRulesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.SetLabelsGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.SetTargetGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.GlobalForwardingRulesStub;
import com.google.cloud.compute.v1.stub.GlobalForwardingRulesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GlobalForwardingRulesClient
implements BackgroundResource {
    private final GlobalForwardingRulesSettings settings;
    private final GlobalForwardingRulesStub stub;

    public static final GlobalForwardingRulesClient create() throws IOException {
        return GlobalForwardingRulesClient.create(GlobalForwardingRulesSettings.newBuilder().build());
    }

    public static final GlobalForwardingRulesClient create(GlobalForwardingRulesSettings settings) throws IOException {
        return new GlobalForwardingRulesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalForwardingRulesClient create(GlobalForwardingRulesStub stub) {
        return new GlobalForwardingRulesClient(stub);
    }

    protected GlobalForwardingRulesClient(GlobalForwardingRulesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalForwardingRulesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalForwardingRulesClient(GlobalForwardingRulesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalForwardingRulesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalForwardingRulesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String forwardingRule) {
        DeleteGlobalForwardingRuleRequest request = DeleteGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteGlobalForwardingRuleRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGlobalForwardingRuleRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteGlobalForwardingRuleRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ForwardingRule get(String project, String forwardingRule) {
        GetGlobalForwardingRuleRequest request = GetGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).build();
        return this.get(request);
    }

    public final ForwardingRule get(GetGlobalForwardingRuleRequest request) {
        return (ForwardingRule)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalForwardingRuleRequest, ForwardingRule> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, ForwardingRule forwardingRuleResource) {
        InsertGlobalForwardingRuleRequest request = InsertGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertGlobalForwardingRuleRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertGlobalForwardingRuleRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertGlobalForwardingRuleRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalForwardingRulesRequest request = ListGlobalForwardingRulesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalForwardingRulesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalForwardingRulesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalForwardingRulesRequest, ForwardingRuleList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String forwardingRule, ForwardingRule forwardingRuleResource) {
        PatchGlobalForwardingRuleRequest request = PatchGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).setForwardingRuleResource(forwardingRuleResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchGlobalForwardingRuleRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchGlobalForwardingRuleRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchGlobalForwardingRuleRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsGlobalForwardingRuleRequest request = SetLabelsGlobalForwardingRuleRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsGlobalForwardingRuleRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsGlobalForwardingRuleRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsGlobalForwardingRuleRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final OperationFuture<Operation, Operation> setTargetAsync(String project, String forwardingRule, TargetReference targetReferenceResource) {
        SetTargetGlobalForwardingRuleRequest request = SetTargetGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTargetAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setTargetAsync(SetTargetGlobalForwardingRuleRequest request) {
        return this.setTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetTargetGlobalForwardingRuleRequest, Operation, Operation> setTargetOperationCallable() {
        return this.stub.setTargetOperationCallable();
    }

    public final UnaryCallable<SetTargetGlobalForwardingRuleRequest, Operation> setTargetCallable() {
        return this.stub.setTargetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage> {
        private ListPage(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

