/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListServiceAttachmentsRequest;
import com.google.cloud.compute.v1.DeleteServiceAttachmentRequest;
import com.google.cloud.compute.v1.GetIamPolicyServiceAttachmentRequest;
import com.google.cloud.compute.v1.GetServiceAttachmentRequest;
import com.google.cloud.compute.v1.InsertServiceAttachmentRequest;
import com.google.cloud.compute.v1.ListServiceAttachmentsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchServiceAttachmentRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.ServiceAttachment;
import com.google.cloud.compute.v1.ServiceAttachmentAggregatedList;
import com.google.cloud.compute.v1.ServiceAttachmentList;
import com.google.cloud.compute.v1.ServiceAttachmentsScopedList;
import com.google.cloud.compute.v1.ServiceAttachmentsSettings;
import com.google.cloud.compute.v1.SetIamPolicyServiceAttachmentRequest;
import com.google.cloud.compute.v1.TestIamPermissionsServiceAttachmentRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ServiceAttachmentsStub;
import com.google.cloud.compute.v1.stub.ServiceAttachmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServiceAttachmentsClient
implements BackgroundResource {
    private final ServiceAttachmentsSettings settings;
    private final ServiceAttachmentsStub stub;

    public static final ServiceAttachmentsClient create() throws IOException {
        return ServiceAttachmentsClient.create(ServiceAttachmentsSettings.newBuilder().build());
    }

    public static final ServiceAttachmentsClient create(ServiceAttachmentsSettings settings) throws IOException {
        return new ServiceAttachmentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ServiceAttachmentsClient create(ServiceAttachmentsStub stub) {
        return new ServiceAttachmentsClient(stub);
    }

    protected ServiceAttachmentsClient(ServiceAttachmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServiceAttachmentsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ServiceAttachmentsClient(ServiceAttachmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ServiceAttachmentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ServiceAttachmentsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListServiceAttachmentsRequest request = AggregatedListServiceAttachmentsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListServiceAttachmentsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListServiceAttachmentsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String serviceAttachment) {
        DeleteServiceAttachmentRequest request = DeleteServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setServiceAttachment(serviceAttachment).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteServiceAttachmentRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceAttachmentRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteServiceAttachmentRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ServiceAttachment get(String project, String region, String serviceAttachment) {
        GetServiceAttachmentRequest request = GetServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setServiceAttachment(serviceAttachment).build();
        return this.get(request);
    }

    public final ServiceAttachment get(GetServiceAttachmentRequest request) {
        return (ServiceAttachment)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceAttachmentRequest, ServiceAttachment> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyServiceAttachmentRequest request = GetIamPolicyServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyServiceAttachmentRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyServiceAttachmentRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, ServiceAttachment serviceAttachmentResource) {
        InsertServiceAttachmentRequest request = InsertServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setServiceAttachmentResource(serviceAttachmentResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertServiceAttachmentRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertServiceAttachmentRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertServiceAttachmentRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListServiceAttachmentsRequest request = ListServiceAttachmentsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListServiceAttachmentsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServiceAttachmentsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListServiceAttachmentsRequest, ServiceAttachmentList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String serviceAttachment, ServiceAttachment serviceAttachmentResource) {
        PatchServiceAttachmentRequest request = PatchServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setServiceAttachment(serviceAttachment).setServiceAttachmentResource(serviceAttachmentResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchServiceAttachmentRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchServiceAttachmentRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchServiceAttachmentRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyServiceAttachmentRequest request = SetIamPolicyServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyServiceAttachmentRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyServiceAttachmentRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsServiceAttachmentRequest request = TestIamPermissionsServiceAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsServiceAttachmentRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsServiceAttachmentRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment, ListPage> {
        private ListPage(PageContext<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment> context, ServiceAttachmentList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment> context, ServiceAttachmentList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment> context, ApiFuture<ServiceAttachmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListServiceAttachmentsRequest, ServiceAttachmentList, ServiceAttachment> context, ApiFuture<ServiceAttachmentList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>> context, ServiceAttachmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>> context, ServiceAttachmentAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>> context, ApiFuture<ServiceAttachmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListServiceAttachmentsRequest, ServiceAttachmentAggregatedList, Map.Entry<String, ServiceAttachmentsScopedList>> context, ApiFuture<ServiceAttachmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

