/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListStoragePoolTypesRequest;
import com.google.cloud.compute.v1.GetStoragePoolTypeRequest;
import com.google.cloud.compute.v1.ListStoragePoolTypesRequest;
import com.google.cloud.compute.v1.StoragePoolType;
import com.google.cloud.compute.v1.StoragePoolTypeAggregatedList;
import com.google.cloud.compute.v1.StoragePoolTypeList;
import com.google.cloud.compute.v1.StoragePoolTypesScopedList;
import com.google.cloud.compute.v1.StoragePoolTypesSettings;
import com.google.cloud.compute.v1.stub.StoragePoolTypesStub;
import com.google.cloud.compute.v1.stub.StoragePoolTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StoragePoolTypesClient
implements BackgroundResource {
    private final StoragePoolTypesSettings settings;
    private final StoragePoolTypesStub stub;

    public static final StoragePoolTypesClient create() throws IOException {
        return StoragePoolTypesClient.create(StoragePoolTypesSettings.newBuilder().build());
    }

    public static final StoragePoolTypesClient create(StoragePoolTypesSettings settings) throws IOException {
        return new StoragePoolTypesClient(settings);
    }

    public static final StoragePoolTypesClient create(StoragePoolTypesStub stub) {
        return new StoragePoolTypesClient(stub);
    }

    protected StoragePoolTypesClient(StoragePoolTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StoragePoolTypesStubSettings)settings.getStubSettings()).createStub();
    }

    protected StoragePoolTypesClient(StoragePoolTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StoragePoolTypesSettings getSettings() {
        return this.settings;
    }

    public StoragePoolTypesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListStoragePoolTypesRequest request = AggregatedListStoragePoolTypesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListStoragePoolTypesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListStoragePoolTypesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final StoragePoolType get(String project, String zone, String storagePoolType) {
        GetStoragePoolTypeRequest request = GetStoragePoolTypeRequest.newBuilder().setProject(project).setZone(zone).setStoragePoolType(storagePoolType).build();
        return this.get(request);
    }

    public final StoragePoolType get(GetStoragePoolTypeRequest request) {
        return (StoragePoolType)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetStoragePoolTypeRequest, StoragePoolType> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListStoragePoolTypesRequest request = ListStoragePoolTypesRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListStoragePoolTypesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStoragePoolTypesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListStoragePoolTypesRequest, StoragePoolTypeList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType, ListPage> {
        private ListPage(PageContext<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType> context, StoragePoolTypeList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType> context, StoragePoolTypeList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType> context, ApiFuture<StoragePoolTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListStoragePoolTypesRequest, StoragePoolTypeList, StoragePoolType> context, ApiFuture<StoragePoolTypeList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>> context, StoragePoolTypeAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>> context, StoragePoolTypeAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>> context, ApiFuture<StoragePoolTypeAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListStoragePoolTypesRequest, StoragePoolTypeAggregatedList, Map.Entry<String, StoragePoolTypesScopedList>> context, ApiFuture<StoragePoolTypeAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

