/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTemplatesRequest;
import com.google.cloud.compute.v1.DeleteNodeTemplateRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeTemplateRequest;
import com.google.cloud.compute.v1.GetNodeTemplateRequest;
import com.google.cloud.compute.v1.InsertNodeTemplateRequest;
import com.google.cloud.compute.v1.ListNodeTemplatesRequest;
import com.google.cloud.compute.v1.NodeTemplate;
import com.google.cloud.compute.v1.NodeTemplateAggregatedList;
import com.google.cloud.compute.v1.NodeTemplateList;
import com.google.cloud.compute.v1.NodeTemplatesScopedList;
import com.google.cloud.compute.v1.NodeTemplatesSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyNodeTemplateRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeTemplateRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NodeTemplatesStub;
import com.google.cloud.compute.v1.stub.NodeTemplatesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NodeTemplatesClient
implements BackgroundResource {
    private final NodeTemplatesSettings settings;
    private final NodeTemplatesStub stub;

    public static final NodeTemplatesClient create() throws IOException {
        return NodeTemplatesClient.create(NodeTemplatesSettings.newBuilder().build());
    }

    public static final NodeTemplatesClient create(NodeTemplatesSettings settings) throws IOException {
        return new NodeTemplatesClient(settings);
    }

    public static final NodeTemplatesClient create(NodeTemplatesStub stub) {
        return new NodeTemplatesClient(stub);
    }

    protected NodeTemplatesClient(NodeTemplatesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NodeTemplatesStubSettings)settings.getStubSettings()).createStub();
    }

    protected NodeTemplatesClient(NodeTemplatesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NodeTemplatesSettings getSettings() {
        return this.settings;
    }

    public NodeTemplatesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNodeTemplatesRequest request = AggregatedListNodeTemplatesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNodeTemplatesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNodeTemplatesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String nodeTemplate) {
        DeleteNodeTemplateRequest request = DeleteNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setNodeTemplate(nodeTemplate).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNodeTemplateRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNodeTemplateRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNodeTemplateRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final NodeTemplate get(String project, String region, String nodeTemplate) {
        GetNodeTemplateRequest request = GetNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setNodeTemplate(nodeTemplate).build();
        return this.get(request);
    }

    public final NodeTemplate get(GetNodeTemplateRequest request) {
        return (NodeTemplate)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeTemplateRequest, NodeTemplate> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyNodeTemplateRequest request = GetIamPolicyNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyNodeTemplateRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyNodeTemplateRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, NodeTemplate nodeTemplateResource) {
        InsertNodeTemplateRequest request = InsertNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setNodeTemplateResource(nodeTemplateResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertNodeTemplateRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNodeTemplateRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNodeTemplateRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListNodeTemplatesRequest request = ListNodeTemplatesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNodeTemplatesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodeTemplatesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNodeTemplatesRequest, NodeTemplateList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyNodeTemplateRequest request = SetIamPolicyNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyNodeTemplateRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyNodeTemplateRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNodeTemplateRequest request = TestIamPermissionsNodeTemplateRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsNodeTemplateRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsNodeTemplateRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate, ListPage> {
        private ListPage(PageContext<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate> context, NodeTemplateList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate> context, NodeTemplateList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate> context, ApiFuture<NodeTemplateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate> context, ApiFuture<NodeTemplateList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>> context, NodeTemplateAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>> context, NodeTemplateAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>> context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>> context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

