/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListStoragePoolsRequest;
import com.google.cloud.compute.v1.DeleteStoragePoolRequest;
import com.google.cloud.compute.v1.GetIamPolicyStoragePoolRequest;
import com.google.cloud.compute.v1.GetStoragePoolRequest;
import com.google.cloud.compute.v1.InsertStoragePoolRequest;
import com.google.cloud.compute.v1.ListDisksStoragePoolsRequest;
import com.google.cloud.compute.v1.ListStoragePoolsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyStoragePoolRequest;
import com.google.cloud.compute.v1.StoragePool;
import com.google.cloud.compute.v1.StoragePoolAggregatedList;
import com.google.cloud.compute.v1.StoragePoolDisk;
import com.google.cloud.compute.v1.StoragePoolList;
import com.google.cloud.compute.v1.StoragePoolListDisks;
import com.google.cloud.compute.v1.StoragePoolsClient;
import com.google.cloud.compute.v1.StoragePoolsScopedList;
import com.google.cloud.compute.v1.TestIamPermissionsStoragePoolRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateStoragePoolRequest;
import com.google.cloud.compute.v1.stub.HttpJsonStoragePoolsStub;
import com.google.cloud.compute.v1.stub.StoragePoolsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class StoragePoolsStubSettings
extends StubSettings<StoragePoolsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteStoragePoolRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteStoragePoolRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetStoragePoolRequest, StoragePool> getSettings;
    private final UnaryCallSettings<GetIamPolicyStoragePoolRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertStoragePoolRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertStoragePoolRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse> listDisksSettings;
    private final UnaryCallSettings<SetIamPolicyStoragePoolRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsStoragePoolRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateStoragePoolRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateStoragePoolRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListStoragePoolsRequest injectToken(AggregatedListStoragePoolsRequest payload, String token) {
            return AggregatedListStoragePoolsRequest.newBuilder((AggregatedListStoragePoolsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListStoragePoolsRequest injectPageSize(AggregatedListStoragePoolsRequest payload, int pageSize) {
            return AggregatedListStoragePoolsRequest.newBuilder((AggregatedListStoragePoolsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListStoragePoolsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(StoragePoolAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, StoragePoolsScopedList>> extractResources(StoragePoolAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListStoragePoolsRequest, StoragePoolList, StoragePool> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListStoragePoolsRequest, StoragePoolList, StoragePool>(){

        public String emptyToken() {
            return "";
        }

        public ListStoragePoolsRequest injectToken(ListStoragePoolsRequest payload, String token) {
            return ListStoragePoolsRequest.newBuilder((ListStoragePoolsRequest)payload).setPageToken(token).build();
        }

        public ListStoragePoolsRequest injectPageSize(ListStoragePoolsRequest payload, int pageSize) {
            return ListStoragePoolsRequest.newBuilder((ListStoragePoolsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListStoragePoolsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(StoragePoolList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StoragePool> extractResources(StoragePoolList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk> LIST_DISKS_PAGE_STR_DESC = new PagedListDescriptor<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk>(){

        public String emptyToken() {
            return "";
        }

        public ListDisksStoragePoolsRequest injectToken(ListDisksStoragePoolsRequest payload, String token) {
            return ListDisksStoragePoolsRequest.newBuilder((ListDisksStoragePoolsRequest)payload).setPageToken(token).build();
        }

        public ListDisksStoragePoolsRequest injectPageSize(ListDisksStoragePoolsRequest payload, int pageSize) {
            return ListDisksStoragePoolsRequest.newBuilder((ListDisksStoragePoolsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDisksStoragePoolsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(StoragePoolListDisks payload) {
            return payload.getNextPageToken();
        }

        public Iterable<StoragePoolDisk> extractResources(StoragePoolListDisks payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse>(){

        public ApiFuture<StoragePoolsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList> callable, AggregatedListStoragePoolsRequest request, ApiCallContext context, ApiFuture<StoragePoolAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StoragePoolsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse>(){

        public ApiFuture<StoragePoolsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListStoragePoolsRequest, StoragePoolList> callable, ListStoragePoolsRequest request, ApiCallContext context, ApiFuture<StoragePoolList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StoragePoolsClient.ListPagedResponse.createAsync((PageContext<ListStoragePoolsRequest, StoragePoolList, StoragePool>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse> LIST_DISKS_PAGE_STR_FACT = new PagedListResponseFactory<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse>(){

        public ApiFuture<StoragePoolsClient.ListDisksPagedResponse> getFuturePagedResponse(UnaryCallable<ListDisksStoragePoolsRequest, StoragePoolListDisks> callable, ListDisksStoragePoolsRequest request, ApiCallContext context, ApiFuture<StoragePoolListDisks> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DISKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StoragePoolsClient.ListDisksPagedResponse.createAsync((PageContext<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteStoragePoolRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteStoragePoolRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetStoragePoolRequest, StoragePool> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyStoragePoolRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertStoragePoolRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertStoragePoolRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse> listDisksSettings() {
        return this.listDisksSettings;
    }

    public UnaryCallSettings<SetIamPolicyStoragePoolRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsStoragePoolRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateStoragePoolRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateStoragePoolRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public StoragePoolsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonStoragePoolsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StoragePoolsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StoragePoolsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StoragePoolsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listDisksSettings = settingsBuilder.listDisksSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StoragePoolsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteStoragePoolRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteStoragePoolRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetStoragePoolRequest, StoragePool> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyStoragePoolRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertStoragePoolRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertStoragePoolRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse> listDisksSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyStoragePoolRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsStoragePoolRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateStoragePoolRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateStoragePoolRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listDisksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DISKS_PAGE_STR_FACT);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listDisksSettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StoragePoolsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listDisksSettings = settings.listDisksSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.listDisksSettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StoragePoolsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StoragePoolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StoragePoolsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StoragePoolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDisksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, StoragePoolsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteStoragePoolRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteStoragePoolRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetStoragePoolRequest, StoragePool> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyStoragePoolRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertStoragePoolRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertStoragePoolRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListStoragePoolsRequest, StoragePoolList, StoragePoolsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolsClient.ListDisksPagedResponse> listDisksSettings() {
            return this.listDisksSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyStoragePoolRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsStoragePoolRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateStoragePoolRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateStoragePoolRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public StoragePoolsStubSettings build() throws IOException {
            return new StoragePoolsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

