/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.AggregatedListSecurityPoliciesRequest;
import com.google.cloud.compute.v1.DeleteSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesAggregatedList;
import com.google.cloud.compute.v1.SecurityPoliciesClient;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPoliciesScopedList;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.SetLabelsSecurityPolicyRequest;
import com.google.cloud.compute.v1.stub.HttpJsonSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.SecurityPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class SecurityPoliciesStubSettings
extends StubSettings<SecurityPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddRuleSecurityPolicyRequest, Operation> addRuleSettings;
    private final OperationCallSettings<AddRuleSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
    private final PagedCallSettings<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteSecurityPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetSecurityPolicyRequest, SecurityPolicy> getSettings;
    private final UnaryCallSettings<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertSecurityPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings;
    private final UnaryCallSettings<PatchSecurityPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchRuleSecurityPolicyRequest, Operation> patchRuleSettings;
    private final OperationCallSettings<PatchRuleSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
    private final UnaryCallSettings<RemoveRuleSecurityPolicyRequest, Operation> removeRuleSettings;
    private final OperationCallSettings<RemoveRuleSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
    private final UnaryCallSettings<SetLabelsSecurityPolicyRequest, Operation> setLabelsSettings;
    private final OperationCallSettings<SetLabelsSecurityPolicyRequest, Operation, Operation> setLabelsOperationSettings;
    private static final PagedListDescriptor<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListSecurityPoliciesRequest injectToken(AggregatedListSecurityPoliciesRequest payload, String token) {
            return AggregatedListSecurityPoliciesRequest.newBuilder((AggregatedListSecurityPoliciesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListSecurityPoliciesRequest injectPageSize(AggregatedListSecurityPoliciesRequest payload, int pageSize) {
            return AggregatedListSecurityPoliciesRequest.newBuilder((AggregatedListSecurityPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListSecurityPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SecurityPoliciesAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, SecurityPoliciesScopedList>> extractResources(SecurityPoliciesAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListSecurityPoliciesRequest injectToken(ListSecurityPoliciesRequest payload, String token) {
            return ListSecurityPoliciesRequest.newBuilder((ListSecurityPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListSecurityPoliciesRequest injectPageSize(ListSecurityPoliciesRequest payload, int pageSize) {
            return ListSecurityPoliciesRequest.newBuilder((ListSecurityPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSecurityPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SecurityPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SecurityPolicy> extractResources(SecurityPolicyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse>(){

        public ApiFuture<SecurityPoliciesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList> callable, AggregatedListSecurityPoliciesRequest request, ApiCallContext context, ApiFuture<SecurityPoliciesAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPoliciesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, Map.Entry<String, SecurityPoliciesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse>(){

        public ApiFuture<SecurityPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListSecurityPoliciesRequest, SecurityPolicyList> callable, ListSecurityPoliciesRequest request, ApiCallContext context, ApiFuture<SecurityPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SecurityPoliciesClient.ListPagedResponse.createAsync((PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddRuleSecurityPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public OperationCallSettings<AddRuleSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
        return this.addRuleOperationSettings;
    }

    public PagedCallSettings<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteSecurityPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetSecurityPolicyRequest, SecurityPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertSecurityPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings() {
        return this.listPreconfiguredExpressionSetsSettings;
    }

    public UnaryCallSettings<PatchSecurityPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchRuleSecurityPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public OperationCallSettings<PatchRuleSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
        return this.patchRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveRuleSecurityPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public OperationCallSettings<RemoveRuleSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
        return this.removeRuleOperationSettings;
    }

    public UnaryCallSettings<SetLabelsSecurityPolicyRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public OperationCallSettings<SetLabelsSecurityPolicyRequest, Operation, Operation> setLabelsOperationSettings() {
        return this.setLabelsOperationSettings;
    }

    public SecurityPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSecurityPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SecurityPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SecurityPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SecurityPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.addRuleOperationSettings = settingsBuilder.addRuleOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listPreconfiguredExpressionSetsSettings = settingsBuilder.listPreconfiguredExpressionSetsSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.patchRuleOperationSettings = settingsBuilder.patchRuleOperationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.removeRuleOperationSettings = settingsBuilder.removeRuleOperationSettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLabelsOperationSettings = settingsBuilder.setLabelsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SecurityPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddRuleSecurityPolicyRequest, Operation> addRuleSettings;
        private final OperationCallSettings.Builder<AddRuleSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteSecurityPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteSecurityPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetSecurityPolicyRequest, SecurityPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertSecurityPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertSecurityPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings;
        private final UnaryCallSettings.Builder<PatchSecurityPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchSecurityPolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchRuleSecurityPolicyRequest, Operation> patchRuleSettings;
        private final OperationCallSettings.Builder<PatchRuleSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleSecurityPolicyRequest, Operation> removeRuleSettings;
        private final OperationCallSettings.Builder<RemoveRuleSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings;
        private final UnaryCallSettings.Builder<SetLabelsSecurityPolicyRequest, Operation> setLabelsSettings;
        private final OperationCallSettings.Builder<SetLabelsSecurityPolicyRequest, Operation, Operation> setLabelsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listPreconfiguredExpressionSetsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleOperationSettings = OperationCallSettings.newBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listPreconfiguredExpressionSetsSettings, this.patchSettings, this.patchRuleSettings, this.removeRuleSettings, this.setLabelsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(SecurityPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.addRuleOperationSettings = settings.addRuleOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listPreconfiguredExpressionSetsSettings = settings.listPreconfiguredExpressionSetsSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.patchRuleOperationSettings = settings.patchRuleOperationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.removeRuleOperationSettings = settings.removeRuleOperationSettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLabelsOperationSettings = settings.setLabelsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addRuleSettings, this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.listPreconfiguredExpressionSetsSettings, this.patchSettings, this.patchRuleSettings, this.removeRuleSettings, this.setLabelsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SecurityPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SecurityPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SecurityPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SecurityPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPreconfiguredExpressionSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddRuleSecurityPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public OperationCallSettings.Builder<AddRuleSecurityPolicyRequest, Operation, Operation> addRuleOperationSettings() {
            return this.addRuleOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListSecurityPoliciesRequest, SecurityPoliciesAggregatedList, SecurityPoliciesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteSecurityPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteSecurityPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSecurityPolicyRequest, SecurityPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertSecurityPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertSecurityPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsSettings() {
            return this.listPreconfiguredExpressionSetsSettings;
        }

        public UnaryCallSettings.Builder<PatchSecurityPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchSecurityPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleSecurityPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public OperationCallSettings.Builder<PatchRuleSecurityPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
            return this.patchRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleSecurityPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public OperationCallSettings.Builder<RemoveRuleSecurityPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
            return this.removeRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<SetLabelsSecurityPolicyRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        public OperationCallSettings.Builder<SetLabelsSecurityPolicyRequest, Operation, Operation> setLabelsOperationSettings() {
            return this.setLabelsOperationSettings;
        }

        public SecurityPoliciesStubSettings build() throws IOException {
            return new SecurityPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

