/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.CreateInstancesRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstancesRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeletePerInstanceConfigsRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.GetRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InsertRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceManagedByIgmError;
import com.google.cloud.compute.v1.ListErrorsRegionInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListManagedInstancesRegionInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListPerInstanceConfigsRegionInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListRegionInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ManagedInstance;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchPerInstanceConfigsRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PatchRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PerInstanceConfig;
import com.google.cloud.compute.v1.RecreateInstancesRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.RegionInstanceGroupManagerList;
import com.google.cloud.compute.v1.RegionInstanceGroupManagersClient;
import com.google.cloud.compute.v1.RegionInstanceGroupManagersListErrorsResponse;
import com.google.cloud.compute.v1.RegionInstanceGroupManagersListInstanceConfigsResp;
import com.google.cloud.compute.v1.RegionInstanceGroupManagersListInstancesResponse;
import com.google.cloud.compute.v1.ResizeRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetTargetPoolsRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.stub.HttpJsonRegionInstanceGroupManagersStub;
import com.google.cloud.compute.v1.stub.RegionInstanceGroupManagersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionInstanceGroupManagersStubSettings
extends StubSettings<RegionInstanceGroupManagersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AbandonInstancesRegionInstanceGroupManagerRequest, Operation> abandonInstancesSettings;
    private final OperationCallSettings<AbandonInstancesRegionInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings;
    private final UnaryCallSettings<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings;
    private final OperationCallSettings<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings;
    private final UnaryCallSettings<CreateInstancesRegionInstanceGroupManagerRequest, Operation> createInstancesSettings;
    private final OperationCallSettings<CreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings;
    private final UnaryCallSettings<DeleteRegionInstanceGroupManagerRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteInstancesRegionInstanceGroupManagerRequest, Operation> deleteInstancesSettings;
    private final OperationCallSettings<DeleteInstancesRegionInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings;
    private final UnaryCallSettings<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings;
    private final OperationCallSettings<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings;
    private final UnaryCallSettings<GetRegionInstanceGroupManagerRequest, InstanceGroupManager> getSettings;
    private final UnaryCallSettings<InsertRegionInstanceGroupManagerRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings;
    private final PagedCallSettings<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings;
    private final PagedCallSettings<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings;
    private final UnaryCallSettings<PatchRegionInstanceGroupManagerRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchRegionInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings;
    private final OperationCallSettings<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings;
    private final UnaryCallSettings<RecreateInstancesRegionInstanceGroupManagerRequest, Operation> recreateInstancesSettings;
    private final OperationCallSettings<RecreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings;
    private final UnaryCallSettings<ResizeRegionInstanceGroupManagerRequest, Operation> resizeSettings;
    private final OperationCallSettings<ResizeRegionInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings;
    private final UnaryCallSettings<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings;
    private final OperationCallSettings<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings;
    private final UnaryCallSettings<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation> setTargetPoolsSettings;
    private final OperationCallSettings<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings;
    private final UnaryCallSettings<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings;
    private final OperationCallSettings<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings;
    private static final PagedListDescriptor<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, InstanceGroupManager> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, InstanceGroupManager>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionInstanceGroupManagersRequest injectToken(ListRegionInstanceGroupManagersRequest payload, String token) {
            return ListRegionInstanceGroupManagersRequest.newBuilder((ListRegionInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListRegionInstanceGroupManagersRequest injectPageSize(ListRegionInstanceGroupManagersRequest payload, int pageSize) {
            return ListRegionInstanceGroupManagersRequest.newBuilder((ListRegionInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupManagerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroupManager> extractResources(RegionInstanceGroupManagerList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> LIST_ERRORS_PAGE_STR_DESC = new PagedListDescriptor<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError>(){

        public String emptyToken() {
            return "";
        }

        public ListErrorsRegionInstanceGroupManagersRequest injectToken(ListErrorsRegionInstanceGroupManagersRequest payload, String token) {
            return ListErrorsRegionInstanceGroupManagersRequest.newBuilder((ListErrorsRegionInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListErrorsRegionInstanceGroupManagersRequest injectPageSize(ListErrorsRegionInstanceGroupManagersRequest payload, int pageSize) {
            return ListErrorsRegionInstanceGroupManagersRequest.newBuilder((ListErrorsRegionInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListErrorsRegionInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupManagersListErrorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceManagedByIgmError> extractResources(RegionInstanceGroupManagersListErrorsResponse payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, ManagedInstance> LIST_MANAGED_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, ManagedInstance>(){

        public String emptyToken() {
            return "";
        }

        public ListManagedInstancesRegionInstanceGroupManagersRequest injectToken(ListManagedInstancesRegionInstanceGroupManagersRequest payload, String token) {
            return ListManagedInstancesRegionInstanceGroupManagersRequest.newBuilder((ListManagedInstancesRegionInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListManagedInstancesRegionInstanceGroupManagersRequest injectPageSize(ListManagedInstancesRegionInstanceGroupManagersRequest payload, int pageSize) {
            return ListManagedInstancesRegionInstanceGroupManagersRequest.newBuilder((ListManagedInstancesRegionInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListManagedInstancesRegionInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupManagersListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ManagedInstance> extractResources(RegionInstanceGroupManagersListInstancesResponse payload) {
            return payload.getManagedInstancesList() == null ? ImmutableList.of() : payload.getManagedInstancesList();
        }
    };
    private static final PagedListDescriptor<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, PerInstanceConfig> LIST_PER_INSTANCE_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, PerInstanceConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListPerInstanceConfigsRegionInstanceGroupManagersRequest injectToken(ListPerInstanceConfigsRegionInstanceGroupManagersRequest payload, String token) {
            return ListPerInstanceConfigsRegionInstanceGroupManagersRequest.newBuilder((ListPerInstanceConfigsRegionInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListPerInstanceConfigsRegionInstanceGroupManagersRequest injectPageSize(ListPerInstanceConfigsRegionInstanceGroupManagersRequest payload, int pageSize) {
            return ListPerInstanceConfigsRegionInstanceGroupManagersRequest.newBuilder((ListPerInstanceConfigsRegionInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPerInstanceConfigsRegionInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(RegionInstanceGroupManagersListInstanceConfigsResp payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PerInstanceConfig> extractResources(RegionInstanceGroupManagersListInstanceConfigsResp payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse>(){

        public ApiFuture<RegionInstanceGroupManagersClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList> callable, ListRegionInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupManagerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupManagersClient.ListPagedResponse.createAsync((PageContext<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, InstanceGroupManager>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse> LIST_ERRORS_PAGE_STR_FACT = new PagedListResponseFactory<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse>(){

        public ApiFuture<RegionInstanceGroupManagersClient.ListErrorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse> callable, ListErrorsRegionInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupManagersListErrorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ERRORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupManagersClient.ListErrorsPagedResponse.createAsync((PageContext<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> LIST_MANAGED_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse>(){

        public ApiFuture<RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse> callable, ListManagedInstancesRegionInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupManagersListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MANAGED_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse.createAsync((PageContext<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, ManagedInstance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> LIST_PER_INSTANCE_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse>(){

        public ApiFuture<RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp> callable, ListPerInstanceConfigsRegionInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<RegionInstanceGroupManagersListInstanceConfigsResp> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PER_INSTANCE_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse.createAsync((PageContext<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, PerInstanceConfig>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AbandonInstancesRegionInstanceGroupManagerRequest, Operation> abandonInstancesSettings() {
        return this.abandonInstancesSettings;
    }

    public OperationCallSettings<AbandonInstancesRegionInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings() {
        return this.abandonInstancesOperationSettings;
    }

    public UnaryCallSettings<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings() {
        return this.applyUpdatesToInstancesSettings;
    }

    public OperationCallSettings<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings() {
        return this.applyUpdatesToInstancesOperationSettings;
    }

    public UnaryCallSettings<CreateInstancesRegionInstanceGroupManagerRequest, Operation> createInstancesSettings() {
        return this.createInstancesSettings;
    }

    public OperationCallSettings<CreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings() {
        return this.createInstancesOperationSettings;
    }

    public UnaryCallSettings<DeleteRegionInstanceGroupManagerRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteInstancesRegionInstanceGroupManagerRequest, Operation> deleteInstancesSettings() {
        return this.deleteInstancesSettings;
    }

    public OperationCallSettings<DeleteInstancesRegionInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings() {
        return this.deleteInstancesOperationSettings;
    }

    public UnaryCallSettings<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings() {
        return this.deletePerInstanceConfigsSettings;
    }

    public OperationCallSettings<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings() {
        return this.deletePerInstanceConfigsOperationSettings;
    }

    public UnaryCallSettings<GetRegionInstanceGroupManagerRequest, InstanceGroupManager> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertRegionInstanceGroupManagerRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings() {
        return this.listErrorsSettings;
    }

    public PagedCallSettings<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings() {
        return this.listManagedInstancesSettings;
    }

    public PagedCallSettings<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings() {
        return this.listPerInstanceConfigsSettings;
    }

    public UnaryCallSettings<PatchRegionInstanceGroupManagerRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchRegionInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings() {
        return this.patchPerInstanceConfigsSettings;
    }

    public OperationCallSettings<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings() {
        return this.patchPerInstanceConfigsOperationSettings;
    }

    public UnaryCallSettings<RecreateInstancesRegionInstanceGroupManagerRequest, Operation> recreateInstancesSettings() {
        return this.recreateInstancesSettings;
    }

    public OperationCallSettings<RecreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings() {
        return this.recreateInstancesOperationSettings;
    }

    public UnaryCallSettings<ResizeRegionInstanceGroupManagerRequest, Operation> resizeSettings() {
        return this.resizeSettings;
    }

    public OperationCallSettings<ResizeRegionInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings() {
        return this.resizeOperationSettings;
    }

    public UnaryCallSettings<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings() {
        return this.setInstanceTemplateSettings;
    }

    public OperationCallSettings<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings() {
        return this.setInstanceTemplateOperationSettings;
    }

    public UnaryCallSettings<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation> setTargetPoolsSettings() {
        return this.setTargetPoolsSettings;
    }

    public OperationCallSettings<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings() {
        return this.setTargetPoolsOperationSettings;
    }

    public UnaryCallSettings<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings() {
        return this.updatePerInstanceConfigsSettings;
    }

    public OperationCallSettings<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings() {
        return this.updatePerInstanceConfigsOperationSettings;
    }

    public RegionInstanceGroupManagersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionInstanceGroupManagersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RegionInstanceGroupManagersStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionInstanceGroupManagersStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionInstanceGroupManagersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionInstanceGroupManagersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.abandonInstancesSettings = settingsBuilder.abandonInstancesSettings().build();
        this.abandonInstancesOperationSettings = settingsBuilder.abandonInstancesOperationSettings().build();
        this.applyUpdatesToInstancesSettings = settingsBuilder.applyUpdatesToInstancesSettings().build();
        this.applyUpdatesToInstancesOperationSettings = settingsBuilder.applyUpdatesToInstancesOperationSettings().build();
        this.createInstancesSettings = settingsBuilder.createInstancesSettings().build();
        this.createInstancesOperationSettings = settingsBuilder.createInstancesOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteInstancesSettings = settingsBuilder.deleteInstancesSettings().build();
        this.deleteInstancesOperationSettings = settingsBuilder.deleteInstancesOperationSettings().build();
        this.deletePerInstanceConfigsSettings = settingsBuilder.deletePerInstanceConfigsSettings().build();
        this.deletePerInstanceConfigsOperationSettings = settingsBuilder.deletePerInstanceConfigsOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listErrorsSettings = settingsBuilder.listErrorsSettings().build();
        this.listManagedInstancesSettings = settingsBuilder.listManagedInstancesSettings().build();
        this.listPerInstanceConfigsSettings = settingsBuilder.listPerInstanceConfigsSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchPerInstanceConfigsSettings = settingsBuilder.patchPerInstanceConfigsSettings().build();
        this.patchPerInstanceConfigsOperationSettings = settingsBuilder.patchPerInstanceConfigsOperationSettings().build();
        this.recreateInstancesSettings = settingsBuilder.recreateInstancesSettings().build();
        this.recreateInstancesOperationSettings = settingsBuilder.recreateInstancesOperationSettings().build();
        this.resizeSettings = settingsBuilder.resizeSettings().build();
        this.resizeOperationSettings = settingsBuilder.resizeOperationSettings().build();
        this.setInstanceTemplateSettings = settingsBuilder.setInstanceTemplateSettings().build();
        this.setInstanceTemplateOperationSettings = settingsBuilder.setInstanceTemplateOperationSettings().build();
        this.setTargetPoolsSettings = settingsBuilder.setTargetPoolsSettings().build();
        this.setTargetPoolsOperationSettings = settingsBuilder.setTargetPoolsOperationSettings().build();
        this.updatePerInstanceConfigsSettings = settingsBuilder.updatePerInstanceConfigsSettings().build();
        this.updatePerInstanceConfigsOperationSettings = settingsBuilder.updatePerInstanceConfigsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionInstanceGroupManagersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AbandonInstancesRegionInstanceGroupManagerRequest, Operation> abandonInstancesSettings;
        private final OperationCallSettings.Builder<AbandonInstancesRegionInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings;
        private final UnaryCallSettings.Builder<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings;
        private final OperationCallSettings.Builder<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings;
        private final UnaryCallSettings.Builder<CreateInstancesRegionInstanceGroupManagerRequest, Operation> createInstancesSettings;
        private final OperationCallSettings.Builder<CreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegionInstanceGroupManagerRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstancesRegionInstanceGroupManagerRequest, Operation> deleteInstancesSettings;
        private final OperationCallSettings.Builder<DeleteInstancesRegionInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings;
        private final UnaryCallSettings.Builder<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionInstanceGroupManagerRequest, InstanceGroupManager> getSettings;
        private final UnaryCallSettings.Builder<InsertRegionInstanceGroupManagerRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings;
        private final PagedCallSettings.Builder<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings;
        private final PagedCallSettings.Builder<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings;
        private final UnaryCallSettings.Builder<PatchRegionInstanceGroupManagerRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchRegionInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings;
        private final UnaryCallSettings.Builder<RecreateInstancesRegionInstanceGroupManagerRequest, Operation> recreateInstancesSettings;
        private final OperationCallSettings.Builder<RecreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings;
        private final UnaryCallSettings.Builder<ResizeRegionInstanceGroupManagerRequest, Operation> resizeSettings;
        private final OperationCallSettings.Builder<ResizeRegionInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings;
        private final UnaryCallSettings.Builder<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings;
        private final OperationCallSettings.Builder<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings;
        private final UnaryCallSettings.Builder<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation> setTargetPoolsSettings;
        private final OperationCallSettings.Builder<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.abandonInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.abandonInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.applyUpdatesToInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.applyUpdatesToInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.createInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.deletePerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listErrorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ERRORS_PAGE_STR_FACT);
            this.listManagedInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MANAGED_INSTANCES_PAGE_STR_FACT);
            this.listPerInstanceConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PER_INSTANCE_CONFIGS_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchPerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchPerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.recreateInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.recreateInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.resizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeOperationSettings = OperationCallSettings.newBuilder();
            this.setInstanceTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.setTargetPoolsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTargetPoolsOperationSettings = OperationCallSettings.newBuilder();
            this.updatePerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesSettings, this.applyUpdatesToInstancesSettings, this.createInstancesSettings, this.deleteSettings, this.deleteInstancesSettings, this.deletePerInstanceConfigsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listErrorsSettings, this.listManagedInstancesSettings, this.listPerInstanceConfigsSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchPerInstanceConfigsSettings, this.recreateInstancesSettings, this.resizeSettings, this.setInstanceTemplateSettings, this.setTargetPoolsSettings, this.updatePerInstanceConfigsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RegionInstanceGroupManagersStubSettings settings) {
            super((StubSettings)settings);
            this.abandonInstancesSettings = settings.abandonInstancesSettings.toBuilder();
            this.abandonInstancesOperationSettings = settings.abandonInstancesOperationSettings.toBuilder();
            this.applyUpdatesToInstancesSettings = settings.applyUpdatesToInstancesSettings.toBuilder();
            this.applyUpdatesToInstancesOperationSettings = settings.applyUpdatesToInstancesOperationSettings.toBuilder();
            this.createInstancesSettings = settings.createInstancesSettings.toBuilder();
            this.createInstancesOperationSettings = settings.createInstancesOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteInstancesSettings = settings.deleteInstancesSettings.toBuilder();
            this.deleteInstancesOperationSettings = settings.deleteInstancesOperationSettings.toBuilder();
            this.deletePerInstanceConfigsSettings = settings.deletePerInstanceConfigsSettings.toBuilder();
            this.deletePerInstanceConfigsOperationSettings = settings.deletePerInstanceConfigsOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listErrorsSettings = settings.listErrorsSettings.toBuilder();
            this.listManagedInstancesSettings = settings.listManagedInstancesSettings.toBuilder();
            this.listPerInstanceConfigsSettings = settings.listPerInstanceConfigsSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchPerInstanceConfigsSettings = settings.patchPerInstanceConfigsSettings.toBuilder();
            this.patchPerInstanceConfigsOperationSettings = settings.patchPerInstanceConfigsOperationSettings.toBuilder();
            this.recreateInstancesSettings = settings.recreateInstancesSettings.toBuilder();
            this.recreateInstancesOperationSettings = settings.recreateInstancesOperationSettings.toBuilder();
            this.resizeSettings = settings.resizeSettings.toBuilder();
            this.resizeOperationSettings = settings.resizeOperationSettings.toBuilder();
            this.setInstanceTemplateSettings = settings.setInstanceTemplateSettings.toBuilder();
            this.setInstanceTemplateOperationSettings = settings.setInstanceTemplateOperationSettings.toBuilder();
            this.setTargetPoolsSettings = settings.setTargetPoolsSettings.toBuilder();
            this.setTargetPoolsOperationSettings = settings.setTargetPoolsOperationSettings.toBuilder();
            this.updatePerInstanceConfigsSettings = settings.updatePerInstanceConfigsSettings.toBuilder();
            this.updatePerInstanceConfigsOperationSettings = settings.updatePerInstanceConfigsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesSettings, this.applyUpdatesToInstancesSettings, this.createInstancesSettings, this.deleteSettings, this.deleteInstancesSettings, this.deletePerInstanceConfigsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listErrorsSettings, this.listManagedInstancesSettings, this.listPerInstanceConfigsSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchSettings, this.patchPerInstanceConfigsSettings, this.recreateInstancesSettings, this.resizeSettings, this.setInstanceTemplateSettings, this.setTargetPoolsSettings, this.updatePerInstanceConfigsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionInstanceGroupManagersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionInstanceGroupManagersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionInstanceGroupManagersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionInstanceGroupManagersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.abandonInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.applyUpdatesToInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listManagedInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listPerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchPerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.recreateInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setInstanceTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setTargetPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.abandonInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.applyUpdatesToInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.createInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deletePerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchPerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.recreateInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resizeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setInstanceTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setTargetPoolsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updatePerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AbandonInstancesRegionInstanceGroupManagerRequest, Operation> abandonInstancesSettings() {
            return this.abandonInstancesSettings;
        }

        public OperationCallSettings.Builder<AbandonInstancesRegionInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings() {
            return this.abandonInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings() {
            return this.applyUpdatesToInstancesSettings;
        }

        public OperationCallSettings.Builder<ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings() {
            return this.applyUpdatesToInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateInstancesRegionInstanceGroupManagerRequest, Operation> createInstancesSettings() {
            return this.createInstancesSettings;
        }

        public OperationCallSettings.Builder<CreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings() {
            return this.createInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionInstanceGroupManagerRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRegionInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstancesRegionInstanceGroupManagerRequest, Operation> deleteInstancesSettings() {
            return this.deleteInstancesSettings;
        }

        public OperationCallSettings.Builder<DeleteInstancesRegionInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings() {
            return this.deleteInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings() {
            return this.deletePerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<DeletePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings() {
            return this.deletePerInstanceConfigsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionInstanceGroupManagerRequest, InstanceGroupManager> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionInstanceGroupManagerRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionInstanceGroupManagersRequest, RegionInstanceGroupManagerList, RegionInstanceGroupManagersClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListErrorsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListErrorsResponse, RegionInstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings() {
            return this.listErrorsSettings;
        }

        public PagedCallSettings.Builder<ListManagedInstancesRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstancesResponse, RegionInstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings() {
            return this.listManagedInstancesSettings;
        }

        public PagedCallSettings.Builder<ListPerInstanceConfigsRegionInstanceGroupManagersRequest, RegionInstanceGroupManagersListInstanceConfigsResp, RegionInstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings() {
            return this.listPerInstanceConfigsSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionInstanceGroupManagerRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchRegionInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings() {
            return this.patchPerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<PatchPerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings() {
            return this.patchPerInstanceConfigsOperationSettings;
        }

        public UnaryCallSettings.Builder<RecreateInstancesRegionInstanceGroupManagerRequest, Operation> recreateInstancesSettings() {
            return this.recreateInstancesSettings;
        }

        public OperationCallSettings.Builder<RecreateInstancesRegionInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings() {
            return this.recreateInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<ResizeRegionInstanceGroupManagerRequest, Operation> resizeSettings() {
            return this.resizeSettings;
        }

        public OperationCallSettings.Builder<ResizeRegionInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings() {
            return this.resizeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings() {
            return this.setInstanceTemplateSettings;
        }

        public OperationCallSettings.Builder<SetInstanceTemplateRegionInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings() {
            return this.setInstanceTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation> setTargetPoolsSettings() {
            return this.setTargetPoolsSettings;
        }

        public OperationCallSettings.Builder<SetTargetPoolsRegionInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings() {
            return this.setTargetPoolsOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings() {
            return this.updatePerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings() {
            return this.updatePerInstanceConfigsOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RegionInstanceGroupManagersStubSettings.getDefaultEndpoint();
        }

        public RegionInstanceGroupManagersStubSettings build() throws IOException {
            return new RegionInstanceGroupManagersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

