/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTemplatesRequest;
import com.google.cloud.compute.v1.DeleteNodeTemplateRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeTemplateRequest;
import com.google.cloud.compute.v1.GetNodeTemplateRequest;
import com.google.cloud.compute.v1.InsertNodeTemplateRequest;
import com.google.cloud.compute.v1.ListNodeTemplatesRequest;
import com.google.cloud.compute.v1.NodeTemplate;
import com.google.cloud.compute.v1.NodeTemplateAggregatedList;
import com.google.cloud.compute.v1.NodeTemplateList;
import com.google.cloud.compute.v1.NodeTemplatesClient;
import com.google.cloud.compute.v1.NodeTemplatesScopedList;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyNodeTemplateRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeTemplateRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNodeTemplatesStub;
import com.google.cloud.compute.v1.stub.NodeTemplatesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class NodeTemplatesStubSettings
extends StubSettings<NodeTemplatesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteNodeTemplateRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetNodeTemplateRequest, NodeTemplate> getSettings;
    private final UnaryCallSettings<GetIamPolicyNodeTemplateRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertNodeTemplateRequest, Operation> insertSettings;
    private final PagedCallSettings<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<SetIamPolicyNodeTemplateRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsNodeTemplateRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeTemplatesRequest injectToken(AggregatedListNodeTemplatesRequest payload, String token) {
            return AggregatedListNodeTemplatesRequest.newBuilder((AggregatedListNodeTemplatesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListNodeTemplatesRequest injectPageSize(AggregatedListNodeTemplatesRequest payload, int pageSize) {
            return AggregatedListNodeTemplatesRequest.newBuilder((AggregatedListNodeTemplatesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeTemplatesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTemplateAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, NodeTemplatesScopedList>> extractResources(NodeTemplateAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeTemplatesRequest injectToken(ListNodeTemplatesRequest payload, String token) {
            return ListNodeTemplatesRequest.newBuilder((ListNodeTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListNodeTemplatesRequest injectPageSize(ListNodeTemplatesRequest payload, int pageSize) {
            return ListNodeTemplatesRequest.newBuilder((ListNodeTemplatesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeTemplatesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTemplateList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeTemplate> extractResources(NodeTemplateList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse>(){

        public ApiFuture<NodeTemplatesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList> callable, AggregatedListNodeTemplatesRequest request, ApiCallContext context, ApiFuture<NodeTemplateAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTemplatesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, Map.Entry<String, NodeTemplatesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse>(){

        public ApiFuture<NodeTemplatesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeTemplatesRequest, NodeTemplateList> callable, ListNodeTemplatesRequest request, ApiCallContext context, ApiFuture<NodeTemplateList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTemplatesClient.ListPagedResponse.createAsync((PageContext<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplate>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteNodeTemplateRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetNodeTemplateRequest, NodeTemplate> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyNodeTemplateRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertNodeTemplateRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<SetIamPolicyNodeTemplateRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsNodeTemplateRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTemplatesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeTemplatesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeTemplatesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeTemplatesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeTemplatesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeTemplatesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteNodeTemplateRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetNodeTemplateRequest, NodeTemplate> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyNodeTemplateRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertNodeTemplateRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyNodeTemplateRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNodeTemplateRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(NodeTemplatesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeTemplatesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeTemplatesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeTemplatesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeTemplatesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(NodeTemplatesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNodeTemplatesRequest, NodeTemplateAggregatedList, NodeTemplatesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteNodeTemplateRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetNodeTemplateRequest, NodeTemplate> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyNodeTemplateRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertNodeTemplateRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListNodeTemplatesRequest, NodeTemplateList, NodeTemplatesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyNodeTemplateRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNodeTemplateRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NodeTemplatesStubSettings build() throws IOException {
            return new NodeTemplatesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

