/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListVpnGatewaysRequest;
import com.google.cloud.compute.v1.DeleteVpnGatewayRequest;
import com.google.cloud.compute.v1.GetStatusVpnGatewayRequest;
import com.google.cloud.compute.v1.GetVpnGatewayRequest;
import com.google.cloud.compute.v1.InsertVpnGatewayRequest;
import com.google.cloud.compute.v1.ListVpnGatewaysRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.SetLabelsVpnGatewayRequest;
import com.google.cloud.compute.v1.TestIamPermissionsVpnGatewayRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.VpnGateway;
import com.google.cloud.compute.v1.VpnGatewayAggregatedList;
import com.google.cloud.compute.v1.VpnGatewayList;
import com.google.cloud.compute.v1.VpnGatewaysGetStatusResponse;
import com.google.cloud.compute.v1.VpnGatewaysScopedList;
import com.google.cloud.compute.v1.VpnGatewaysSettings;
import com.google.cloud.compute.v1.stub.VpnGatewaysStub;
import com.google.cloud.compute.v1.stub.VpnGatewaysStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VpnGatewaysClient
implements BackgroundResource {
    private final VpnGatewaysSettings settings;
    private final VpnGatewaysStub stub;

    public static final VpnGatewaysClient create() throws IOException {
        return VpnGatewaysClient.create(VpnGatewaysSettings.newBuilder().build());
    }

    public static final VpnGatewaysClient create(VpnGatewaysSettings settings) throws IOException {
        return new VpnGatewaysClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final VpnGatewaysClient create(VpnGatewaysStub stub) {
        return new VpnGatewaysClient(stub);
    }

    protected VpnGatewaysClient(VpnGatewaysSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VpnGatewaysStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected VpnGatewaysClient(VpnGatewaysStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final VpnGatewaysSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpnGatewaysStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListVpnGatewaysRequest request = AggregatedListVpnGatewaysRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListVpnGatewaysRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListVpnGatewaysRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String vpnGateway) {
        DeleteVpnGatewayRequest request = DeleteVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setVpnGateway(vpnGateway).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteVpnGatewayRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteVpnGatewayRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final VpnGateway get(String project, String region, String vpnGateway) {
        GetVpnGatewayRequest request = GetVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setVpnGateway(vpnGateway).build();
        return this.get(request);
    }

    public final VpnGateway get(GetVpnGatewayRequest request) {
        return (VpnGateway)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetVpnGatewayRequest, VpnGateway> getCallable() {
        return this.stub.getCallable();
    }

    public final VpnGatewaysGetStatusResponse getStatus(String project, String region, String vpnGateway) {
        GetStatusVpnGatewayRequest request = GetStatusVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setVpnGateway(vpnGateway).build();
        return this.getStatus(request);
    }

    public final VpnGatewaysGetStatusResponse getStatus(GetStatusVpnGatewayRequest request) {
        return (VpnGatewaysGetStatusResponse)this.getStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetStatusVpnGatewayRequest, VpnGatewaysGetStatusResponse> getStatusCallable() {
        return this.stub.getStatusCallable();
    }

    public final Operation insert(String project, String region, VpnGateway vpnGatewayResource) {
        InsertVpnGatewayRequest request = InsertVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setVpnGatewayResource(vpnGatewayResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertVpnGatewayRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertVpnGatewayRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListVpnGatewaysRequest request = ListVpnGatewaysRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListVpnGatewaysRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVpnGatewaysRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListVpnGatewaysRequest, VpnGatewayList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation setLabels(String project, String region, String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsVpnGatewayRequest request = SetLabelsVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsVpnGatewayRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsVpnGatewayRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsVpnGatewayRequest request = TestIamPermissionsVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsVpnGatewayRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsVpnGatewayRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway, ListPage> {
        private ListPage(PageContext<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway> context, VpnGatewayList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway> context, VpnGatewayList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway> context, ApiFuture<VpnGatewayList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListVpnGatewaysRequest, VpnGatewayList, VpnGateway> context, ApiFuture<VpnGatewayList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>> context, VpnGatewayAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>> context, VpnGatewayAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>> context, ApiFuture<VpnGatewayAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListVpnGatewaysRequest, VpnGatewayAggregatedList, Map.Entry<String, VpnGatewaysScopedList>> context, ApiFuture<VpnGatewayAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

