/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.AddResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.AggregatedListInstancesRequest;
import com.google.cloud.compute.v1.AttachDiskInstanceRequest;
import com.google.cloud.compute.v1.BulkInsertInstanceRequest;
import com.google.cloud.compute.v1.DeleteAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.DeleteInstanceRequest;
import com.google.cloud.compute.v1.DetachDiskInstanceRequest;
import com.google.cloud.compute.v1.GetEffectiveFirewallsInstanceRequest;
import com.google.cloud.compute.v1.GetGuestAttributesInstanceRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.GetInstanceRequest;
import com.google.cloud.compute.v1.GetScreenshotInstanceRequest;
import com.google.cloud.compute.v1.GetSerialPortOutputInstanceRequest;
import com.google.cloud.compute.v1.GetShieldedInstanceIdentityInstanceRequest;
import com.google.cloud.compute.v1.GuestAttributes;
import com.google.cloud.compute.v1.InsertInstanceRequest;
import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceAggregatedList;
import com.google.cloud.compute.v1.InstanceList;
import com.google.cloud.compute.v1.InstanceListReferrers;
import com.google.cloud.compute.v1.InstancesClient;
import com.google.cloud.compute.v1.InstancesGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.InstancesScopedList;
import com.google.cloud.compute.v1.ListInstancesRequest;
import com.google.cloud.compute.v1.ListReferrersInstancesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PerformMaintenanceInstanceRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.Reference;
import com.google.cloud.compute.v1.RemoveResourcePoliciesInstanceRequest;
import com.google.cloud.compute.v1.ResetInstanceRequest;
import com.google.cloud.compute.v1.ResumeInstanceRequest;
import com.google.cloud.compute.v1.Screenshot;
import com.google.cloud.compute.v1.SendDiagnosticInterruptInstanceRequest;
import com.google.cloud.compute.v1.SendDiagnosticInterruptInstanceResponse;
import com.google.cloud.compute.v1.SerialPortOutput;
import com.google.cloud.compute.v1.SetDeletionProtectionInstanceRequest;
import com.google.cloud.compute.v1.SetDiskAutoDeleteInstanceRequest;
import com.google.cloud.compute.v1.SetIamPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetLabelsInstanceRequest;
import com.google.cloud.compute.v1.SetMachineResourcesInstanceRequest;
import com.google.cloud.compute.v1.SetMachineTypeInstanceRequest;
import com.google.cloud.compute.v1.SetMetadataInstanceRequest;
import com.google.cloud.compute.v1.SetMinCpuPlatformInstanceRequest;
import com.google.cloud.compute.v1.SetNameInstanceRequest;
import com.google.cloud.compute.v1.SetSchedulingInstanceRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetServiceAccountInstanceRequest;
import com.google.cloud.compute.v1.SetShieldedInstanceIntegrityPolicyInstanceRequest;
import com.google.cloud.compute.v1.SetTagsInstanceRequest;
import com.google.cloud.compute.v1.ShieldedInstanceIdentity;
import com.google.cloud.compute.v1.SimulateMaintenanceEventInstanceRequest;
import com.google.cloud.compute.v1.StartInstanceRequest;
import com.google.cloud.compute.v1.StartWithEncryptionKeyInstanceRequest;
import com.google.cloud.compute.v1.StopInstanceRequest;
import com.google.cloud.compute.v1.SuspendInstanceRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateAccessConfigInstanceRequest;
import com.google.cloud.compute.v1.UpdateDisplayDeviceInstanceRequest;
import com.google.cloud.compute.v1.UpdateInstanceRequest;
import com.google.cloud.compute.v1.UpdateNetworkInterfaceInstanceRequest;
import com.google.cloud.compute.v1.UpdateShieldedInstanceConfigInstanceRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstancesStub;
import com.google.cloud.compute.v1.stub.InstancesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class InstancesStubSettings
extends StubSettings<InstancesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings;
    private final OperationCallSettings<AddAccessConfigInstanceRequest, Operation, Operation> addAccessConfigOperationSettings;
    private final UnaryCallSettings<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings;
    private final OperationCallSettings<AddResourcePoliciesInstanceRequest, Operation, Operation> addResourcePoliciesOperationSettings;
    private final PagedCallSettings<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<AttachDiskInstanceRequest, Operation> attachDiskSettings;
    private final OperationCallSettings<AttachDiskInstanceRequest, Operation, Operation> attachDiskOperationSettings;
    private final UnaryCallSettings<BulkInsertInstanceRequest, Operation> bulkInsertSettings;
    private final OperationCallSettings<BulkInsertInstanceRequest, Operation, Operation> bulkInsertOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings;
    private final OperationCallSettings<DeleteAccessConfigInstanceRequest, Operation, Operation> deleteAccessConfigOperationSettings;
    private final UnaryCallSettings<DetachDiskInstanceRequest, Operation> detachDiskSettings;
    private final OperationCallSettings<DetachDiskInstanceRequest, Operation, Operation> detachDiskOperationSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getSettings;
    private final UnaryCallSettings<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
    private final UnaryCallSettings<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings;
    private final UnaryCallSettings<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings;
    private final UnaryCallSettings<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings;
    private final UnaryCallSettings<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings;
    private final UnaryCallSettings<InsertInstanceRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertInstanceRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings;
    private final UnaryCallSettings<PerformMaintenanceInstanceRequest, Operation> performMaintenanceSettings;
    private final OperationCallSettings<PerformMaintenanceInstanceRequest, Operation, Operation> performMaintenanceOperationSettings;
    private final UnaryCallSettings<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings;
    private final OperationCallSettings<RemoveResourcePoliciesInstanceRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetSettings;
    private final OperationCallSettings<ResetInstanceRequest, Operation, Operation> resetOperationSettings;
    private final UnaryCallSettings<ResumeInstanceRequest, Operation> resumeSettings;
    private final OperationCallSettings<ResumeInstanceRequest, Operation, Operation> resumeOperationSettings;
    private final UnaryCallSettings<SendDiagnosticInterruptInstanceRequest, SendDiagnosticInterruptInstanceResponse> sendDiagnosticInterruptSettings;
    private final UnaryCallSettings<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings;
    private final OperationCallSettings<SetDeletionProtectionInstanceRequest, Operation, Operation> setDeletionProtectionOperationSettings;
    private final UnaryCallSettings<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings;
    private final OperationCallSettings<SetDiskAutoDeleteInstanceRequest, Operation, Operation> setDiskAutoDeleteOperationSettings;
    private final UnaryCallSettings<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<SetLabelsInstanceRequest, Operation> setLabelsSettings;
    private final OperationCallSettings<SetLabelsInstanceRequest, Operation, Operation> setLabelsOperationSettings;
    private final UnaryCallSettings<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings;
    private final OperationCallSettings<SetMachineResourcesInstanceRequest, Operation, Operation> setMachineResourcesOperationSettings;
    private final UnaryCallSettings<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings;
    private final OperationCallSettings<SetMachineTypeInstanceRequest, Operation, Operation> setMachineTypeOperationSettings;
    private final UnaryCallSettings<SetMetadataInstanceRequest, Operation> setMetadataSettings;
    private final OperationCallSettings<SetMetadataInstanceRequest, Operation, Operation> setMetadataOperationSettings;
    private final UnaryCallSettings<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings;
    private final OperationCallSettings<SetMinCpuPlatformInstanceRequest, Operation, Operation> setMinCpuPlatformOperationSettings;
    private final UnaryCallSettings<SetNameInstanceRequest, Operation> setNameSettings;
    private final OperationCallSettings<SetNameInstanceRequest, Operation, Operation> setNameOperationSettings;
    private final UnaryCallSettings<SetSchedulingInstanceRequest, Operation> setSchedulingSettings;
    private final OperationCallSettings<SetSchedulingInstanceRequest, Operation, Operation> setSchedulingOperationSettings;
    private final UnaryCallSettings<SetSecurityPolicyInstanceRequest, Operation> setSecurityPolicySettings;
    private final OperationCallSettings<SetSecurityPolicyInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
    private final UnaryCallSettings<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings;
    private final OperationCallSettings<SetServiceAccountInstanceRequest, Operation, Operation> setServiceAccountOperationSettings;
    private final UnaryCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings;
    private final OperationCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation, Operation> setShieldedInstanceIntegrityPolicyOperationSettings;
    private final UnaryCallSettings<SetTagsInstanceRequest, Operation> setTagsSettings;
    private final OperationCallSettings<SetTagsInstanceRequest, Operation, Operation> setTagsOperationSettings;
    private final UnaryCallSettings<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings;
    private final OperationCallSettings<SimulateMaintenanceEventInstanceRequest, Operation, Operation> simulateMaintenanceEventOperationSettings;
    private final UnaryCallSettings<StartInstanceRequest, Operation> startSettings;
    private final OperationCallSettings<StartInstanceRequest, Operation, Operation> startOperationSettings;
    private final UnaryCallSettings<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings;
    private final OperationCallSettings<StartWithEncryptionKeyInstanceRequest, Operation, Operation> startWithEncryptionKeyOperationSettings;
    private final UnaryCallSettings<StopInstanceRequest, Operation> stopSettings;
    private final OperationCallSettings<StopInstanceRequest, Operation, Operation> stopOperationSettings;
    private final UnaryCallSettings<SuspendInstanceRequest, Operation> suspendSettings;
    private final OperationCallSettings<SuspendInstanceRequest, Operation, Operation> suspendOperationSettings;
    private final UnaryCallSettings<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Operation, Operation> updateOperationSettings;
    private final UnaryCallSettings<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings;
    private final OperationCallSettings<UpdateAccessConfigInstanceRequest, Operation, Operation> updateAccessConfigOperationSettings;
    private final UnaryCallSettings<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings;
    private final OperationCallSettings<UpdateDisplayDeviceInstanceRequest, Operation, Operation> updateDisplayDeviceOperationSettings;
    private final UnaryCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings;
    private final OperationCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation, Operation> updateNetworkInterfaceOperationSettings;
    private final UnaryCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings;
    private final OperationCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation, Operation> updateShieldedInstanceConfigOperationSettings;
    private static final PagedListDescriptor<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstancesRequest injectToken(AggregatedListInstancesRequest payload, String token) {
            return AggregatedListInstancesRequest.newBuilder((AggregatedListInstancesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListInstancesRequest injectPageSize(AggregatedListInstancesRequest payload, int pageSize) {
            return AggregatedListInstancesRequest.newBuilder((AggregatedListInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, InstancesScopedList>> extractResources(InstanceAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListInstancesRequest, InstanceList, Instance> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, InstanceList, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(InstanceList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListReferrersInstancesRequest, InstanceListReferrers, Reference> LIST_REFERRERS_PAGE_STR_DESC = new PagedListDescriptor<ListReferrersInstancesRequest, InstanceListReferrers, Reference>(){

        public String emptyToken() {
            return "";
        }

        public ListReferrersInstancesRequest injectToken(ListReferrersInstancesRequest payload, String token) {
            return ListReferrersInstancesRequest.newBuilder((ListReferrersInstancesRequest)payload).setPageToken(token).build();
        }

        public ListReferrersInstancesRequest injectPageSize(ListReferrersInstancesRequest payload, int pageSize) {
            return ListReferrersInstancesRequest.newBuilder((ListReferrersInstancesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReferrersInstancesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceListReferrers payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Reference> extractResources(InstanceListReferrers payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse>(){

        public ApiFuture<InstancesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstancesRequest, InstanceAggregatedList> callable, AggregatedListInstancesRequest request, ApiCallContext context, ApiFuture<InstanceAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListInstancesRequest, InstanceAggregatedList, Map.Entry<String, InstancesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse>(){

        public ApiFuture<InstancesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, InstanceList> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<InstanceList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.ListPagedResponse.createAsync((PageContext<ListInstancesRequest, InstanceList, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> LIST_REFERRERS_PAGE_STR_FACT = new PagedListResponseFactory<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse>(){

        public ApiFuture<InstancesClient.ListReferrersPagedResponse> getFuturePagedResponse(UnaryCallable<ListReferrersInstancesRequest, InstanceListReferrers> callable, ListReferrersInstancesRequest request, ApiCallContext context, ApiFuture<InstanceListReferrers> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REFERRERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstancesClient.ListReferrersPagedResponse.createAsync((PageContext<ListReferrersInstancesRequest, InstanceListReferrers, Reference>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings() {
        return this.addAccessConfigSettings;
    }

    public OperationCallSettings<AddAccessConfigInstanceRequest, Operation, Operation> addAccessConfigOperationSettings() {
        return this.addAccessConfigOperationSettings;
    }

    public UnaryCallSettings<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings() {
        return this.addResourcePoliciesSettings;
    }

    public OperationCallSettings<AddResourcePoliciesInstanceRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
        return this.addResourcePoliciesOperationSettings;
    }

    public PagedCallSettings<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<AttachDiskInstanceRequest, Operation> attachDiskSettings() {
        return this.attachDiskSettings;
    }

    public OperationCallSettings<AttachDiskInstanceRequest, Operation, Operation> attachDiskOperationSettings() {
        return this.attachDiskOperationSettings;
    }

    public UnaryCallSettings<BulkInsertInstanceRequest, Operation> bulkInsertSettings() {
        return this.bulkInsertSettings;
    }

    public OperationCallSettings<BulkInsertInstanceRequest, Operation, Operation> bulkInsertOperationSettings() {
        return this.bulkInsertOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings() {
        return this.deleteAccessConfigSettings;
    }

    public OperationCallSettings<DeleteAccessConfigInstanceRequest, Operation, Operation> deleteAccessConfigOperationSettings() {
        return this.deleteAccessConfigOperationSettings;
    }

    public UnaryCallSettings<DetachDiskInstanceRequest, Operation> detachDiskSettings() {
        return this.detachDiskSettings;
    }

    public OperationCallSettings<DetachDiskInstanceRequest, Operation, Operation> detachDiskOperationSettings() {
        return this.detachDiskOperationSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
        return this.getEffectiveFirewallsSettings;
    }

    public UnaryCallSettings<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings() {
        return this.getGuestAttributesSettings;
    }

    public UnaryCallSettings<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings() {
        return this.getScreenshotSettings;
    }

    public UnaryCallSettings<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings() {
        return this.getSerialPortOutputSettings;
    }

    public UnaryCallSettings<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings() {
        return this.getShieldedInstanceIdentitySettings;
    }

    public UnaryCallSettings<InsertInstanceRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertInstanceRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings() {
        return this.listReferrersSettings;
    }

    public UnaryCallSettings<PerformMaintenanceInstanceRequest, Operation> performMaintenanceSettings() {
        return this.performMaintenanceSettings;
    }

    public OperationCallSettings<PerformMaintenanceInstanceRequest, Operation, Operation> performMaintenanceOperationSettings() {
        return this.performMaintenanceOperationSettings;
    }

    public UnaryCallSettings<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings() {
        return this.removeResourcePoliciesSettings;
    }

    public OperationCallSettings<RemoveResourcePoliciesInstanceRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
        return this.removeResourcePoliciesOperationSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetSettings() {
        return this.resetSettings;
    }

    public OperationCallSettings<ResetInstanceRequest, Operation, Operation> resetOperationSettings() {
        return this.resetOperationSettings;
    }

    public UnaryCallSettings<ResumeInstanceRequest, Operation> resumeSettings() {
        return this.resumeSettings;
    }

    public OperationCallSettings<ResumeInstanceRequest, Operation, Operation> resumeOperationSettings() {
        return this.resumeOperationSettings;
    }

    public UnaryCallSettings<SendDiagnosticInterruptInstanceRequest, SendDiagnosticInterruptInstanceResponse> sendDiagnosticInterruptSettings() {
        return this.sendDiagnosticInterruptSettings;
    }

    public UnaryCallSettings<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings() {
        return this.setDeletionProtectionSettings;
    }

    public OperationCallSettings<SetDeletionProtectionInstanceRequest, Operation, Operation> setDeletionProtectionOperationSettings() {
        return this.setDeletionProtectionOperationSettings;
    }

    public UnaryCallSettings<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings() {
        return this.setDiskAutoDeleteSettings;
    }

    public OperationCallSettings<SetDiskAutoDeleteInstanceRequest, Operation, Operation> setDiskAutoDeleteOperationSettings() {
        return this.setDiskAutoDeleteOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<SetLabelsInstanceRequest, Operation> setLabelsSettings() {
        return this.setLabelsSettings;
    }

    public OperationCallSettings<SetLabelsInstanceRequest, Operation, Operation> setLabelsOperationSettings() {
        return this.setLabelsOperationSettings;
    }

    public UnaryCallSettings<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings() {
        return this.setMachineResourcesSettings;
    }

    public OperationCallSettings<SetMachineResourcesInstanceRequest, Operation, Operation> setMachineResourcesOperationSettings() {
        return this.setMachineResourcesOperationSettings;
    }

    public UnaryCallSettings<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings() {
        return this.setMachineTypeSettings;
    }

    public OperationCallSettings<SetMachineTypeInstanceRequest, Operation, Operation> setMachineTypeOperationSettings() {
        return this.setMachineTypeOperationSettings;
    }

    public UnaryCallSettings<SetMetadataInstanceRequest, Operation> setMetadataSettings() {
        return this.setMetadataSettings;
    }

    public OperationCallSettings<SetMetadataInstanceRequest, Operation, Operation> setMetadataOperationSettings() {
        return this.setMetadataOperationSettings;
    }

    public UnaryCallSettings<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings() {
        return this.setMinCpuPlatformSettings;
    }

    public OperationCallSettings<SetMinCpuPlatformInstanceRequest, Operation, Operation> setMinCpuPlatformOperationSettings() {
        return this.setMinCpuPlatformOperationSettings;
    }

    public UnaryCallSettings<SetNameInstanceRequest, Operation> setNameSettings() {
        return this.setNameSettings;
    }

    public OperationCallSettings<SetNameInstanceRequest, Operation, Operation> setNameOperationSettings() {
        return this.setNameOperationSettings;
    }

    public UnaryCallSettings<SetSchedulingInstanceRequest, Operation> setSchedulingSettings() {
        return this.setSchedulingSettings;
    }

    public OperationCallSettings<SetSchedulingInstanceRequest, Operation, Operation> setSchedulingOperationSettings() {
        return this.setSchedulingOperationSettings;
    }

    public UnaryCallSettings<SetSecurityPolicyInstanceRequest, Operation> setSecurityPolicySettings() {
        return this.setSecurityPolicySettings;
    }

    public OperationCallSettings<SetSecurityPolicyInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
        return this.setSecurityPolicyOperationSettings;
    }

    public UnaryCallSettings<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings() {
        return this.setServiceAccountSettings;
    }

    public OperationCallSettings<SetServiceAccountInstanceRequest, Operation, Operation> setServiceAccountOperationSettings() {
        return this.setServiceAccountOperationSettings;
    }

    public UnaryCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings() {
        return this.setShieldedInstanceIntegrityPolicySettings;
    }

    public OperationCallSettings<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation, Operation> setShieldedInstanceIntegrityPolicyOperationSettings() {
        return this.setShieldedInstanceIntegrityPolicyOperationSettings;
    }

    public UnaryCallSettings<SetTagsInstanceRequest, Operation> setTagsSettings() {
        return this.setTagsSettings;
    }

    public OperationCallSettings<SetTagsInstanceRequest, Operation, Operation> setTagsOperationSettings() {
        return this.setTagsOperationSettings;
    }

    public UnaryCallSettings<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings() {
        return this.simulateMaintenanceEventSettings;
    }

    public OperationCallSettings<SimulateMaintenanceEventInstanceRequest, Operation, Operation> simulateMaintenanceEventOperationSettings() {
        return this.simulateMaintenanceEventOperationSettings;
    }

    public UnaryCallSettings<StartInstanceRequest, Operation> startSettings() {
        return this.startSettings;
    }

    public OperationCallSettings<StartInstanceRequest, Operation, Operation> startOperationSettings() {
        return this.startOperationSettings;
    }

    public UnaryCallSettings<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings() {
        return this.startWithEncryptionKeySettings;
    }

    public OperationCallSettings<StartWithEncryptionKeyInstanceRequest, Operation, Operation> startWithEncryptionKeyOperationSettings() {
        return this.startWithEncryptionKeyOperationSettings;
    }

    public UnaryCallSettings<StopInstanceRequest, Operation> stopSettings() {
        return this.stopSettings;
    }

    public OperationCallSettings<StopInstanceRequest, Operation, Operation> stopOperationSettings() {
        return this.stopOperationSettings;
    }

    public UnaryCallSettings<SuspendInstanceRequest, Operation> suspendSettings() {
        return this.suspendSettings;
    }

    public OperationCallSettings<SuspendInstanceRequest, Operation, Operation> suspendOperationSettings() {
        return this.suspendOperationSettings;
    }

    public UnaryCallSettings<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public UnaryCallSettings<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings() {
        return this.updateAccessConfigSettings;
    }

    public OperationCallSettings<UpdateAccessConfigInstanceRequest, Operation, Operation> updateAccessConfigOperationSettings() {
        return this.updateAccessConfigOperationSettings;
    }

    public UnaryCallSettings<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings() {
        return this.updateDisplayDeviceSettings;
    }

    public OperationCallSettings<UpdateDisplayDeviceInstanceRequest, Operation, Operation> updateDisplayDeviceOperationSettings() {
        return this.updateDisplayDeviceOperationSettings;
    }

    public UnaryCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings() {
        return this.updateNetworkInterfaceSettings;
    }

    public OperationCallSettings<UpdateNetworkInterfaceInstanceRequest, Operation, Operation> updateNetworkInterfaceOperationSettings() {
        return this.updateNetworkInterfaceOperationSettings;
    }

    public UnaryCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings() {
        return this.updateShieldedInstanceConfigSettings;
    }

    public OperationCallSettings<UpdateShieldedInstanceConfigInstanceRequest, Operation, Operation> updateShieldedInstanceConfigOperationSettings() {
        return this.updateShieldedInstanceConfigOperationSettings;
    }

    public InstancesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstancesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return InstancesStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstancesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstancesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstancesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAccessConfigSettings = settingsBuilder.addAccessConfigSettings().build();
        this.addAccessConfigOperationSettings = settingsBuilder.addAccessConfigOperationSettings().build();
        this.addResourcePoliciesSettings = settingsBuilder.addResourcePoliciesSettings().build();
        this.addResourcePoliciesOperationSettings = settingsBuilder.addResourcePoliciesOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.attachDiskSettings = settingsBuilder.attachDiskSettings().build();
        this.attachDiskOperationSettings = settingsBuilder.attachDiskOperationSettings().build();
        this.bulkInsertSettings = settingsBuilder.bulkInsertSettings().build();
        this.bulkInsertOperationSettings = settingsBuilder.bulkInsertOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteAccessConfigSettings = settingsBuilder.deleteAccessConfigSettings().build();
        this.deleteAccessConfigOperationSettings = settingsBuilder.deleteAccessConfigOperationSettings().build();
        this.detachDiskSettings = settingsBuilder.detachDiskSettings().build();
        this.detachDiskOperationSettings = settingsBuilder.detachDiskOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getEffectiveFirewallsSettings = settingsBuilder.getEffectiveFirewallsSettings().build();
        this.getGuestAttributesSettings = settingsBuilder.getGuestAttributesSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getScreenshotSettings = settingsBuilder.getScreenshotSettings().build();
        this.getSerialPortOutputSettings = settingsBuilder.getSerialPortOutputSettings().build();
        this.getShieldedInstanceIdentitySettings = settingsBuilder.getShieldedInstanceIdentitySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listReferrersSettings = settingsBuilder.listReferrersSettings().build();
        this.performMaintenanceSettings = settingsBuilder.performMaintenanceSettings().build();
        this.performMaintenanceOperationSettings = settingsBuilder.performMaintenanceOperationSettings().build();
        this.removeResourcePoliciesSettings = settingsBuilder.removeResourcePoliciesSettings().build();
        this.removeResourcePoliciesOperationSettings = settingsBuilder.removeResourcePoliciesOperationSettings().build();
        this.resetSettings = settingsBuilder.resetSettings().build();
        this.resetOperationSettings = settingsBuilder.resetOperationSettings().build();
        this.resumeSettings = settingsBuilder.resumeSettings().build();
        this.resumeOperationSettings = settingsBuilder.resumeOperationSettings().build();
        this.sendDiagnosticInterruptSettings = settingsBuilder.sendDiagnosticInterruptSettings().build();
        this.setDeletionProtectionSettings = settingsBuilder.setDeletionProtectionSettings().build();
        this.setDeletionProtectionOperationSettings = settingsBuilder.setDeletionProtectionOperationSettings().build();
        this.setDiskAutoDeleteSettings = settingsBuilder.setDiskAutoDeleteSettings().build();
        this.setDiskAutoDeleteOperationSettings = settingsBuilder.setDiskAutoDeleteOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.setLabelsSettings = settingsBuilder.setLabelsSettings().build();
        this.setLabelsOperationSettings = settingsBuilder.setLabelsOperationSettings().build();
        this.setMachineResourcesSettings = settingsBuilder.setMachineResourcesSettings().build();
        this.setMachineResourcesOperationSettings = settingsBuilder.setMachineResourcesOperationSettings().build();
        this.setMachineTypeSettings = settingsBuilder.setMachineTypeSettings().build();
        this.setMachineTypeOperationSettings = settingsBuilder.setMachineTypeOperationSettings().build();
        this.setMetadataSettings = settingsBuilder.setMetadataSettings().build();
        this.setMetadataOperationSettings = settingsBuilder.setMetadataOperationSettings().build();
        this.setMinCpuPlatformSettings = settingsBuilder.setMinCpuPlatformSettings().build();
        this.setMinCpuPlatformOperationSettings = settingsBuilder.setMinCpuPlatformOperationSettings().build();
        this.setNameSettings = settingsBuilder.setNameSettings().build();
        this.setNameOperationSettings = settingsBuilder.setNameOperationSettings().build();
        this.setSchedulingSettings = settingsBuilder.setSchedulingSettings().build();
        this.setSchedulingOperationSettings = settingsBuilder.setSchedulingOperationSettings().build();
        this.setSecurityPolicySettings = settingsBuilder.setSecurityPolicySettings().build();
        this.setSecurityPolicyOperationSettings = settingsBuilder.setSecurityPolicyOperationSettings().build();
        this.setServiceAccountSettings = settingsBuilder.setServiceAccountSettings().build();
        this.setServiceAccountOperationSettings = settingsBuilder.setServiceAccountOperationSettings().build();
        this.setShieldedInstanceIntegrityPolicySettings = settingsBuilder.setShieldedInstanceIntegrityPolicySettings().build();
        this.setShieldedInstanceIntegrityPolicyOperationSettings = settingsBuilder.setShieldedInstanceIntegrityPolicyOperationSettings().build();
        this.setTagsSettings = settingsBuilder.setTagsSettings().build();
        this.setTagsOperationSettings = settingsBuilder.setTagsOperationSettings().build();
        this.simulateMaintenanceEventSettings = settingsBuilder.simulateMaintenanceEventSettings().build();
        this.simulateMaintenanceEventOperationSettings = settingsBuilder.simulateMaintenanceEventOperationSettings().build();
        this.startSettings = settingsBuilder.startSettings().build();
        this.startOperationSettings = settingsBuilder.startOperationSettings().build();
        this.startWithEncryptionKeySettings = settingsBuilder.startWithEncryptionKeySettings().build();
        this.startWithEncryptionKeyOperationSettings = settingsBuilder.startWithEncryptionKeyOperationSettings().build();
        this.stopSettings = settingsBuilder.stopSettings().build();
        this.stopOperationSettings = settingsBuilder.stopOperationSettings().build();
        this.suspendSettings = settingsBuilder.suspendSettings().build();
        this.suspendOperationSettings = settingsBuilder.suspendOperationSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
        this.updateAccessConfigSettings = settingsBuilder.updateAccessConfigSettings().build();
        this.updateAccessConfigOperationSettings = settingsBuilder.updateAccessConfigOperationSettings().build();
        this.updateDisplayDeviceSettings = settingsBuilder.updateDisplayDeviceSettings().build();
        this.updateDisplayDeviceOperationSettings = settingsBuilder.updateDisplayDeviceOperationSettings().build();
        this.updateNetworkInterfaceSettings = settingsBuilder.updateNetworkInterfaceSettings().build();
        this.updateNetworkInterfaceOperationSettings = settingsBuilder.updateNetworkInterfaceOperationSettings().build();
        this.updateShieldedInstanceConfigSettings = settingsBuilder.updateShieldedInstanceConfigSettings().build();
        this.updateShieldedInstanceConfigOperationSettings = settingsBuilder.updateShieldedInstanceConfigOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstancesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings;
        private final OperationCallSettings.Builder<AddAccessConfigInstanceRequest, Operation, Operation> addAccessConfigOperationSettings;
        private final UnaryCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings;
        private final OperationCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation, Operation> addResourcePoliciesOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<AttachDiskInstanceRequest, Operation> attachDiskSettings;
        private final OperationCallSettings.Builder<AttachDiskInstanceRequest, Operation, Operation> attachDiskOperationSettings;
        private final UnaryCallSettings.Builder<BulkInsertInstanceRequest, Operation> bulkInsertSettings;
        private final OperationCallSettings.Builder<BulkInsertInstanceRequest, Operation, Operation> bulkInsertOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings;
        private final OperationCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation, Operation> deleteAccessConfigOperationSettings;
        private final UnaryCallSettings.Builder<DetachDiskInstanceRequest, Operation> detachDiskSettings;
        private final OperationCallSettings.Builder<DetachDiskInstanceRequest, Operation, Operation> detachDiskOperationSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getSettings;
        private final UnaryCallSettings.Builder<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
        private final UnaryCallSettings.Builder<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings;
        private final UnaryCallSettings.Builder<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings;
        private final UnaryCallSettings.Builder<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings;
        private final UnaryCallSettings.Builder<InsertInstanceRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertInstanceRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings;
        private final UnaryCallSettings.Builder<PerformMaintenanceInstanceRequest, Operation> performMaintenanceSettings;
        private final OperationCallSettings.Builder<PerformMaintenanceInstanceRequest, Operation, Operation> performMaintenanceOperationSettings;
        private final UnaryCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings;
        private final OperationCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation, Operation> removeResourcePoliciesOperationSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetSettings;
        private final OperationCallSettings.Builder<ResetInstanceRequest, Operation, Operation> resetOperationSettings;
        private final UnaryCallSettings.Builder<ResumeInstanceRequest, Operation> resumeSettings;
        private final OperationCallSettings.Builder<ResumeInstanceRequest, Operation, Operation> resumeOperationSettings;
        private final UnaryCallSettings.Builder<SendDiagnosticInterruptInstanceRequest, SendDiagnosticInterruptInstanceResponse> sendDiagnosticInterruptSettings;
        private final UnaryCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings;
        private final OperationCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation, Operation> setDeletionProtectionOperationSettings;
        private final UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings;
        private final OperationCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation, Operation> setDiskAutoDeleteOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<SetLabelsInstanceRequest, Operation> setLabelsSettings;
        private final OperationCallSettings.Builder<SetLabelsInstanceRequest, Operation, Operation> setLabelsOperationSettings;
        private final UnaryCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings;
        private final OperationCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation, Operation> setMachineResourcesOperationSettings;
        private final UnaryCallSettings.Builder<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings;
        private final OperationCallSettings.Builder<SetMachineTypeInstanceRequest, Operation, Operation> setMachineTypeOperationSettings;
        private final UnaryCallSettings.Builder<SetMetadataInstanceRequest, Operation> setMetadataSettings;
        private final OperationCallSettings.Builder<SetMetadataInstanceRequest, Operation, Operation> setMetadataOperationSettings;
        private final UnaryCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings;
        private final OperationCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation, Operation> setMinCpuPlatformOperationSettings;
        private final UnaryCallSettings.Builder<SetNameInstanceRequest, Operation> setNameSettings;
        private final OperationCallSettings.Builder<SetNameInstanceRequest, Operation, Operation> setNameOperationSettings;
        private final UnaryCallSettings.Builder<SetSchedulingInstanceRequest, Operation> setSchedulingSettings;
        private final OperationCallSettings.Builder<SetSchedulingInstanceRequest, Operation, Operation> setSchedulingOperationSettings;
        private final UnaryCallSettings.Builder<SetSecurityPolicyInstanceRequest, Operation> setSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetSecurityPolicyInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings;
        private final UnaryCallSettings.Builder<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings;
        private final OperationCallSettings.Builder<SetServiceAccountInstanceRequest, Operation, Operation> setServiceAccountOperationSettings;
        private final UnaryCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings;
        private final OperationCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation, Operation> setShieldedInstanceIntegrityPolicyOperationSettings;
        private final UnaryCallSettings.Builder<SetTagsInstanceRequest, Operation> setTagsSettings;
        private final OperationCallSettings.Builder<SetTagsInstanceRequest, Operation, Operation> setTagsOperationSettings;
        private final UnaryCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings;
        private final OperationCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation, Operation> simulateMaintenanceEventOperationSettings;
        private final UnaryCallSettings.Builder<StartInstanceRequest, Operation> startSettings;
        private final OperationCallSettings.Builder<StartInstanceRequest, Operation, Operation> startOperationSettings;
        private final UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings;
        private final OperationCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation, Operation> startWithEncryptionKeyOperationSettings;
        private final UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopSettings;
        private final OperationCallSettings.Builder<StopInstanceRequest, Operation, Operation> stopOperationSettings;
        private final UnaryCallSettings.Builder<SuspendInstanceRequest, Operation> suspendSettings;
        private final OperationCallSettings.Builder<SuspendInstanceRequest, Operation, Operation> suspendOperationSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Operation, Operation> updateOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings;
        private final OperationCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation, Operation> updateAccessConfigOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings;
        private final OperationCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation, Operation> updateDisplayDeviceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings;
        private final OperationCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation, Operation> updateNetworkInterfaceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings;
        private final OperationCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation, Operation> updateShieldedInstanceConfigOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addAccessConfigOperationSettings = OperationCallSettings.newBuilder();
            this.addResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.attachDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.attachDiskOperationSettings = OperationCallSettings.newBuilder();
            this.bulkInsertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.bulkInsertOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessConfigOperationSettings = OperationCallSettings.newBuilder();
            this.detachDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachDiskOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectiveFirewallsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGuestAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getScreenshotSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSerialPortOutputSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getShieldedInstanceIdentitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listReferrersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REFERRERS_PAGE_STR_FACT);
            this.performMaintenanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.performMaintenanceOperationSettings = OperationCallSettings.newBuilder();
            this.removeResourcePoliciesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeResourcePoliciesOperationSettings = OperationCallSettings.newBuilder();
            this.resetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetOperationSettings = OperationCallSettings.newBuilder();
            this.resumeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeOperationSettings = OperationCallSettings.newBuilder();
            this.sendDiagnosticInterruptSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDeletionProtectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDeletionProtectionOperationSettings = OperationCallSettings.newBuilder();
            this.setDiskAutoDeleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDiskAutoDeleteOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.setMachineResourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineResourcesOperationSettings = OperationCallSettings.newBuilder();
            this.setMachineTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMachineTypeOperationSettings = OperationCallSettings.newBuilder();
            this.setMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMetadataOperationSettings = OperationCallSettings.newBuilder();
            this.setMinCpuPlatformSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setMinCpuPlatformOperationSettings = OperationCallSettings.newBuilder();
            this.setNameSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setNameOperationSettings = OperationCallSettings.newBuilder();
            this.setSchedulingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSchedulingOperationSettings = OperationCallSettings.newBuilder();
            this.setSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.setServiceAccountSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setServiceAccountOperationSettings = OperationCallSettings.newBuilder();
            this.setShieldedInstanceIntegrityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setShieldedInstanceIntegrityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.setTagsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTagsOperationSettings = OperationCallSettings.newBuilder();
            this.simulateMaintenanceEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.simulateMaintenanceEventOperationSettings = OperationCallSettings.newBuilder();
            this.startSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startOperationSettings = OperationCallSettings.newBuilder();
            this.startWithEncryptionKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startWithEncryptionKeyOperationSettings = OperationCallSettings.newBuilder();
            this.stopSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopOperationSettings = OperationCallSettings.newBuilder();
            this.suspendSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suspendOperationSettings = OperationCallSettings.newBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.updateAccessConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessConfigOperationSettings = OperationCallSettings.newBuilder();
            this.updateDisplayDeviceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDisplayDeviceOperationSettings = OperationCallSettings.newBuilder();
            this.updateNetworkInterfaceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateNetworkInterfaceOperationSettings = OperationCallSettings.newBuilder();
            this.updateShieldedInstanceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateShieldedInstanceConfigOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigSettings, this.addResourcePoliciesSettings, this.aggregatedListSettings, this.attachDiskSettings, this.bulkInsertSettings, this.deleteSettings, this.deleteAccessConfigSettings, this.detachDiskSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.getGuestAttributesSettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getScreenshotSettings, this.getSerialPortOutputSettings, this.getShieldedInstanceIdentitySettings, this.insertSettings, this.listSettings, this.listReferrersSettings, this.performMaintenanceSettings, this.removeResourcePoliciesSettings, this.resetSettings, this.resumeSettings, this.sendDiagnosticInterruptSettings, this.setDeletionProtectionSettings, this.setDiskAutoDeleteSettings, this.setIamPolicySettings, this.setLabelsSettings, this.setMachineResourcesSettings, this.setMachineTypeSettings, this.setMetadataSettings, this.setMinCpuPlatformSettings, this.setNameSettings, this.setSchedulingSettings, this.setSecurityPolicySettings, this.setServiceAccountSettings, this.setShieldedInstanceIntegrityPolicySettings, this.setTagsSettings, this.simulateMaintenanceEventSettings, this.startSettings, this.startWithEncryptionKeySettings, this.stopSettings, this.suspendSettings, this.testIamPermissionsSettings, this.updateSettings, this.updateAccessConfigSettings, this.updateDisplayDeviceSettings, this.updateNetworkInterfaceSettings, this.updateShieldedInstanceConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(InstancesStubSettings settings) {
            super((StubSettings)settings);
            this.addAccessConfigSettings = settings.addAccessConfigSettings.toBuilder();
            this.addAccessConfigOperationSettings = settings.addAccessConfigOperationSettings.toBuilder();
            this.addResourcePoliciesSettings = settings.addResourcePoliciesSettings.toBuilder();
            this.addResourcePoliciesOperationSettings = settings.addResourcePoliciesOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.attachDiskSettings = settings.attachDiskSettings.toBuilder();
            this.attachDiskOperationSettings = settings.attachDiskOperationSettings.toBuilder();
            this.bulkInsertSettings = settings.bulkInsertSettings.toBuilder();
            this.bulkInsertOperationSettings = settings.bulkInsertOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteAccessConfigSettings = settings.deleteAccessConfigSettings.toBuilder();
            this.deleteAccessConfigOperationSettings = settings.deleteAccessConfigOperationSettings.toBuilder();
            this.detachDiskSettings = settings.detachDiskSettings.toBuilder();
            this.detachDiskOperationSettings = settings.detachDiskOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getEffectiveFirewallsSettings = settings.getEffectiveFirewallsSettings.toBuilder();
            this.getGuestAttributesSettings = settings.getGuestAttributesSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getScreenshotSettings = settings.getScreenshotSettings.toBuilder();
            this.getSerialPortOutputSettings = settings.getSerialPortOutputSettings.toBuilder();
            this.getShieldedInstanceIdentitySettings = settings.getShieldedInstanceIdentitySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listReferrersSettings = settings.listReferrersSettings.toBuilder();
            this.performMaintenanceSettings = settings.performMaintenanceSettings.toBuilder();
            this.performMaintenanceOperationSettings = settings.performMaintenanceOperationSettings.toBuilder();
            this.removeResourcePoliciesSettings = settings.removeResourcePoliciesSettings.toBuilder();
            this.removeResourcePoliciesOperationSettings = settings.removeResourcePoliciesOperationSettings.toBuilder();
            this.resetSettings = settings.resetSettings.toBuilder();
            this.resetOperationSettings = settings.resetOperationSettings.toBuilder();
            this.resumeSettings = settings.resumeSettings.toBuilder();
            this.resumeOperationSettings = settings.resumeOperationSettings.toBuilder();
            this.sendDiagnosticInterruptSettings = settings.sendDiagnosticInterruptSettings.toBuilder();
            this.setDeletionProtectionSettings = settings.setDeletionProtectionSettings.toBuilder();
            this.setDeletionProtectionOperationSettings = settings.setDeletionProtectionOperationSettings.toBuilder();
            this.setDiskAutoDeleteSettings = settings.setDiskAutoDeleteSettings.toBuilder();
            this.setDiskAutoDeleteOperationSettings = settings.setDiskAutoDeleteOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.setLabelsSettings = settings.setLabelsSettings.toBuilder();
            this.setLabelsOperationSettings = settings.setLabelsOperationSettings.toBuilder();
            this.setMachineResourcesSettings = settings.setMachineResourcesSettings.toBuilder();
            this.setMachineResourcesOperationSettings = settings.setMachineResourcesOperationSettings.toBuilder();
            this.setMachineTypeSettings = settings.setMachineTypeSettings.toBuilder();
            this.setMachineTypeOperationSettings = settings.setMachineTypeOperationSettings.toBuilder();
            this.setMetadataSettings = settings.setMetadataSettings.toBuilder();
            this.setMetadataOperationSettings = settings.setMetadataOperationSettings.toBuilder();
            this.setMinCpuPlatformSettings = settings.setMinCpuPlatformSettings.toBuilder();
            this.setMinCpuPlatformOperationSettings = settings.setMinCpuPlatformOperationSettings.toBuilder();
            this.setNameSettings = settings.setNameSettings.toBuilder();
            this.setNameOperationSettings = settings.setNameOperationSettings.toBuilder();
            this.setSchedulingSettings = settings.setSchedulingSettings.toBuilder();
            this.setSchedulingOperationSettings = settings.setSchedulingOperationSettings.toBuilder();
            this.setSecurityPolicySettings = settings.setSecurityPolicySettings.toBuilder();
            this.setSecurityPolicyOperationSettings = settings.setSecurityPolicyOperationSettings.toBuilder();
            this.setServiceAccountSettings = settings.setServiceAccountSettings.toBuilder();
            this.setServiceAccountOperationSettings = settings.setServiceAccountOperationSettings.toBuilder();
            this.setShieldedInstanceIntegrityPolicySettings = settings.setShieldedInstanceIntegrityPolicySettings.toBuilder();
            this.setShieldedInstanceIntegrityPolicyOperationSettings = settings.setShieldedInstanceIntegrityPolicyOperationSettings.toBuilder();
            this.setTagsSettings = settings.setTagsSettings.toBuilder();
            this.setTagsOperationSettings = settings.setTagsOperationSettings.toBuilder();
            this.simulateMaintenanceEventSettings = settings.simulateMaintenanceEventSettings.toBuilder();
            this.simulateMaintenanceEventOperationSettings = settings.simulateMaintenanceEventOperationSettings.toBuilder();
            this.startSettings = settings.startSettings.toBuilder();
            this.startOperationSettings = settings.startOperationSettings.toBuilder();
            this.startWithEncryptionKeySettings = settings.startWithEncryptionKeySettings.toBuilder();
            this.startWithEncryptionKeyOperationSettings = settings.startWithEncryptionKeyOperationSettings.toBuilder();
            this.stopSettings = settings.stopSettings.toBuilder();
            this.stopOperationSettings = settings.stopOperationSettings.toBuilder();
            this.suspendSettings = settings.suspendSettings.toBuilder();
            this.suspendOperationSettings = settings.suspendOperationSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.updateAccessConfigSettings = settings.updateAccessConfigSettings.toBuilder();
            this.updateAccessConfigOperationSettings = settings.updateAccessConfigOperationSettings.toBuilder();
            this.updateDisplayDeviceSettings = settings.updateDisplayDeviceSettings.toBuilder();
            this.updateDisplayDeviceOperationSettings = settings.updateDisplayDeviceOperationSettings.toBuilder();
            this.updateNetworkInterfaceSettings = settings.updateNetworkInterfaceSettings.toBuilder();
            this.updateNetworkInterfaceOperationSettings = settings.updateNetworkInterfaceOperationSettings.toBuilder();
            this.updateShieldedInstanceConfigSettings = settings.updateShieldedInstanceConfigSettings.toBuilder();
            this.updateShieldedInstanceConfigOperationSettings = settings.updateShieldedInstanceConfigOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAccessConfigSettings, this.addResourcePoliciesSettings, this.aggregatedListSettings, this.attachDiskSettings, this.bulkInsertSettings, this.deleteSettings, this.deleteAccessConfigSettings, this.detachDiskSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.getGuestAttributesSettings, this.getIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.getScreenshotSettings, this.getSerialPortOutputSettings, this.getShieldedInstanceIdentitySettings, this.insertSettings, this.listSettings, this.listReferrersSettings, this.performMaintenanceSettings, this.removeResourcePoliciesSettings, this.resetSettings, this.resumeSettings, this.sendDiagnosticInterruptSettings, this.setDeletionProtectionSettings, this.setDiskAutoDeleteSettings, this.setIamPolicySettings, this.setLabelsSettings, this.setMachineResourcesSettings, this.setMachineTypeSettings, this.setMetadataSettings, this.setMinCpuPlatformSettings, this.setNameSettings, this.setSchedulingSettings, this.setSecurityPolicySettings, this.setServiceAccountSettings, this.setShieldedInstanceIntegrityPolicySettings, this.setTagsSettings, this.simulateMaintenanceEventSettings, this.startSettings, this.startWithEncryptionKeySettings, this.stopSettings, this.suspendSettings, this.testIamPermissionsSettings, this.updateSettings, this.updateAccessConfigSettings, this.updateDisplayDeviceSettings, this.updateNetworkInterfaceSettings, this.updateShieldedInstanceConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstancesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstancesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstancesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InstancesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.attachDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.bulkInsertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.detachDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEffectiveFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getGuestAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getScreenshotSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSerialPortOutputSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getShieldedInstanceIdentitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listReferrersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.performMaintenanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeResourcePoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resumeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.sendDiagnosticInterruptSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setDeletionProtectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setDiskAutoDeleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMachineResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMachineTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setMinCpuPlatformSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setNameSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSchedulingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setServiceAccountSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setShieldedInstanceIntegrityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setTagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.simulateMaintenanceEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startWithEncryptionKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.suspendSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAccessConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDisplayDeviceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateNetworkInterfaceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateShieldedInstanceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addAccessConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.addResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.attachDiskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.bulkInsertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteAccessConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.detachDiskOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.performMaintenanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeResourcePoliciesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resumeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setDeletionProtectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setDiskAutoDeleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setMachineResourcesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setMachineTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setMetadataOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setMinCpuPlatformOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setNameOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSchedulingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setServiceAccountOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setShieldedInstanceIntegrityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setTagsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.simulateMaintenanceEventOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.startOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.startWithEncryptionKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.stopOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.suspendOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateAccessConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateDisplayDeviceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateNetworkInterfaceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateShieldedInstanceConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAccessConfigInstanceRequest, Operation> addAccessConfigSettings() {
            return this.addAccessConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddAccessConfigInstanceRequest, Operation, Operation> addAccessConfigOperationSettings() {
            return this.addAccessConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation> addResourcePoliciesSettings() {
            return this.addResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AddResourcePoliciesInstanceRequest, Operation, Operation> addResourcePoliciesOperationSettings() {
            return this.addResourcePoliciesOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstancesRequest, InstanceAggregatedList, InstancesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<AttachDiskInstanceRequest, Operation> attachDiskSettings() {
            return this.attachDiskSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AttachDiskInstanceRequest, Operation, Operation> attachDiskOperationSettings() {
            return this.attachDiskOperationSettings;
        }

        public UnaryCallSettings.Builder<BulkInsertInstanceRequest, Operation> bulkInsertSettings() {
            return this.bulkInsertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BulkInsertInstanceRequest, Operation, Operation> bulkInsertOperationSettings() {
            return this.bulkInsertOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteInstanceRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation> deleteAccessConfigSettings() {
            return this.deleteAccessConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAccessConfigInstanceRequest, Operation, Operation> deleteAccessConfigOperationSettings() {
            return this.deleteAccessConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DetachDiskInstanceRequest, Operation> detachDiskSettings() {
            return this.detachDiskSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DetachDiskInstanceRequest, Operation, Operation> detachDiskOperationSettings() {
            return this.detachDiskOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetEffectiveFirewallsInstanceRequest, InstancesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
            return this.getEffectiveFirewallsSettings;
        }

        public UnaryCallSettings.Builder<GetGuestAttributesInstanceRequest, GuestAttributes> getGuestAttributesSettings() {
            return this.getGuestAttributesSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyInstanceRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetScreenshotInstanceRequest, Screenshot> getScreenshotSettings() {
            return this.getScreenshotSettings;
        }

        public UnaryCallSettings.Builder<GetSerialPortOutputInstanceRequest, SerialPortOutput> getSerialPortOutputSettings() {
            return this.getSerialPortOutputSettings;
        }

        public UnaryCallSettings.Builder<GetShieldedInstanceIdentityInstanceRequest, ShieldedInstanceIdentity> getShieldedInstanceIdentitySettings() {
            return this.getShieldedInstanceIdentitySettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertInstanceRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, InstanceList, InstancesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListReferrersInstancesRequest, InstanceListReferrers, InstancesClient.ListReferrersPagedResponse> listReferrersSettings() {
            return this.listReferrersSettings;
        }

        public UnaryCallSettings.Builder<PerformMaintenanceInstanceRequest, Operation> performMaintenanceSettings() {
            return this.performMaintenanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PerformMaintenanceInstanceRequest, Operation, Operation> performMaintenanceOperationSettings() {
            return this.performMaintenanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation> removeResourcePoliciesSettings() {
            return this.removeResourcePoliciesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RemoveResourcePoliciesInstanceRequest, Operation, Operation> removeResourcePoliciesOperationSettings() {
            return this.removeResourcePoliciesOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetSettings() {
            return this.resetSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetInstanceRequest, Operation, Operation> resetOperationSettings() {
            return this.resetOperationSettings;
        }

        public UnaryCallSettings.Builder<ResumeInstanceRequest, Operation> resumeSettings() {
            return this.resumeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResumeInstanceRequest, Operation, Operation> resumeOperationSettings() {
            return this.resumeOperationSettings;
        }

        public UnaryCallSettings.Builder<SendDiagnosticInterruptInstanceRequest, SendDiagnosticInterruptInstanceResponse> sendDiagnosticInterruptSettings() {
            return this.sendDiagnosticInterruptSettings;
        }

        public UnaryCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation> setDeletionProtectionSettings() {
            return this.setDeletionProtectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetDeletionProtectionInstanceRequest, Operation, Operation> setDeletionProtectionOperationSettings() {
            return this.setDeletionProtectionOperationSettings;
        }

        public UnaryCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation> setDiskAutoDeleteSettings() {
            return this.setDiskAutoDeleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetDiskAutoDeleteInstanceRequest, Operation, Operation> setDiskAutoDeleteOperationSettings() {
            return this.setDiskAutoDeleteOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyInstanceRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetLabelsInstanceRequest, Operation> setLabelsSettings() {
            return this.setLabelsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetLabelsInstanceRequest, Operation, Operation> setLabelsOperationSettings() {
            return this.setLabelsOperationSettings;
        }

        public UnaryCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation> setMachineResourcesSettings() {
            return this.setMachineResourcesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetMachineResourcesInstanceRequest, Operation, Operation> setMachineResourcesOperationSettings() {
            return this.setMachineResourcesOperationSettings;
        }

        public UnaryCallSettings.Builder<SetMachineTypeInstanceRequest, Operation> setMachineTypeSettings() {
            return this.setMachineTypeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetMachineTypeInstanceRequest, Operation, Operation> setMachineTypeOperationSettings() {
            return this.setMachineTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetMetadataInstanceRequest, Operation> setMetadataSettings() {
            return this.setMetadataSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetMetadataInstanceRequest, Operation, Operation> setMetadataOperationSettings() {
            return this.setMetadataOperationSettings;
        }

        public UnaryCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation> setMinCpuPlatformSettings() {
            return this.setMinCpuPlatformSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetMinCpuPlatformInstanceRequest, Operation, Operation> setMinCpuPlatformOperationSettings() {
            return this.setMinCpuPlatformOperationSettings;
        }

        public UnaryCallSettings.Builder<SetNameInstanceRequest, Operation> setNameSettings() {
            return this.setNameSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetNameInstanceRequest, Operation, Operation> setNameOperationSettings() {
            return this.setNameOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSchedulingInstanceRequest, Operation> setSchedulingSettings() {
            return this.setSchedulingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetSchedulingInstanceRequest, Operation, Operation> setSchedulingOperationSettings() {
            return this.setSchedulingOperationSettings;
        }

        public UnaryCallSettings.Builder<SetSecurityPolicyInstanceRequest, Operation> setSecurityPolicySettings() {
            return this.setSecurityPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetSecurityPolicyInstanceRequest, Operation, Operation> setSecurityPolicyOperationSettings() {
            return this.setSecurityPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetServiceAccountInstanceRequest, Operation> setServiceAccountSettings() {
            return this.setServiceAccountSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetServiceAccountInstanceRequest, Operation, Operation> setServiceAccountOperationSettings() {
            return this.setServiceAccountOperationSettings;
        }

        public UnaryCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation> setShieldedInstanceIntegrityPolicySettings() {
            return this.setShieldedInstanceIntegrityPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetShieldedInstanceIntegrityPolicyInstanceRequest, Operation, Operation> setShieldedInstanceIntegrityPolicyOperationSettings() {
            return this.setShieldedInstanceIntegrityPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetTagsInstanceRequest, Operation> setTagsSettings() {
            return this.setTagsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetTagsInstanceRequest, Operation, Operation> setTagsOperationSettings() {
            return this.setTagsOperationSettings;
        }

        public UnaryCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation> simulateMaintenanceEventSettings() {
            return this.simulateMaintenanceEventSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SimulateMaintenanceEventInstanceRequest, Operation, Operation> simulateMaintenanceEventOperationSettings() {
            return this.simulateMaintenanceEventOperationSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceRequest, Operation> startSettings() {
            return this.startSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartInstanceRequest, Operation, Operation> startOperationSettings() {
            return this.startOperationSettings;
        }

        public UnaryCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation> startWithEncryptionKeySettings() {
            return this.startWithEncryptionKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartWithEncryptionKeyInstanceRequest, Operation, Operation> startWithEncryptionKeyOperationSettings() {
            return this.startWithEncryptionKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopSettings() {
            return this.stopSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopInstanceRequest, Operation, Operation> stopOperationSettings() {
            return this.stopOperationSettings;
        }

        public UnaryCallSettings.Builder<SuspendInstanceRequest, Operation> suspendSettings() {
            return this.suspendSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SuspendInstanceRequest, Operation, Operation> suspendOperationSettings() {
            return this.suspendOperationSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsInstanceRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateInstanceRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation> updateAccessConfigSettings() {
            return this.updateAccessConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAccessConfigInstanceRequest, Operation, Operation> updateAccessConfigOperationSettings() {
            return this.updateAccessConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation> updateDisplayDeviceSettings() {
            return this.updateDisplayDeviceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDisplayDeviceInstanceRequest, Operation, Operation> updateDisplayDeviceOperationSettings() {
            return this.updateDisplayDeviceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation> updateNetworkInterfaceSettings() {
            return this.updateNetworkInterfaceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateNetworkInterfaceInstanceRequest, Operation, Operation> updateNetworkInterfaceOperationSettings() {
            return this.updateNetworkInterfaceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation> updateShieldedInstanceConfigSettings() {
            return this.updateShieldedInstanceConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateShieldedInstanceConfigInstanceRequest, Operation, Operation> updateShieldedInstanceConfigOperationSettings() {
            return this.updateShieldedInstanceConfigOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return InstancesStubSettings.getDefaultEndpoint();
        }

        public InstancesStubSettings build() throws IOException {
            return new InstancesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

