/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddNodesNodeGroupRequest;
import com.google.cloud.compute.v1.AggregatedListNodeGroupsRequest;
import com.google.cloud.compute.v1.DeleteNodeGroupRequest;
import com.google.cloud.compute.v1.DeleteNodesNodeGroupRequest;
import com.google.cloud.compute.v1.GetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.GetNodeGroupRequest;
import com.google.cloud.compute.v1.InsertNodeGroupRequest;
import com.google.cloud.compute.v1.ListNodeGroupsRequest;
import com.google.cloud.compute.v1.ListNodesNodeGroupsRequest;
import com.google.cloud.compute.v1.NodeGroup;
import com.google.cloud.compute.v1.NodeGroupAggregatedList;
import com.google.cloud.compute.v1.NodeGroupList;
import com.google.cloud.compute.v1.NodeGroupsClient;
import com.google.cloud.compute.v1.NodeGroupsListNodes;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNodeGroupRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyNodeGroupRequest;
import com.google.cloud.compute.v1.SetNodeTemplateNodeGroupRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNodeGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNodeGroupsCallableFactory;
import com.google.cloud.compute.v1.stub.NodeGroupsStub;
import com.google.cloud.compute.v1.stub.NodeGroupsStubSettings;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonNodeGroupsStub
extends NodeGroupsStub {
    private static final ApiMethodDescriptor<AddNodesNodeGroupRequest, Operation> addNodesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/AddNodes").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/addNodes", (FieldsExtractor)new FieldsExtractor<AddNodesNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(AddNodesNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<AddNodesNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(AddNodesNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<AddNodesNodeGroupRequest, String>(){

        public String extract(AddNodesNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("nodeGroupsAddNodesRequestResource", (Message)request.getNodeGroupsAddNodesRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/nodeGroups", (FieldsExtractor)new FieldsExtractor<AggregatedListNodeGroupsRequest, Map<String, String>>(){

        public Map<String, String> extract(AggregatedListNodeGroupsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListNodeGroupsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(AggregatedListNodeGroupsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasIncludeAllScopes()) {
                serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListNodeGroupsRequest, String>(){

        public String extract(AggregatedListNodeGroupsRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)NodeGroupAggregatedList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<DeleteNodeGroupRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}", (FieldsExtractor)new FieldsExtractor<DeleteNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteNodeGroupRequest, String>(){

        public String extract(DeleteNodeGroupRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<DeleteNodesNodeGroupRequest, Operation> deleteNodesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/DeleteNodes").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/deleteNodes", (FieldsExtractor)new FieldsExtractor<DeleteNodesNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteNodesNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteNodesNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteNodesNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteNodesNodeGroupRequest, String>(){

        public String extract(DeleteNodesNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("nodeGroupsDeleteNodesRequestResource", (Message)request.getNodeGroupsDeleteNodesRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetNodeGroupRequest, NodeGroup> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}", (FieldsExtractor)new FieldsExtractor<GetNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(GetNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetNodeGroupRequest, String>(){

        public String extract(GetNodeGroupRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)NodeGroup.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyNodeGroupRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/GetIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy", (FieldsExtractor)new FieldsExtractor<GetIamPolicyNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(GetIamPolicyNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetIamPolicyNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasOptionsRequestedPolicyVersion()) {
                serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyNodeGroupRequest, String>(){

        public String extract(GetIamPolicyNodeGroupRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<InsertNodeGroupRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups", (FieldsExtractor)new FieldsExtractor<InsertNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "initialNodeCount", (Object)request.getInitialNodeCount());
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertNodeGroupRequest, String>(){

        public String extract(InsertNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("nodeGroupResource", (Message)request.getNodeGroupResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<ListNodeGroupsRequest, NodeGroupList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups", (FieldsExtractor)new FieldsExtractor<ListNodeGroupsRequest, Map<String, String>>(){

        public Map<String, String> extract(ListNodeGroupsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListNodeGroupsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListNodeGroupsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListNodeGroupsRequest, String>(){

        public String extract(ListNodeGroupsRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)NodeGroupList.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<ListNodesNodeGroupsRequest, NodeGroupsListNodes> listNodesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/ListNodes").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/listNodes", (FieldsExtractor)new FieldsExtractor<ListNodesNodeGroupsRequest, Map<String, String>>(){

        public Map<String, String> extract(ListNodesNodeGroupsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListNodesNodeGroupsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListNodesNodeGroupsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasFilter()) {
                serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            }
            if (request.hasMaxResults()) {
                serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            }
            if (request.hasOrderBy()) {
                serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            }
            if (request.hasPageToken()) {
                serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            }
            if (request.hasReturnPartialSuccess()) {
                serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListNodesNodeGroupsRequest, String>(){

        public String extract(ListNodesNodeGroupsRequest request) {
            return null;
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)NodeGroupsListNodes.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<PatchNodeGroupRequest, Operation> patchMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/Patch").setHttpMethod("PATCH").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}", (FieldsExtractor)new FieldsExtractor<PatchNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(PatchNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<PatchNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(PatchNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<PatchNodeGroupRequest, String>(){

        public String extract(PatchNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("nodeGroupResource", (Message)request.getNodeGroupResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyNodeGroupRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/SetIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy", (FieldsExtractor)new FieldsExtractor<SetIamPolicyNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(SetIamPolicyNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetIamPolicyNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyNodeGroupRequest, String>(){

        public String extract(SetIamPolicyNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("zoneSetPolicyRequestResource", (Message)request.getZoneSetPolicyRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/SetNodeTemplate").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{nodeGroup}/setNodeTemplate", (FieldsExtractor)new FieldsExtractor<SetNodeTemplateNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(SetNodeTemplateNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "nodeGroup", (Object)request.getNodeGroup());
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetNodeTemplateNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetNodeTemplateNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            if (request.hasRequestId()) {
                serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            }
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetNodeTemplateNodeGroupRequest, String>(){

        public String extract(SetNodeTemplateNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("nodeGroupsSetNodeTemplateRequestResource", (Message)request.getNodeGroupsSetNodeTemplateRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.NodeGroups/TestIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/nodeGroups/{resource}/testIamPermissions", (FieldsExtractor)new FieldsExtractor<TestIamPermissionsNodeGroupRequest, Map<String, String>>(){

        public Map<String, String> extract(TestIamPermissionsNodeGroupRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsNodeGroupRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(TestIamPermissionsNodeGroupRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsNodeGroupRequest, String>(){

        public String extract(TestIamPermissionsNodeGroupRequest request) {
            return ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final UnaryCallable<AddNodesNodeGroupRequest, Operation> addNodesCallable;
    private final UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteNodeGroupRequest, Operation> deleteCallable;
    private final UnaryCallable<DeleteNodesNodeGroupRequest, Operation> deleteNodesCallable;
    private final UnaryCallable<GetNodeGroupRequest, NodeGroup> getCallable;
    private final UnaryCallable<GetIamPolicyNodeGroupRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<InsertNodeGroupRequest, Operation> insertCallable;
    private final UnaryCallable<ListNodeGroupsRequest, NodeGroupList> listCallable;
    private final UnaryCallable<ListNodeGroupsRequest, NodeGroupsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsListNodes> listNodesCallable;
    private final UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsClient.ListNodesPagedResponse> listNodesPagedCallable;
    private final UnaryCallable<PatchNodeGroupRequest, Operation> patchCallable;
    private final UnaryCallable<SetIamPolicyNodeGroupRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateCallable;
    private final UnaryCallable<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonNodeGroupsStub create(NodeGroupsStubSettings settings) throws IOException {
        return new HttpJsonNodeGroupsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonNodeGroupsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonNodeGroupsStub(NodeGroupsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonNodeGroupsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonNodeGroupsStub(NodeGroupsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonNodeGroupsStub(NodeGroupsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonNodeGroupsCallableFactory());
    }

    protected HttpJsonNodeGroupsStub(NodeGroupsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings addNodesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addNodesMethodDescriptor).build();
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings deleteNodesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteNodesMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings listNodesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listNodesMethodDescriptor).build();
        HttpJsonCallSettings patchTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(patchMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings setNodeTemplateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setNodeTemplateMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).build();
        this.addNodesCallable = callableFactory.createUnaryCallable(addNodesTransportSettings, settings.addNodesSettings(), clientContext);
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.deleteNodesCallable = callableFactory.createUnaryCallable(deleteNodesTransportSettings, settings.deleteNodesSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listNodesCallable = callableFactory.createUnaryCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.listNodesPagedCallable = callableFactory.createPagedCallable(listNodesTransportSettings, settings.listNodesSettings(), clientContext);
        this.patchCallable = callableFactory.createUnaryCallable(patchTransportSettings, settings.patchSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.setNodeTemplateCallable = callableFactory.createUnaryCallable(setNodeTemplateTransportSettings, settings.setNodeTemplateSettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(addNodesMethodDescriptor);
        methodDescriptors.add(aggregatedListMethodDescriptor);
        methodDescriptors.add(deleteMethodDescriptor);
        methodDescriptors.add(deleteNodesMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(insertMethodDescriptor);
        methodDescriptors.add(listMethodDescriptor);
        methodDescriptors.add(listNodesMethodDescriptor);
        methodDescriptors.add(patchMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(setNodeTemplateMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<AddNodesNodeGroupRequest, Operation> addNodesCallable() {
        return this.addNodesCallable;
    }

    @Override
    public UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<AggregatedListNodeGroupsRequest, NodeGroupsClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteNodeGroupRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<DeleteNodesNodeGroupRequest, Operation> deleteNodesCallable() {
        return this.deleteNodesCallable;
    }

    @Override
    public UnaryCallable<GetNodeGroupRequest, NodeGroup> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyNodeGroupRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<InsertNodeGroupRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListNodeGroupsRequest, NodeGroupList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ListNodeGroupsRequest, NodeGroupsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsListNodes> listNodesCallable() {
        return this.listNodesCallable;
    }

    @Override
    public UnaryCallable<ListNodesNodeGroupsRequest, NodeGroupsClient.ListNodesPagedResponse> listNodesPagedCallable() {
        return this.listNodesPagedCallable;
    }

    @Override
    public UnaryCallable<PatchNodeGroupRequest, Operation> patchCallable() {
        return this.patchCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyNodeGroupRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetNodeTemplateNodeGroupRequest, Operation> setNodeTemplateCallable() {
        return this.setNodeTemplateCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsNodeGroupRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

