/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSslCertificatesRequest;
import com.google.cloud.compute.v1.DeleteSslCertificateRequest;
import com.google.cloud.compute.v1.GetSslCertificateRequest;
import com.google.cloud.compute.v1.InsertSslCertificateRequest;
import com.google.cloud.compute.v1.ListSslCertificatesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateAggregatedList;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.SslCertificatesScopedList;
import com.google.cloud.compute.v1.SslCertificatesSettings;
import com.google.cloud.compute.v1.stub.SslCertificatesStub;
import com.google.cloud.compute.v1.stub.SslCertificatesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SslCertificatesClient
implements BackgroundResource {
    private final SslCertificatesSettings settings;
    private final SslCertificatesStub stub;

    public static final SslCertificatesClient create() throws IOException {
        return SslCertificatesClient.create(SslCertificatesSettings.newBuilder().build());
    }

    public static final SslCertificatesClient create(SslCertificatesSettings settings) throws IOException {
        return new SslCertificatesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SslCertificatesClient create(SslCertificatesStub stub) {
        return new SslCertificatesClient(stub);
    }

    protected SslCertificatesClient(SslCertificatesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SslCertificatesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SslCertificatesClient(SslCertificatesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SslCertificatesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SslCertificatesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListSslCertificatesRequest request = AggregatedListSslCertificatesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListSslCertificatesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListSslCertificatesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String sslCertificate) {
        DeleteSslCertificateRequest request = DeleteSslCertificateRequest.newBuilder().setProject(project).setSslCertificate(sslCertificate).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteSslCertificateRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSslCertificateRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SslCertificate get(String project, String sslCertificate) {
        GetSslCertificateRequest request = GetSslCertificateRequest.newBuilder().setProject(project).setSslCertificate(sslCertificate).build();
        return this.get(request);
    }

    public final SslCertificate get(GetSslCertificateRequest request) {
        return (SslCertificate)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSslCertificateRequest, SslCertificate> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, SslCertificate sslCertificateResource) {
        InsertSslCertificateRequest request = InsertSslCertificateRequest.newBuilder().setProject(project).setSslCertificateResource(sslCertificateResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertSslCertificateRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertSslCertificateRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListSslCertificatesRequest request = ListSslCertificatesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSslCertificatesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSslCertificatesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSslCertificatesRequest, SslCertificateList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage> {
        private ListPage(PageContext<ListSslCertificatesRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSslCertificatesRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSslCertificatesRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSslCertificatesRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>> context, SslCertificateAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>> context, SslCertificateAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>> context, ApiFuture<SslCertificateAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListSslCertificatesRequest, SslCertificateAggregatedList, Map.Entry<String, SslCertificatesScopedList>> context, ApiFuture<SslCertificateAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

