/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationResponse;
import com.google.cloud.compute.v1.GetGlobalOperationRequest;
import com.google.cloud.compute.v1.GlobalOperationsClient;
import com.google.cloud.compute.v1.ListGlobalOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationAggregatedList;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.OperationsScopedList;
import com.google.cloud.compute.v1.WaitGlobalOperationRequest;
import com.google.cloud.compute.v1.stub.GlobalOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class GlobalOperationsStubSettings
extends StubSettings<GlobalOperationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteGlobalOperationRequest, DeleteGlobalOperationResponse> deleteSettings;
    private final UnaryCallSettings<GetGlobalOperationRequest, Operation> getSettings;
    private final PagedCallSettings<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<WaitGlobalOperationRequest, Operation> waitSettings;
    private static final PagedListDescriptor<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListGlobalOperationsRequest injectToken(AggregatedListGlobalOperationsRequest payload, String token) {
            return AggregatedListGlobalOperationsRequest.newBuilder((AggregatedListGlobalOperationsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListGlobalOperationsRequest injectPageSize(AggregatedListGlobalOperationsRequest payload, int pageSize) {
            return AggregatedListGlobalOperationsRequest.newBuilder((AggregatedListGlobalOperationsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListGlobalOperationsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, OperationsScopedList>> extractResources(OperationAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListGlobalOperationsRequest, OperationList, Operation> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListGlobalOperationsRequest, OperationList, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListGlobalOperationsRequest injectToken(ListGlobalOperationsRequest payload, String token) {
            return ListGlobalOperationsRequest.newBuilder((ListGlobalOperationsRequest)payload).setPageToken(token).build();
        }

        public ListGlobalOperationsRequest injectPageSize(ListGlobalOperationsRequest payload, int pageSize) {
            return ListGlobalOperationsRequest.newBuilder((ListGlobalOperationsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListGlobalOperationsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(OperationList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse>(){

        public ApiFuture<GlobalOperationsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListGlobalOperationsRequest, OperationAggregatedList> callable, AggregatedListGlobalOperationsRequest request, ApiCallContext context, ApiFuture<OperationAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalOperationsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListGlobalOperationsRequest, OperationAggregatedList, Map.Entry<String, OperationsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse>(){

        public ApiFuture<GlobalOperationsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlobalOperationsRequest, OperationList> callable, ListGlobalOperationsRequest request, ApiCallContext context, ApiFuture<OperationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalOperationsClient.ListPagedResponse.createAsync((PageContext<ListGlobalOperationsRequest, OperationList, Operation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteGlobalOperationRequest, DeleteGlobalOperationResponse> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetGlobalOperationRequest, Operation> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<WaitGlobalOperationRequest, Operation> waitSettings() {
        return this.waitSettings;
    }

    public GlobalOperationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGlobalOperationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GlobalOperationsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GlobalOperationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GlobalOperationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.waitSettings = settingsBuilder.waitSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GlobalOperationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteGlobalOperationRequest, DeleteGlobalOperationResponse> deleteSettings;
        private final UnaryCallSettings.Builder<GetGlobalOperationRequest, Operation> getSettings;
        private final PagedCallSettings.Builder<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<WaitGlobalOperationRequest, Operation> waitSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.waitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.listSettings, this.waitSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GlobalOperationsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.waitSettings = settings.waitSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.listSettings, this.waitSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GlobalOperationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GlobalOperationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GlobalOperationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GlobalOperationsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(GlobalOperationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.waitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListGlobalOperationsRequest, OperationAggregatedList, GlobalOperationsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteGlobalOperationRequest, DeleteGlobalOperationResponse> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetGlobalOperationRequest, Operation> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListGlobalOperationsRequest, OperationList, GlobalOperationsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<WaitGlobalOperationRequest, Operation> waitSettings() {
            return this.waitSettings;
        }

        public GlobalOperationsStubSettings build() throws IOException {
            return new GlobalOperationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

