/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetHttpProxiesSettings;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpProxyRequest;
import com.google.cloud.compute.v1.TargetHttpProxy;
import com.google.cloud.compute.v1.TargetHttpProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.RegionTargetHttpProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionTargetHttpProxiesClient
implements BackgroundResource {
    private final RegionTargetHttpProxiesSettings settings;
    private final RegionTargetHttpProxiesStub stub;

    public static final RegionTargetHttpProxiesClient create() throws IOException {
        return RegionTargetHttpProxiesClient.create(RegionTargetHttpProxiesSettings.newBuilder().build());
    }

    public static final RegionTargetHttpProxiesClient create(RegionTargetHttpProxiesSettings settings) throws IOException {
        return new RegionTargetHttpProxiesClient(settings);
    }

    public static final RegionTargetHttpProxiesClient create(RegionTargetHttpProxiesStub stub) {
        return new RegionTargetHttpProxiesClient(stub);
    }

    protected RegionTargetHttpProxiesClient(RegionTargetHttpProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionTargetHttpProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionTargetHttpProxiesClient(RegionTargetHttpProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionTargetHttpProxiesSettings getSettings() {
        return this.settings;
    }

    public RegionTargetHttpProxiesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String targetHttpProxy) {
        DeleteRegionTargetHttpProxyRequest request = DeleteRegionTargetHttpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpProxy(targetHttpProxy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionTargetHttpProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionTargetHttpProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionTargetHttpProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetHttpProxy get(String project, String region, String targetHttpProxy) {
        GetRegionTargetHttpProxyRequest request = GetRegionTargetHttpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpProxy(targetHttpProxy).build();
        return this.get(request);
    }

    public final TargetHttpProxy get(GetRegionTargetHttpProxyRequest request) {
        return (TargetHttpProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionTargetHttpProxyRequest, TargetHttpProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, TargetHttpProxy targetHttpProxyResource) {
        InsertRegionTargetHttpProxyRequest request = InsertRegionTargetHttpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpProxyResource(targetHttpProxyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionTargetHttpProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionTargetHttpProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionTargetHttpProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionTargetHttpProxiesRequest request = ListRegionTargetHttpProxiesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionTargetHttpProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionTargetHttpProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> setUrlMapAsync(String project, String region, String targetHttpProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpProxyRequest request = SetUrlMapRegionTargetHttpProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpProxy(targetHttpProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMapAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setUrlMapAsync(SetUrlMapRegionTargetHttpProxyRequest request) {
        return this.setUrlMapOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetUrlMapRegionTargetHttpProxyRequest, Operation, Operation> setUrlMapOperationCallable() {
        return this.stub.setUrlMapOperationCallable();
    }

    public final UnaryCallable<SetUrlMapRegionTargetHttpProxyRequest, Operation> setUrlMapCallable() {
        return this.stub.setUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage> {
        private ListPage(PageContext<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, TargetHttpProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionTargetHttpProxiesRequest, TargetHttpProxyList, TargetHttpProxy> context, ApiFuture<TargetHttpProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

