/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetGrpcProxyRequest;
import com.google.cloud.compute.v1.GetTargetGrpcProxyRequest;
import com.google.cloud.compute.v1.InsertTargetGrpcProxyRequest;
import com.google.cloud.compute.v1.ListTargetGrpcProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchTargetGrpcProxyRequest;
import com.google.cloud.compute.v1.TargetGrpcProxiesSettings;
import com.google.cloud.compute.v1.TargetGrpcProxy;
import com.google.cloud.compute.v1.TargetGrpcProxyList;
import com.google.cloud.compute.v1.stub.TargetGrpcProxiesStub;
import com.google.cloud.compute.v1.stub.TargetGrpcProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetGrpcProxiesClient
implements BackgroundResource {
    private final TargetGrpcProxiesSettings settings;
    private final TargetGrpcProxiesStub stub;

    public static final TargetGrpcProxiesClient create() throws IOException {
        return TargetGrpcProxiesClient.create(TargetGrpcProxiesSettings.newBuilder().build());
    }

    public static final TargetGrpcProxiesClient create(TargetGrpcProxiesSettings settings) throws IOException {
        return new TargetGrpcProxiesClient(settings);
    }

    public static final TargetGrpcProxiesClient create(TargetGrpcProxiesStub stub) {
        return new TargetGrpcProxiesClient(stub);
    }

    protected TargetGrpcProxiesClient(TargetGrpcProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetGrpcProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    protected TargetGrpcProxiesClient(TargetGrpcProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetGrpcProxiesSettings getSettings() {
        return this.settings;
    }

    public TargetGrpcProxiesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String targetGrpcProxy) {
        DeleteTargetGrpcProxyRequest request = DeleteTargetGrpcProxyRequest.newBuilder().setProject(project).setTargetGrpcProxy(targetGrpcProxy).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteTargetGrpcProxyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetGrpcProxyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteTargetGrpcProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetGrpcProxy get(String project, String targetGrpcProxy) {
        GetTargetGrpcProxyRequest request = GetTargetGrpcProxyRequest.newBuilder().setProject(project).setTargetGrpcProxy(targetGrpcProxy).build();
        return this.get(request);
    }

    public final TargetGrpcProxy get(GetTargetGrpcProxyRequest request) {
        return (TargetGrpcProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetGrpcProxyRequest, TargetGrpcProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, TargetGrpcProxy targetGrpcProxyResource) {
        InsertTargetGrpcProxyRequest request = InsertTargetGrpcProxyRequest.newBuilder().setProject(project).setTargetGrpcProxyResource(targetGrpcProxyResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertTargetGrpcProxyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertTargetGrpcProxyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertTargetGrpcProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetGrpcProxiesRequest request = ListTargetGrpcProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetGrpcProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetGrpcProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetGrpcProxiesRequest, TargetGrpcProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String targetGrpcProxy, TargetGrpcProxy targetGrpcProxyResource) {
        PatchTargetGrpcProxyRequest request = PatchTargetGrpcProxyRequest.newBuilder().setProject(project).setTargetGrpcProxy(targetGrpcProxy).setTargetGrpcProxyResource(targetGrpcProxyResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchTargetGrpcProxyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchTargetGrpcProxyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchTargetGrpcProxyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy, ListPage> {
        private ListPage(PageContext<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy> context, TargetGrpcProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy> context, TargetGrpcProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy> context, ApiFuture<TargetGrpcProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetGrpcProxiesRequest, TargetGrpcProxyList, TargetGrpcProxy> context, ApiFuture<TargetGrpcProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

