/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BulkInsertInstanceResource;
import com.google.cloud.compute.v1.BulkInsertRegionInstanceRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstancesSettings;
import com.google.cloud.compute.v1.stub.RegionInstancesStub;
import com.google.cloud.compute.v1.stub.RegionInstancesStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RegionInstancesClient
implements BackgroundResource {
    private final RegionInstancesSettings settings;
    private final RegionInstancesStub stub;

    public static final RegionInstancesClient create() throws IOException {
        return RegionInstancesClient.create(RegionInstancesSettings.newBuilder().build());
    }

    public static final RegionInstancesClient create(RegionInstancesSettings settings) throws IOException {
        return new RegionInstancesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionInstancesClient create(RegionInstancesStub stub) {
        return new RegionInstancesClient(stub);
    }

    protected RegionInstancesClient(RegionInstancesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstancesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionInstancesClient(RegionInstancesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstancesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionInstancesStub getStub() {
        return this.stub;
    }

    public final Operation bulkInsert(String project, String region, BulkInsertInstanceResource bulkInsertInstanceResourceResource) {
        BulkInsertRegionInstanceRequest request = BulkInsertRegionInstanceRequest.newBuilder().setProject(project).setRegion(region).setBulkInsertInstanceResourceResource(bulkInsertInstanceResourceResource).build();
        return this.bulkInsert(request);
    }

    public final Operation bulkInsert(BulkInsertRegionInstanceRequest request) {
        return (Operation)this.bulkInsertCallable().call((Object)request);
    }

    public final UnaryCallable<BulkInsertRegionInstanceRequest, Operation> bulkInsertCallable() {
        return this.stub.bulkInsertCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

